/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.appec.LeftHeader;
import com.digiwin.mobile.mobileuibot.core.appec.SlipConfigLeft;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldLabelStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titledesc.TitleDesc;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildManualTaskDetailStrategy")
public class UiBotModelBuildManualTaskDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildManualTaskDetailStrategy.class);
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildManualTaskDetail");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        List<Object> tags;
        TitleBody titleBody;
        stopWatch.start("GetData From Athena API");
        UiBotModel pcUibotModel = this.digiwinPcUiBotProxyService.showUibotManualTask(apiRequest.getDataId(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), apiRequest.getRawData());
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId());
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getDataId());
        boolean isTeamTask = apiRequest.getRawData().getBooleanValue("isTeamTask");
        boolean isComplete = this.judgeDetailComplete(pcUibotModel);
        if (isTeamTask) {
            isComplete = true;
            digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getDataId());
        }
        List reassignReportList = this.digiwinAtmcProxyService.getProjectReassignReport(apiRequest.getDataId(), apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        List uiBotLayouts = uiBotModel.getLayout();
        String customerNo = null;
        String customerName = null;
        if (!CollectionUtils.isEmpty((Collection)uiBotLayouts)) {
            boolean teamEnter = apiRequest.getTeamEnter() == null ? false : apiRequest.getTeamEnter();
            boolean isExecutorUser = false;
            List mobileRuleList = this.ruleService.findByRulePath(((UiBotLayout)pcUibotModel.getLayout().get(0)).getSchema());
            Map data = (Map)pcUibotModel.getPageData().get((Object)((UiBotLayout)pcUibotModel.getLayout().get(0)).getSchema());
            Map calendarTaskInfo = (Map)data.get("calendar_task_info");
            if (calendarTaskInfo != null && calendarTaskInfo.size() > 0) {
                customerNo = (String)calendarTaskInfo.get("customer_no");
                customerName = (String)calendarTaskInfo.get("customer_name");
            }
            List executorList = (List)data.get("executorList");
            Iterator iterator = executorList.iterator();
            while (iterator.hasNext()) {
                HashMap executor = (HashMap)iterator.next();
                if (!apiRequest.getUserId().equals(executor.get("executorUserId"))) continue;
                isExecutorUser = true;
                break;
            }
            if (!teamEnter) {
                isExecutorUser = true;
            }
            if (isExecutorUser) {
                for (UiBotLayout uiBotLayout : uiBotLayouts) {
                    switch (uiBotLayout.getType()) {
                        case "TITLE_BODY": {
                            pageData.put((Object)uiBotLayout.getSchema(), (Object)TitleBody.create((String)locale, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, (Map)data));
                            break;
                        }
                        case "FIELD": {
                            Field field;
                            if ("executorList".equals(uiBotLayout.getSchema())) {
                                field = Field.create((String)((String)uiBotLayout.getmLabelText().get(locale)), (String)((String)((HashMap)executorList.get(0)).get("executorUserName")), (Integer)FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT, (HashMap)((HashMap)executorList.get(0)), (Boolean)isComplete);
                            } else if (uiBotLayout.getSchema().contains(".")) {
                                if (!StringUtils.hasLength((String)customerNo)) break;
                                String schema = uiBotLayout.getSchema().split("\\.")[1];
                                field = Field.create((String)((String)uiBotLayout.getmLabelText().get(locale)), (String)((String)calendarTaskInfo.get(schema)), (Integer)FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT, (Boolean)isComplete);
                            } else {
                                field = Field.create((String)((String)uiBotLayout.getmLabelText().get(locale)), (String)((String)data.get(uiBotLayout.getSchema())), (Integer)FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT, (Boolean)isComplete);
                            }
                            if (field == null) break;
                            pageData.put((Object)uiBotLayout.getSchema(), (Object)field);
                            break;
                        }
                        case "DIVIDER": {
                            pageData.put((Object)uiBotLayout.getSchema(), (Object)Divider.create((DividerTypeEnum)DividerTypeEnum.ELEMENT_DIVIDER));
                            break;
                        }
                        case "BUTTON_SINGLE_SELECT": {
                            pageData.put((Object)uiBotLayout.getSchema(), (Object)ButtonSingleSelect.create((UiBotLayout)uiBotLayout, (Map)data, (String)pageSetting.getPageId(), (String)locale, (Boolean)isComplete));
                            break;
                        }
                        case "INPUT_DATETIME_PICKER": {
                            pageData.put((Object)uiBotLayout.getSchema(), (Object)InputDateTimePicker.create((UiBotLayout)uiBotLayout, (Map)data, (String)locale, (String)"", (Boolean)isComplete));
                            break;
                        }
                        case "INPUT_MULTI": {
                            pageData.put((Object)uiBotLayout.getSchema(), (Object)InputMultiText.create((UiBotLayout)uiBotLayout, (List)mobileRuleList, (Map)data, (String)locale, (boolean)false, (Boolean)isComplete));
                            break;
                        }
                        case "INPUT_SINGLE": {
                            pageData.put((Object)uiBotLayout.getSchema(), (Object)InputSingleText.create((UiBotLayout)uiBotLayout, (String)"0", (Map)data, (String)locale, (Boolean)isComplete));
                            break;
                        }
                        case "ATTACHMENT": {
                            Attachment attachment = Attachment.create((UiBotLayout)uiBotLayout, (Map)data, (String)locale, (DigiwinDmcProxyService)this.digiwinDmcProxyService, (Boolean)isComplete);
                            if (attachment == null) break;
                            pageData.put((Object)uiBotLayout.getSchema(), (Object)attachment);
                            break;
                        }
                        case "BOTTOM_BUTTON": {
                            if (!isComplete) {
                                List bottomButtons = (List)pageData.get((Object)"bottomButtons");
                                Map submit = (Map)bottomButtons.get(0);
                                BottomButtonDigiwinAthena bottomButtonDigiwinAthena = BottomButtonDigiwinAthena.create((Integer)BottomButtonStyleEnum.STRESS.getValue(), (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u63d0\u4ea4"));
                                Map action = (Map)submit.get("action");
                                Map rawData = (Map)action.get("rawData");
                                rawData.put("actions", ((UiBotLayout)pcUibotModel.getLayout().get(0)).getActions());
                                rawData.put("data", data);
                                Action action1 = new Action();
                                action1.setJumpPageId((String)submit.get("jumpPageId"));
                                action1.setType(ActionTypeEnum.CALL_API.getValue());
                                action1.setJumpPageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u63d0\u4ea4"));
                                action1.setRawData((Object)rawData);
                                action1.setScreenShotSwitch(Boolean.valueOf(false));
                                bottomButtonDigiwinAthena.setAction(action1);
                                bottomButtonDigiwinAthena.setId((String)submit.get("id"));
                                ModuleUtils.addRefreshPageId((BottomButtonDigiwinAthena)bottomButtonDigiwinAthena, (String)"");
                                ArrayList<BottomButtonDigiwinAthena> buttonDigiwinAthenas = new ArrayList<BottomButtonDigiwinAthena>(1);
                                buttonDigiwinAthenas.add(bottomButtonDigiwinAthena);
                                pageData.put((Object)uiBotLayout.getSchema(), buttonDigiwinAthenas);
                                break;
                            }
                            pageData.remove((Object)uiBotLayout.getSchema());
                            break;
                        }
                    }
                }
            } else {
                UiBotPageData readOnlyPageData = new UiBotPageData();
                for (UiBotLayout uiBotLayout : uiBotLayouts) {
                    switch (uiBotLayout.getType()) {
                        case "TITLE_BODY": {
                            readOnlyPageData.put((Object)uiBotLayout.getSchema(), (Object)TitleBody.create((String)locale, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, (Map)data));
                            break;
                        }
                        case "FIELD": {
                            Field field;
                            if ("executorList".equals(uiBotLayout.getSchema())) {
                                field = Field.create((String)((String)uiBotLayout.getmLabelText().get(locale)), (String)((String)((HashMap)executorList.get(0)).get("executorUserName")), (Integer)FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT, (Boolean)isComplete);
                            } else if (uiBotLayout.getSchema().contains(".")) {
                                if (!StringUtils.hasLength((String)customerNo)) break;
                                String schema = uiBotLayout.getSchema().split("\\.")[1];
                                field = Field.create((String)((String)uiBotLayout.getmLabelText().get(locale)), (String)((String)calendarTaskInfo.get(schema)), (Integer)FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT, (Boolean)isComplete);
                            } else {
                                field = Field.create((String)((String)uiBotLayout.getmLabelText().get(locale)), (String)((String)data.get(uiBotLayout.getSchema())), (Integer)FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT, (Boolean)isComplete);
                            }
                            if (field == null) break;
                            readOnlyPageData.put((Object)uiBotLayout.getSchema(), (Object)field);
                            break;
                        }
                    }
                }
                uiBotModel.setPageData(readOnlyPageData);
            }
        }
        if (uiBotModel.getSlip().getSlipConfig() != null && uiBotModel.getSlip().getSlipConfig().getRight() != null) {
            LeftHeader header = uiBotModel.getSlip().getSlipConfig().getRight().getHeader();
            header.getSubTitle().setContent(digiwinAtmcBacklogDetail.getName());
            if (uiBotModel.getSlip().getSlipConfig().getRight().getBody() != null) {
                Map params = uiBotModel.getSlip().getSlipConfig().getRight().getBody().getJumpConfig().getParams();
                params.put("tenant_id", apiRequest.getTenantId());
                params.put("user_id", apiRequest.getUserId());
                params.put("transaction_id", digiwinAtmcBacklogDetail.getId());
                params.put("transaction_code", digiwinAtmcBacklogDetail.getTmActivityId());
                if (customerNo != null) {
                    params.put("customer_no", customerNo);
                }
                if (customerName != null) {
                    params.put("customer_name", customerName);
                }
                params.put("dataId", digiwinAtmcBacklogDetail.getTmActivityId());
            }
        }
        if (uiBotModel.getSlip().getSlipConfig() != null && uiBotModel.getSlip().getSlipConfig().getLeft() != null) {
            SlipConfigLeft left = uiBotModel.getSlip().getSlipConfig().getLeft();
            List projectPerformers = this.digiwinAtmcProxyService.getPerformerListByBackLogId(digiwinAtmcBacklogDetail.getBacklogId(), apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
            EocPersonResponse eocPersonResponse = this.digiwinEocProxyService.getSimplePersonList(apiRequest.getIamUserToken(), 9999, 1, "");
            SlipConfigLeft.setPersonList((SlipConfigLeft)left, (List)projectPerformers, (EocPersonResponse)eocPersonResponse);
        }
        if (!this.judgeDetailComplete(pcUibotModel).booleanValue() && digiwinAtmcBacklogDetail != null && digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List buttons = uiBotModel.getAppbarButtonList();
            HashMap<String, String> buttonActionRawData = new HashMap<String, String>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", (String)digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign((String)(apiRequest.getDataId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"TASK", (Integer)59096));
        }
        List layouts = uiBotModel.getLayout();
        if (reassignReportList != null && reassignReportList.size() > 0) {
            for (UiBotLayout layout : layouts) {
                if ("TITLE_BODY".equals(layout.getType())) {
                    titleBody = (TitleBody)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layout.getSchema()), TitleBody.class);
                    tags = titleBody.getTags();
                    if (tags == null) {
                        tags = new ArrayList<Tag>();
                    } else {
                        for (Tag tag : tags) {
                            if (!LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u8f6c\u6d3e").equals(tag.getText())) continue;
                            tags.remove(tag);
                            break;
                        }
                    }
                    Tag tag = Tag.createOnlyTextStateTag((String)String.format(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u7531\u8f6c\u6d3e"), ((DigiwinReassignReport)reassignReportList.get(0)).getOldPerformerName()), (Action)Action.createReassignReportAction((String)apiRequest.getLocale(), (List)reassignReportList));
                    tags.add(tag);
                    uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)titleBody);
                    break;
                }
                if ("PAGE_DESC".equals(layout.getType())) {
                    PageDesc pageDesc = (PageDesc)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layout.getSchema()), PageDesc.class);
                    List pageDescContents = pageDesc.getContent();
                    pageDescContents.add(PageDescContent.buildReassignReport((String)apiRequest.getLocale(), (List)reassignReportList));
                    uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)pageDesc);
                }
                if (!"TITLE_DESC".equals(layout.getType())) continue;
                TitleDesc titleDesc = (TitleDesc)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layout.getSchema()), TitleDesc.class);
                List labels = titleDesc.getLabelList();
                labels.add(Label.buildReassignReport((String)apiRequest.getLocale(), (List)reassignReportList));
                uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)titleDesc);
            }
        } else {
            for (UiBotLayout layout : layouts) {
                if (!"TITLE_BODY".equals(layout.getType())) continue;
                titleBody = (TitleBody)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layout.getSchema()), TitleBody.class);
                tags = titleBody.getTags();
                if (tags != null) {
                    for (Tag tag : tags) {
                        if (!LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u8f6c\u6d3e").equals(tag.getText())) continue;
                        tags.remove(tag);
                        tags.add(Tag.createBlueBgdWriteTextStateTag((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u8f6c\u6d3e")));
                        break;
                    }
                }
                uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)titleBody);
                break;
            }
        }
        stopWatch.stop();
        uiBotModel.setCustomGroup();
        return uiBotModel;
    }

    private Boolean judgeDetailComplete(UiBotModel pcUibotModel) {
        if (pcUibotModel == null || pcUibotModel.getPageData() == null) {
            return false;
        }
        if (StringUtils.hasLength((String)((String)((Map)pcUibotModel.getPageData().get((Object)"data")).get("actualEndTime"))) || StringUtils.hasLength((String)((String)((Map)pcUibotModel.getPageData().get((Object)"data")).get("actualDescription")))) {
            return true;
        }
        return false;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data = null;
        UiBotModel uiBotModel = null;
        if (PageSettingIdPresetEnum.MOBILE_MANUAL_TASK_DETAIL.toString().equalsIgnoreCase(pageSetting.getPageId())) {
            data = FileUtil.readText((String)"static/appstore-use/manual-task-detail-v2.json");
        }
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

