/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.horizontalprogress.HorizontalProgress;
import com.digiwin.mobile.mobileuibot.core.component.horizontalprogress.HorizontalProgressItem;
import com.digiwin.mobile.mobileuibot.core.component.horizontalprogress.HorizontalProgressType;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContent;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleContent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titledesc.TitleDesc;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEngineActivity;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEnginePanelInfo;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEngineTaskCode;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanelTask;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelStandardProjectDetailStrategy")
public class UiBotModelStandardProjectDetailStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        List layoutList;
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (modelTypeShow.booleanValue()) {
            return this.doShowData(apiRequest);
        }
        String locale = apiRequest.getLocale();
        Boolean isShare = false;
        if (apiRequest.getRawData() == null) {
            isShare = apiRequest.getRawData().get((Object)"isShare") == null ? false : (Boolean)apiRequest.getRawData().get((Object)"isShare");
        }
        this.digiwinAtmcProxyService.updateDigiwinAtmcTaskReadCount(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId());
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId());
        List reassignReportList = this.digiwinAtmcProxyService.getProjectReassignReport(apiRequest.getDataId(), apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
        DigiwinAtmcEnginePanelInfo enginePanelInfo = this.digiwinAtmcProxyService.getEnginePanelInfoByTaskId(apiRequest.getDataId(), apiRequest.getClientId(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        DigiwinAtmcPanelTask task = enginePanelInfo.getTask();
        TitleBody titleBody = new TitleBody();
        String startTime = Optional.ofNullable(task).map(DigiwinAtmcPanelTask::getStartTime).orElse("");
        String endTime = Optional.ofNullable(task).map(DigiwinAtmcPanelTask::getEndTime).orElse("");
        String createTime = Optional.ofNullable(task).map(DigiwinAtmcPanelTask::getCreateTime).orElse("");
        String name = Optional.ofNullable(task).map(DigiwinAtmcPanelTask::getName).orElse("");
        if (StringUtils.hasLength((String)startTime)) {
            startTime = startTime.substring(5, 10).replace("-", ".");
        }
        if (StringUtils.hasLength((String)endTime)) {
            endTime = endTime.substring(5, 10).replace("-", ".");
        }
        if (StringUtils.hasLength((String)createTime)) {
            createTime = createTime.substring(0, 10).replace("-", ".");
        }
        TitleContent content = new TitleContent();
        content.setText(startTime + "-" + endTime + name);
        PageDesc pageDesc = new PageDesc(name);
        ArrayList<PageDesc.LabelValue> labelValueList = new ArrayList<PageDesc.LabelValue>();
        labelValueList.add(new PageDesc.LabelValue(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u65f6\u95f4"), startTime + "-" + endTime));
        labelValueList.add(new PageDesc.LabelValue(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u53d1\u8d77\u65b9"), createTime + " " + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7531Athena\u53d1\u8d77\u5f53\u524d\u9879\u76ee")));
        String source = !Locale.US.toString().equals(locale) ? String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6807\u51c6\u9879\u76ee\u6765\u6e90"), task.getSources().size(), task.getSourceCount(), task.getSourceName()) : String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6807\u51c6\u9879\u76ee\u6765\u6e90"), task.getSourceCount(), task.getSourceName(), task.getSources().size());
        labelValueList.add(new PageDesc.LabelValue(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6765\u6e90"), LocaleUtil.getMobileTextByKey((String)locale, (String)source)));
        pageDesc.setLabelValueList(labelValueList);
        content.setDesc(pageDesc);
        titleBody.setContent(content);
        HorizontalProgress horizontalProgress = new HorizontalProgress();
        if (enginePanelInfo.getRoute() != null && enginePanelInfo.getRoute().getSelectRoute() != null && enginePanelInfo.getRoute().getSelectRoute().getActivities() != null) {
            ArrayList<HorizontalProgressItem> progressList = new ArrayList<HorizontalProgressItem>();
            List activities = enginePanelInfo.getRoute().getSelectRoute().getActivities();
            boolean haveDefaultSelect = false;
            Iterator iterator = activities.iterator();
            while (iterator.hasNext()) {
                DigiwinAtmcEngineActivity activity = (DigiwinAtmcEngineActivity)iterator.next();
                HorizontalProgressItem item = this.activity2ProgressItem(activity, locale, haveDefaultSelect, apiRequest.getDataId(), task.getTmTaskId());
                progressList.add(item);
                if (!item.getDefaultSelected().booleanValue()) continue;
                haveDefaultSelect = true;
            }
            if (!haveDefaultSelect && !progressList.isEmpty()) {
                ((HorizontalProgressItem)progressList.get(0)).setDefaultSelected(Boolean.valueOf(true));
            }
            horizontalProgress.setProgressList(progressList);
        }
        if ((layoutList = pageSetting.getPageModel().getLayout()) != null) {
            for (UiBotLayout layout : layoutList) {
                if ("HORIZONTAL_PROGRESS".equalsIgnoreCase(layout.getType())) {
                    pageSetting.getPageModel().getPageData().put((Object)layout.getSchema(), (Object)horizontalProgress);
                    continue;
                }
                if (!"TITLE_BODY".equalsIgnoreCase(layout.getType())) continue;
                pageSetting.getPageModel().getPageData().put((Object)layout.getSchema(), (Object)titleBody);
            }
        }
        UiBotModel uiBotModel = pageSetting.getPageModel();
        if (enginePanelInfo != null && enginePanelInfo.getReassign() != null && !isShare.booleanValue()) {
            List buttons = uiBotModel.getAppbarButtonList();
            HashMap<String, String> buttonActionRawData = new HashMap<String, String>(enginePanelInfo.getReassign());
            buttonActionRawData.put("appCode", enginePanelInfo.getTask().getAppCode());
            buttonActionRawData.put("projectDetail", (String)enginePanelInfo.getTask());
            buttons.add(Button.createApprovalReassign((String)(apiRequest.getDataId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"PROJECT", (Integer)58926));
            buttons.add(Button.createShareWithOthers((String)apiRequest.getDataId(), (Map)((Map)JsonUtil.objectToJavaObject((Object)enginePanelInfo.getReassign(), Map.class)), (String)apiRequest.getLocale(), (LocaleService)this.localeService));
        }
        if (reassignReportList != null && reassignReportList.size() > 0) {
            List layouts = uiBotModel.getLayout();
            for (UiBotLayout layout : layouts) {
                if ("TITLE_BODY".equals(layout.getType())) {
                    TitleBody titleBody1 = (TitleBody)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layout.getSchema()), TitleBody.class);
                    ArrayList<Tag> tags = titleBody1.getTags();
                    if (tags == null) {
                        tags = new ArrayList<Tag>();
                    } else {
                        for (Tag tag : tags) {
                            if (!LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u8f6c\u6d3e").equals(tag.getText())) continue;
                            tags.remove(tag);
                            break;
                        }
                    }
                    Tag tag = Tag.createOnlyTextStateTag((String)String.format(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u7531\u8f6c\u6d3e"), ((DigiwinReassignReport)reassignReportList.get(0)).getOldPerformerName()), (Action)Action.createReassignReportAction((String)apiRequest.getLocale(), (List)reassignReportList));
                    tags.add(tag);
                    break;
                }
                if ("PAGE_DESC".equals(layout.getType())) {
                    PageDesc pageDesc1 = (PageDesc)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layout.getSchema()), PageDesc.class);
                    List pageDescContents = pageDesc1.getContent();
                    pageDescContents.add(PageDescContent.buildReassignReport((String)apiRequest.getLocale(), (List)reassignReportList));
                    uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)pageDesc1);
                }
                if (!"TITLE_DESC".equals(layout.getType())) continue;
                TitleDesc titleDesc = (TitleDesc)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layout.getSchema()), TitleDesc.class);
                List labels = titleDesc.getLabelList();
                labels.add(Label.buildReassignReport((String)apiRequest.getLocale(), (List)reassignReportList));
                uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)titleDesc);
            }
        }
        return pageSetting.getPageModel();
    }

    private UiBotModel doShowData(ApiRequest apiRequest) {
        String dataId = apiRequest.getDataId();
        String data = FileUtil.readText((String)("static/appstore-use/project-standard-detail-show-" + dataId + ".json"));
        return (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
    }

    private HorizontalProgressItem activity2ProgressItem(DigiwinAtmcEngineActivity activity, String locale, boolean haveDefaultSelect, String projectId, String tmTaskId) {
        HorizontalProgressItem progressItem = new HorizontalProgressItem();
        progressItem.setName(activity.getName());
        if (activity.getTaskCodes() != null && !activity.getTaskCodes().isEmpty()) {
            DigiwinAtmcEngineTaskCode taskCode = (DigiwinAtmcEngineTaskCode)activity.getTaskCodes().get(0);
            progressItem.setId(taskCode.getId());
            Integer state = taskCode.getState() != null ? taskCode.getState() : 0;
            switch (state) {
                case -9001: {
                    progressItem.setType(Integer.valueOf(HorizontalProgressType.NOT_ALL_DONE.getValue()));
                    progressItem.setClickable(Boolean.valueOf(true));
                    break;
                }
                case 1: {
                    progressItem.setClickable(Boolean.valueOf(true));
                    if (!haveDefaultSelect) {
                        progressItem.setDefaultSelected(Boolean.valueOf(true));
                    }
                    Boolean overdue = taskCode.getOverdue();
                    Boolean exception = taskCode.getException();
                    if (exception != null && exception.booleanValue()) {
                        progressItem.setType(Integer.valueOf(HorizontalProgressType.EXCEPTION_OVERDUE.getValue()));
                        break;
                    }
                    if (overdue != null && overdue.booleanValue()) {
                        progressItem.setType(Integer.valueOf(HorizontalProgressType.OVERDUE.getValue()));
                        break;
                    }
                    progressItem.setType(Integer.valueOf(HorizontalProgressType.DOING.getValue()));
                    break;
                }
                case 3: {
                    progressItem.setType(Integer.valueOf(HorizontalProgressType.DONE.getValue()));
                    progressItem.setClickable(Boolean.valueOf(true));
                    break;
                }
                default: {
                    progressItem.setType(Integer.valueOf(HorizontalProgressType.NOT_START.getValue()));
                    progressItem.setClickable(Boolean.valueOf(false));
                }
            }
            HorizontalProgressItem.HorizontalProgressItemDetail detail = new HorizontalProgressItem.HorizontalProgressItemDetail();
            detail.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/project/standard/progress/detail?tmTaskId=" + tmTaskId + "&projectId=" + projectId);
            progressItem.setDetail(detail);
        }
        return progressItem;
    }
}

