/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.list.personnel.PersonnelStateGroup;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTab;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild.UiBotCompDataBuildStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelOnlineManage;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="uiBotCompDataBuildPersonnelGroupDetailStrategy")
public class UiBotCompDataBuildPersonnelGroupDetailStrategy
implements UiBotCompDataBuildStrategy<CustomTab> {
    private static final Logger logger = LoggerFactory.getLogger(UiBotCompDataBuildPersonnelGroupDetailStrategy.class);
    @Autowired
    private PageSettingService pageSettingService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private PersonnelOnlineManage personnelOnlineManage;

    public String getTypeByRequestId() {
        return ComponentSettingRequestIdEnum.DIRECTOR_CHECK_PERSONNEL_GROUP_DETAIL.getReuqestId();
    }

    public CustomTab buildComponentData(ApiRequest apiRequest) throws IOException {
        return null;
    }

    public List<CustomTab> buildComponentDataList(ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        CustomTabs customTabs = useMockData == false && !modelTypeShow ? this.doActually(apiRequest) : this.doMockData(apiRequest);
        return customTabs;
    }

    private CustomTabs doActually(ApiRequest apiRequest) {
        List selectList;
        PageSetting pageSetting = this.pageSettingService.findById(apiRequest.getPageId());
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        UiBotLayout layout = (UiBotLayout)uiBotModel.getLayout().stream().filter(o -> "CUSTOM_TABS".equals(o.getType())).collect(Collectors.toList()).get(0);
        CustomTabs customTabs = (CustomTabs)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), CustomTabs.class);
        InputCascade.DefaultSelect defaultSelect = null;
        if (null != apiRequest.getRawData() && null != apiRequest.getRawData().get((Object)"eoc_company_id") && !CollectionUtils.isEmpty((Collection)(selectList = (List)JsonUtil.objectToJavaObject((Object)apiRequest.getRawData().get((Object)"eoc_company_id"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */)))) {
            defaultSelect = ((InputCascade.DefaultSelect)selectList.get(0)).setChild((InputCascade.DefaultSelect)selectList.get(1));
        }
        this.buildCustomTabs(apiRequest, customTabs, defaultSelect);
        return customTabs;
    }

    private void buildCustomTabs(ApiRequest apiRequest, CustomTabs customTabs, InputCascade.DefaultSelect defaultSelect) {
        String eocCompanyId = "";
        String eocSiteId = "";
        if (null != defaultSelect && null != defaultSelect.getChild()) {
            eocCompanyId = Optional.ofNullable(defaultSelect.getId()).orElse("");
            eocSiteId = Optional.ofNullable(defaultSelect.getChild().getId()).orElse("");
        }
        String teamNo = apiRequest.getRawData().getString("teamNo");
        Map<PersonnelStateEnum, List<WoOpReportInfo>> reportMap = this.personnelOnlineManage.woOpReportPersonnelGet(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), eocCompanyId, eocSiteId).stream().filter(woOpReportInfo -> woOpReportInfo.getTeamNo().equals(teamNo)).collect(Collectors.groupingBy(WoOpReportInfo::getStateEnum));
        for (CustomTab customTab : customTabs) {
            customTab.updateRefreshConfigParam(apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getClientId(), apiRequest.getTenantId(), apiRequest.getPageId(), (Map)apiRequest.getRawData());
            PersonnelStateEnum stateEnum = PersonnelStateEnum.valueOf((String)customTab.getId());
            List reportList = reportMap.computeIfAbsent(stateEnum, k -> new ArrayList());
            this.fillCustomTab(apiRequest, customTab, stateEnum, reportList);
        }
    }

    private void fillCustomTab(ApiRequest apiRequest, CustomTab customTab, PersonnelStateEnum stateEnum, List<WoOpReportInfo> reportList) {
        CustomTabContentContainer content = new CustomTabContentContainer();
        content.setContentCmptType("PERSONNEL_STATE_GROUP");
        content.setData((Object)this.createContent(apiRequest, stateEnum, reportList));
        customTab.setContent(Collections.singletonList(content));
        customTab.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), customTab.getName()) + "(" + reportList.size() + ")");
    }

    private PersonnelStateGroup createContent(ApiRequest apiRequest, PersonnelStateEnum stateEnum, List<WoOpReportInfo> teamList) {
        return new PersonnelStateGroup().convert(apiRequest, this.localeService, stateEnum, teamList).setTitle("");
    }

    private CustomTabs doMockData(ApiRequest apiRequest) {
        return null;
    }
}

