/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardOpenDetailTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardDetailPage;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="uibotModelBuildPersonelStateMergeDetailStrategy")
public class UibotModelBuildPersonelStateMergeDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UibotModelBuildPersonelStateMergeDetailStrategy.class);
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Personel State Merge Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "ZTB_VIEW_LIST": {
                    ZtbViewList ztbViewList = (ZtbViewList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), ZtbViewList.class);
                    List cardContentList = ((Card)ztbViewList.getData().get(0)).getContent();
                    List mergeWoOpReportInfoList = (List)JsonUtil.objectToJavaObject((Object)apiRawData.get((Object)"mergeWoOpReportInfoList"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    ArrayList<Card> cardList = new ArrayList<Card>();
                    for (Map mergeWoOpReportInfo : mergeWoOpReportInfoList) {
                        LinkedHashMap cardContentMap = new LinkedHashMap();
                        cardContentList.forEach(e -> {
                            String label = "project_no".equalsIgnoreCase(e.getSchema()) ? ("zh_TW".equalsIgnoreCase(apiRequest.getLocale()) ? "\u5c08\u6848\u4ee3\u865f" : "\u9879\u76ee\u4ee3\u53f7") : ("project_name".equalsIgnoreCase(e.getSchema()) ? ("zh_TW".equalsIgnoreCase(apiRequest.getLocale()) ? "\u5c08\u6848\u540d\u7a31" : "\u9879\u76ee\u540d\u79f0") : ("wo_no".equalsIgnoreCase(e.getSchema()) ? ("zh_TW".equalsIgnoreCase(apiRequest.getLocale()) ? "\u88fd\u4ee4\u55ae\u865f" : "\u5de5\u5355\u5355\u53f7") : this.localeService.getLanguageValue(locale, e.getLabel())));
                            cardContentMap.put(label, mergeWoOpReportInfo.get(e.getSchema()));
                        });
                        String dataId = UUIDUtil.getUuid();
                        HashMap<String, Map> rawData = new HashMap<String, Map>();
                        rawData.put("woOpReportInfo", mergeWoOpReportInfo);
                        ArrayList<Button> buttonList = new ArrayList<Button>(1);
                        buttonList.add(Button.createButton((String)this.localeService.getLanguageValue(locale, "\u8be6\u7ec6\u4fe1\u606f"), (String)dataId, (Integer)BottomButtonStyleEnum.NORMAL.getValue(), null));
                        TabItemCardDetailPage tabItemCardDetailPage = new TabItemCardDetailPage();
                        tabItemCardDetailPage.setDataId(dataId);
                        tabItemCardDetailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_PERSONEL_STATE_ONLINE_DETAIL.toString());
                        tabItemCardDetailPage.setRawData(rawData);
                        Card card = Card.create((String)"", cardContentMap, buttonList, (boolean)false);
                        card.setDataId(dataId);
                        card.setDetailPage(tabItemCardDetailPage);
                        card.setOpenDetailType(CardOpenDetailTypeEnum.BY_BUTTON.getValue());
                        cardList.add(card);
                    }
                    ztbViewList.setData(cardList);
                    ztbViewList.setDetailPageSwiper(Boolean.valueOf(true));
                    pageData.put((Object)schema, (Object)ztbViewList);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> bottomButtonDigiwinAthena.setName(this.localeService.getLanguageValue(locale, bottomButtonDigiwinAthena.getName())));
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

