/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.dashboard;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent;
import com.digiwin.mobile.mobileuibot.core.mobileappconfig.MobileAppConfig;
import com.digiwin.mobile.mobileuibot.core.mobileappconfig.MobileAppConfigService;
import com.digiwin.mobile.mobileuibot.core.mobileappconfig.MobileAppReportConfig;
import com.digiwin.mobile.mobileuibot.dashboard.DashboardContentBuildStrategy;
import com.digiwin.mobile.mobileuibot.dashboard.DashboardContentBuildStrategyFactory;
import com.digiwin.mobile.mobileuibot.dashboard.DashboardContentOrderService;
import com.digiwin.mobile.mobileuibot.dashboard.DashboardService;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacTenantAuthorization;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacTenantAuthorizationResponse;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAnalyzedToken;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class DashboardServiceImpl
implements DashboardService {
    private Logger logger = LoggerFactory.getLogger(DashboardServiceImpl.class);
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;
    @Autowired
    private DigiwinCacProxyService digiwinCacProxyService;
    @Autowired
    private MobileAppConfigService mobileAppConfigService;
    @Autowired
    private DashboardContentOrderService dashboardContentOrderService;
    @Autowired
    private DashboardContentBuildStrategyFactory dashboardContentBuildStrategyFactory;

    public List<CustomContent> generateDashboardCustomContent(String iamUserToken, String locale, String clientId, boolean recommend, Boolean isOnly) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("GetData From IAM API");
        DigiwinIamAnalyzedToken analyzedToken = this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
        stopWatch.stop();
        stopWatch.start("GetData From CAC API");
        DigiwinCacTenantAuthorizationResponse digiwinCacTenantAuthorizationResponse = new DigiwinCacTenantAuthorizationResponse();
        if (analyzedToken != null && analyzedToken.getTenantId() != null) {
            digiwinCacTenantAuthorizationResponse = this.digiwinCacProxyService.findTenantAuthorizations(analyzedToken.getTenantId(), iamUserToken);
        }
        stopWatch.stop();
        ArrayList<CustomContent> customContentList = new ArrayList(digiwinCacTenantAuthorizationResponse.size());
        List mobileAppConfigs = this.mobileAppConfigService.listMobileAppConfigsBelongDigiwinCompanyId();
        for (DigiwinCacTenantAuthorization digiwinCacTenantAuthorization : digiwinCacTenantAuthorizationResponse) {
            DashboardContentBuildStrategy buildStrategy;
            MobileAppConfig mobileAppConfig2;
            boolean hasReport;
            String goodsCode = digiwinCacTenantAuthorization.getCode();
            String goodsDisplayName = digiwinCacTenantAuthorization.getDisplayName();
            if ("athena".equalsIgnoreCase(goodsCode)) continue;
            if (digiwinCacTenantAuthorization.isExpired().booleanValue()) {
                this.logger.debug("CAC authorization expired...userId is {}, tenantId is {}, tenantName is {}, goodsCode is {}, goodsDisplayName is {}", new Object[]{analyzedToken.getId(), analyzedToken.getTenantId(), analyzedToken.getTenantName(), goodsCode, goodsDisplayName});
                continue;
            }
            this.logger.debug("CAC authorization valid...userId is {}, tenantId is {}, tenantName is {}, goodsCode is {}, goodsDisplayName is {}", new Object[]{analyzedToken.getId(), analyzedToken.getTenantId(), analyzedToken.getTenantName(), goodsCode, goodsDisplayName});
            Optional<MobileAppConfig> optMobileAppConfig = mobileAppConfigs.stream().filter(mobileAppConfig -> goodsCode.equals(mobileAppConfig.getAppCode()) && mobileAppConfig.validWithAppEnvType(AppContext.getEnvType()) != false).findFirst();
            if (!optMobileAppConfig.isPresent() || !(hasReport = Optional.ofNullable(mobileAppConfig2 = optMobileAppConfig.get()).map(MobileAppConfig::getReportConfig).map(MobileAppReportConfig::hasReport).orElse(false).booleanValue()) || null == (buildStrategy = this.dashboardContentBuildStrategyFactory.get("REPORT"))) continue;
            CustomContent customContent = buildStrategy.buildDashboardContent(iamUserToken, locale, clientId, mobileAppConfig2, recommend);
            customContent.getSysParam().put("tenantId", analyzedToken.getTenantId());
            customContent.getSysParam().put("userId", analyzedToken.getId());
            customContentList.add(customContent);
        }
        if (customContentList.isEmpty() && isOnly.booleanValue()) {
            this.logger.debug("Noting authorizable found in dashboard, create DEFAULT EMPTY content...userId is {}, tenantId is {}, tenantName is {}", new Object[]{analyzedToken.getId(), analyzedToken.getTenantId(), analyzedToken.getTenantName()});
            CustomContent customContent = CustomContent.create((String)locale, (String)clientId, (String)iamUserToken, (String)"", (String)(AppContext.getBaseUrl() + "/mobile/v1/uibot/customcontent/empty"), (boolean)recommend);
            customContentList.add(customContent);
        }
        customContentList = this.dashboardContentOrderService.orderContentList(customContentList);
        return customContentList;
    }
}

