/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.dashboard;

import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.abireport.ReportCategoryEnum;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent;
import com.digiwin.mobile.mobileuibot.core.component.kingkong.BallRouter;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppModuleItem;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.module.AppModuleCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.component.webview.WebviewPanel;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.portal.model.ApiRequsetPortal;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAnalyzedToken;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAuthInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAuthResult;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileBallResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileClassificatonResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileDatasourceInfoResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendMobileConfig;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendRule;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendRuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendRuleParamsTypeEnum;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendRuleService;
import com.digiwin.mobile.mobileuibot.recommend.rule.params.PurchasedGoodsEnableModule;
import com.digiwin.mobile.mobileuibot.recommend.rule.params.PurchasedGoodsParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildDashboardV2Strategy")
public class UiBotModelBuildDashboardV2Strategy
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelBuildDashboardV2Strategy.class);
    @Autowired
    private DigiwinAudcProxyService audcProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;
    @Autowired
    private DigiwinCacProxyService digiwinCacProxyService;
    @Autowired
    private RecommendRuleService recommendRuleService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinSemcProxyService semcProxyService;
    @Autowired
    private BallRouter ballRouter;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Buildv2Dashboard");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        log.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        List startProjectAppModuleItemList;
        PageSetting actualPageSetting = new PageSetting();
        actualPageSetting.setSystemDefault(pageSetting.getSystemDefault());
        actualPageSetting.setPageTitle(pageSetting.getPageTitle());
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        ArrayList<BaseMobileComponentWrapper> bodyCmptList = new ArrayList<BaseMobileComponentWrapper>();
        List baseMobileComponentList = this.getClassAppComponent(apiRequest);
        if (!CollectionUtils.isEmpty((Collection)baseMobileComponentList)) {
            bodyCmptList.addAll(baseMobileComponentList);
        }
        List reportFormAppModuleItemList = this.getReportForm(apiRequest);
        boolean hasReportModule = false;
        if (!CollectionUtils.isEmpty((Collection)reportFormAppModuleItemList)) {
            hasReportModule = true;
            CustomContent reportFormCustomContent = new CustomContent();
            reportFormCustomContent.setCode(AppModuleCodeEnum.REPORT_FORM.getCode());
            reportFormCustomContent.setTitle(this.localeService.getLanguageValue(apiRequest.getLocale(), AppModuleCodeEnum.REPORT_FORM.getName()));
            reportFormCustomContent.setAppLayoutType(AppEntranceLayoutTypeEnum.HORIZONTAL.getValue());
            reportFormCustomContent.setRowSize(Integer.valueOf(2));
            reportFormCustomContent.setLimitShowSize(Integer.valueOf(4));
            reportFormCustomContent.setSubTitle(this.localeService.getLanguageValue(apiRequest.getLocale(), "\u67e5\u770b\u66f4\u591a") + ">");
            Action subTitleAction = new Action();
            subTitleAction.setJumpPageTitle(reportFormCustomContent.getTitle());
            subTitleAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_REPORT_LIST.toString());
            subTitleAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            reportFormCustomContent.setSubTitleAction(subTitleAction);
            reportFormCustomContent.addAllComponentsToGroup(reportFormAppModuleItemList, "DW_APP_MODULE_ITEM");
            bodyCmptList.add(new BaseMobileComponentWrapper((BaseMobileComponent)reportFormCustomContent, "DW_CUSTOM_CONTENT"));
        }
        if (!CollectionUtils.isEmpty((Collection)(startProjectAppModuleItemList = this.getStartProjectAppModuleItemList(apiRequest)))) {
            CustomContent startProjectCustomContent = new CustomContent();
            startProjectCustomContent.setCode(AppModuleCodeEnum.START_PROJECT.getCode());
            startProjectCustomContent.setTitle(this.localeService.getLanguageValue(apiRequest.getLocale(), AppModuleCodeEnum.START_PROJECT.getName()));
            startProjectCustomContent.setAppLayoutType(AppEntranceLayoutTypeEnum.HORIZONTAL.getValue());
            startProjectCustomContent.setRowSize(Integer.valueOf(2));
            startProjectCustomContent.setLimitShowSize(Integer.valueOf(startProjectAppModuleItemList.size()));
            startProjectCustomContent.addAllComponentsToGroup(startProjectAppModuleItemList, "DW_APP_MODULE_ITEM");
            bodyCmptList.add(new BaseMobileComponentWrapper((BaseMobileComponent)startProjectCustomContent, "DW_CUSTOM_CONTENT"));
        }
        CustomContent dataEntryCustomContent = new CustomContent();
        HashMap<String, String> sysParamMap = new HashMap<String, String>();
        sysParamMap.put("clientId", apiRequest.getClientId());
        sysParamMap.put("iamUserToken", apiRequest.getIamUserToken());
        sysParamMap.put("tenantId", apiRequest.getTenantId());
        sysParamMap.put("locale", apiRequest.getLocale());
        sysParamMap.put("userId", apiRequest.getUserId());
        sysParamMap.put("code", AppModuleCodeEnum.DATA_ENTRY.getCode());
        dataEntryCustomContent.setSysParam(sysParamMap);
        dataEntryCustomContent.setUrl(AppContext.getBaseUrl() + "/mobile/v2/dashboard/dataEntry/async");
        bodyCmptList.add(new BaseMobileComponentWrapper((BaseMobileComponent)dataEntryCustomContent, "DW_CUSTOM_CONTENT"));
        List intelligentEnterAppModuleItemList = this.getIntelligentEnterAppModuleItemList(apiRequest, hasReportModule);
        if (!CollectionUtils.isEmpty((Collection)intelligentEnterAppModuleItemList)) {
            CustomContent intelligentEnterCustomContent = new CustomContent();
            intelligentEnterCustomContent.setCode(AppModuleCodeEnum.INTELLIGENT_ENTER.getCode());
            intelligentEnterCustomContent.setTitle(this.localeService.getLanguageValue(apiRequest.getLocale(), AppModuleCodeEnum.INTELLIGENT_ENTER.getName()));
            intelligentEnterCustomContent.setAppLayoutType(AppEntranceLayoutTypeEnum.VERTICAL.getValue());
            intelligentEnterCustomContent.setRowSize(Integer.valueOf(4));
            intelligentEnterCustomContent.setLimitShowSize(Integer.valueOf(intelligentEnterAppModuleItemList.size()));
            intelligentEnterCustomContent.addAllComponentsToGroup(intelligentEnterAppModuleItemList, "DW_APP_MODULE_ITEM");
            bodyCmptList.add(new BaseMobileComponentWrapper((BaseMobileComponent)intelligentEnterCustomContent, "DW_CUSTOM_CONTENT"));
        }
        if (null != apiRequest.getIsHavePreset() && apiRequest.getIsHavePreset().booleanValue()) {
            CustomContent smartMachineCustomContent = CustomContent.create((String)apiRequest.getLocale(), (String)apiRequest.getClientId(), (String)apiRequest.getIamUserToken(), (String)"", (String)(AppContext.getBaseUrl() + "/mobile/v2/dashboard/smartMachine/async"), (boolean)true);
            bodyCmptList.add(new BaseMobileComponentWrapper((BaseMobileComponent)smartMachineCustomContent, "DW_CUSTOM_CONTENT"));
        }
        if (CollectionUtils.isEmpty(bodyCmptList)) {
            WebviewPanel webviewPanel = new WebviewPanel();
            webviewPanel.setTitle(this.localeService.getLanguageValue(apiRequest.getLocale(), "\u656c\u8bf7\u671f\u5f85") + "!");
            webviewPanel.setData(new ArrayList());
            bodyCmptList.add(new BaseMobileComponentWrapper((BaseMobileComponent)webviewPanel, "DW_WEBVIEW_PANEL"));
        }
        SingleListContainer singleListContainer = new SingleListContainer();
        singleListContainer.addAll(bodyCmptList);
        uiBotModel.getRenderData().addWrapperedComponentToBody(new BaseMobileComponentWrapper((BaseMobileComponent)singleListContainer, "DW_" + singleListContainer.returnComponentType()));
        return uiBotModel;
    }

    public List<BaseMobileComponentWrapper<BaseMobileComponent>> getClassAppComponent(ApiRequest apiRequest) {
        ArrayList<BaseMobileComponentWrapper<BaseMobileComponent>> baseMobileComponentList = new ArrayList<BaseMobileComponentWrapper<BaseMobileComponent>>();
        ApiRequsetPortal apiRequsetPortal = new ApiRequsetPortal();
        apiRequsetPortal.setIsAll(Boolean.valueOf(true));
        apiRequsetPortal.setLocale(apiRequest.getLocale());
        apiRequsetPortal.setIamUserToken(apiRequest.getIamUserToken());
        List classificatonRespList = this.semcProxyService.getClassificationList(apiRequsetPortal);
        if (CollectionUtils.isEmpty((Collection)classificatonRespList)) {
            return baseMobileComponentList;
        }
        try {
            for (MobileClassificatonResp classificatonResp : classificatonRespList) {
                if (CollectionUtils.isEmpty((Collection)classificatonResp.getMobileCustomAppList())) continue;
                CustomContent classCustomContent = new CustomContent();
                classCustomContent.setTitle(this.localeService.getLanguageValue(apiRequest.getLocale(), classificatonResp.getClassificationName()));
                classCustomContent.setAppLayoutType(AppEntranceLayoutTypeEnum.VERTICAL.getValue());
                classCustomContent.setRowSize(Integer.valueOf(4));
                Integer limitShowSize = classificatonResp.getMobileCustomAppList().size();
                classCustomContent.setLimitShowSize(limitShowSize);
                ArrayList<AppModuleItem> appModuleItemList = new ArrayList<AppModuleItem>();
                for (MobileDatasourceInfoResp customApp : classificatonResp.getMobileCustomAppList()) {
                    MobileBallResp mobileBallResp = new MobileBallResp();
                    mobileBallResp.setCustomApplicationId(customApp.getId());
                    mobileBallResp.setCallBackUrl("");
                    mobileBallResp.setBallName("");
                    Action action = this.ballRouter.getCompoentAction("CustomApplication", apiRequest, mobileBallResp);
                    AppModuleItem moduleItem = new AppModuleItem();
                    moduleItem.setAction(action);
                    moduleItem.setName(customApp.getName());
                    moduleItem.setImageUrl(customApp.getIcon());
                    appModuleItemList.add(moduleItem);
                }
                classCustomContent.addAllComponentsToGroup(appModuleItemList, "DW_APP_MODULE_ITEM");
                BaseMobileComponentWrapper baseMobileComponentWrapper = new BaseMobileComponentWrapper((BaseMobileComponent)classCustomContent, "DW_CUSTOM_CONTENT");
                baseMobileComponentList.add((BaseMobileComponentWrapper<BaseMobileComponent>)baseMobileComponentWrapper);
            }
        }
        catch (Exception e) {
            log.error("getClassAppComponent error:{}", (Throwable)e);
            return baseMobileComponentList;
        }
        return baseMobileComponentList;
    }

    private List<AppModuleItem> getReportForm(ApiRequest apiRequest) {
        List tmDataList = this.audcProxyService.getTmDataList(apiRequest.getClientId(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (CollectionUtils.isEmpty((Collection)tmDataList)) {
            return Collections.emptyList();
        }
        ArrayList<AppModuleItem> appModuleItemList = new ArrayList<AppModuleItem>();
        for (DigiwinAtmcTmData digiwinAtmcTmData : tmDataList) {
            if (CollectionUtils.isEmpty((Collection)digiwinAtmcTmData.getBaseItemDtoList())) continue;
            for (DigiwinAtmcTmDataReport dataReport : digiwinAtmcTmData.getBaseItemDtoList()) {
                if (!dataReport.isAllow().booleanValue() || !ReportCategoryEnum.STATEMENT.getValue().equals(dataReport.getCategory())) continue;
                BottomButtonDigiwinAthena bottomButtonDigiwinAthena = BottomButtonDigiwinAthena.createTBBReportButton((String)apiRequest.getLocale(), (String)apiRequest.getIamUserToken(), (String)apiRequest.getTenantId(), (String)Optional.ofNullable(dataReport.getResCode()).filter(StrUtil::isNotEmpty).orElse(dataReport.getCode()), (String)dataReport.getName());
                AppModuleItem appModuleItem = (AppModuleItem)JsonUtil.objectToJavaObject((Object)bottomButtonDigiwinAthena, AppModuleItem.class);
                appModuleItem.setBgColor("#EEF1FF");
                appModuleItem.setAccessRecord(null);
                appModuleItemList.add(appModuleItem);
            }
        }
        return appModuleItemList;
    }

    private List<AppModuleItem> getStartProjectAppModuleItemList(ApiRequest apiRequest) {
        String locale;
        String tenantId;
        String iamUserToken = apiRequest.getIamUserToken();
        List accessibleLaunchableProjectList = this.projectService.getLaunchableProjectList(iamUserToken, tenantId = apiRequest.getTenantId(), locale = apiRequest.getLocale());
        if (CollectionUtils.isEmpty((Collection)accessibleLaunchableProjectList)) {
            return Collections.emptyList();
        }
        return accessibleLaunchableProjectList.stream().map(project -> {
            AppModuleItem appModuleItem = new AppModuleItem();
            appModuleItem.setId(project.getCode());
            if ("demo_so_athenaopt_mainline_project_0001".equals(project.getCode())) {
                appModuleItem.setName(project.getName().substring(0, 4));
            } else {
                appModuleItem.setName(project.getName());
            }
            Action action = new Action();
            if (BooleanUtils.isTrue((Boolean)project.getIsDesigner())) {
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.toString());
                action.setJumpPageTitle(project.getName());
                HashMap<String, String> rawData = new HashMap<String, String>(2);
                rawData.put("project_introduce", project.getDesc());
                rawData.put("project_name", project.getName());
                rawData.put("dataId", project.getCreateSuffix());
                action.setRawData(rawData);
            } else if ("scan_freightage_start".equalsIgnoreCase(project.getCode())) {
                Action rawDataAction = new Action();
                rawDataAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                rawDataAction.setJumpPageTitle(project.getName());
                rawDataAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                rawDataAction.setDataId(project.getCreateSuffix());
                HashMap<String, String> rawData = new HashMap<String, String>(2);
                rawData.put("bizType", "ASN_CODE");
                rawData.put("action", (String)rawDataAction);
                action.setType(ActionTypeEnum.OPEN_NATIVE_SCAN.getValue());
                action.setRawData(rawData);
            } else {
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                action.setJumpPageTitle(project.getName());
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                action.setDataId(project.getCreateSuffix());
            }
            appModuleItem.setAction(action);
            appModuleItem.setBgColor("#EEF1FF");
            return appModuleItem;
        }).collect(Collectors.toList());
    }

    public List<AppModuleItem> getIntelligentEnterAppModuleItemList(ApiRequest apiRequest, boolean hasReportModule) {
        String iamUserToken = apiRequest.getIamUserToken();
        String userId = apiRequest.getUserId();
        String locale = apiRequest.getLocale();
        DigiwinIamAnalyzedToken analyzedToken = this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
        List goodsCodes = this.digiwinCacProxyService.findAuthorizationsEnabledByUserIdAndTenantId(analyzedToken.getTenantId(), analyzedToken.getId(), iamUserToken);
        if (goodsCodes.isEmpty()) {
            return Collections.emptyList();
        }
        List recommendRules = this.recommendRuleService.findRuleByCategory(RecommendRuleCategoryEnum.APP_SERVER_ENTRANCE.getValue());
        List<RecommendRule> purchasedGoodsRecommendRules = recommendRules.stream().filter(rr -> Objects.equals(rr.getParamsType(), RecommendRuleParamsTypeEnum.PURCHASED_GOODS.getValue())).sorted(Comparator.comparingInt(RecommendRule::getOrder)).collect(Collectors.toList());
        ArrayList<AppModuleItem> appModuleItemList = new ArrayList<AppModuleItem>();
        purchasedGoodsRecommendRules.forEach(pgrr -> {
            PurchasedGoodsParam param = (PurchasedGoodsParam)JsonUtil.objectToJavaObject((Object)pgrr.getParams(), PurchasedGoodsParam.class);
            if (null == param) {
                return;
            }
            String pgrrGoodsCode = param.getGoodsCode();
            boolean goodsPurchasedInFact = goodsCodes.stream().anyMatch(goodsCode -> Objects.equals(goodsCode, pgrrGoodsCode) || "Athena".equalsIgnoreCase(pgrrGoodsCode));
            if (goodsPurchasedInFact && null != param.getEnableModules()) {
                param.getEnableModules().forEach(module -> {
                    module.convert();
                    Boolean valid = Optional.ofNullable(module.getValid()).orElse(false);
                    Boolean verify = Optional.ofNullable(module.getVerify()).orElse(true);
                    if (!valid.booleanValue()) {
                        return;
                    }
                    String moduleId = module.getModuleId();
                    if ("BASIC_DATA_ENTRANCE".equals(moduleId)) {
                        return;
                    }
                    boolean moduleEnableInFact = true;
                    if (verify.booleanValue()) {
                        if ("APC".equals(pgrrGoodsCode)) {
                            if ("PERSONNEL_ONLINE".equals(module.getModuleId()) || "STAND_PRODUCTION_PROGRESS".equals(module.getModuleId())) {
                                moduleEnableInFact = this.isMatchWorkId(userId, pgrrGoodsCode, iamUserToken, module);
                            }
                        } else {
                            moduleEnableInFact = this.digiwinCacProxyService.useModuleByTenantIdAndUserId(analyzedToken.getTenantId(), analyzedToken.getId(), pgrrGoodsCode, moduleId, iamUserToken);
                        }
                    }
                    if (moduleEnableInFact) {
                        RecommendMobileConfig mobileConfig = module.getMobileConfig();
                        mobileConfig.initSetting(locale);
                        String requestUrl = mobileConfig.getAction().getRequestUrl();
                        if ("ChatFile".equalsIgnoreCase(mobileConfig.getName()) || "trmnana".equals(param.getGoodsCode())) {
                            requestUrl = requestUrl.replace("{tenantId}", analyzedToken.getTenantId()).replace("{tenantSid}", String.valueOf(analyzedToken.getTenantSid())).replace("{tenantName}", analyzedToken.getTenantName()).replace("{userId}", analyzedToken.getId()).replace("{userName}", analyzedToken.getName()).replace("{token}", iamUserToken).replace("{locale}", locale);
                        }
                        if (StringUtils.hasLength((String)requestUrl) && !requestUrl.startsWith("http")) {
                            requestUrl = AppContext.getBaseUrl() + requestUrl;
                        }
                        AppModuleItem appModuleItem = AppModuleItem.create((String)mobileConfig.getName(), (Integer)mobileConfig.getIconData(), (String)mobileConfig.getIconColor(), (String)mobileConfig.getAction().getJumpPageId(), (String)mobileConfig.getAction().getJumpPageTitle(), (Integer)mobileConfig.getAction().getType(), (String)requestUrl, (String)mobileConfig.getImage(), (String)mobileConfig.getImageUrl());
                        appModuleItem.getAction().setDataId(mobileConfig.getAction().getDataId());
                        appModuleItem.setId(pgrrGoodsCode + "_" + moduleId);
                        appModuleItem.setBgColor("#EEF1FF");
                        if (this.validAndHandleAppModuleItem(apiRequest, appModuleItem, hasReportModule)) {
                            appModuleItemList.add(appModuleItem);
                        }
                    }
                });
            }
        });
        return appModuleItemList;
    }

    private boolean validAndHandleAppModuleItem(ApiRequest apiRequest, AppModuleItem appModuleItem, boolean hasReportModule) {
        Boolean isZtbDriver = Optional.ofNullable(apiRequest.getIsZtbDriver()).orElse(false);
        if ("srm-loading_srm-loading".equalsIgnoreCase(appModuleItem.getId())) {
            if (!isZtbDriver.booleanValue() && (StrUtil.equals((CharSequence)appModuleItem.getAction().getDataId(), (CharSequence)"shipper") || StrUtil.equals((CharSequence)appModuleItem.getAction().getDataId(), (CharSequence)"receiver"))) {
                appModuleItem.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), appModuleItem.getName()));
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("module_type", "2");
                String url = this.digiwinEspProxyService.getSrmLoadingWebUrl(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params) + "&userId=" + apiRequest.getUserId() + "&transportType=" + (StrUtil.equals((CharSequence)appModuleItem.getAction().getDataId(), (CharSequence)"shipper") ? "1" : "2");
                appModuleItem.getAction().setRequestUrl(url);
                return true;
            }
            if (isZtbDriver.booleanValue() && StrUtil.equals((CharSequence)appModuleItem.getAction().getDataId(), (CharSequence)"driver")) {
                appModuleItem.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), appModuleItem.getName()));
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("module_type", "2");
                String url = this.digiwinEspProxyService.getSrmLoadingWebUrl(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params) + "&userId=" + apiRequest.getUserId();
                appModuleItem.getAction().setRequestUrl(url);
                return true;
            }
            return false;
        }
        if ("TipBiuBI_datasource".equalsIgnoreCase(appModuleItem.getId())) {
            if (StringUtils.hasLength((String)Optional.ofNullable(appModuleItem.getAction()).map(Action::getRequestUrl).orElse(null))) {
                String requestUrl = appModuleItem.getAction().getRequestUrl().replaceAll("\\$\\{locale}", apiRequest.getLocale()).replaceAll("\\$\\{mobile_user_token}", apiRequest.getIamUserToken());
                appModuleItem.getAction().setRequestUrl(requestUrl);
            }
        } else if ("Athena_GLOBAL_INFORMATION".equals(appModuleItem.getId())) {
            return hasReportModule;
        }
        return true;
    }

    private boolean isMatchWorkId(String userId, String pgrrGoodsCode, String iamUserToken, PurchasedGoodsEnableModule module) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("userId", userId);
        params.put("target", "drn:iam:app:" + pgrrGoodsCode);
        DigiwinIamUserAuthInfo userPermission = this.digiwinIamProxyService.getUserPermissionFunctional(iamUserToken, params);
        Boolean isMatchWorkId = false;
        Optional<List> optional = Optional.ofNullable(userPermission).map(DigiwinIamUserAuthInfo::getResult).map(DigiwinIamUserAuthResult::getPermissions);
        if (optional.isPresent() && userPermission != null && userPermission.getResult() != null) {
            isMatchWorkId = userPermission.getResult().getPermissions().stream().anyMatch(e -> e.getId().equals(module.getWorkId()) && "allow".equalsIgnoreCase(e.getEffect()));
        }
        return isMatchWorkId;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

