/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.designer.uibot.service;

import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerActionMetadataElement;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerFieldTagConfig;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.PageFieldMetaData;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.ScoredField;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.ScoredFieldsSummary;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerFieldAndOrderApplierService;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerFieldAndOrderApplierServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotBizFieldBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="uiBotDesignerFieldAndOrderApplierService")
public class UiBotDesignerFieldAndOrderApplierServiceImpl
implements UiBotDesignerFieldAndOrderApplierService {
    private static final Logger log = LoggerFactory.getLogger(UiBotDesignerFieldAndOrderApplierServiceImpl.class);

    public void applyFieldAndOrder(UiBotModel uiBotModel, UiBotDesignerConfig uiBotDesignerConfig) {
        UiBotTargetLayoutSearchResult layoutSearchResult = uiBotModel.searchPcTargetLayout();
        if (!layoutSearchResult.found()) {
            return;
        }
        List orderedFieldIds = this.getOrderedFieldIds(uiBotDesignerConfig);
        UiBotLayout pcDataLayout = layoutSearchResult.getTargetUiBotLayout();
        if (pcDataLayout.isTypeOfTable()) {
            this.applyFieldAndOrderWithPcTable(uiBotDesignerConfig, uiBotModel, orderedFieldIds, pcDataLayout);
            uiBotModel.setAppliedDesignerFieldAndOrder(Boolean.valueOf(true));
        } else if (pcDataLayout.isTypeOfFormList()) {
            this.applyFieldAndOrderWithPcFormList(uiBotDesignerConfig, uiBotModel, orderedFieldIds, pcDataLayout);
            uiBotModel.setAppliedDesignerFieldAndOrder(Boolean.valueOf(true));
        } else {
            return;
        }
    }

    private void applyFieldAndOrderWithPcTable(UiBotDesignerConfig uiBotDesignerConfig, UiBotModel uiBotModel, List<String> orderedFieldIds, UiBotLayout pcDataLayout) {
        String schema = pcDataLayout.getSchema();
        List bizDataList = (List)uiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizDataList, (String)("pagedata." + schema + " cannot be null"));
        List tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (CollectionUtils.isEmpty((Collection)tableColumnDefinitionList)) {
            return;
        }
        List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
        Map<String, UiBotTableColumn> tableColumnMap = tableColumns.stream().collect(Collectors.toMap(UiBotBizFieldBase::getSchema, c -> c, (c1, c2) -> c1));
        int resultSize = orderedFieldIds.size();
        ArrayList<UiBotTableColumnDefinition> tableColumnDefsFromDesigner = new ArrayList<UiBotTableColumnDefinition>(resultSize);
        for (String fieldId : orderedFieldIds) {
            UiBotTableColumn newUiBotTableColumn = tableColumnMap.get(fieldId);
            if (null == newUiBotTableColumn) {
                newUiBotTableColumn = new UiBotTableColumn();
                newUiBotTableColumn.setSchema(fieldId);
                UiBotDesignerActionMetadataElement metadataElement = uiBotDesignerConfig.getFieldInResponseMetadata(schema, fieldId);
                newUiBotTableColumn.setHeaderName(Optional.ofNullable(metadataElement).map(UiBotDesignerActionMetadataElement::getDescription).orElse(fieldId));
                newUiBotTableColumn.setDataType(Optional.ofNullable(metadataElement).map(UiBotDesignerActionMetadataElement::getDataType).orElse("string"));
                newUiBotTableColumn.setType(PcModuleEnum.INPUT.getValue());
            }
            newUiBotTableColumn.doSetCanEdit();
            UiBotTableColumnDefinition tableColumnDefinition = new UiBotTableColumnDefinition();
            tableColumnDefinition.setSchema(fieldId);
            tableColumnDefinition.addUiBotTableColumn(newUiBotTableColumn);
            tableColumnDefsFromDesigner.add(tableColumnDefinition);
        }
        if (!CollectionUtils.isEmpty(tableColumnDefsFromDesigner)) {
            pcDataLayout.setColumnDefs(tableColumnDefsFromDesigner);
        }
    }

    private void applyFieldAndOrderWithPcFormList(UiBotDesignerConfig uiBotDesignerConfig, UiBotModel uiBotModel, List<String> orderedFieldIds, UiBotLayout pcDataLayout) {
        String schema = pcDataLayout.getSchema();
        Map bizData = (Map)uiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizData, (String)("pagedata." + schema + " cannot be null"));
        List pcFieldLayoutList = pcDataLayout.decomposeFieldsWithPcFormList(Collections.emptyList());
        Map<String, UiBotLayout> pcFieldLayoutMap = pcFieldLayoutList.stream().collect(Collectors.toMap(UiBotBizFieldBase::getSchema, c -> c, (c1, c2) -> c1));
        int resultSize = orderedFieldIds.size();
        ArrayList<UiBotLayout> fieldLayoutFromDesigner = new ArrayList<UiBotLayout>(resultSize);
        for (String fieldId : orderedFieldIds) {
            UiBotLayout fieldLayout = pcFieldLayoutMap.get(fieldId);
            if (null == fieldLayout) {
                fieldLayout = new UiBotLayout();
                fieldLayout.setSchema(fieldId);
                UiBotDesignerActionMetadataElement metadataElement = uiBotDesignerConfig.getFieldInResponseMetadata(schema, fieldId);
                fieldLayout.setHeaderName(Optional.ofNullable(metadataElement).map(UiBotDesignerActionMetadataElement::getDescription).orElse(fieldId));
                fieldLayout.setDataType(Optional.ofNullable(metadataElement).map(UiBotDesignerActionMetadataElement::getDataType).orElse("string"));
                fieldLayout.setType(PcModuleEnum.INPUT.getValue());
            }
            fieldLayout.doSetCanEdit();
            fieldLayoutFromDesigner.add(fieldLayout);
        }
        if (!CollectionUtils.isEmpty(fieldLayoutFromDesigner)) {
            pcDataLayout.setGroup(fieldLayoutFromDesigner);
        }
    }

    @NotNull
    private List<String> getOrderedFieldIds(UiBotDesignerConfig uiBotDesignerConfig) {
        List<String> orderedFieldIds = this.getOrderedFieldIdsByScoredWords(uiBotDesignerConfig);
        if (CollectionUtils.isEmpty((Collection)orderedFieldIds)) {
            orderedFieldIds = this.getOrderedFieldIdsByTag(uiBotDesignerConfig);
        }
        if (CollectionUtils.isEmpty((Collection)orderedFieldIds)) {
            orderedFieldIds = Collections.emptyList();
        }
        return orderedFieldIds;
    }

    private List<String> getOrderedFieldIdsByScoredWords(UiBotDesignerConfig uiBotDesignerConfig) {
        Map pageFieldMetaDataMap = uiBotDesignerConfig.getPage().getPageFieldMetadataMap();
        if (CollectionUtils.isEmpty((Map)pageFieldMetaDataMap)) {
            return Collections.emptyList();
        }
        int i = 0;
        PageFieldMetaData fieldMetaData = null;
        for (Map.Entry entry : pageFieldMetaDataMap.entrySet()) {
            if (i == 1) break;
            fieldMetaData = (PageFieldMetaData)entry.getValue();
            ++i;
        }
        if (ObjectUtils.isEmpty(fieldMetaData)) {
            return Collections.emptyList();
        }
        List scoredFieldSummaries = Collections.emptyList();
        if (fieldMetaData != null) {
            scoredFieldSummaries = fieldMetaData.getNewScoreWords();
        }
        if (CollectionUtils.isEmpty(scoredFieldSummaries)) {
            return Collections.emptyList();
        }
        List scoredFields = ((ScoredFieldsSummary)scoredFieldSummaries.get(0)).getFields();
        return scoredFields.stream().sorted(Comparator.comparingLong(ScoredField::getScore).reversed()).map(ScoredField::getFieldName).collect(Collectors.toList());
    }

    private List<String> getOrderedFieldIdsByTag(UiBotDesignerConfig uiBotDesignerConfig) {
        String ORDER_TAG_CATEGORY = "ORDER";
        String TAG_CODE_SPLITTER = "__";
        String ORDER_TAG_SPLITTER = "_";
        Long ORDER_TAG_MAX_NUMBER = 999999999L;
        int fieldSize = uiBotDesignerConfig.getTagConfigs().size();
        ArrayList<DesignerFieldOrder> designerFieldOrderList = new ArrayList<DesignerFieldOrder>(fieldSize);
        for (UiBotDesignerFieldTagConfig fieldTagConfig : uiBotDesignerConfig.getTagConfigs()) {
            String fieldId = fieldTagConfig.getEspFieldId();
            Optional<KnowledgeMapsTag> optKmTag = fieldTagConfig.getTags().stream().filter(tag -> "ORDER".equals(tag.getCategory())).findFirst();
            if (null == fieldId || !optKmTag.isPresent()) continue;
            String[] splitTagCode = optKmTag.get().getCode().split("__");
            if (splitTagCode.length < 3) {
                designerFieldOrderList.add(DesignerFieldOrder.builder().fieldId(fieldId).order(ORDER_TAG_MAX_NUMBER).build());
                continue;
            }
            String orderDesc = splitTagCode[2];
            String[] splitOrderDesc = orderDesc.split("_");
            if (splitOrderDesc.length < 2) {
                designerFieldOrderList.add(DesignerFieldOrder.builder().fieldId(fieldId).order(ORDER_TAG_MAX_NUMBER).build());
                continue;
            }
            String orderNumber = splitOrderDesc[splitOrderDesc.length - 1];
            designerFieldOrderList.add(DesignerFieldOrder.builder().fieldId(fieldId).order(Long.valueOf(Long.parseLong(orderNumber))).build());
        }
        return designerFieldOrderList.stream().sorted(Comparator.comparingLong(DesignerFieldOrder::getOrder)).map(DesignerFieldOrder::getFieldId).collect(Collectors.toList());
    }
}

