/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.designer.uibot.service;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.PageDataState;
import com.digiwin.mobile.mobileuibot.designer.uibot.rule.DesignerTrigger;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerFieldAndOrderApplierService;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerFieldOperationApplierService;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerFieldTagApplierService;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="uiBotDesignerService")
public class UiBotDesignerServiceImpl
implements UiBotDesignerService {
    private static final Logger log = LoggerFactory.getLogger(UiBotDesignerServiceImpl.class);
    private final UiBotDesignerFieldAndOrderApplierService uiBotDesignerFieldAndOrderApplierService;
    private final UiBotDesignerFieldOperationApplierService uiBotDesignerFieldOperationApplierService;
    private final UiBotDesignerFieldTagApplierService uiBotDesignerFieldTagApplierService;

    public UiBotDesignerServiceImpl(UiBotDesignerFieldAndOrderApplierService uiBotDesignerFieldAndOrderApplierService, UiBotDesignerFieldOperationApplierService uiBotDesignerFieldOperationApplierService, UiBotDesignerFieldTagApplierService uiBotDesignerFieldTagApplierService) {
        this.uiBotDesignerFieldAndOrderApplierService = uiBotDesignerFieldAndOrderApplierService;
        this.uiBotDesignerFieldOperationApplierService = uiBotDesignerFieldOperationApplierService;
        this.uiBotDesignerFieldTagApplierService = uiBotDesignerFieldTagApplierService;
    }

    public void applyFieldAndOrder(UiBotModel uiBotModel, UiBotDesignerConfig uiBotDesignerConfig) {
        this.uiBotDesignerFieldAndOrderApplierService.applyFieldAndOrder(uiBotModel, uiBotDesignerConfig);
    }

    public void applyFieldTag(UiBotModel uiBotModel, UiBotDesignerConfig uiBotDesignerConfig) {
        this.uiBotDesignerFieldTagApplierService.applyFieldTag(uiBotModel, uiBotDesignerConfig);
    }

    public void applyFieldRule(UiBotModel uiBotModel, UiBotDesignerConfig uiBotDesignerConfig) {
        if (MobileRenderMetaData.RENDER_VERSION_2.equals(AppRequestContext.getContextEntity().getRenderVersion())) {
            List rules = uiBotDesignerConfig.getRuleConfigs().stream().filter(rule -> !CollectionUtils.isEmpty((Map)rule.getContentMobile())).map(rule -> {
                UiBotRule uiBotRule = (UiBotRule)JsonUtil.objectToJavaObject((Object)rule.getContentMobile(), UiBotRule.class);
                uiBotRule.setName(rule.getName());
                Optional<String> apiPrefixType = Optional.ofNullable(uiBotRule.getTrigger()).map(DesignerTrigger::getApiPrefixType);
                if (apiPrefixType.isPresent() && StringUtils.isNotEmpty((CharSequence)apiPrefixType.get().trim())) {
                    String prefixUrl = AppContext.getUrl((String)apiPrefixType.get());
                    Optional<String> apiUrl = Optional.ofNullable(uiBotRule.getTrigger()).map(DesignerTrigger::getApiUrl);
                    if (apiUrl.isPresent() && StringUtils.isNotEmpty((CharSequence)apiUrl.get().trim())) {
                        uiBotRule.getTrigger().setApiUrl(prefixUrl + apiUrl.get());
                    }
                }
                return uiBotRule;
            }).collect(Collectors.toList());
            uiBotModel.setRules(rules);
        }
    }

    public void applyFieldOperation(UiBotModel uiBotModel, UiBotDesignerConfig uiBotDesignerConfig) {
        PageDataState pageDataState;
        List pageTmOperationList;
        List openWindowPageTmOperationList = new ArrayList(1);
        List singleSelectPageTmOperationList = new ArrayList(1);
        for (int i = 0; i < uiBotDesignerConfig.getPage().getDataStates().size() && i != 1 && !CollectionUtils.isEmpty((Collection)(pageTmOperationList = (pageDataState = (PageDataState)uiBotDesignerConfig.getPage().getDataStates().get(i)).getOperations())); ++i) {
            openWindowPageTmOperationList = pageDataState.getOpenWindowOperationList();
            singleSelectPageTmOperationList = pageDataState.getEditorSelectOperationList();
        }
        this.uiBotDesignerFieldOperationApplierService.applyOpenWindowOperation(uiBotModel, openWindowPageTmOperationList);
        this.uiBotDesignerFieldOperationApplierService.applySingleSelectOperation(uiBotModel, singleSelectPageTmOperationList);
    }
}

