/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.experience;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppEnvDeployAreaEnum;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.experience.dao.ExperienceRoleRepository;
import com.digiwin.mobile.mobileuibot.experience.model.ExperienceRole;
import com.digiwin.mobile.mobileuibot.experience.model.ExperienceRoleIdEnum;
import com.digiwin.mobile.mobileuibot.mock.MockService;
import com.digiwin.mobile.mobileuibot.mock.enums.EnableEnum;
import com.digiwin.mobile.mobileuibot.model.Mock;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoExperienceRoleConfigDataQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoExperienceRoleConfigDataResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.service.DigiwinAgileDataEchoProxyService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/mobile/v1/experience"})
public class ExperienceController {
    @Autowired
    private ExperienceRoleRepository experienceRoleRepository;
    @Autowired
    private MockService mockService;
    @Autowired
    private DigiwinAgileDataEchoProxyService echoProxyService;

    @PostMapping(value={"/role/list"})
    public ApiResponse<Map> getExperienceRoleList(HttpServletRequest request) {
        HashMap<String, List> data = new HashMap<String, List>();
        try {
            Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
            String locale = (String)StringUtils.defaultIfBlank((CharSequence)String.valueOf(params.get("locale")), (CharSequence)"zh_CN");
            String channel = (String)params.get("channel");
            String district = Objects.equals(AppEnvDeployAreaEnum.CN.toString(), AppContext.getEnvDeployArea()) ? "CN" : "TW";
            List roleList = this.experienceRoleRepository.getRoleList();
            if (!CollectionUtils.isEmpty((Collection)roleList) && StringUtils.isNotBlank((CharSequence)channel) && channel.equals("line")) {
                roleList = roleList.stream().filter(role -> Objects.nonNull(role.getNanaAssistant()) && role.getNanaAssistant() == 1).collect(Collectors.toList());
            }
            List experienceRoleConfigList = this.echoProxyService.queryExperienceRoleConfigList(EchoExperienceRoleConfigDataQueryDTO.builder().locale(locale).district(district).build());
            if (CollectionUtils.isEmpty((Collection)roleList) && CollectionUtils.isEmpty((Collection)experienceRoleConfigList)) {
                data.put("roleList", new ArrayList());
                return ApiResponse.buildOK().setData(data);
            }
            if (CollectionUtils.isEmpty(roleList)) {
                roleList = experienceRoleConfigList.stream().map(dto -> new ExperienceRole(dto.getId(), dto.getRoleId(), dto.getRoleName(), dto.getSort())).collect(Collectors.toList());
            }
            roleList.forEach(role -> {
                role.setRoleName(Optional.ofNullable(role.getRoleNameMap()).map(map -> (String)map.get(locale)).orElse(role.getRoleName()));
                role.setRoleNameMap(null);
            });
            roleList = ExperienceController.handleAgileDataExperienceRoles((List)experienceRoleConfigList, roleList);
            roleList.sort(Comparator.comparing(ExperienceRole::getSort));
            List list = (List)JsonUtil.objectToJavaObject((Object)roleList, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            List<Mock> mockList = this.mockService.mockListOfPublish();
            if (!CollectionUtils.isEmpty((Collection)mockList)) {
                if (StringUtils.isNotBlank((CharSequence)channel) && channel.equals("line")) {
                    mockList = mockList.stream().filter(mock -> Objects.nonNull(mock.getEnableNana()) && EnableEnum.YES.getValue().equals(mock.getEnableNana())).collect(Collectors.toList());
                }
                mockList.forEach(mock -> {
                    if (EnableEnum.YES.getValue().equals(mock.getEnableNana())) {
                        mock.setMockRoleId(ExperienceRoleIdEnum.ATHENA_MOCK.getValue());
                    }
                });
                list.addAll((Collection)JsonUtil.objectToJavaObject((Object)mockList, (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
            }
            data.put("roleList", list);
        }
        catch (IOException e) {
            return ApiResponse.buildError((String)("\u83b7\u53d6\u89d2\u8272\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()));
        }
        catch (Exception e) {
            return ApiResponse.buildError((String)("\u83b7\u53d6\u89d2\u8272\u5217\u8868\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        return ApiResponse.buildOK().setData(data);
    }

    private static List<ExperienceRole> handleAgileDataExperienceRoles(List<EchoExperienceRoleConfigDataResultDTO> experienceRoleConfigList, List<ExperienceRole> roleList) {
        if (!CollectionUtils.isEmpty(experienceRoleConfigList)) {
            Map<String, ExperienceRole> roleMap = roleList.stream().collect(Collectors.toMap(ExperienceRole::getRoleId, role -> role, (a, b) -> b));
            for (EchoExperienceRoleConfigDataResultDTO dto : experienceRoleConfigList) {
                roleMap.computeIfPresent(dto.getRoleId(), (id, role) -> {
                    role.setRoleName(dto.getRoleName());
                    role.setSort(dto.getSort());
                    return role;
                });
                roleMap.putIfAbsent(dto.getRoleId(), new ExperienceRole(dto.getId(), dto.getRoleId(), dto.getRoleName(), dto.getSort()));
            }
            roleList = new ArrayList<ExperienceRole>(roleMap.values());
        }
        return roleList;
    }
}

