/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.file;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.dap.middleware.dmc.model.DirInfo;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.mobile.mobileuibot.api.AgileDataUploadAttachment;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.ApiSegmentedUploadAttachment;
import com.digiwin.mobile.mobileuibot.api.ApiUploadAttachment;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.file.FileService;
import com.digiwin.mobile.mobileuibot.file.fileupload.ContentTypeEnum;
import com.digiwin.mobile.mobileuibot.file.fileupload.UploadFile;
import com.digiwin.mobile.mobileuibot.file.fileupload.UploadFileLocationEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mapper.FileUploadRecordMapper;
import com.digiwin.mobile.mobileuibot.model.FileUploadRecord;
import com.digiwin.mobile.mobileuibot.proxy.aam.model.AttachmentMessage;
import com.digiwin.mobile.mobileuibot.proxy.aam.model.AttachmentResponse;
import com.digiwin.mobile.mobileuibot.proxy.aam.service.DigiwinAamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtSubmitLiteProcessMessageResult;
import com.digiwin.mobile.mobileuibot.proxy.adt.service.DigiwinAdtProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.model.SegmentedUploadFileDTO;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import io.micrometer.core.instrument.util.StringUtils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.web.multipart.MultipartFile;

@Service(value="fileService")
public class FileServiceImpl
extends ServiceImpl<FileUploadRecordMapper, FileUploadRecord>
implements FileService {
    public static final int FILE_UPLOAD_PART_SIZE = 5222400;
    @Autowired
    private FileService fileService;
    private static final Logger logger = LoggerFactory.getLogger(FileServiceImpl.class);
    private static final String CALENDAR_ATTACHMENT_DIR = "calendar_file_category";
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;
    @Autowired
    private DigiwinAamProxyService digiwinAamProxyService;
    @Autowired
    private DigiwinAdtProxyService digiwinAdtProxyService;
    @Autowired
    private LocaleService localeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> uploadFile(ApiUploadAttachment apiAttachment, int uploadPC1) {
        HashMap<String, Object> hashMap;
        String fileId;
        String uploadCategory;
        String uploadCategoryId;
        MultipartFile file;
        StopWatch stopWatch;
        HashMap<String, Object> result;
        block12: {
            boolean uploadPC = false;
            if (uploadPC1 != 0) {
                uploadPC = true;
            }
            result = new HashMap<String, Object>();
            if (apiAttachment == null) {
                result.put("code", "-1");
                result.put("message", "\u8bf7\u6c42\u6570\u636e\u6709\u8bef");
                return result;
            }
            stopWatch = new StopWatch("uploadFile");
            stopWatch.start("get MultipartFile from request");
            file = apiAttachment.getFile();
            stopWatch.stop();
            if (file == null) {
                result.put("code", "-1");
                result.put("message", "\u6587\u4ef6\u4e3a\u7a7a");
                return result;
            }
            uploadCategoryId = "";
            uploadCategory = "";
            AttachmentRawDataDigiwinAthena rawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
            if (StringUtils.isNotBlank((String)apiAttachment.getRawData()) && !"null".equals(apiAttachment.getRawData()) && !"NULL".equals(apiAttachment.getRawData())) {
                rawDataDigiwinAthena = (AttachmentRawDataDigiwinAthena)JsonUtil.jsonStringToObject((String)apiAttachment.getRawData(), AttachmentRawDataDigiwinAthena.class);
                uploadCategoryId = rawDataDigiwinAthena.getUploadCategoryId();
                uploadCategory = rawDataDigiwinAthena.getUploadCategory();
                uploadCategoryId = StringUtils.isBlank((String)uploadCategoryId) && StringUtils.isNotBlank((String)uploadCategory) ? this.digiwinDmcProxyService.getDirIdByName(uploadCategory, rawDataDigiwinAthena.getBuckets()) : "00000000-0000-0000-0000-000000000000";
            } else {
                uploadCategoryId = this.digiwinDmcProxyService.getDirIdByName(CALENDAR_ATTACHMENT_DIR);
            }
            stopWatch.start("upload file to Digiwin DMC");
            if (StringUtils.isNotBlank((String)uploadCategoryId)) {
                this.digiwinDmcProxyService.createDir(uploadCategoryId, rawDataDigiwinAthena.getUploadCategory(), rawDataDigiwinAthena.getBuckets());
            }
            logger.error("begin -- upload file info, contentType:{}", (Object)file.getContentType());
            String fileExtendName = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
            String contentType = ContentTypeEnum.getContentTypeByName((String)fileExtendName);
            if (StringUtils.isEmpty((String)contentType)) {
                contentType = file.getContentType();
            }
            FileInfo fileInfo = this.digiwinDmcProxyService.uploadFile(file.getBytes(), file.getOriginalFilename(), contentType, uploadCategoryId, rawDataDigiwinAthena.getBuckets());
            logger.error("end -- upload file info, fileId:{}, contentType:{}", (Object)fileInfo.getId(), (Object)contentType);
            stopWatch.stop();
            fileId = fileInfo.getId();
            stopWatch.start("get file shareurl from Digiwin DMC");
            stopWatch.stop();
            Boolean disableAam = rawDataDigiwinAthena.getDisableAam();
            if (!uploadPC || Optional.ofNullable(disableAam).orElse(true).booleanValue()) break block12;
            stopWatch.start("upload file to Athena ATDM");
            AttachmentMessage attachmentMessage = new AttachmentMessage();
            attachmentMessage.setId(fileId);
            attachmentMessage.setName(apiAttachment.getFileName());
            attachmentMessage.setSize(apiAttachment.getFileSize());
            attachmentMessage.setCategory(uploadCategory);
            attachmentMessage.setCategoryId(uploadCategoryId);
            attachmentMessage.setTenantId(apiAttachment.getTenantId());
            attachmentMessage.setProjectId(rawDataDigiwinAthena.getTmTaskId());
            attachmentMessage.setRowDataKey(rawDataDigiwinAthena.getRowDataKey());
            attachmentMessage.setTaskId(rawDataDigiwinAthena.getTmActivityId());
            AttachmentResponse attachmentResponse = this.digiwinAamProxyService.uploadFile(attachmentMessage, apiAttachment.getIamUserToken());
            stopWatch.stop();
            if (attachmentResponse.getStatus() == 200) break block12;
            result.put("code", "-1");
            result.put("message", attachmentResponse.getStatusDescription());
            HashMap<String, Object> hashMap2 = result;
            logger.debug("FileName:{}, FileSize:{} bytes\n{} ms\n{}", new Object[]{file.getOriginalFilename(), file.getSize(), stopWatch.getTotalTimeMillis(), stopWatch.prettyPrint()});
            return hashMap2;
        }
        try {
            result.put("fileId", fileId);
            result.put("uploadCategory", uploadCategory);
            result.put("uploadCategoryId", uploadCategoryId);
            result.put("code", "200");
            hashMap = result;
        }
        catch (IOException e) {
            HashMap<String, Object> hashMap3;
            try {
                e.printStackTrace();
                result.put("code", "-1");
                result.put("message", "File Read IO Exception!");
                hashMap3 = result;
            }
            catch (Throwable throwable) {
                logger.debug("FileName:{}, FileSize:{} bytes\n{} ms\n{}", new Object[]{file.getOriginalFilename(), file.getSize(), stopWatch.getTotalTimeMillis(), stopWatch.prettyPrint()});
                throw throwable;
            }
            logger.debug("FileName:{}, FileSize:{} bytes\n{} ms\n{}", new Object[]{file.getOriginalFilename(), file.getSize(), stopWatch.getTotalTimeMillis(), stopWatch.prettyPrint()});
            return hashMap3;
        }
        logger.debug("FileName:{}, FileSize:{} bytes\n{} ms\n{}", new Object[]{file.getOriginalFilename(), file.getSize(), stopWatch.getTotalTimeMillis(), stopWatch.prettyPrint()});
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> uploadFile(String strBase64, String buckets, String uploadCategory, boolean disableAam, String iamUserToken, String tenantId) {
        HashMap<String, Object> hashMap;
        String fileId;
        String originalFilename;
        StopWatch stopWatch;
        String uploadCategoryId;
        int fileSize;
        HashMap<String, Object> result;
        block8: {
            result = new HashMap<String, Object>();
            if (StrUtil.isAllBlank((CharSequence[])new CharSequence[]{strBase64, buckets, uploadCategory})) {
                result.put("code", "-1");
                result.put("message", "\u8bf7\u6c42\u6570\u636e\u6709\u8bef");
                return result;
            }
            byte[] decode = Base64.decode((CharSequence)strBase64);
            fileSize = decode.length;
            if (decode == null || decode.length == 0) {
                result.put("code", "-1");
                result.put("message", "base64\u4e3a\u7a7a");
                return result;
            }
            uploadCategoryId = this.digiwinDmcProxyService.getDirIdByName(uploadCategory, buckets);
            stopWatch = new StopWatch("uploadFile");
            originalFilename = UUID.randomUUID() + ".png";
            stopWatch.start("upload file to Digiwin DMC");
            if (StringUtils.isNotBlank((String)uploadCategoryId)) {
                this.digiwinDmcProxyService.createDir(uploadCategoryId, uploadCategory, buckets);
            }
            FileInfo fileInfo = this.digiwinDmcProxyService.uploadFile(decode, originalFilename, null, uploadCategoryId, buckets);
            stopWatch.stop();
            fileId = fileInfo.getId();
            stopWatch.start("get file shareurl from Digiwin DMC");
            stopWatch.stop();
            if (Optional.ofNullable(disableAam).orElse(true).booleanValue() || !StrUtil.isAllNotBlank((CharSequence[])new CharSequence[]{iamUserToken, tenantId})) break block8;
            stopWatch.start("upload file to Athena ATDM");
            AttachmentMessage attachmentMessage = new AttachmentMessage();
            attachmentMessage.setId(fileId);
            attachmentMessage.setName(originalFilename);
            attachmentMessage.setSize((long)fileSize);
            attachmentMessage.setCategory(uploadCategory);
            attachmentMessage.setCategoryId(uploadCategoryId);
            attachmentMessage.setTenantId(tenantId);
            AttachmentResponse attachmentResponse = this.digiwinAamProxyService.uploadFile(attachmentMessage, iamUserToken);
            stopWatch.stop();
            if (attachmentResponse.getStatus() == 200) break block8;
            result.put("code", "-1");
            result.put("message", attachmentResponse.getStatusDescription());
            HashMap<String, Object> hashMap2 = result;
            logger.debug("FileName:{}, FileSize:{} bytes\n{} ms\n{}", new Object[]{originalFilename, fileSize, stopWatch.getTotalTimeMillis(), stopWatch.prettyPrint()});
            return hashMap2;
        }
        try {
            logger.error("\u6765\u6765\u6765\uff0c\u6211\u4eec\u770b\u770b\u3002fileId:{}", (Object)fileId);
            result.put("fileId", fileId);
            result.put("uploadCategory", uploadCategory);
            result.put("uploadCategoryId", uploadCategoryId);
            result.put("code", "200");
            hashMap = result;
        }
        catch (Exception e) {
            HashMap<String, Object> hashMap3;
            try {
                e.printStackTrace();
                result.put("code", "-1");
                result.put("message", "\u4e0a\u4f20\u5931\u8d25");
                hashMap3 = result;
            }
            catch (Throwable throwable) {
                logger.debug("FileName:{}, FileSize:{} bytes\n{} ms\n{}", new Object[]{originalFilename, fileSize, stopWatch.getTotalTimeMillis(), stopWatch.prettyPrint()});
                throw throwable;
            }
            logger.debug("FileName:{}, FileSize:{} bytes\n{} ms\n{}", new Object[]{originalFilename, fileSize, stopWatch.getTotalTimeMillis(), stopWatch.prettyPrint()});
            return hashMap3;
        }
        logger.debug("FileName:{}, FileSize:{} bytes\n{} ms\n{}", new Object[]{originalFilename, fileSize, stopWatch.getTotalTimeMillis(), stopWatch.prettyPrint()});
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> uploadFile(UploadFile uploadFile) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (null == uploadFile) {
            result.put("code", "-1");
            result.put("message", "\u8bf7\u6c42\u6570\u636e\u6709\u8bef");
            return result;
        }
        List files = uploadFile.getFiles();
        if (CollectionUtils.isEmpty((Collection)files)) {
            result.put("code", "-1");
            result.put("message", "\u8bf7\u6c42\u6570\u636e\u6709\u8bef");
            return result;
        }
        String dirName = "athenamobile_log_nfclogin";
        String dirId = this.digiwinDmcProxyService.getDirIdByName(dirName, "Athena");
        ArrayList<FileUploadRecord> fileUploadRecordList = new ArrayList<FileUploadRecord>();
        for (MultipartFile file : files) {
            if (file == null) {
                result.put("code", "-1");
                result.put("message", "\u6587\u4ef6\u4e3a\u7a7a");
                return result;
            }
            try {
                if (StringUtils.isNotBlank((String)dirId)) {
                    this.digiwinDmcProxyService.createDir(dirId, dirName, "Athena");
                }
                String fileId = this.digiwinDmcProxyService.uploadFile(file.getBytes(), file.getOriginalFilename(), file.getContentType(), dirId, "Athena").getId();
                ShareInfo shareInfo = this.digiwinDmcProxyService.shareFile(fileId, "Athena");
                fileUploadRecordList.add(new FileUploadRecord().setUserId(uploadFile.getUserId()).setUserName(uploadFile.getUserName()).setTenantId(uploadFile.getTenantId()).setAppPackageName(uploadFile.getPackageName()).setUploadLocation(UploadFileLocationEnum.DMC.getLocation()).setDirName(dirName).setFileId(fileId).setFileName(file.getOriginalFilename()).setOriginalFileName(file.getOriginalFilename()).setFileUrl(shareInfo.getUrl()).setFileSize(Long.valueOf(file.getSize())).setUploadTime(new Date()).setAppVersion(uploadFile.getVersion()).setAppDeviceType(uploadFile.getDeviceType()));
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("file upload error :", (Throwable)e);
                result.put("code", "-1");
                result.put("message", "File Read IO Exception!");
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            finally {
                logger.debug("file upload success, FileName:{}, FileSize:{}", (Object)file.getOriginalFilename(), (Object)file.getSize());
            }
        }
        this.fileService.saveBatch(fileUploadRecordList);
        return result;
    }

    public String segmentedUploadFile(ApiSegmentedUploadAttachment uploadFile) {
        String iamUserToken = uploadFile.getIamUserToken();
        String bucket = uploadFile.getBucket();
        Assert.isTrue((!uploadFile.getFile().isEmpty() ? 1 : 0) != 0, (String)"MultipartFile cannot be null.");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)iamUserToken), (String)"iamUserToken cannot be null.");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)bucket), (String)"bucket cannot be null.");
        SegmentedUploadFileDTO dto = new SegmentedUploadFileDTO();
        dto.setFileName(uploadFile.getFile().getOriginalFilename());
        dto.setDisplayName(uploadFile.getDisplayName());
        dto.setDescription(uploadFile.getDescription());
        dto.setTag(uploadFile.getTag());
        dto.setExpireDate(uploadFile.getExpireDate());
        dto.setDirectoryId(uploadFile.getDirectoryId());
        dto.setTenantId(uploadFile.getTenantId());
        String uploadId = this.digiwinDmcProxyService.segmentedUploadFile(dto, bucket, iamUserToken);
        if (null == uploadId) {
            return null;
        }
        long fileLength = uploadFile.getFile().getSize();
        int partCount = (int)Math.ceil((double)fileLength / 5222400.0);
        if (partCount > 10000) {
            throw new ServiceException("SegmentedUploadFile: Total parts count should not exceed 10000.");
        }
        return this.partUpload(uploadFile.getFile(), uploadId, partCount, fileLength, iamUserToken, bucket);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String partUpload(MultipartFile file, String fileId, int partCount, long fileLength, String token, String bucket) {
        try (FileChannel channel = new RandomAccessFile(FileUtil.multipartFileToFile((MultipartFile)file), "r").getChannel();){
            MappedByteBuffer map = channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileLength);
            for (int i = 0; i < partCount; ++i) {
                int startPos = i * 5222400;
                int curPartSize = i + 1 == partCount ? (int)(fileLength - (long)startPos) : 5222400;
                byte[] buffer = new byte[curPartSize];
                map.get(buffer, 0, curPartSize);
                ByteArrayResource resource = new ByteArrayResource(buffer);
                this.digiwinDmcProxyService.segmentUploadCreateFile((Resource)resource, token, bucket, fileId, Integer.valueOf(startPos), Integer.valueOf(startPos + curPartSize - 1), Integer.valueOf((int)fileLength));
                logger.debug("\u603b\u5171\uff1a{}\u6bb5, \u7b2c{}\u6bb5\u4e0a\u4f20\u6210\u529f\uff1afileId={},startPos={},curPartSize={}.", new Object[]{partCount, i + 1, fileId, startPos, curPartSize});
            }
            String string = fileId;
            return string;
        }
        catch (Exception e) {
            logger.error("\u5206\u6bb5\u4e0a\u4f20\u5931\u8d25\uff1afileId={},partSize={},partCount={},curPartSize={}.", new Object[]{fileId, 5222400, partCount, fileLength, e});
            return null;
        }
    }

    public ApiResponse uploadFileAgileData(AgileDataUploadAttachment apiAttachment) {
        FileInfo info;
        String iamUserToken = apiAttachment.getIamUserToken();
        String tenantId = apiAttachment.getTenantId();
        String directoryName = apiAttachment.getDirectoryName();
        String bucket = apiAttachment.getBucket();
        String locale = apiAttachment.getLocale();
        if (apiAttachment.getIfCommonFlag().booleanValue()) {
            String fileId = apiAttachment.getFileId();
            if (StringUtils.isBlank((String)fileId)) {
                return ApiResponse.buildError((String)this.localeService.getLanguageValue(locale, "\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            return this.getAdtProcessMessageResponse(iamUserToken, tenantId, Boolean.valueOf(true), fileId, locale);
        }
        if (apiAttachment.getFile() == null) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(locale, "\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        try {
            String directoryId = this.digiwinDmcProxyService.getDirIdByName(directoryName, bucket);
            if (StringUtils.isBlank((String)directoryId)) {
                DirInfo dirInfo = this.digiwinDmcProxyService.createDir(directoryId, directoryName, bucket);
                directoryId = dirInfo.getId();
            }
            if ((info = this.uploadDirFile(apiAttachment, directoryId, bucket)) == null) {
                return ApiResponse.buildError((String)this.localeService.getLanguageValue(locale, "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
            }
        }
        catch (Exception e) {
            logger.error("\u654f\u6377\u6570\u636eLite\u7248\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25, error:{}", (Object)e.getMessage(), (Object)e);
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(locale, "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
        }
        return this.getAdtProcessMessageResponse(iamUserToken, tenantId, Boolean.valueOf(false), info.getId(), locale);
    }

    public List<Map<String, String>> getDirFileList(ApiRequest apiRequest) {
        List fileInfos;
        String tenantId = apiRequest.getTenantId();
        String dirName = "AgileDataDemo".equalsIgnoreCase(tenantId) ? "lite_executiveAssistantUploadFile" : "lite_attachment_demo";
        String directoryId = this.digiwinDmcProxyService.getDirIdByName(dirName, "asada");
        if (StringUtils.isBlank((String)directoryId)) {
            return Collections.emptyList();
        }
        try {
            fileInfos = this.digiwinDmcProxyService.getFileInfos(directoryId, "asada");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty((Collection)fileInfos)) {
            return Collections.emptyList();
        }
        return fileInfos.stream().map(fileInfo -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("previewFileUrl", this.getFileUrl(fileInfo.getId()));
            map.put("fileStreamUrl", this.geFileStreamUrl(fileInfo.getId()));
            map.put("fileId", fileInfo.getId());
            map.put("name", fileInfo.getFileName());
            return map;
        }).collect(Collectors.toList());
    }

    private FileInfo uploadDirFile(AgileDataUploadAttachment apiAttachment, String directoryId, String bucket) throws IOException {
        MultipartFile file = apiAttachment.getFile();
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileName(file.getOriginalFilename());
        fileInfo.setDisplayName(file.getOriginalFilename());
        fileInfo.setDescription(file.getOriginalFilename());
        fileInfo.setDirectoryId(directoryId);
        fileInfo.setTenantId(apiAttachment.getTenantId());
        fileInfo.setBucket(bucket);
        return this.digiwinDmcProxyService.uploadFile(file.getInputStream(), fileInfo);
    }

    private ApiResponse getAdtProcessMessageResponse(String iamUserToken, String tenantId, Boolean ifCommonFlag, String fileId, String locale) {
        DigiwinAdtSubmitLiteProcessMessageResult adtSubmitLiteProcessMessageResult = new DigiwinAdtSubmitLiteProcessMessageResult();
        if ("AgileDataDemo".equalsIgnoreCase(tenantId)) {
            this.handleDemonstrationTenant(locale, adtSubmitLiteProcessMessageResult);
        } else {
            adtSubmitLiteProcessMessageResult = this.digiwinAdtProxyService.submitLiteProcessMessage(iamUserToken, tenantId, this.geFileStreamUrl(fileId), ifCommonFlag);
            if (adtSubmitLiteProcessMessageResult == null) {
                return ApiResponse.buildError((String)this.localeService.getLanguageValue(locale, "\u670d\u52a1\u5f02\u5e38,\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
            }
            adtSubmitLiteProcessMessageResult.setFileUrl(this.getFileUrl(fileId));
        }
        return ApiResponse.buildOK().setData((Object)adtSubmitLiteProcessMessageResult);
    }

    private void handleDemonstrationTenant(String locale, DigiwinAdtSubmitLiteProcessMessageResult adtSubmitLiteProcessMessageResult) {
        adtSubmitLiteProcessMessageResult.setSendNana(true);
        adtSubmitLiteProcessMessageResult.setPrompt(this.localeService.getLanguageValue(locale, "\u4f60\u5df2\u6210\u529f\u4e0a\u4f20Excel\u6587\u4ef6\uff0c\u8bf7\u53c2\u8003\u4e0b\u65b9\u793a\u4f8b\u95ee\u53e5\u63d0\u95ee"));
        adtSubmitLiteProcessMessageResult.setSuccess(Boolean.valueOf(true));
        adtSubmitLiteProcessMessageResult.setMultiDialogue(false);
        adtSubmitLiteProcessMessageResult.setSentences(Arrays.asList(this.localeService.getLanguageValue(locale, "2024\u5e74\u9884\u6d4b\u91d1\u989d\u7684\u8d8b\u52bf"), this.localeService.getLanguageValue(locale, "2024\u5e74\u5404\u4e2a\u4e1a\u52a1\u5458\u7684\u9884\u6d4b\u91d1\u989d")));
    }

    private String geFileStreamUrl(String fileId) {
        return AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/" + "asada" + "/preview/" + fileId;
    }

    private String getFileUrl(String fileId) {
        return AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/" + "asada" + "/online/preview/" + fileId;
    }
}

