/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.im;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.im.IMService;
import com.digiwin.mobile.mobileuibot.im.TeamInfo;
import com.digiwin.mobile.mobileuibot.im.addmembers.IMAddMembersRequest;
import com.digiwin.mobile.mobileuibot.im.getuserinfo.ImUserInfoRequest;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.ExpireApplicationNoticeDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTask;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfoTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMTeam;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMTeamTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMUser;
import com.digiwin.mobile.mobileuibot.proxy.im.model.TeamMember;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/im"})
public class IMController {
    public static final int PERSON_TYPE_ENTERPRISER = 1;
    public static final int PERSON_TYPE_INTERNAL_USER = 0;
    @Autowired
    private IMService imService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    @RequestMapping(value={"/user/info"}, method={RequestMethod.POST})
    public ApiResponse<IMUser> getNimLoginInfo(HttpServletRequest request) throws IOException {
        IMUser imUser;
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String iamUserToken = (String)params.get("iamUserToken");
        String tenantId = String.valueOf(params.get("tenantId"));
        Object nanaTenantId = request.getAttribute("nanaTenantId");
        if (nanaTenantId != null) {
            tenantId = nanaTenantId.toString();
        }
        if ((imUser = this.imService.getIMUserByToken(iamUserToken, tenantId)) != null && StringUtils.hasLength((String)imUser.getAccid())) {
            return ApiResponse.buildOK().setData((Object)imUser);
        }
        return ApiResponse.buildError();
    }

    @RequestMapping(value={"/user/getAndCreate"}, method={RequestMethod.POST})
    public ApiResponse<IMUser> getAndCreateUserInfo(HttpServletRequest request) throws IOException {
        String tenantId;
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String iamUserToken = (String)params.get("iamUserToken");
        IMUser imUser = this.imService.getAndCreateIMUserByToken(iamUserToken, tenantId = String.valueOf(params.get("tenantId")));
        if (imUser != null) {
            return ApiResponse.buildOK().setData((Object)imUser);
        }
        return ApiResponse.buildError();
    }

    @RequestMapping(value={"/project/tasklist"}, method={RequestMethod.POST})
    public ApiResponse<List<DigiwinAtmcTask>> getTaskList(HttpServletRequest request) throws IOException {
        String locale;
        String tenantId;
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String iamUserToken = (String)params.get("iamUserToken");
        String projectID = (String)params.get("projectId");
        List digiwinAtmcTasks = this.digiwinAtmcProxyService.getTaskListByProjectId(projectID, iamUserToken, tenantId = "", locale = (String)params.get("locale"));
        if (digiwinAtmcTasks != null && digiwinAtmcTasks.size() > 0) {
            return ApiResponse.buildOK().setData((Object)digiwinAtmcTasks);
        }
        return ApiResponse.buildError();
    }

    @Deprecated
    @RequestMapping(value={"/project/getAllTaskAndBackLog"}, method={RequestMethod.POST})
    public ApiResponse getAllTaskAndBackLog(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String iamUserToken = params.getOrDefault("iamUserToken", "");
        String clientId = params.getOrDefault("clientId", "");
        String locale = params.getOrDefault("locale", "");
        String tenantId = params.getOrDefault("tenantId", "");
        return ApiResponse.buildError();
    }

    @RequestMapping(value={"/team/create"}, method={RequestMethod.POST})
    public ApiResponse<IMTeam> teamCreate(HttpServletRequest request, @RequestBody IMTeam imTeam) throws IOException {
        DigiwinAthenaApiResponse createResponse;
        boolean createSuccess;
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String iamUserToken = (String)params.get("iamUserToken");
        String tenantId = String.valueOf(params.get("tenantId"));
        if (params.get("pId") != null && StringUtils.hasLength((String)((String)params.get("pId")))) {
            imTeam.setPId((String)params.get("pId"));
        }
        boolean bl = createSuccess = (createResponse = this.imService.teamCreate(iamUserToken, imTeam, tenantId)).getStatus() == 200;
        if (createSuccess) {
            return ApiResponse.buildOK((String)((String)createResponse.getResponse())).setData((Object)imTeam);
        }
        return ApiResponse.buildError((String)createResponse.getStatusDescription()).setData((Object)imTeam);
    }

    @RequestMapping(value={"/team/addmembers"}, method={RequestMethod.POST})
    public ApiResponse<IMAddMembersRequest> addMembers(@RequestBody IMAddMembersRequest imAddMembersRequest) {
        boolean addMembersSuccess;
        DigiwinAthenaApiResponse addResponse = this.imService.teamAddMembers(imAddMembersRequest);
        boolean bl = addMembersSuccess = addResponse.getStatus() == 200;
        if (addMembersSuccess) {
            return ApiResponse.buildOK((String)((String)addResponse.getResponse())).setData((Object)imAddMembersRequest);
        }
        return ApiResponse.buildError((String)addResponse.getStatusDescription()).setData((Object)imAddMembersRequest);
    }

    @RequestMapping(value={"/getEnterpriseUserInfo"}, method={RequestMethod.POST})
    public ApiResponse<List<DigiwinIamUserInfo>> getEnterpriseUserInfo(@RequestBody ImUserInfoRequest imUserInfoRequest) throws IOException {
        String locale = imUserInfoRequest.getLocale();
        String iamUserToken = imUserInfoRequest.getIamUserToken();
        List userIds = imUserInfoRequest.getUserIds();
        List userInfos = this.digiwinIamProxyService.userList(userIds, iamUserToken, locale);
        if (null == userInfos) {
            return ApiResponse.buildError((String)"error occurred in get user list from Digiwin IAM");
        }
        String enterpriseTypeUserEnterpriseName = LocaleUtil.getMobileTextByKey((String)locale, (String)"\u4f01\u4e1a\u7528\u6237");
        for (DigiwinIamUserInfo userInfo : userInfos) {
            if (!Objects.equals(DigiwinIamUserInfoTypeEnum.ENTERPRISE.getValue(), userInfo.getType())) continue;
            userInfo.setEnterpriseName(enterpriseTypeUserEnterpriseName);
        }
        return ApiResponse.buildOK().setData((Object)userInfos);
    }

    @RequestMapping(value={"/getTeamMembers"}, method={RequestMethod.POST})
    public ApiResponse<TeamInfo> getTeamMembers(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String iamUserToken = (String)params.get("iamUserToken");
        String teamId = (String)params.get("teamId");
        Integer type = (Integer)params.get("type");
        String clientId = (String)params.get("clientId");
        String locale = (String)params.get("locale");
        String pId = (String)params.get("pId");
        String bizId = (String)params.get("bizId");
        String tenantId = String.valueOf(params.get("tenantId"));
        TeamInfo teamInfo = this.getTeamMembers(iamUserToken, teamId, type, locale, bizId, tenantId);
        return ApiResponse.buildOK().setData((Object)teamInfo);
    }

    @NotNull
    private TeamInfo getTeamMembers(String iamUserToken, String teamId, Integer type, String locale, String bizId, String tenantId) {
        TeamInfo teamInfo = new TeamInfo();
        String pattern = "^\\d+";
        boolean isNumber = bizId.matches(pattern);
        if (Objects.equals(type, IMTeamTypeEnum.PROJECT_TYPE.getValue())) {
            DigiwinAtmcProject digiwinAtmcProject = null;
            if (isNumber) {
                digiwinAtmcProject = this.digiwinAtmcProxyService.getDigiwinAtmcProjectByAimMessage(locale, iamUserToken, bizId, "task");
            }
            if (digiwinAtmcProject != null) {
                if (this.dealDateFormat(digiwinAtmcProject.getStartTime()) == null) {
                    teamInfo.setTitle("");
                } else {
                    teamInfo.setTitle(this.dealDateFormat(digiwinAtmcProject.getStartTime()) + "~" + this.dealDateFormat(digiwinAtmcProject.getEndTime()));
                }
                teamInfo.setType(IMTeamTypeEnum.PROJECT_TYPE.getValue() + "");
            }
        } else if (Objects.equals(type, IMTeamTypeEnum.TASK_TYPE.getValue())) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = null;
            if (isNumber) {
                digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, bizId);
            }
            if (digiwinAtmcBacklogDetail != null) {
                if (this.dealDateFormat(digiwinAtmcBacklogDetail.getEndTime()) == null) {
                    teamInfo.setTitle("");
                } else {
                    teamInfo.setTitle(this.dealDateFormat(digiwinAtmcBacklogDetail.getEndTime()) + "\u9700\u5b8c\u6210");
                }
                teamInfo.setType(IMTeamTypeEnum.TASK_TYPE.getValue() + "");
            }
        }
        List teamMembers = this.imService.getTeamMembers(iamUserToken, teamId, tenantId);
        if (CollectionUtils.isEmpty((Collection)teamMembers)) {
            teamInfo.setTeamMembers(new ArrayList(1));
        } else {
            List<Object> newTeamMembers = new ArrayList<TeamMember>(teamMembers.size());
            for (TeamMember teamMember : teamMembers) {
                if (teamMember.getType() != 0) continue;
                newTeamMembers.add(teamMember);
            }
            if (newTeamMembers.size() > 0) {
                newTeamMembers = this.imService.setAccId(newTeamMembers, iamUserToken);
                teamInfo.setTeamMembers(newTeamMembers);
            }
        }
        return teamInfo;
    }

    @RequestMapping(value={"/expire/application/notice"}, method={RequestMethod.POST})
    public ApiResponse<ExpireApplicationNoticeDetail> getExpireApplicationNoticeInfo(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String userId = (String)params.get("userId");
        String iamUserToken = (String)params.get("iamUserToken");
        String tenantId = (String)params.get("tenantId");
        String locale = (String)params.get("locale");
        ExpireApplicationNoticeDetail expireApplicationNoticeDetail = this.imService.getExpireApplicationNoticeInfo(userId, iamUserToken, tenantId, locale);
        return ApiResponse.buildOK().setData((Object)expireApplicationNoticeDetail);
    }

    private String dealDateFormat(String date) {
        if (date != null) {
            try {
                String[] dates = date.split(" ")[0].split("-");
                return dates[1] + "/" + dates[2];
            }
            catch (Exception e) {
                e.printStackTrace();
                return date;
            }
        }
        return null;
    }
}

