/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.index.DriveTips;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.component.search.UniSearch;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="indexBuildDriverNoVehicleZtbStrategy")
public class IndexBuildDriverNoVehicleZtbStrategy {
    @Autowired
    private ProjectService projectService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    public UiBotModel build(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        Iterator layoutIterator = uiBotModel.getLayout().iterator();
        ArrayList<UiBotLayout> layoutList = new ArrayList<UiBotLayout>();
        boolean haveRecommend = false;
        while (layoutIterator.hasNext()) {
            UiBotLayout layout = (UiBotLayout)layoutIterator.next();
            if ("INDEX_NAVBAR".equals(layout.getType()) && pageData.get((Object)layout.getSchema()) != null) {
                IndexNavBar indexNavBar = (IndexNavBar)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), IndexNavBar.class);
                indexNavBar.initSetting(apiRequest.getLocale(), apiRequest.getAppInfo());
                indexNavBar.initShortcutButton(apiRequest, this.projectService, this.localeService);
                pageData.put((Object)layout.getSchema(), (Object)indexNavBar);
                layoutList.add(layout);
                continue;
            }
            if ("UNI_SEARCH".equals(layout.getType()) && pageData.get((Object)layout.getSchema()) != null) {
                UniSearch uniSearch = (UniSearch)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), UniSearch.class);
                uniSearch.initSetting(apiRequest.getLocale());
                pageData.put((Object)layout.getSchema(), (Object)uniSearch);
                layoutList.add(layout);
                continue;
            }
            if ("BLANK_AREA".equalsIgnoreCase(layout.getType())) {
                if (!haveRecommend) continue;
                layoutList.add(layout);
                continue;
            }
            if (!"DRIVE_TIPS".equalsIgnoreCase(layout.getType())) continue;
            DriveTips driveTips = (DriveTips)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), DriveTips.class);
            driveTips.initSetting(this.localeService, locale);
            DigiwinIamUserInfo userInfo = this.digiwinIamProxyService.userInfoById(apiRequest.getUserId(), apiRequest.getIamUserToken(), apiRequest.getLocale());
            String title = null == userInfo ? "" : userInfo.getName();
            driveTips.setTitle(title + driveTips.getTitle());
            pageData.put((Object)layout.getSchema(), (Object)driveTips);
            layoutList.add(layout);
        }
        uiBotModel.setLayout(layoutList);
        return uiBotModel;
    }
}

