/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.machinePreset.controller;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContentRequest;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntrance;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.machinePreset.model.ApiRequestCompanyFactory;
import com.digiwin.mobile.mobileuibot.machinePreset.service.MachinePresetService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TopicPresetJobResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TopicPresetResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.recommend.appentrancerecord.service.AppEntranceRecordService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/machine/preset/"})
public class MachinePresetController {
    private static final Logger log = LoggerFactory.getLogger(MachinePresetController.class);
    @Autowired
    MachinePresetService machinePresetService;
    @Autowired
    DigiwinSemcProxyService semcProxyService;
    @Autowired
    private AppEntranceRecordService appEntranceRecordService;
    @Autowired
    private LocaleService localeService;

    @PostMapping(value={"/getCompanyFactoryList"})
    public ApiResponse getCompanyFactoryList(@RequestBody ApiRequest apiRequest) {
        List list = this.machinePresetService.getCompanyFactoryList(apiRequest);
        return ApiResponse.buildOK().setData((Object)list);
    }

    @PostMapping(value={"/saveCompanyFactory"})
    public ApiResponse saveCompanyFactory(@RequestBody @Valid ApiRequestCompanyFactory apiRequestCompanyFactory) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setTenantId(apiRequestCompanyFactory.getTenantId());
        apiRequest.setIamUserToken(apiRequestCompanyFactory.getIamUserToken());
        this.machinePresetService.saveCompanyFactory(apiRequest, apiRequestCompanyFactory.getCompany(), apiRequestCompanyFactory.getFactory());
        return ApiResponse.buildOK();
    }

    @PostMapping(value={"/queryUserAuth"})
    public ApiResponse queryUserAuth(@RequestBody ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData((Object)this.machinePresetService.queryUserAuth(apiRequest));
    }

    @PostMapping(value={"/workBench/queryAppJob"})
    public ApiResponse<UiBotModel> queryAppJob(@RequestBody CustomContentRequest customContentRequest) {
        Map sysParam = customContentRequest.getSysParam();
        String locale = (String)sysParam.get("locale");
        String iamUserToken = (String)sysParam.get("iamUserToken");
        log.debug("workBench/queryAppJob req{}", (Object)JSONObject.toJSONString((Object)sysParam));
        List topicPresetRespList = this.semcProxyService.queryAllJob(new ArrayList(), locale, iamUserToken);
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        if (CollUtil.isEmpty((Collection)topicPresetRespList)) {
            return ApiResponse.buildOK().setData((Object)uiBotModel);
        }
        ArrayList layoutList = new ArrayList();
        try {
            Map topicPresetRespMap = this.addAppUiBot(topicPresetRespList, layoutList);
            UiBotPageData pageData = new UiBotPageData();
            this.packagePageData(pageData, topicPresetRespMap, locale);
            uiBotModel.setLayout(layoutList);
            uiBotModel.setPageData(pageData);
        }
        catch (Exception e) {
            log.error("workBench/queryAppJob req{},error:{}", (Object)JSONObject.toJSONString((Object)sysParam), (Object)e.getMessage());
            return ApiResponse.buildOK().setData((Object)uiBotModel);
        }
        return ApiResponse.buildOK().setData((Object)uiBotModel);
    }

    public void packagePageData(UiBotPageData pageData, Map<String, TopicPresetResp> topicPresetRespMap, String locale) {
        Set<Map.Entry<String, TopicPresetResp>> entries = topicPresetRespMap.entrySet();
        for (Map.Entry<String, TopicPresetResp> entry : entries) {
            String uuid = entry.getKey();
            TopicPresetResp topicPreset = entry.getValue();
            CustomGroup customGroup = new CustomGroup();
            customGroup.setName(topicPreset.getModuleName());
            CustomGroupContent content = this.packageJob(topicPreset, uuid, locale);
            customGroup.setContent(content);
            pageData.put((Object)uuid, (Object)customGroup);
        }
    }

    public CustomGroupContent packageJob(TopicPresetResp topicPreset, String uuid, String locale) {
        CustomGroupContent content = new CustomGroupContent();
        ArrayList<UiBotLayout> layoutList = new ArrayList<UiBotLayout>();
        UiBotLayout layout = new UiBotLayout();
        layout.setSchema(uuid);
        layout.setType("APP_ENTRANCE");
        layoutList.add(layout);
        content.setLayout(layoutList);
        UiBotPageData pageData = new UiBotPageData();
        AppEntrance appEntrance = new AppEntrance();
        List appList = this.addJobTouchable(topicPreset.getTopicpList(), locale);
        appEntrance.setAppList(appList);
        pageData.put((Object)uuid, (Object)appEntrance);
        content.setPageData(pageData);
        return content;
    }

    public List<AppFunctionTouchable> addJobTouchable(List<TopicPresetJobResp> topicpList, String locale) {
        ArrayList<AppFunctionTouchable> appList = new ArrayList<AppFunctionTouchable>();
        for (TopicPresetJobResp topicp : topicpList) {
            AppFunctionTouchable touchable = new AppFunctionTouchable();
            touchable.setIconUrl(topicp.getTopicPresetIcon());
            touchable.setName(topicp.getTopicPresetName());
            touchable.setId(topicp.getCaseId());
            Action action = new Action();
            action.setOpenWebPageTitle(topicp.getTopicPresetName());
            action.setRequestUrl(topicp.getTopicPresetUrl());
            action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
            if (!topicp.getIsSetCompany().booleanValue()) {
                action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
                action.setToastMsg(this.localeService.getLanguageValue(locale, "\u8bf7\u5148\u8bbe\u7f6e\u516c\u53f8\u522b\u548c\u5382\u522b"));
            }
            touchable.setAction(action);
            appList.add(touchable);
        }
        return appList;
    }

    public Map<String, TopicPresetResp> addAppUiBot(List<TopicPresetResp> topicPresetRespList, List<UiBotLayout> layoutList) {
        HashMap<String, TopicPresetResp> topicPresetRespMap = new HashMap<String, TopicPresetResp>();
        for (TopicPresetResp topicPreset : topicPresetRespList) {
            UiBotLayout layout = new UiBotLayout();
            String schema = UUIDUtil.getUuid();
            layout.setSchema(schema);
            layout.setType("CUSTOM_GROUP");
            layoutList.add(layout);
            topicPresetRespMap.put(schema, topicPreset);
        }
        return topicPresetRespMap;
    }

    @PostMapping(value={"/myBench/queryClickAppJob"})
    public ApiResponse<UiBotModel> queryClickAppJob(@RequestBody CustomContentRequest customContentRequest) {
        Map sysParam = customContentRequest.getSysParam();
        String locale = (String)sysParam.get("locale");
        String iamUserToken = (String)sysParam.get("iamUserToken");
        String tenantId = (String)sysParam.get("tenantId");
        String userId = (String)sysParam.get("userId");
        log.debug("myBench/queryClickAppJob req{}", (Object)JSONObject.toJSONString((Object)sysParam));
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        try {
            List commonAppIdList = this.appEntranceRecordService.getAppIdListByUserId(userId, tenantId);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)commonAppIdList)) {
                return ApiResponse.buildOK().setData((Object)uiBotModel);
            }
            List topicPresetRespList = this.semcProxyService.queryAllJob(commonAppIdList, locale, iamUserToken);
            if (CollUtil.isEmpty((Collection)topicPresetRespList)) {
                return ApiResponse.buildOK().setData((Object)uiBotModel);
            }
            UiBotPageData pageData = new UiBotPageData();
            ArrayList<UiBotLayout> layoutList = new ArrayList<UiBotLayout>();
            UiBotLayout layout = new UiBotLayout();
            String uuid = UUIDUtil.getUuid();
            layout.setSchema(uuid);
            layout.setType("APP_ENTRANCE");
            layoutList.add(layout);
            uiBotModel.setLayout(layoutList);
            AppEntrance appEntrance = this.getJobAppEntrance(topicPresetRespList, locale);
            pageData.put((Object)uuid, (Object)appEntrance);
            uiBotModel.setPageData(pageData);
        }
        catch (Exception e) {
            log.debug("myBench/queryClickAppJob req{},error:{}", (Object)JSONObject.toJSONString((Object)sysParam), (Object)e.getMessage());
            return ApiResponse.buildOK().setData((Object)uiBotModel);
        }
        return ApiResponse.buildOK().setData((Object)uiBotModel);
    }

    public AppEntrance getJobAppEntrance(List<TopicPresetResp> topicPresetRespList, String locale) {
        AppEntrance appEntrance = new AppEntrance();
        ArrayList appList = new ArrayList();
        for (TopicPresetResp topicPresetResp : topicPresetRespList) {
            List appJobList = this.addJobTouchable(topicPresetResp.getTopicpList(), locale);
            if (!CollectionUtils.isNotEmpty((Collection)appJobList)) continue;
            appList.addAll(appJobList);
        }
        appEntrance.setAppList(appList);
        return appEntrance;
    }
}

