/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.mock.model;

import com.digiwin.mobile.mobileuibot.mock.model.MockData;
import com.digiwin.mobile.mobileuibot.mock.model.MockDataRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class MockDataRepositoryImpl
implements MockDataRepository {
    private static final String RENDER_PAGE_URI = "/mobile/v1/uibot/model";
    @Autowired
    private MongoTemplate mongoTemplate;

    public List<MockData> getMockDataList(String uri, String pageId, String requestId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"uri").is((Object)uri));
        if (RENDER_PAGE_URI.equals(uri)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"pageId").is((Object)pageId));
        }
        if (StringUtils.hasLength((String)requestId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"requestId").is((Object)requestId));
        }
        return this.mongoTemplate.find(query, MockData.class);
    }

    public MockData getMockData(String uri, String pageId, String dataId, String locale, String requestId) {
        List mockDataList = this.getMockDataList(uri, pageId, requestId);
        if (CollectionUtils.isEmpty((Collection)mockDataList)) {
            return null;
        }
        if (mockDataList.size() == 1) {
            return (MockData)mockDataList.get(0);
        }
        List<Object> dataIdMockDataList = new ArrayList();
        List<Object> localeMockDataList = new ArrayList();
        if (StringUtils.hasLength((String)dataId)) {
            dataIdMockDataList = mockDataList.stream().filter(mockData -> dataId.equalsIgnoreCase(mockData.getDataId())).collect(Collectors.toList());
        }
        if (StringUtils.hasLength((String)locale)) {
            localeMockDataList = mockDataList.stream().filter(mockData -> locale.equalsIgnoreCase(mockData.getLocale())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(dataIdMockDataList) && CollectionUtils.isEmpty(localeMockDataList)) {
            return (MockData)mockDataList.get(0);
        }
        if (!CollectionUtils.isEmpty(dataIdMockDataList) && !CollectionUtils.isEmpty(localeMockDataList)) {
            ArrayList<MockData> dataIdLocaleMockDataList = new ArrayList<MockData>();
            for (MockData mockData2 : dataIdMockDataList) {
                if (!localeMockDataList.contains(mockData2)) continue;
                dataIdLocaleMockDataList.add(mockData2);
            }
            if (CollectionUtils.isEmpty(dataIdLocaleMockDataList)) {
                return (MockData)dataIdMockDataList.get(0);
            }
            return (MockData)dataIdLocaleMockDataList.get(0);
        }
        return CollectionUtils.isEmpty(dataIdMockDataList) ? (MockData)localeMockDataList.get(0) : (MockData)dataIdMockDataList.get(0);
    }
}

