/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.myteam;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.index.TodoList;
import com.digiwin.mobile.mobileuibot.core.component.title.teamtitle.TeamTitle;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterService;
import com.digiwin.mobile.mobileuibot.task.model.TaskSummary;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="uiBotModelBuildTeamTaskStrategy")
public class UiBotModelBuildTeamTaskStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildTeamTaskStrategy.class);
    private static final String GROUP_TYPE_TEAM_MEMBER = "teamMember";
    private static final String GROUP_TYPE_CODE = "code";
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private TaskFilterService taskFilterService;
    @Autowired
    private CustomTaskConfigService customTaskConfigService;
    @Autowired
    private PageTaskRelationService pageTaskRelationService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private ActivityFilterService activityFilterService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String userId = apiRequest.getUserId();
        ApiRawData rawData = apiRequest.getRawData();
        String groupType = (String)rawData.get((Object)"groupType");
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("groupType", groupType);
        if (GROUP_TYPE_TEAM_MEMBER.equalsIgnoreCase(groupType)) {
            params.put("userId", rawData.get((Object)"userId"));
        } else if (GROUP_TYPE_CODE.equalsIgnoreCase(groupType)) {
            params.put("taskDefCode", rawData.get((Object)"taskDefCode"));
        }
        String tenantVersion = this.activityFilterService.tenantVersion(iamUserToken, tenantId, locale);
        List teamBacklogs = this.digiwinAtmcProxyService.getDepartBacklogGroupList(iamUserToken, tenantId, locale, params);
        List taskSummaries = TaskSummary.createByBacklogs((List)teamBacklogs, (TaskFilterService)this.taskFilterService, (CustomTaskConfigService)this.customTaskConfigService, (PageTaskRelationService)this.pageTaskRelationService, (String)locale, (String)iamUserToken, (String)userId, (LocaleService)this.localeService, (String)tenantId, (ActivityFilterService)this.activityFilterService, (String)tenantVersion);
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout uiBotLayout : layoutList) {
            String schema = uiBotLayout.getSchema();
            switch (uiBotLayout.getType()) {
                case "TEAM_TITLE": {
                    pageData.put((Object)schema, JsonUtil.objectToJavaObject((Object)rawData.get((Object)schema), TeamTitle.class));
                    break;
                }
                case "TODO_LIST": {
                    TodoList todoList = new TodoList();
                    todoList.setTodoList(TaskSummary.sortTeamList((List)taskSummaries));
                    todoList.setIsTeamTask(Boolean.valueOf(true));
                    pageData.put((Object)schema, (Object)todoList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}

