/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.news.controller;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.news.model.ApiRequsetNews;
import com.digiwin.mobile.mobileuibot.news.service.NewsService;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/news/info"})
public class MobileNewsController {
    @Autowired
    private NewsService newsService;
    @Autowired
    private LocaleService localeService;

    @PostMapping(value={"/queryMobileNewsListPage"})
    public ApiResponse queryMobileNewsListPage(@RequestBody ApiRequsetNews apiRequsetNews) {
        return ApiResponse.buildOK().setData((Object)this.newsService.queryMobileNewsListPage(apiRequsetNews));
    }

    @PostMapping(value={"/queryUserNewsDetail"})
    public ApiResponse queryUserNewsDetail(@RequestBody ApiRequsetNews apiRequsetNews) {
        return ApiResponse.buildOK().setData((Object)this.newsService.queryUserNewsDetail(apiRequsetNews));
    }

    @PostMapping(value={"/validateNews"})
    public ApiResponse validateNews(@RequestBody ApiRequsetNews apiRequsetNews) {
        return ApiResponse.buildOK().setData((Object)this.newsService.validateNews(apiRequsetNews));
    }

    @PostMapping(value={"/queryNewsTypeList"})
    public ApiResponse queryNewsTypeList(@RequestBody ApiRequsetNews apiRequsetNews) {
        return ApiResponse.buildOK().setData((Object)this.newsService.queryNewsTypeList(apiRequsetNews));
    }

    @PostMapping(value={"/readNews"})
    public ApiResponse readNews(@RequestBody ApiRequsetNews apiRequsetNews) {
        if (ObjectUtils.isEmpty((Object)apiRequsetNews.getId())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetNews.getLocale(), "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u53c2\u6570"));
        }
        return ApiResponse.buildOK().setData((Object)this.newsService.readNews(apiRequsetNews));
    }

    @PostMapping(value={"/likeNews"})
    public ApiResponse likeNews(@RequestBody ApiRequsetNews apiRequsetNews) {
        if (ObjectUtils.isEmpty((Object)apiRequsetNews.getId())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetNews.getLocale(), "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u53c2\u6570"));
        }
        return ApiResponse.buildOK().setData((Object)this.newsService.likeNews(apiRequsetNews));
    }

    @PostMapping(value={"/cancelLikeNews"})
    public ApiResponse cancelLikeNews(@RequestBody ApiRequsetNews apiRequsetNews) {
        if (ObjectUtils.isEmpty((Object)apiRequsetNews.getId())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetNews.getLocale(), "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u53c2\u6570"));
        }
        return ApiResponse.buildOK().setData((Object)this.newsService.cancelLikeNews(apiRequsetNews));
    }

    @PostMapping(value={"/favoriteNews"})
    public ApiResponse favoriteNews(@RequestBody ApiRequsetNews apiRequsetNews) {
        if (ObjectUtils.isEmpty((Object)apiRequsetNews.getId())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetNews.getLocale(), "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u53c2\u6570"));
        }
        return ApiResponse.buildOK().setData((Object)this.newsService.favoriteNews(apiRequsetNews));
    }

    @PostMapping(value={"/cancelFavoriteNews"})
    public ApiResponse cancelFavoriteNews(@RequestBody ApiRequsetNews apiRequsetNews) {
        if (CollectionUtils.isEmpty((Collection)apiRequsetNews.getIdList())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetNews.getLocale(), "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u53c2\u6570"));
        }
        return ApiResponse.buildOK().setData((Object)this.newsService.cancelFavoriteNews(apiRequsetNews));
    }

    @PostMapping(value={"/myFavoriteNewsList"})
    public ApiResponse myFavoriteNewsList(@RequestBody ApiRequsetNews apiRequsetNews) {
        return ApiResponse.buildOK().setData((Object)this.newsService.myFavoriteNewsList(apiRequsetNews));
    }

    @PostMapping(value={"/validNewsType"})
    public ApiResponse validNewsType(@RequestBody ApiRequsetNews apiRequsetNews, HttpServletRequest request) {
        if (ObjectUtils.isEmpty((Object)apiRequsetNews.getNewsTypeId())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetNews.getLocale(), "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u53c2\u6570"));
        }
        return ApiResponse.buildOK().setData((Object)this.newsService.validNewsType(apiRequsetNews, AthenaBasicHttpRequestHead.buildByRequest((HttpServletRequest)request)));
    }
}

