/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.node;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.pipeline.Pipeline;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNode;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNodeEnum;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpgradeDSLPipelineNode
extends DslGeneratePipelineNode {
    private static final Logger log = LoggerFactory.getLogger(UpgradeDSLPipelineNode.class);
    @Autowired
    private HttpServletRequest request;

    public DslGeneratePipelineNodeEnum getDslGeneratePipelineNodeEnum() {
        return DslGeneratePipelineNodeEnum.UPGRADE_DSL;
    }

    public void execute(Pipeline<ApiResponse> pipeline, ApiResponse apiResponse) {
        pipeline.execute((Object)apiResponse);
        try {
            if (null == apiResponse) {
                return;
            }
            String requestUri = Optional.ofNullable(this.request.getAttribute("experience_real_url")).map(StringUtil::valueOf).orElse(AppRequestContext.getContextEntity().getRequestUri());
            MobileRenderDataUtil.upgradeToV2((String)requestUri, (ApiResponse)apiResponse);
        }
        catch (Exception e) {
            log.error("UpgradeDSLPipelineNode failure, error:", (Throwable)e);
        }
    }
}

