/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.service.impl;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.math.MathUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.basic.LabelTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceAccessRecord;
import com.digiwin.mobile.mobileuibot.core.component.list.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardCategory;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardList;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListOption;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardProgress;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.card.ChildCard;
import com.digiwin.mobile.mobileuibot.core.component.progress.ProgressRate;
import com.digiwin.mobile.mobileuibot.core.component.progress.ProgressRateTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterService;
import com.digiwin.mobile.mobileuibot.project.model.LaunchableProject;
import com.digiwin.mobile.mobileuibot.project.model.TaskAbnormalReason;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.project.service.impl.ProjectServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcActivity;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcActivityStateEnum;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcCardDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcCheckTaskResultItem;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEngineActivity;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEnginePanelInfo;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEngineTaskCode;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanel;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectCheckTaskResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcSummaryLayout;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTask;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinEmp;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAudcActivityAccessible;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPerson;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsProject;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.Collator;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="projectService")
public class ProjectServiceImpl
implements ProjectService {
    private static final Logger logger = LoggerFactory.getLogger(ProjectServiceImpl.class);
    public static final String PCC_APP_CODE = "PCC";
    public static final String KSC_APP_CODE = "KSC";
    private final Map<String, String> codeSuffixMap = new HashMap();
    private static final List<String> NEED_SORTCARD_BY_TENANTID_LIST = Lists.newArrayList((Object[])new String[]{"72002320", "72002320_001", "002", "PCCcloundProd"});
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgemapsProxyService;
    @Autowired
    private DigiwinAudcProxyService audcProxyService;
    @Autowired
    private ProjectFilterService projectFilterService;
    @Autowired
    private DigiwinEocProxyService eocProxyService;
    @Autowired
    private ActivityFilterService activityFilterService;
    @Autowired
    private LocaleService localeService;

    @PostConstruct
    private void init() {
        this.codeSuffixMap.put("task_Project_Budget", "LaunchBudgetProject");
        this.codeSuffixMap.put("task_Project_Center_Console", "LaunchSpecialProject");
        this.codeSuffixMap.put("valuationInformationMaintenance_mainproject", "itemInformation_create");
        this.codeSuffixMap.put("task_question_answer_mainline", "athena_questionAnswer_create");
        this.codeSuffixMap.put("excluded_return_mainproject", "LaunchExcludedProject");
        this.codeSuffixMap.put("demo_so_athenaopt_mainline_project_0001", "start_demo_so_athenaopt_mainline_project_0001");
        this.codeSuffixMap.put("manual_freightage_start", "manual_freightage_start");
        this.codeSuffixMap.put("scan_freightage_start", "scan_freightage_start");
    }

    public TaskAbnormalReason getTaskAbnormalReason(String locale, DigiwinAtmcProjectCheckTaskResult digiwinAtmcProjectCheckTaskResult) {
        if (null == digiwinAtmcProjectCheckTaskResult || null == digiwinAtmcProjectCheckTaskResult.getCheckItems() || digiwinAtmcProjectCheckTaskResult.getCheckItems().isEmpty()) {
            return new TaskAbnormalReason();
        }
        String itemUnitText = LocaleUtil.getMobileTextByKey((String)locale, (String)"task-report-\u9879");
        TaskAbnormalReason taskAbnormalReason = new TaskAbnormalReason();
        for (DigiwinAtmcCheckTaskResultItem item : digiwinAtmcProjectCheckTaskResult.getCheckItems()) {
            taskAbnormalReason.addAbnormalMsg(item.getValue() + itemUnitText + " " + item.getItem());
        }
        return taskAbnormalReason;
    }

    public CardList getCardList(ApiRequest apiRequest, boolean needSearchAndFilter) {
        String locale = apiRequest.getLocale();
        CardList cardList = new CardList();
        List categoryList = this.getProjectList(apiRequest);
        cardList.setCategoryList(categoryList);
        ArrayList<CardListFilter> filterList = new ArrayList<CardListFilter>();
        if (needSearchAndFilter) {
            cardList.setSearchUrl("/mobile/v1/project/search");
            cardList.setFilterList(filterList);
        }
        CardListFilter projectTypeFilter = new CardListFilter();
        projectTypeFilter.setFilterId("project_type");
        projectTypeFilter.setFilterName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9879\u76ee\u7c7b\u578b"));
        HashSet projectTypeFilterOptionSet = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)categoryList)) {
            categoryList.forEach(cardCategory -> {
                List cards = cardCategory.getCardList();
                if (!CollectionUtils.isEmpty((Collection)cards)) {
                    cards.forEach(card -> {
                        List filterContentList = card.getFilterContentList();
                        filterContentList.forEach(filter -> {
                            if ("project_type".equalsIgnoreCase(filter.getFilterId())) {
                                projectTypeFilterOptionSet.addAll(filter.getFilterOptionList());
                            }
                        });
                    });
                    cards = this.validIsMatchTenantId(apiRequest.getTenantId()) ? this.sortCardListByCreateTime(cards) : this.sortCardList(cards, locale);
                    cardCategory.setCardList(cards);
                }
            });
        }
        ArrayList projectTypeFilterOptionList = new ArrayList();
        projectTypeFilterOptionList.addAll(projectTypeFilterOptionSet);
        projectTypeFilter.setFilterOptionList(projectTypeFilterOptionList);
        filterList.add(projectTypeFilter);
        CardListFilter projectStatusFilter = new CardListFilter();
        projectStatusFilter.setFilterId("project_status");
        projectStatusFilter.setFilterName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9879\u76ee\u72b6\u6001"));
        ArrayList<CardListOption> projectStatusFilterOptionList = new ArrayList<CardListOption>();
        projectStatusFilter.setFilterOptionList(projectStatusFilterOptionList);
        projectStatusFilterOptionList.add(new CardListOption("project_status_abnormal", LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5f02\u5e38") + "/" + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f")));
        projectStatusFilterOptionList.add(new CardListOption("project_status_normal", LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6b63\u5e38\u8fdb\u884c")));
        projectStatusFilterOptionList.add(new CardListOption("project_status_urgent", LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7d27\u6025")));
        projectStatusFilterOptionList.add(new CardListOption("project_status_no_task", LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6682\u65e0\u4efb\u52a1")));
        projectStatusFilterOptionList.add(new CardListOption("project_status_share", LocaleUtil.getMobileTextByKey((String)locale, (String)"\u4ed6\u4eba\u5206\u4eab")));
        filterList.add(projectStatusFilter);
        return cardList;
    }

    public List<CardCategory> getProjectList(ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        List dataIds = apiRequest.getJumpDataIds();
        ArrayList<CardCategory> cardCategoryList = new ArrayList<CardCategory>();
        CardCategory abnormalCardCategory = new CardCategory();
        abnormalCardCategory.setCategoryName(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u903e\u671f/\u5f02\u5e38"));
        ArrayList abnormalCardList = new ArrayList();
        abnormalCardCategory.setCardList(abnormalCardList);
        CardCategory normalCardCategory = new CardCategory();
        normalCardCategory.setCategoryName(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u6b63\u5e38"));
        ArrayList normalCardList = new ArrayList();
        normalCardCategory.setCardList(normalCardList);
        try {
            ArrayList allProjectList = new ArrayList();
            ArrayList<DigiwinAtmcProject> jumpProjectList = new ArrayList<DigiwinAtmcProject>();
            List myProjectList = this.digiwinAtmcProxyService.listMyProject(apiRequest.getClientId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
            allProjectList.addAll(myProjectList);
            if (!CollectionUtils.isEmpty((Collection)dataIds)) {
                ArrayList<DigiwinEmp> digiwinEmps = new ArrayList<DigiwinEmp>();
                EocPersonResponse eocPersonResponse = this.eocProxyService.getPersonList(iamUserToken, 9999, 1, "");
                if (eocPersonResponse != null && eocPersonResponse.getList() != null && eocPersonResponse.getList().size() > 0) {
                    for (EocPerson eocPerson : eocPersonResponse.getList()) {
                        if (eocPerson.getUserId() == null) continue;
                        DigiwinEmp digiwinEmp = new DigiwinEmp();
                        digiwinEmp.setUserId(eocPerson.getUserId());
                        digiwinEmp.setTitle(eocPerson.getUserName());
                        digiwinEmp.setType("employee");
                        digiwinEmps.add(digiwinEmp);
                    }
                }
                List allTeamProjectList = this.digiwinAtmcProxyService.selectEmpProject(digiwinEmps, iamUserToken, locale, tenantId);
                allProjectList.addAll(allTeamProjectList);
                List supportedProjectList = allProjectList.stream().filter(project -> this.projectFilterService.isSupportedProjectByDigiwinAtmcProject(project, tenantId)).collect(Collectors.toList());
                if (PCC_APP_CODE.equalsIgnoreCase(apiRequest.getAppCode()) || KSC_APP_CODE.equalsIgnoreCase(apiRequest.getAppCode())) {
                    List pccProjectList = supportedProjectList.stream().filter(project -> this.projectFilterService.isSupportedProjectByDigiwinAtmcProject(project, tenantId)).collect(Collectors.toList());
                    for (DigiwinAtmcProject digiwinAtmcProject : pccProjectList) {
                        int start = digiwinAtmcProject.getName().trim().lastIndexOf("[");
                        if (start < 0) continue;
                        int end = digiwinAtmcProject.getName().trim().lastIndexOf("]");
                        String dataId = digiwinAtmcProject.getName().substring(start + 1, end);
                        if (dataIds.contains(dataId)) {
                            jumpProjectList.add(digiwinAtmcProject);
                            dataIds.remove(dataId);
                        }
                        if (dataIds.size() != 0) continue;
                        break;
                    }
                }
            } else {
                jumpProjectList = allProjectList;
            }
            String tenantVersion = this.activityFilterService.tenantVersion(iamUserToken, tenantId, locale);
            Set tmActivityIds = this.activityFilterService.findByTypeOfMobileDesignerConfig(MobileDesignerConfigTypeEnum.PROJECT.getValue(), tenantId, tenantVersion).stream().map(MobileDesignerConfig::getTmActivityId).collect(Collectors.toSet());
            List<DigiwinAtmcProject> designerProjectList = jumpProjectList.stream().filter(project -> {
                List tasks = project.getTasks();
                if (CollectionUtils.isEmpty((Collection)tasks)) {
                    return false;
                }
                Set projectActivityIds = project.getTasks().stream().map(DigiwinAtmcTask::getTmActivityId).collect(Collectors.toSet());
                return tmActivityIds.stream().anyMatch(projectActivityIds::contains);
            }).collect(Collectors.toList());
            designerProjectList.forEach(project -> this.buildDesignerProject(project, normalCardList, abnormalCardList, iamUserToken, tenantId, locale));
            jumpProjectList.removeAll(designerProjectList);
            List filteredProjectAndDoingTaskList = this.getFilteredProjectAndDoingTasks(jumpProjectList, tenantId);
            if (!filteredProjectAndDoingTaskList.isEmpty()) {
                for (ProjectAndDoingTask projectAndDoingTask : filteredProjectAndDoingTaskList) {
                    DigiwinAtmcProject project2 = projectAndDoingTask.getProject();
                    DigiwinAtmcTask doingTask = projectAndDoingTask.getTask();
                    if (this.projectFilterService.isCenterConsoleProject(project2, tenantId)) {
                        this.handleCenterConsoleProject(project2, doingTask, normalCardList, abnormalCardList, iamUserToken, tenantId, locale, false);
                        continue;
                    }
                    if (this.projectFilterService.isSystemCloudHouseKeeper(project2, tenantId)) {
                        this.handleSystemCloudKeeperProject(project2, doingTask, normalCardList, abnormalCardList, iamUserToken, tenantId, locale, false);
                        continue;
                    }
                    if (this.projectFilterService.isStandardProject(project2, tenantId)) {
                        this.handleStandardProject(project2, normalCardList, abnormalCardList, iamUserToken, locale, tenantId, false);
                        continue;
                    }
                    this.handleCurrentlyNotSupportedProject(project2, normalCardList, abnormalCardList, iamUserToken, locale, tenantId, false);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!abnormalCardList.isEmpty()) {
            cardCategoryList.add(abnormalCardCategory);
        }
        if (!normalCardList.isEmpty()) {
            cardCategoryList.add(normalCardCategory);
        }
        return cardCategoryList;
    }

    private void buildDesignerProject(DigiwinAtmcProject project, List<Card> normalCardList, List<Card> abnormalCardList, String iamUserToken, String tenantId, String locale) {
        Card card = new Card();
        card.setId(project.getId().toString());
        card.setIsTeamProject(Boolean.valueOf(false));
        card.setName(project.getName());
        card.setStartTime(project.getStartTime());
        card.setEndTime(project.getEndTime());
        card.setCreateTime(project.getCreateTime());
        card.setImportance(project.getImportance());
        ArrayList<CardListFilter> filterContentList = new ArrayList<CardListFilter>();
        filterContentList.add(project.getProjectType(locale));
        filterContentList.add(project.getProjectStatus(locale));
        card.setFilterContentList(filterContentList);
        HashMap<String, Boolean> rawData = new HashMap<String, Boolean>(1);
        if (project.getPinning() != null && project.getPinning().booleanValue()) {
            String text = String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6765\u81ea%s\u7684\u5206\u4eab"), project.getPersonInChargeName());
            card.setBottomTipText(text);
            rawData.put("isShare", true);
        } else {
            rawData.put("isShare", false);
        }
        if (project.getReadCount() != null && project.getReadCount() == 0L) {
            Label label = Label.create((String)"NEW", (String)LabelTypeEnum.NEW.getType());
            ArrayList<Label> labelList = new ArrayList<Label>();
            labelList.add(label);
            card.setLabelList(labelList);
        }
        Action action = new Action(project.getId() + "", PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_V2_PAGE.toString(), "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(), "");
        action.setRawData(rawData);
        card.setAction(action);
        ChildCard childCard = new ChildCard();
        card.setChildCard(childCard);
        List taskList = project.getTasks();
        List<Object> abnormalTaskList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            card.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
            childCard.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6682\u65e0\u4efb\u52a1\u8fdb\u884c\u4e2d"));
            childCard.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
            normalCardList.add(card);
            return;
        }
        abnormalTaskList = taskList.stream().filter(task -> Optional.ofNullable(task.getException()).orElse(false) != false || Optional.ofNullable(task.getOverdue()).orElse(false) != false).collect(Collectors.toList());
        if (abnormalTaskList.isEmpty()) {
            card.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
            childCard.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
            normalCardList.add(card);
            if (taskList.size() == 1) {
                childCard.setName(((DigiwinAtmcTask)taskList.get(0)).getName());
            } else {
                childCard.setName(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u591a\u4e2a\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d"), taskList.size()));
            }
            return;
        }
        card.setType(Integer.valueOf(CardTypeEnum.ABNORMAL.getValue()));
        childCard.setType(Integer.valueOf(CardTypeEnum.ABNORMAL.getValue()));
        abnormalCardList.add(card);
        if (abnormalTaskList.size() > 1) {
            childCard.setName(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u591a\u4e2a\u4efb\u52a1\u903e\u671f\u5f02\u5e38"), abnormalCardList.size()));
        } else if (abnormalTaskList.size() == 1) {
            DigiwinAtmcTask task2 = (DigiwinAtmcTask)abnormalTaskList.get(0);
            childCard.setName(task2.getName());
            if (task2.getOverdue().booleanValue()) {
                ArrayList<Label> labelList = new ArrayList<Label>();
                labelList.add(new Label(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u5929\u6570"), task2.getOverdueDays()), LabelTypeEnum.OVERDUE.getType()));
                childCard.setLabelList(labelList);
            }
        } else {
            ArrayList<Label> labelList = new ArrayList<Label>();
            labelList.add(new Label(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u5929\u6570"), DateTimeUtil.getDateTimePeriod((String)project.getEndTime(), (String)DateTimeUtil.getTodayTimeUseDefaultPattern())), LabelTypeEnum.OVERDUE.getType()));
            childCard.setLabelList(labelList);
        }
    }

    public void handleCurrentlyNotSupportedProject(DigiwinAtmcProject project, List<Card> normalCardList, List<Card> abnormalCardList, String iamUserToken, String locale, String tenantId, boolean isTeamProject) {
        Card card = new Card();
        card.setIsTeamProject(Boolean.valueOf(isTeamProject));
        card.setId(project.getId().toString());
        card.setName(project.getName());
        card.setStartTime(project.getStartTime());
        card.setEndTime(project.getEndTime());
        card.setCreateTime(project.getCreateTime());
        card.setImportance(project.getImportance());
        ArrayList<CardListFilter> filterContentList = new ArrayList<CardListFilter>();
        filterContentList.add(project.getProjectType(locale));
        filterContentList.add(project.getProjectStatus(locale));
        card.setFilterContentList(filterContentList);
        HashMap<String, Boolean> rawData = new HashMap<String, Boolean>(1);
        if (project.getPinning() != null && project.getPinning().booleanValue()) {
            String text = String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6765\u81ea%s\u7684\u5206\u4eab"), project.getPersonInChargeName());
            card.setBottomTipText(text);
            rawData.put("isShare", true);
        } else {
            rawData.put("isShare", false);
        }
        if (project.getReadCount() != null && project.getReadCount() == 0L) {
            Label label = Label.create((String)"NEW", (String)LabelTypeEnum.NEW.getType());
            ArrayList<Label> labelList = new ArrayList<Label>();
            labelList.add(label);
            card.setLabelList(labelList);
        }
        Action action = new Action();
        action.setDataId(String.valueOf(project.getId()));
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        action.setRequestUrl("/mobile/v1/pattern/jump/info?type=search");
        DigiwinAtmcSearchResult result = new DigiwinAtmcSearchResult();
        result.setEndTime(project.getEndTime());
        result.setId(project.getId());
        result.setName(project.getName());
        result.setStartTime(project.getStartTime());
        result.setType("PROJECT");
        result.setCode(String.valueOf(project.getId()));
        result.setEngineType("TaskEngine");
        action.setRawData((Object)result);
        card.setAction(action);
        ChildCard childCard = new ChildCard();
        card.setChildCard(childCard);
        List taskList = project.getTasks();
        List<Object> abnormalTaskList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            card.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
            childCard.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6682\u65e0\u4efb\u52a1\u8fdb\u884c\u4e2d"));
            childCard.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
            normalCardList.add(card);
            return;
        }
        abnormalTaskList = taskList.stream().filter(task -> Optional.ofNullable(task.getException()).orElse(false) != false || Optional.ofNullable(task.getOverdue()).orElse(false) != false).collect(Collectors.toList());
        boolean normal = true;
        if (abnormalTaskList.isEmpty()) {
            card.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
            childCard.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
            normalCardList.add(card);
            if (taskList.size() == 1) {
                childCard.setName(((DigiwinAtmcTask)taskList.get(0)).getName());
            } else {
                childCard.setName(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u591a\u4e2a\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d"), taskList.size()));
            }
            return;
        }
        card.setType(Integer.valueOf(CardTypeEnum.ABNORMAL.getValue()));
        childCard.setType(Integer.valueOf(CardTypeEnum.ABNORMAL.getValue()));
        abnormalCardList.add(card);
        if (abnormalTaskList.size() > 1) {
            childCard.setName(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u591a\u4e2a\u4efb\u52a1\u903e\u671f\u5f02\u5e38"), abnormalCardList.size()));
        } else if (abnormalTaskList.size() == 1) {
            DigiwinAtmcTask task2 = (DigiwinAtmcTask)abnormalTaskList.get(0);
            childCard.setName(task2.getName());
            if (task2.getOverdue().booleanValue()) {
                ArrayList<Label> labelList = new ArrayList<Label>();
                labelList.add(new Label(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u5929\u6570"), task2.getOverdueDays()), LabelTypeEnum.OVERDUE.getType()));
                childCard.setLabelList(labelList);
            }
        } else {
            ArrayList<Label> labelList = new ArrayList<Label>();
            labelList.add(new Label(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u5929\u6570"), DateTimeUtil.getDateTimePeriod((String)project.getEndTime(), (String)DateTimeUtil.getTodayTimeUseDefaultPattern())), LabelTypeEnum.OVERDUE.getType()));
            childCard.setLabelList(labelList);
        }
    }

    public Card handleCurrentlyNotSupportedProject(DigiwinAtmcProject project, String iamUserToken, String locale, String tenantId, boolean isTeamProject) {
        Card card = new Card();
        card.convert(project);
        card.setIsTeamProject(Boolean.valueOf(isTeamProject));
        if (project.getPinning() != null && project.getPinning().booleanValue()) {
            String text = String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6765\u81ea%s\u7684\u5206\u4eab"), project.getPersonInChargeName());
            card.setBottomTipText(text);
        }
        if (project.getReadCount() != null && project.getReadCount() == 0L) {
            Label label = Label.create((String)"NEW", (String)LabelTypeEnum.NEW.getType());
            ArrayList<Label> labelList = new ArrayList<Label>();
            labelList.add(label);
            card.setLabelList(labelList);
        }
        Action action = new Action();
        action.setDataId(String.valueOf(project.getId()));
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        action.setRequestUrl("/mobile/v1/pattern/jump/info?type=search");
        DigiwinAtmcSearchResult result = new DigiwinAtmcSearchResult();
        result.setEndTime(project.getEndTime());
        result.setId(project.getId());
        result.setName(project.getName());
        result.setStartTime(project.getStartTime());
        result.setType("PROJECT");
        result.setCode(String.valueOf(project.getId()));
        result.setEngineType("TaskEngine");
        action.setRawData((Object)result);
        card.setAction(action);
        ChildCard childCard = new ChildCard();
        card.setChildCard(childCard);
        List taskList = project.getTasks();
        List<Object> abnormalTaskList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            card.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
            childCard.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6682\u65e0\u4efb\u52a1\u8fdb\u884c\u4e2d"));
            childCard.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
            return card;
        }
        abnormalTaskList = taskList.stream().filter(task -> Optional.ofNullable(task.getException()).orElse(false) != false || Optional.ofNullable(task.getOverdue()).orElse(false) != false).collect(Collectors.toList());
        boolean normal = true;
        if (abnormalTaskList.isEmpty()) {
            card.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
            childCard.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
            if (taskList.size() == 1) {
                childCard.setName(((DigiwinAtmcTask)taskList.get(0)).getName());
            } else {
                childCard.setName(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u591a\u4e2a\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d"), taskList.size()));
            }
            return card;
        }
        card.setType(Integer.valueOf(CardTypeEnum.ABNORMAL.getValue()));
        childCard.setType(Integer.valueOf(CardTypeEnum.ABNORMAL.getValue()));
        if (abnormalTaskList.size() > 1) {
            childCard.setName(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u591a\u4e2a\u4efb\u52a1\u903e\u671f\u5f02\u5e38"), abnormalTaskList.size()));
        } else if (abnormalTaskList.size() == 1) {
            DigiwinAtmcTask task2 = (DigiwinAtmcTask)abnormalTaskList.get(0);
            childCard.setName(task2.getName());
            if (task2.getOverdue().booleanValue()) {
                ArrayList<Label> labelList = new ArrayList<Label>();
                labelList.add(new Label(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u5929\u6570"), task2.getOverdueDays()), LabelTypeEnum.OVERDUE.getType()));
                childCard.setLabelList(labelList);
            }
        } else {
            ArrayList<Label> labelList = new ArrayList<Label>();
            labelList.add(new Label(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u5929\u6570"), DateTimeUtil.getDateTimePeriod((String)project.getEndTime(), (String)DateTimeUtil.getTodayTimeUseDefaultPattern())), LabelTypeEnum.OVERDUE.getType()));
            childCard.setLabelList(labelList);
        }
        return card;
    }

    private List<ProjectAndDoingTask> getFilteredProjectAndDoingTasks(List<DigiwinAtmcProject> allProjectList, String tenantId) {
        List supportedProjectList = allProjectList.stream().filter(project -> this.projectFilterService.isSupportedProjectByDigiwinAtmcProject(project, tenantId)).collect(Collectors.toList());
        List<ProjectAndDoingTask> projectAndDoingTaskList = supportedProjectList.stream().map(project -> {
            if (CollectionUtils.isEmpty((Collection)project.getTasks())) {
                return new ProjectAndDoingTask(this, project, new DigiwinAtmcTask());
            }
            return new ProjectAndDoingTask(this, project, (DigiwinAtmcTask)project.getTasks().get(0));
        }).sorted((o1, o2) -> {
            LocalDateTime o1STime = DateTimeUtil.parseUseDefaultPattern((String)o1.getProject().getStartTime());
            LocalDateTime o2STime = DateTimeUtil.parseUseDefaultPattern((String)o2.getProject().getStartTime());
            int sTimeCompareValue = o1STime.compareTo(o2STime);
            LocalDateTime o1ETime = DateTimeUtil.parseUseDefaultPattern((String)o1.getProject().getEndTime());
            LocalDateTime o2ETime = DateTimeUtil.parseUseDefaultPattern((String)o2.getProject().getEndTime());
            return sTimeCompareValue == 0 ? o1ETime.compareTo(o2ETime) : sTimeCompareValue;
        }).collect(Collectors.toList());
        return projectAndDoingTaskList;
    }

    public List<ProjectAndDoingTask> convertProjectAndDoingTasks(List<DigiwinAtmcProject> allProjectList) {
        List<ProjectAndDoingTask> projectAndDoingTaskList = allProjectList.stream().map(project -> {
            if (CollectionUtils.isEmpty((Collection)project.getTasks())) {
                return new ProjectAndDoingTask(this, project, new DigiwinAtmcTask());
            }
            return new ProjectAndDoingTask(this, project, (DigiwinAtmcTask)project.getTasks().get(0));
        }).sorted((o1, o2) -> {
            LocalDateTime o1STime = DateTimeUtil.parseUseDefaultPattern((String)o1.getProject().getStartTime());
            LocalDateTime o2STime = DateTimeUtil.parseUseDefaultPattern((String)o2.getProject().getStartTime());
            int sTimeCompareValue = o1STime.compareTo(o2STime);
            LocalDateTime o1ETime = DateTimeUtil.parseUseDefaultPattern((String)o1.getProject().getEndTime());
            LocalDateTime o2ETime = DateTimeUtil.parseUseDefaultPattern((String)o2.getProject().getEndTime());
            return sTimeCompareValue == 0 ? o1ETime.compareTo(o2ETime) : sTimeCompareValue;
        }).collect(Collectors.toList());
        return projectAndDoingTaskList;
    }

    public List<LaunchableProject> getLaunchableProjectList(String iamUserToken, String tenantId, String locale) {
        List tmActivityIdList;
        List projectAccessibleList;
        List knowledgeMapsProjects = this.digiwinKnowledgemapsProxyService.getLaunchableProjects(iamUserToken, tenantId, locale);
        ArrayList<LaunchableProject> projectList = new ArrayList<LaunchableProject>();
        if (!CollectionUtils.isEmpty((Collection)knowledgeMapsProjects)) {
            String tenantVersion = this.activityFilterService.tenantVersion(iamUserToken, tenantId, locale);
            List mobileDesignerConfigList = this.activityFilterService.findByTypeOfMobileDesignerConfig(MobileDesignerConfigTypeEnum.START_PROJECT.getValue(), tenantId, tenantVersion);
            block0: for (KnowledgeMapsProject knowledgeMapsProject : knowledgeMapsProjects) {
                Optional<Map> presetActivityItem;
                LaunchableProject project = new LaunchableProject();
                project.setName(knowledgeMapsProject.getName());
                project.setCode(knowledgeMapsProject.getCode());
                if (this.codeSuffixMap.containsKey(knowledgeMapsProject.getCode())) {
                    project.setCreateSuffix((String)this.codeSuffixMap.get(knowledgeMapsProject.getCode()));
                    projectList.add(project);
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)knowledgeMapsProject.getPresetActivities()) || !(presetActivityItem = knowledgeMapsProject.getPresetActivities().stream().filter(e -> knowledgeMapsProject.getCode().equals(e.get("project"))).findFirst()).isPresent()) continue;
                String tmActivityId = (String)MapUtil.getOrDefault((Map)presetActivityItem.get(), (String)"code", (Object)"");
                project.setCreateSuffix(tmActivityId);
                for (MobileDesignerConfig designerConfig : mobileDesignerConfigList) {
                    boolean match = TaskFilter.match((String)tmActivityId, (String)designerConfig.getTmActivityId(), (String)designerConfig.getTmActivityIdMatch());
                    if (!match) continue;
                    project.setIsDesigner(Boolean.valueOf(true));
                    Object projectDesc = Optional.ofNullable(knowledgeMapsProject.getLang()).map(e -> (Map)e.get("description")).orElse(Collections.emptyMap()).get(locale);
                    if (ObjectUtils.isNotEmpty(projectDesc)) {
                        project.setDesc((String)projectDesc);
                    }
                    projectList.add(project);
                    continue block0;
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)(projectAccessibleList = this.audcProxyService.getAccessibleList(locale, iamUserToken, tenantId, tmActivityIdList = projectList.stream().map(LaunchableProject::getCode).collect(Collectors.toList()), 2, "start-project")))) {
            return Collections.emptyList();
        }
        ArrayList<LaunchableProject> accessibleLaunchableProjectList = new ArrayList(projectAccessibleList.size());
        block2: for (DigiwinAudcActivityAccessible accessible : projectAccessibleList) {
            for (LaunchableProject launchableProject : projectList) {
                if (!accessible.getTmActivityId().equals(launchableProject.getCode()) || !accessible.getAccess().equalsIgnoreCase("allow")) continue;
                accessibleLaunchableProjectList.add(launchableProject);
                continue block2;
            }
        }
        accessibleLaunchableProjectList = accessibleLaunchableProjectList.stream().filter(e -> e.isSupportedLaunchableProject() || BooleanUtils.isTrue((Boolean)e.getIsDesigner())).collect(Collectors.toList());
        return accessibleLaunchableProjectList;
    }

    public List<AppFunctionTouchable> getLaunchableProjectAppList(String iamUserToken, String tenantId, String locale) {
        List accessibleLaunchableProjectList = this.getLaunchableProjectList(iamUserToken, tenantId, locale);
        List<Object> appList = new ArrayList<AppFunctionTouchable>();
        if (CollectionUtils.isEmpty((Collection)accessibleLaunchableProjectList)) {
            return appList;
        }
        appList = accessibleLaunchableProjectList.stream().map(project -> {
            AppFunctionTouchable appFunctionTouchable = new AppFunctionTouchable();
            appFunctionTouchable.setId(project.getCode());
            appFunctionTouchable.setName(project.getName());
            if ("demo_so_athenaopt_mainline_project_0001".equals(project.getCode())) {
                appFunctionTouchable.setImage("IMAGE_LaunchExcludedProject");
            } else {
                appFunctionTouchable.setImage("IMAGE_" + project.getCreateSuffix());
            }
            Action action = new Action();
            if (BooleanUtils.isTrue((Boolean)project.getIsDesigner())) {
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.toString());
                action.setJumpPageTitle(project.getName());
                HashMap<String, String> rawData = new HashMap<String, String>(2);
                rawData.put("project_introduce", project.getDesc());
                rawData.put("project_name", project.getName());
                rawData.put("dataId", project.getCreateSuffix());
                action.setRawData(rawData);
            } else {
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.toString());
                action.setJumpPageTitle(project.getName());
                action.setDataId(project.getCreateSuffix());
            }
            appFunctionTouchable.setAction(action);
            AppEntranceAccessRecord accessRecord = new AppEntranceAccessRecord();
            accessRecord.setSendRecord(Boolean.valueOf(true));
            accessRecord.setRecordUrl("/mobile/v1/appEntranceRecord/add");
            appFunctionTouchable.setAccessRecord(accessRecord);
            return appFunctionTouchable;
        }).collect(Collectors.toList());
        return appList;
    }

    public void handleStandardProject(DigiwinAtmcProject project, List<Card> normalCardList, List<Card> abnormalCardList, String iamUserToken, String locale, String tenantId, boolean isTeamProject) {
        Card card = new Card();
        card.setId(project.getId().toString());
        card.setIsTeamProject(Boolean.valueOf(isTeamProject));
        card.setName(project.getName());
        card.setStartTime(project.getStartTime());
        card.setEndTime(project.getEndTime());
        card.setCreateTime(project.getCreateTime());
        card.setImportance(project.getImportance());
        ArrayList<CardListFilter> filterContentList = new ArrayList<CardListFilter>();
        filterContentList.add(project.getProjectType(locale));
        filterContentList.add(project.getProjectStatus(locale));
        card.setFilterContentList(filterContentList);
        HashMap<String, Boolean> rawData = new HashMap<String, Boolean>(1);
        if (project.getPinning() != null && project.getPinning().booleanValue()) {
            String text = String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6765\u81ea%s\u7684\u5206\u4eab"), project.getPersonInChargeName());
            card.setBottomTipText(text);
            rawData.put("isShare", true);
        } else {
            rawData.put("isShare", false);
        }
        if (project.getReadCount() != null && project.getReadCount() == 0L) {
            Label label = Label.create((String)"NEW", (String)LabelTypeEnum.NEW.getType());
            ArrayList<Label> labelList = new ArrayList<Label>();
            labelList.add(label);
            card.setLabelList(labelList);
        }
        Action action = new Action(project.getId() + "", PageSettingIdPresetEnum.MOBILE_ATHENA_STANDARD_PROJECT_DETAIL.toString(), "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(), "");
        action.setRawData(rawData);
        card.setAction(action);
        ChildCard childCard = new ChildCard();
        card.setChildCard(childCard);
        List taskList = project.getTasks();
        List<Object> abnormalTaskList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            card.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
            childCard.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6682\u65e0\u4efb\u52a1\u8fdb\u884c\u4e2d"));
            childCard.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
            normalCardList.add(card);
            return;
        }
        abnormalTaskList = taskList.stream().filter(task -> Optional.ofNullable(task.getException()).orElse(false) != false || Optional.ofNullable(task.getOverdue()).orElse(false) != false).collect(Collectors.toList());
        boolean normal = true;
        if (abnormalTaskList.isEmpty()) {
            card.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
            childCard.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
            normalCardList.add(card);
            if (taskList.size() == 1) {
                childCard.setName(((DigiwinAtmcTask)taskList.get(0)).getName());
            } else {
                childCard.setName(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u591a\u4e2a\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d"), taskList.size()));
            }
            return;
        }
        card.setType(Integer.valueOf(CardTypeEnum.ABNORMAL.getValue()));
        childCard.setType(Integer.valueOf(CardTypeEnum.ABNORMAL.getValue()));
        abnormalCardList.add(card);
        if (abnormalTaskList.size() > 1) {
            childCard.setName(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u591a\u4e2a\u4efb\u52a1\u903e\u671f\u5f02\u5e38"), abnormalCardList.size()));
        } else if (abnormalTaskList.size() == 1) {
            DigiwinAtmcTask task2 = (DigiwinAtmcTask)abnormalTaskList.get(0);
            childCard.setName(task2.getName());
            if (task2.getOverdue().booleanValue()) {
                ArrayList<Label> labelList = new ArrayList<Label>();
                labelList.add(new Label(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u5929\u6570"), task2.getOverdueDays()), LabelTypeEnum.OVERDUE.getType()));
                childCard.setLabelList(labelList);
            }
        } else {
            ArrayList<Label> labelList = new ArrayList<Label>();
            labelList.add(new Label(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u5929\u6570"), DateTimeUtil.getDateTimePeriod((String)project.getEndTime(), (String)DateTimeUtil.getTodayTimeUseDefaultPattern())), LabelTypeEnum.OVERDUE.getType()));
            childCard.setLabelList(labelList);
        }
    }

    public Card handleStandardProject(DigiwinAtmcProject project, String iamUserToken, String locale, String tenantId, boolean isTeamProject) {
        Card card = new Card();
        card.convert(project);
        card.setIsTeamProject(Boolean.valueOf(isTeamProject));
        HashMap<String, Boolean> rawData = new HashMap<String, Boolean>(1);
        if (project.getPinning() != null && project.getPinning().booleanValue()) {
            String text = String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6765\u81ea%s\u7684\u5206\u4eab"), project.getPersonInChargeName());
            card.setBottomTipText(text);
            rawData.put("isShare", true);
        } else {
            rawData.put("isShare", false);
        }
        if (project.getReadCount() != null && project.getReadCount() == 0L) {
            Label label = Label.create((String)"NEW", (String)LabelTypeEnum.NEW.getType());
            ArrayList<Label> labelList = new ArrayList<Label>();
            labelList.add(label);
            card.setLabelList(labelList);
        }
        Action action = new Action(project.getId() + "", PageSettingIdPresetEnum.MOBILE_ATHENA_STANDARD_PROJECT_DETAIL.toString(), "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(), "");
        action.setRawData(rawData);
        card.setAction(action);
        ChildCard childCard = new ChildCard();
        card.setChildCard(childCard);
        List taskList = project.getTasks();
        List<Object> abnormalTaskList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            card.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
            childCard.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6682\u65e0\u4efb\u52a1\u8fdb\u884c\u4e2d"));
            childCard.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
            return card;
        }
        abnormalTaskList = taskList.stream().filter(task -> Optional.ofNullable(task.getException()).orElse(false) != false || Optional.ofNullable(task.getOverdue()).orElse(false) != false).collect(Collectors.toList());
        boolean normal = true;
        if (abnormalTaskList.isEmpty()) {
            card.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
            childCard.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
            if (taskList.size() == 1) {
                childCard.setName(((DigiwinAtmcTask)taskList.get(0)).getName());
            } else {
                childCard.setName(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u591a\u4e2a\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d"), taskList.size()));
            }
            return card;
        }
        card.setType(Integer.valueOf(CardTypeEnum.ABNORMAL.getValue()));
        childCard.setType(Integer.valueOf(CardTypeEnum.ABNORMAL.getValue()));
        if (abnormalTaskList.size() > 1) {
            childCard.setName(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u591a\u4e2a\u4efb\u52a1\u903e\u671f\u5f02\u5e38"), abnormalTaskList.size()));
        } else if (abnormalTaskList.size() == 1) {
            DigiwinAtmcTask task2 = (DigiwinAtmcTask)abnormalTaskList.get(0);
            childCard.setName(task2.getName());
            if (task2.getOverdue().booleanValue()) {
                ArrayList<Label> labelList = new ArrayList<Label>();
                labelList.add(new Label(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u5929\u6570"), task2.getOverdueDays()), LabelTypeEnum.OVERDUE.getType()));
                childCard.setLabelList(labelList);
            }
        } else {
            ArrayList<Label> labelList = new ArrayList<Label>();
            labelList.add(new Label(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u5929\u6570"), DateTimeUtil.getDateTimePeriod((String)project.getEndTime(), (String)DateTimeUtil.getTodayTimeUseDefaultPattern())), LabelTypeEnum.OVERDUE.getType()));
            childCard.setLabelList(labelList);
        }
        return card;
    }

    public void handleSystemCloudKeeperProject(DigiwinAtmcProject project, DigiwinAtmcTask doingTask, List<Card> normalCardList, List<Card> abnormalCardList, String iamUserToken, String tenantId, String locale, boolean isTeamProject) {
        Card card = new Card();
        card.setIsTeamProject(Boolean.valueOf(isTeamProject));
        Boolean isException = true;
        if (!project.getException().booleanValue() && !project.getOverdue().booleanValue()) {
            normalCardList.add(card);
            isException = false;
        } else {
            abnormalCardList.add(card);
        }
        card.setId(project.getId().toString());
        card.setName(project.getName());
        card.setStartTime(project.getStartTime());
        card.setEndTime(project.getEndTime());
        card.setCreateTime(project.getCreateTime());
        card.setImportance(project.getImportance());
        ArrayList<CardListFilter> filterContentList = new ArrayList<CardListFilter>();
        filterContentList.add(project.getProjectType(locale));
        filterContentList.add(project.getProjectStatus(locale));
        card.setFilterContentList(filterContentList);
        Boolean isShare = false;
        if (Boolean.TRUE.equals(project.getPinning())) {
            String text = String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6765\u81ea%s\u7684\u5206\u4eab"), project.getPersonInChargeName());
            card.setBottomTipText(text);
            isShare = true;
        }
        if (project.getReadCount() != null && project.getReadCount() == 0L) {
            Label label = Label.create((String)"NEW", (String)LabelTypeEnum.NEW.getType());
            ArrayList<Label> labelList = new ArrayList<Label>();
            labelList.add(label);
            card.setLabelList(labelList);
        }
        card.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
        CardProgress cardProgress = new CardProgress();
        String urlTemplate = AppContext.getBaseUrl() + "/mobile/v1/project/progress/list?iamUserToken=%s&tenantId=%s&locale=%s&projectId=%s&isShare=%s&type=KSC&pccProjectTypeIsNew=%s&isException=%s";
        String url = String.format(urlTemplate, iamUserToken, tenantId, locale, project.getId(), isShare, true, isException);
        cardProgress.setUrl(url);
        card.setProgress(cardProgress);
        HashMap<String, String> rawData = new HashMap<String, String>();
        rawData.put("project_type", project.getTmTaskId());
    }

    public Card handleSystemCloudKeeperProject(DigiwinAtmcProject project, String iamUserToken, String tenantId, String locale, boolean isTeamProject) {
        Card card = new Card();
        card.convert(project);
        card.setIsTeamProject(Boolean.valueOf(isTeamProject));
        boolean isException = true;
        if (!project.getException().booleanValue() && !project.getOverdue().booleanValue()) {
            isException = false;
        }
        boolean isShare = false;
        if (Boolean.TRUE.equals(project.getPinning())) {
            String text = String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6765\u81ea%s\u7684\u5206\u4eab"), project.getPersonInChargeName());
            card.setBottomTipText(text);
            isShare = true;
        }
        if (project.getReadCount() != null && project.getReadCount() == 0L) {
            Label label = Label.create((String)"NEW", (String)LabelTypeEnum.NEW.getType());
            ArrayList<Label> labelList = new ArrayList<Label>();
            labelList.add(label);
            card.setLabelList(labelList);
        }
        card.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
        CardProgress cardProgress = new CardProgress();
        String urlTemplate = AppContext.getBaseUrl() + "/mobile/v1/project/progress/list?iamUserToken=%s&tenantId=%s&locale=%s&projectId=%s&isShare=%s&type=KSC&pccProjectTypeIsNew=%s&isException=%s";
        String url = String.format(urlTemplate, iamUserToken, tenantId, locale, project.getId(), isShare, true, isException);
        cardProgress.setUrl(url);
        card.setProgress(cardProgress);
        return card;
    }

    public void handleCenterConsoleProject(DigiwinAtmcProject project, DigiwinAtmcTask doingTask, List<Card> normalCardList, List<Card> abnormalCardList, String iamUserToken, String tenantId, String locale, boolean isTeamProject) {
        boolean pccProjectTypeIsNew = "projectCenterConsole_userProject".equalsIgnoreCase(project.getTmTaskId());
        Card card = new Card();
        card.setIsTeamProject(Boolean.valueOf(isTeamProject));
        if (!project.getException().booleanValue() && !project.getOverdue().booleanValue()) {
            normalCardList.add(card);
        } else {
            abnormalCardList.add(card);
        }
        card.setId(project.getId().toString());
        card.setName(project.getName());
        card.setStartTime(project.getStartTime());
        card.setEndTime(project.getEndTime());
        card.setCreateTime(project.getCreateTime());
        card.setImportance(project.getImportance());
        ArrayList<CardListFilter> filterContentList = new ArrayList<CardListFilter>();
        filterContentList.add(project.getProjectType(locale));
        filterContentList.add(project.getProjectStatus(locale));
        card.setFilterContentList(filterContentList);
        Boolean isShare = false;
        if (Boolean.TRUE.equals(project.getPinning())) {
            String text = String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6765\u81ea%s\u7684\u5206\u4eab"), project.getPersonInChargeName());
            card.setBottomTipText(text);
            isShare = true;
        }
        if (project.getReadCount() != null && project.getReadCount() == 0L) {
            Label label = Label.create((String)"NEW", (String)LabelTypeEnum.NEW.getType());
            ArrayList<Label> labelList = new ArrayList<Label>();
            labelList.add(label);
            card.setLabelList(labelList);
        }
        card.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
        CardProgress cardProgress = new CardProgress();
        String urlTemplate = AppContext.getBaseUrl() + "/mobile/v1/project/progress/list?iamUserToken=%s&tenantId=%s&locale=%s&projectId=%s&isShare=%s&pccProjectTypeIsNew=%s";
        String url = String.format(urlTemplate, iamUserToken, tenantId, locale, project.getId(), isShare, pccProjectTypeIsNew);
        cardProgress.setUrl(url);
        card.setProgress(cardProgress);
        HashMap<String, String> rawData = new HashMap<String, String>();
        rawData.put("project_type", project.getTmTaskId());
    }

    public Card handleCenterConsoleProject(DigiwinAtmcProject project, String iamUserToken, String tenantId, String locale, boolean isTeamProject) {
        boolean pccProjectTypeIsNew = "projectCenterConsole_userProject".equalsIgnoreCase(project.getTmTaskId());
        Card card = new Card();
        card.convert(project);
        card.setIsTeamProject(Boolean.valueOf(isTeamProject));
        boolean isShare = false;
        if (Boolean.TRUE.equals(project.getPinning())) {
            String text = String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6765\u81ea%s\u7684\u5206\u4eab"), project.getPersonInChargeName());
            card.setBottomTipText(text);
            isShare = true;
        }
        if (project.getReadCount() != null && project.getReadCount() == 0L) {
            Label label = Label.create((String)"NEW", (String)LabelTypeEnum.NEW.getType());
            ArrayList<Label> labelList = new ArrayList<Label>();
            labelList.add(label);
            card.setLabelList(labelList);
        }
        card.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
        CardProgress cardProgress = new CardProgress();
        String urlTemplate = AppContext.getBaseUrl() + "/mobile/v1/project/progress/list?iamUserToken=%s&tenantId=%s&locale=%s&projectId=%s&isShare=%s&pccProjectTypeIsNew=%s";
        String url = String.format(urlTemplate, iamUserToken, tenantId, locale, project.getId(), isShare, pccProjectTypeIsNew);
        cardProgress.setUrl(url);
        card.setProgress(cardProgress);
        return card;
    }

    public CardProgress getPccProjectProgress(String locale, String iamUserToken, String tenantId, String projectId, Boolean isShare, Boolean pccProjectTypeIsNew) {
        String tmTaskId = "";
        String tmActivityId = "";
        if (!pccProjectTypeIsNew.booleanValue()) {
            Optional<DigiwinAtmcActivity> optActivity;
            DigiwinAtmcPanel atmcPanel = this.digiwinAtmcProxyService.getTaskPanel(locale, iamUserToken, tenantId, projectId);
            if (null != atmcPanel.getTask()) {
                tmTaskId = atmcPanel.getTask().getTmTaskId();
            }
            if (!CollectionUtils.isEmpty((Collection)atmcPanel.getActivities()) && (optActivity = atmcPanel.getActivities().stream().filter(atmcActivity -> "progressTrack".equalsIgnoreCase(atmcActivity.getId()) && (DigiwinAtmcActivityStateEnum.DOING.getState().equals(atmcActivity.getState()) || DigiwinAtmcActivityStateEnum.DONE.getState().equals(atmcActivity.getState()))).findFirst()).isPresent()) {
                tmActivityId = optActivity.get().getId();
            }
        } else {
            DigiwinAtmcEnginePanelInfo atmcEnginePanelInfo = this.digiwinAtmcProxyService.getEnginePanelInfoByTaskId(projectId, "", iamUserToken, tenantId, locale);
            tmTaskId = atmcEnginePanelInfo.getTask().getTmTaskId();
            List activityList = atmcEnginePanelInfo.getRoute().getSelectRoute().getActivities();
            ArrayList taskCodes = new ArrayList();
            for (DigiwinAtmcEngineActivity activity : activityList) {
                if (activity == null || activity.getTaskCodes() == null) continue;
                taskCodes.addAll(activity.getTaskCodes());
            }
            Optional<DigiwinAtmcEngineTaskCode> taskCodeOptional = taskCodes.stream().filter(taskCode -> "progressTrack_DTD".equalsIgnoreCase(taskCode.getId()) && (DigiwinAtmcActivityStateEnum.DOING.getState().equals(taskCode.getState()) || DigiwinAtmcActivityStateEnum.DONE.getState().equals(taskCode.getState()))).findFirst();
            if (taskCodeOptional.isPresent()) {
                tmActivityId = taskCodeOptional.get().getId();
            }
        }
        if (StringUtils.hasLength((String)tmActivityId) && "progressTrack_DTD".equalsIgnoreCase(tmActivityId)) {
            tmActivityId = "progressTrack";
        }
        return this.transCardDetailToPccProjectProgress(locale, iamUserToken, tenantId, projectId, isShare, tmActivityId, tmTaskId);
    }

    public CardProgress getKscProjectProgress(String locale, String iamUserToken, String tenantId, String projectId, Boolean isShare, Boolean isException) {
        String tmActivityId = "";
        DigiwinAtmcEnginePanelInfo atmcEnginePanelInfo = this.digiwinAtmcProxyService.getEnginePanelInfoByTaskId(projectId, "", iamUserToken, tenantId, locale);
        List activityList = atmcEnginePanelInfo.getRoute().getSelectRoute().getActivities();
        ArrayList taskCodes = new ArrayList();
        for (DigiwinAtmcEngineActivity activity : activityList) {
            if (activity == null || activity.getTaskCodes() == null) continue;
            taskCodes.addAll(activity.getTaskCodes());
        }
        Optional<DigiwinAtmcEngineTaskCode> taskCodeOptional = taskCodes.stream().filter(taskCode -> "sch_progressTrack".equalsIgnoreCase(taskCode.getId()) && (DigiwinAtmcActivityStateEnum.DOING.getState().equals(taskCode.getState()) || DigiwinAtmcActivityStateEnum.DONE.getState().equals(taskCode.getState()))).findFirst();
        if (taskCodeOptional.isPresent()) {
            DigiwinAtmcEngineTaskCode taskCode2 = taskCodeOptional.get();
            tmActivityId = taskCode2.getId();
        }
        return this.transCardDetailToKscProjectProgress(locale, iamUserToken, tenantId, projectId, isShare, tmActivityId, isException);
    }

    public CardProgress transCardDetailToKscProjectProgress(String locale, String iamUserToken, String tenantId, String projectId, Boolean isShare, String tmActivityId, Boolean isException) {
        String projectStatus;
        CardProgress resultCardProgress = new CardProgress();
        DigiwinAtmcCardDetail taskCardDetail = this.digiwinAtmcProxyService.getDigiwinAtmcProjectCardDetail(locale, iamUserToken, tenantId, projectId);
        DigiwinAtmcSummaryLayout summaryLayout = taskCardDetail.getSummaryLayout();
        if (null == summaryLayout || CollectionUtils.isEmpty((Collection)summaryLayout.getLayout())) {
            ChildCard childCard = new ChildCard();
            childCard.setName(this.localeService.getLanguageValue(locale, "\u6682\u65e0\u6570\u636e"));
            childCard.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
            resultCardProgress.setChildCard(childCard);
            HashMap<String, Object> rawData = new HashMap<String, Object>();
            rawData.put("project_type", taskCardDetail.getTmTaskId());
            rawData.put("isShare", isShare);
            resultCardProgress.setAction(new Action(taskCardDetail.getProjectId().trim(), PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_DETAIL.toString(), "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(), rawData));
            return resultCardProgress;
        }
        List layoutList = summaryLayout.getLayout();
        UiBotPageData pageData = summaryLayout.getPageData();
        Map bizData = new HashMap();
        for (UiBotLayout layout : layoutList) {
            Map map;
            Object o;
            if (layout.isTypeOfTable()) {
                List bizDataList = (List)pageData.get((Object)layout.getSchema());
                if (CollectionUtils.isEmpty((Collection)bizDataList)) continue;
                bizData = (Map)bizDataList.get(0);
                continue;
            }
            if (!layout.isTypeOfFormList() || !((o = pageData.get((Object)layout.getSchema())) instanceof Map) || CollectionUtils.isEmpty((Map)(map = (Map)o))) continue;
            bizData = map;
        }
        switch (projectStatus = String.valueOf(bizData.get("project_status"))) {
            case "20": {
                this.buildApprovals(resultCardProgress, locale, taskCardDetail);
                break;
            }
            case "10": 
            case "30": 
            case "50": {
                String notice = (String)bizData.get("project_progress_message");
                ChildCard childCard = resultCardProgress.getChildCard();
                if (childCard == null) {
                    childCard = new ChildCard();
                }
                childCard.setName(notice);
                if (isException.booleanValue()) {
                    childCard.setType(Integer.valueOf(CardTypeEnum.ABNORMAL.getValue()));
                } else {
                    childCard.setType(Integer.valueOf(CardTypeEnum.NORMAL.getValue()));
                }
                resultCardProgress.setChildCard(childCard);
                HashMap<String, Object> rawData = new HashMap<String, Object>(2);
                rawData.put("project_type", taskCardDetail.getTmTaskId());
                rawData.put("isShare", isShare);
                rawData.put("project_status", projectStatus);
                resultCardProgress.setAction(new Action(taskCardDetail.getProjectId() + "", PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_DETAIL.toString(), "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(), rawData));
                break;
            }
            case "60": {
                this.buildCloseCase(resultCardProgress, locale, taskCardDetail);
                break;
            }
            default: {
                this.buildNotStarted(resultCardProgress, locale, taskCardDetail.getProjectId().trim());
            }
        }
        return resultCardProgress;
    }

    private CardProgress buildToWeb(CardProgress resultCardProgress, String locale, String id) {
        ChildCard notSupportedActivityChildCard = new ChildCard();
        notSupportedActivityChildCard.setName(this.localeService.getLanguageValue(locale, "\u4e13\u6848\u5f53\u524d\u91cc\u7a0b\u7891\u4e0d\u652f\u6301\u5c55\u793a"));
        notSupportedActivityChildCard.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
        resultCardProgress.setChildCard(notSupportedActivityChildCard);
        resultCardProgress.setAction(new Action(id, ActionTypeEnum.SHOW_TOAST.getValue(), this.localeService.getLanguageValue(locale, "\u4e13\u6848\u5f53\u524d\u91cc\u7a0b\u7891\u4e0d\u652f\u6301\u5c55\u793a\uff0c\u5efa\u8bae\u53bbPC\u7aef\u67e5\u770b")));
        return resultCardProgress;
    }

    private CardProgress buildApprovals(CardProgress resultCardProgress, String locale, DigiwinAtmcCardDetail taskCardDetail) {
        ChildCard childCard = new ChildCard();
        childCard.setName(this.localeService.getLanguageValue(locale, "\u4e13\u6848\u7b7e\u6838\u4e2d"));
        childCard.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
        resultCardProgress.setChildCard(childCard);
        resultCardProgress.setAction(new Action(taskCardDetail.getProjectId().trim(), ActionTypeEnum.SHOW_TOAST.getValue(), this.localeService.getLanguageValue(locale, "\u6b64\u4e13\u6848\u6b63\u5728\u7b7e\u6838\u4e2d\uff0c\u5efa\u8bae\u53bbPC\u7aef\u7ef4\u62a4")));
        return resultCardProgress;
    }

    private CardProgress buildCloseCase(CardProgress resultCardProgress, String locale, DigiwinAtmcCardDetail taskCardDetail) {
        ChildCard endChildCard = new ChildCard();
        endChildCard.setName(this.localeService.getLanguageValue(locale, "\u4e13\u6848\u5df2\u6307\u5b9a\u7ed3\u6848"));
        endChildCard.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
        resultCardProgress.setChildCard(endChildCard);
        resultCardProgress.setAction(new Action(taskCardDetail.getProjectId().trim(), ActionTypeEnum.SHOW_TOAST.getValue(), this.localeService.getLanguageValue(locale, "\u6b64\u4e13\u6848\u5df2\u6307\u5b9a\u7ed3\u6848\uff0c\u5c5e\u4e8e\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u540e\u53f0\u6570\u636e")));
        return resultCardProgress;
    }

    private CardProgress buildNotStarted(CardProgress resultCardProgress, String locale, String id) {
        ChildCard notStartChildCard = new ChildCard();
        notStartChildCard.setName(this.localeService.getLanguageValue(locale, "\u4e13\u6848\u672a\u542f\u52a8"));
        notStartChildCard.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
        resultCardProgress.setChildCard(notStartChildCard);
        resultCardProgress.setAction(new Action(id, ActionTypeEnum.SHOW_TOAST.getValue(), this.localeService.getLanguageValue(locale, "\u6b64\u4e13\u6848\u5c1a\u672a\u542f\u52a8\uff0c\u5efa\u8bae\u53bbPC\u7aef\u7ef4\u62a4")));
        return resultCardProgress;
    }

    private CardProgress buildPccNotStarted(CardProgress resultCardProgress, String locale, String id, Map<String, Object> rawData) {
        ChildCard notStartChildCard = new ChildCard();
        notStartChildCard.setName(this.localeService.getLanguageValue(locale, "\u4e13\u6848\u672a\u542f\u52a8"));
        notStartChildCard.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
        resultCardProgress.setChildCard(notStartChildCard);
        resultCardProgress.setAction(new Action(id, PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_PCC_EMPTY_PAGE.toString(), ActionTypeEnum.OPEN_NEW_PAGE.getValue(), rawData));
        return resultCardProgress;
    }

    public CardProgress transCardDetailToPccProjectProgress(String locale, String iamUserToken, String tenantId, String projectId, Boolean isShare, String tmActivityId, String tmTaskId) {
        String projectStatus;
        DigiwinAtmcCardDetail taskCardDetail = this.digiwinAtmcProxyService.getDigiwinAtmcProjectCardDetail(locale, iamUserToken, tenantId, projectId);
        CardProgress resultCardProgress = new CardProgress();
        if (!StringUtils.hasLength((String)tmActivityId)) {
            HashMap<String, Object> rawData = new HashMap<String, Object>();
            rawData.put("project_type", taskCardDetail.getTmTaskId());
            rawData.put("isShare", isShare);
            rawData.put("tmTaskId", tmTaskId);
            return this.buildPccNotStarted(resultCardProgress, locale, projectId.trim(), rawData);
        }
        if (!"progressTrack".equalsIgnoreCase(tmActivityId)) {
            return this.buildToWeb(resultCardProgress, locale, projectId.trim());
        }
        DigiwinAtmcSummaryLayout summaryLayout = taskCardDetail.getSummaryLayout();
        if (null == summaryLayout || CollectionUtils.isEmpty((Collection)summaryLayout.getLayout())) {
            ChildCard childCard = new ChildCard();
            childCard.setName(this.localeService.getLanguageValue(locale, "\u6682\u65e0\u6570\u636e"));
            childCard.setType(Integer.valueOf(CardTypeEnum.GENERAL.getValue()));
            resultCardProgress.setChildCard(childCard);
            HashMap<String, Object> rawData = new HashMap<String, Object>();
            rawData.put("project_type", taskCardDetail.getTmTaskId());
            rawData.put("isShare", isShare);
            resultCardProgress.setAction(new Action(taskCardDetail.getProjectId().trim(), PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_PROJECT_DETAIL.toString(), "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(), rawData));
            return resultCardProgress;
        }
        List layoutList = summaryLayout.getLayout();
        UiBotPageData pageData = summaryLayout.getPageData();
        Map bizData = new HashMap();
        for (UiBotLayout layout : layoutList) {
            Map map;
            Object o;
            if (layout.isTypeOfTable()) {
                List bizDataList = (List)pageData.get((Object)layout.getSchema());
                if (CollectionUtils.isEmpty((Collection)bizDataList)) continue;
                bizData = (Map)bizDataList.get(0);
                continue;
            }
            if (!layout.isTypeOfFormList() || !((o = pageData.get((Object)layout.getSchema())) instanceof Map) || CollectionUtils.isEmpty((Map)(map = (Map)o))) continue;
            bizData = map;
        }
        switch (projectStatus = String.valueOf(bizData.get("project_status"))) {
            case "20": {
                this.buildApprovals(resultCardProgress, locale, taskCardDetail);
                break;
            }
            case "30": 
            case "50": {
                ArrayList<ProgressRate> progressRateList = new ArrayList<ProgressRate>();
                double projectCompleteRate = Double.valueOf(((Object)bizData.getOrDefault("project_complete_rate", 0.0)).toString());
                ProgressRate completeProgressRate = new ProgressRate();
                completeProgressRate.setRate(Double.valueOf(MathUtil.getDecimalPoint((double)projectCompleteRate, (int)2)));
                completeProgressRate.setType(ProgressRateTypeEnum.NORMAL.getType());
                completeProgressRate.setName(this.localeService.getLanguageValue(locale, "\u5b8c\u6210\u7387"));
                progressRateList.add(completeProgressRate);
                double projectOverdueRate = Double.valueOf(((Object)bizData.getOrDefault("project_overdue_rate", 0.0)).toString());
                if (projectOverdueRate != 0.0) {
                    ProgressRate overdueProgressRate = new ProgressRate();
                    overdueProgressRate.setRate(Double.valueOf(MathUtil.getDecimalPoint((double)projectOverdueRate, (int)2)));
                    overdueProgressRate.setType(ProgressRateTypeEnum.EXCEPTION.getType());
                    overdueProgressRate.setName(this.localeService.getLanguageValue(locale, "\u903e\u671f\u7387"));
                    progressRateList.add(overdueProgressRate);
                }
                resultCardProgress.setProgressRateList(progressRateList);
                HashMap<String, Object> rawData = new HashMap<String, Object>();
                rawData.put("project_type", taskCardDetail.getTmTaskId());
                rawData.put("isShare", isShare);
                resultCardProgress.setAction(new Action(taskCardDetail.getProjectId() + "", PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_PROJECT_DETAIL.toString(), "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(), rawData));
                break;
            }
            case "60": {
                this.buildCloseCase(resultCardProgress, locale, taskCardDetail);
                break;
            }
            default: {
                this.buildNotStarted(resultCardProgress, locale, taskCardDetail.getProjectId().trim());
            }
        }
        return resultCardProgress;
    }

    public List<Card> sortCardList(List<Card> cardList, String locale) {
        if ("zh_CN".equalsIgnoreCase(locale)) {
            List<Card> startWithEnList = new LinkedList();
            List<Card> startWithNotEnList = new LinkedList();
            for (Card card : cardList) {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)card.getName()) && String.valueOf(card.getName().charAt(0)).matches("^[a-zA-Z]")) {
                    startWithEnList.add(card);
                    continue;
                }
                startWithNotEnList.add(card);
            }
            startWithNotEnList = this.sortCardListByType(startWithNotEnList, locale);
            startWithEnList = this.sortCardListByType(startWithEnList, locale);
            startWithNotEnList.addAll(startWithEnList);
            return startWithNotEnList;
        }
        return this.sortCardListByType(cardList, locale);
    }

    public List<Card> sortCardListByType(List<Card> cardList, String locale) {
        return cardList.stream().sorted((o1, o2) -> {
            LocalDateTime o2EndTime;
            boolean isNewO2;
            Collator collator = "zh_CN".equalsIgnoreCase(locale) ? Collator.getInstance(Locale.SIMPLIFIED_CHINESE) : Collator.getInstance(Locale.TRADITIONAL_CHINESE);
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)o1.getName(), (CharSequence)o2.getName())) {
                return collator.compare(o1.getName(), o2.getName());
            }
            boolean isNewO1 = !CollectionUtils.isEmpty((Collection)o1.getLabelList()) ? o1.getLabelList().stream().anyMatch(e -> "NEW".equalsIgnoreCase(e.getType())) : false;
            boolean bl = isNewO2 = !CollectionUtils.isEmpty((Collection)o2.getLabelList()) ? o2.getLabelList().stream().anyMatch(e -> "NEW".equalsIgnoreCase(e.getType())) : false;
            if (isNewO1 ^ isNewO2) {
                return isNewO1 ? -1 : 1;
            }
            LocalDateTime o1EndTime = DateTimeUtil.parseUseDefaultPattern((String)o1.getEndTime());
            if (!o1EndTime.isEqual(o2EndTime = DateTimeUtil.parseUseDefaultPattern((String)o2.getEndTime()))) {
                return o1EndTime.isBefore(o2EndTime) ? -1 : 1;
            }
            return 0;
        }).collect(Collectors.toList());
    }

    public boolean validIsMatchTenantId(String tenantId) {
        return NEED_SORTCARD_BY_TENANTID_LIST.contains(tenantId);
    }

    public List<Card> sortCardListByCreateTime(List<Card> cardList) {
        return cardList.stream().sorted((o1, o2) -> {
            LocalDateTime o1CreateTime = DateTimeUtil.parseUseDefaultPattern((String)o1.getCreateTime());
            LocalDateTime o2CreateTime = DateTimeUtil.parseUseDefaultPattern((String)o2.getCreateTime());
            return o2CreateTime.compareTo(o1CreateTime);
        }).collect(Collectors.toList());
    }
}

