/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.project.strategy.ProjectCreateDetailBuildBizDataEntryDrivenStrategy;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmFormInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.StartProjectPageService;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class UiBotModelBuildProjectCreateV2Strategy
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelBuildProjectCreateV2Strategy.class);
    @Autowired
    private StartProjectPageService startProjectPageService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private ProjectCreateDetailBuildBizDataEntryDrivenStrategy projectCreateDetailBuildBizDataEntryDrivenStrategy;
    @Autowired
    private ActivityFilterService activityFilterService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        apiRequest.setDataId(apiRequest.getRawData().getString("dataId"));
        PcUiBotExecuteContext executeContext = PcUiBotExecuteContext.create((String)apiRequest.getLocale(), (String)apiRequest.getTenantId(), (String)apiRequest.getDataId());
        executeContext.appendPageInfo("task-detail-mobile", null, apiRequest.getDataId(), "performer", Boolean.FALSE);
        executeContext.setAuthoredUser(new PcUiBotAuthoredUser().setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId()).setToken(apiRequest.getIamUserToken()));
        if (this.isMobileConfigExist(executeContext)) {
            return this.startProjectPageService.createPresetActivityTemplateForm(apiRequest, executeContext);
        }
        return this.projectCreateDetailBuildBizDataEntryDrivenStrategy.buildUibotModel(apiRequest);
    }

    private boolean isMobileConfigExist(PcUiBotExecuteContext executeContext) {
        PcUiBotTmActivity tmActivity = this.getActivityWithoutTaskId(executeContext);
        if (tmActivity == null) {
            return true;
        }
        PcUiBotTmFormInfo bindForm = tmActivity.getBindForm();
        if (bindForm == null) {
            return true;
        }
        String formCode = bindForm.getFormCode();
        if (!StringUtils.hasLength((String)formCode)) {
            return true;
        }
        if (TaskStringUtil.isProjectCreateOfModelDriven((String)formCode)) {
            return false;
        }
        String tenantVersion = this.activityFilterService.tenantVersion(executeContext.getAuthoredUser().getToken(), executeContext.getTenantId(), executeContext.getLocale());
        return BooleanUtils.isTrue((Boolean)this.activityFilterService.isExsitTmActivityIdOfMobileDesignerConfig(tmActivity.getApplication(), formCode, MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue(), executeContext.getTenantId(), tenantVersion));
    }

    public PcUiBotTmActivity getActivityWithoutTaskId(PcUiBotExecuteContext executeContext) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", executeContext.getPageCode());
        DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getTenantId())).uriVariables(uriVariables).build();
        KnowledgeMapsActivityDefinition rawActivityDefinition = this.digiwinKnowledgeMapsProxyService.getActivityDefinitionWithoutTaskId(athenaApiRequest);
        return (PcUiBotTmActivity)JsonUtil.objectToJavaObject((Object)rawActivityDefinition, PcUiBotTmActivity.class);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

