/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.atmc.model;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListOption;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcCardConfigItem;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DigiwinAtmcProject
implements Serializable {
    private static final long serialVersionUID = -7647221986259004434L;
    public static final String PROJECT_TYPE = "project_type";
    public static final String PROJECT_STATUS = "project_status";
    public static final String PROJECT_STATUS_ABNORMAL = "project_status_abnormal";
    public static final String PROJECT_STATUS_NORMAL = "project_status_normal";
    public static final String PROJECT_STATUS_URGENT = "project_status_urgent";
    public static final String PROJECT_STATUS_NO_TASK = "project_status_no_task";
    public static final String PROJECT_STATUS_SHARE = "project_status_share";
    private Long id;
    private String name;
    private String startTime;
    private String endTime;
    private Boolean importance;
    private String createTime;
    private Integer taskCount;
    private Integer emergency;
    private Integer emergencyProjectCount;
    private Integer subProjectCount;
    private Integer subProjectFinishedCount;
    private Boolean changed;
    private Boolean isOwner;
    private String ownerUserId;
    private Long readCount;
    private String tmTaskId;
    private Boolean exception;
    private Boolean overdue;
    private String modifyDate;
    private Boolean hasDataChanged;
    private List<DigiwinAtmcTask> tasks;
    private String projectName;
    private String personInCharge;
    private String personInChargeName;
    private Boolean pinning;
    private String appCode;
    private String engineType;
    private String dataFrom;
    private List<DigiwinAtmcCardConfigItem> cardConfig;
    private Map<String, Object> businessMessage;

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DigiwinAtmcProject) {
            DigiwinAtmcProject otherProject = (DigiwinAtmcProject)obj;
            return this.id.equals(otherProject.id);
        }
        return super.equals(obj);
    }

    public CardListFilter getProjectType(String locale) {
        CardListFilter filter = new CardListFilter();
        filter.setFilterId(PROJECT_TYPE);
        filter.setFilterName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9879\u76ee\u7c7b\u578b"));
        ArrayList<CardListOption> optionList = new ArrayList<CardListOption>();
        filter.setFilterOptionList(optionList);
        optionList.add(new CardListOption(this.getTmTaskId(), this.getProjectName()));
        return filter;
    }

    public CardListFilter getProjectStatus(String locale) {
        CardListFilter filter = new CardListFilter();
        filter.setFilterId(PROJECT_STATUS);
        filter.setFilterName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9879\u76ee\u72b6\u6001"));
        ArrayList<CardListOption> optionList = new ArrayList<CardListOption>();
        filter.setFilterOptionList(optionList);
        if (this.getOverdue().booleanValue() || this.getException().booleanValue()) {
            optionList.add(new CardListOption(PROJECT_STATUS_ABNORMAL, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5f02\u5e38") + "/" + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f")));
        } else {
            optionList.add(new CardListOption(PROJECT_STATUS_NORMAL, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6b63\u5e38\u8fdb\u884c")));
        }
        if (this.getEmergency() != null && this.getEmergency() == 1) {
            optionList.add(new CardListOption(PROJECT_STATUS_URGENT, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7d27\u6025")));
        }
        if (this.getTaskCount() != null && this.getTaskCount() == 0) {
            optionList.add(new CardListOption(PROJECT_STATUS_NO_TASK, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6682\u65e0\u4efb\u52a1")));
        }
        if (this.getPinning() != null && this.getPinning().booleanValue()) {
            optionList.add(new CardListOption(PROJECT_STATUS_SHARE, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u4ed6\u4eba\u5206\u4eab")));
        }
        return filter;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Boolean getImportance() {
        return this.importance;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public Integer getTaskCount() {
        return this.taskCount;
    }

    public Integer getEmergency() {
        return this.emergency;
    }

    public Integer getEmergencyProjectCount() {
        return this.emergencyProjectCount;
    }

    public Integer getSubProjectCount() {
        return this.subProjectCount;
    }

    public Integer getSubProjectFinishedCount() {
        return this.subProjectFinishedCount;
    }

    public Boolean getChanged() {
        return this.changed;
    }

    public Boolean getIsOwner() {
        return this.isOwner;
    }

    public String getOwnerUserId() {
        return this.ownerUserId;
    }

    public Long getReadCount() {
        return this.readCount;
    }

    public String getTmTaskId() {
        return this.tmTaskId;
    }

    public Boolean getException() {
        return this.exception;
    }

    public Boolean getOverdue() {
        return this.overdue;
    }

    public String getModifyDate() {
        return this.modifyDate;
    }

    public Boolean getHasDataChanged() {
        return this.hasDataChanged;
    }

    public List<DigiwinAtmcTask> getTasks() {
        return this.tasks;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getPersonInCharge() {
        return this.personInCharge;
    }

    public String getPersonInChargeName() {
        return this.personInChargeName;
    }

    public Boolean getPinning() {
        return this.pinning;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public String getDataFrom() {
        return this.dataFrom;
    }

    public List<DigiwinAtmcCardConfigItem> getCardConfig() {
        return this.cardConfig;
    }

    public Map<String, Object> getBusinessMessage() {
        return this.businessMessage;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setImportance(Boolean importance) {
        this.importance = importance;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setTaskCount(Integer taskCount) {
        this.taskCount = taskCount;
    }

    public void setEmergency(Integer emergency) {
        this.emergency = emergency;
    }

    public void setEmergencyProjectCount(Integer emergencyProjectCount) {
        this.emergencyProjectCount = emergencyProjectCount;
    }

    public void setSubProjectCount(Integer subProjectCount) {
        this.subProjectCount = subProjectCount;
    }

    public void setSubProjectFinishedCount(Integer subProjectFinishedCount) {
        this.subProjectFinishedCount = subProjectFinishedCount;
    }

    public void setChanged(Boolean changed) {
        this.changed = changed;
    }

    public void setIsOwner(Boolean isOwner) {
        this.isOwner = isOwner;
    }

    public void setOwnerUserId(String ownerUserId) {
        this.ownerUserId = ownerUserId;
    }

    public void setReadCount(Long readCount) {
        this.readCount = readCount;
    }

    public void setTmTaskId(String tmTaskId) {
        this.tmTaskId = tmTaskId;
    }

    public void setException(Boolean exception) {
        this.exception = exception;
    }

    public void setOverdue(Boolean overdue) {
        this.overdue = overdue;
    }

    public void setModifyDate(String modifyDate) {
        this.modifyDate = modifyDate;
    }

    public void setHasDataChanged(Boolean hasDataChanged) {
        this.hasDataChanged = hasDataChanged;
    }

    public void setTasks(List<DigiwinAtmcTask> tasks) {
        this.tasks = tasks;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setPersonInCharge(String personInCharge) {
        this.personInCharge = personInCharge;
    }

    public void setPersonInChargeName(String personInChargeName) {
        this.personInChargeName = personInChargeName;
    }

    public void setPinning(Boolean pinning) {
        this.pinning = pinning;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public void setDataFrom(String dataFrom) {
        this.dataFrom = dataFrom;
    }

    public void setCardConfig(List<DigiwinAtmcCardConfigItem> cardConfig) {
        this.cardConfig = cardConfig;
    }

    public void setBusinessMessage(Map<String, Object> businessMessage) {
        this.businessMessage = businessMessage;
    }

    public String toString() {
        return "DigiwinAtmcProject(id=" + this.getId() + ", name=" + this.getName() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", importance=" + this.getImportance() + ", createTime=" + this.getCreateTime() + ", taskCount=" + this.getTaskCount() + ", emergency=" + this.getEmergency() + ", emergencyProjectCount=" + this.getEmergencyProjectCount() + ", subProjectCount=" + this.getSubProjectCount() + ", subProjectFinishedCount=" + this.getSubProjectFinishedCount() + ", changed=" + this.getChanged() + ", isOwner=" + this.getIsOwner() + ", ownerUserId=" + this.getOwnerUserId() + ", readCount=" + this.getReadCount() + ", tmTaskId=" + this.getTmTaskId() + ", exception=" + this.getException() + ", overdue=" + this.getOverdue() + ", modifyDate=" + this.getModifyDate() + ", hasDataChanged=" + this.getHasDataChanged() + ", tasks=" + this.getTasks() + ", projectName=" + this.getProjectName() + ", personInCharge=" + this.getPersonInCharge() + ", personInChargeName=" + this.getPersonInChargeName() + ", pinning=" + this.getPinning() + ", appCode=" + this.getAppCode() + ", engineType=" + this.getEngineType() + ", dataFrom=" + this.getDataFrom() + ", cardConfig=" + this.getCardConfig() + ", businessMessage=" + this.getBusinessMessage() + ")";
    }

    public DigiwinAtmcProject() {
    }

    public DigiwinAtmcProject(Long id, String name, String startTime, String endTime, Boolean importance, String createTime, Integer taskCount, Integer emergency, Integer emergencyProjectCount, Integer subProjectCount, Integer subProjectFinishedCount, Boolean changed, Boolean isOwner, String ownerUserId, Long readCount, String tmTaskId, Boolean exception, Boolean overdue, String modifyDate, Boolean hasDataChanged, List<DigiwinAtmcTask> tasks, String projectName, String personInCharge, String personInChargeName, Boolean pinning, String appCode, String engineType, String dataFrom, List<DigiwinAtmcCardConfigItem> cardConfig, Map<String, Object> businessMessage) {
        this.id = id;
        this.name = name;
        this.startTime = startTime;
        this.endTime = endTime;
        this.importance = importance;
        this.createTime = createTime;
        this.taskCount = taskCount;
        this.emergency = emergency;
        this.emergencyProjectCount = emergencyProjectCount;
        this.subProjectCount = subProjectCount;
        this.subProjectFinishedCount = subProjectFinishedCount;
        this.changed = changed;
        this.isOwner = isOwner;
        this.ownerUserId = ownerUserId;
        this.readCount = readCount;
        this.tmTaskId = tmTaskId;
        this.exception = exception;
        this.overdue = overdue;
        this.modifyDate = modifyDate;
        this.hasDataChanged = hasDataChanged;
        this.tasks = tasks;
        this.projectName = projectName;
        this.personInCharge = personInCharge;
        this.personInChargeName = personInChargeName;
        this.pinning = pinning;
        this.appCode = appCode;
        this.engineType = engineType;
        this.dataFrom = dataFrom;
        this.cardConfig = cardConfig;
        this.businessMessage = businessMessage;
    }
}

