/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.eoc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.DigiwinEocAddUpdateEmp;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.DigiwinEocEmployee;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.DigiwinEocResult;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.DigiwinEocTenantAllUser;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocDeptPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocDeptResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocOrg;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPerson;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonInfo;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocProxyUserResult;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service(value="digiwinEocProxyService")
public class DigiwinEocProxyServiceImpl
implements DigiwinEocProxyService {
    private static final Logger log = LoggerFactory.getLogger(DigiwinEocProxyServiceImpl.class);
    @Autowired
    private HttpService httpService;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private SysEnvConfig sysEnvConfig;

    public EocPersonResponse getPersonList(String iamUserToken, int pageSize, int pageNum, String queryCondition) {
        EocPersonResponse eocPersonResponse = null;
        JSONObject queryObj = new JSONObject();
        queryObj.put("content", (Object)queryCondition);
        String queryStr = queryObj.toString();
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("pageNum", pageNum);
        uriVariables.put("params", queryStr);
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp?pageSize={pageSize}&pageNum={pageNum}&params={params}";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), uriVariables, Map.class);
        Map responseMap = (Map)responseEntity.getBody();
        if (responseMap.get("code").equals(200)) {
            eocPersonResponse = (EocPersonResponse)JsonUtil.objectToJavaObject(responseMap.get("data"), EocPersonResponse.class);
        }
        return eocPersonResponse != null ? eocPersonResponse : EocPersonResponse.getEmptyObject();
    }

    public EocPersonResponse getSimplePersonList(String iamUserToken, int pageSize, int pageNum, String queryCondition) {
        EocPersonResponse eocPersonResponse = null;
        JSONObject queryObj = new JSONObject();
        queryObj.put("content", (Object)queryCondition);
        String queryStr = queryObj.toString();
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("pageNum", pageNum);
        uriVariables.put("params", queryStr);
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp/simple?pageSize={pageSize}&pageNum={pageNum}&params={params}";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), uriVariables, Map.class);
        Map responseMap = (Map)responseEntity.getBody();
        if (responseMap.get("code").equals(200)) {
            eocPersonResponse = (EocPersonResponse)JsonUtil.objectToJavaObject(responseMap.get("data"), EocPersonResponse.class);
        }
        return eocPersonResponse != null ? eocPersonResponse : EocPersonResponse.getEmptyObject();
    }

    public EocPersonResponse getSimplePersonListByParams(String iamUserToken, int pageSize, int pageNum, Map<String, Object> params) {
        EocPersonResponse eocPersonResponse = null;
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("pageNum", pageNum);
        uriVariables.put("params", params);
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp/simple?pageSize={pageSize}&pageNum={pageNum}&params={params}";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), uriVariables, Map.class);
        Map responseMap = (Map)responseEntity.getBody();
        if (responseMap.get("code").equals(200)) {
            eocPersonResponse = (EocPersonResponse)JsonUtil.objectToJavaObject(responseMap.get("data"), EocPersonResponse.class);
        }
        return eocPersonResponse != null ? eocPersonResponse : EocPersonResponse.getEmptyObject();
    }

    public EocDeptResponse getEocDeptList(String iamUserToken, int pageSize, int pageNum) {
        EocDeptResponse eocDeptResponse = null;
        HashMap<String, Integer> uriVariables = new HashMap<String, Integer>();
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("pageNum", pageNum);
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/dept/list?pageSize={pageSize}&pageNum={pageNum}";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), uriVariables, Map.class);
        Map responseMap = (Map)responseEntity.getBody();
        if (responseMap.get("code").equals(200)) {
            eocDeptResponse = (EocDeptResponse)JsonUtil.objectToJavaObject(responseMap.get("data"), EocDeptResponse.class);
        }
        return eocDeptResponse != null ? eocDeptResponse : EocDeptResponse.getEmptyObject();
    }

    public EocDeptPersonResponse getEocDeptPersonList(String deptId, String iamUserToken, int pageSize, int pageNum) {
        EocDeptPersonResponse eocDeptPersonResponse = null;
        HashMap<String, Integer> uriVariables = new HashMap<String, Integer>();
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("pageNum", pageNum);
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/dept/" + deptId + "/emps?pageSize={pageSize}&pageNum={pageNum}";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), uriVariables, Map.class);
        Map responseMap = (Map)responseEntity.getBody();
        if (responseMap.get("code").equals(200)) {
            eocDeptPersonResponse = (EocDeptPersonResponse)JsonUtil.objectToJavaObject(responseMap.get("data"), EocDeptPersonResponse.class);
        }
        return eocDeptPersonResponse != null ? eocDeptPersonResponse : EocDeptPersonResponse.getEmptyObject();
    }

    public EocPerson getEocInfo(String id, String iamUserToken) {
        HashMap<String, String> body = new HashMap<String, String>(1);
        body.put("userId", id);
        try {
            String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp/info";
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(body), DigiwinEocResult.class);
            DigiwinEocResult result = (DigiwinEocResult)responseEntity.getBody();
            if (result != null && result.isSuccess()) {
                return (EocPerson)JsonUtil.objectToJavaObject((Object)result.getData(), EocPerson.class);
            }
        }
        catch (Exception e) {
            return new EocPerson();
        }
        return null;
    }

    public EocPersonInfo getEocPersonInfo(String id, String iamUserToken, int type) {
        String imUrl;
        ResponseEntity imResponseEntity;
        Map imResponseMap;
        EocPersonInfo personInfo = new EocPersonInfo();
        HashMap<String, String> body = new HashMap<String, String>();
        String eocId = null;
        if (type == 1) {
            eocId = id;
            body.put("empId", id);
        } else {
            body.put("userId", id);
        }
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp/info";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(body), Map.class);
        Map responseMap = (Map)responseEntity.getBody();
        if (responseMap.get("code").equals(200)) {
            Map person = (Map)responseMap.get("data");
            eocId = (String)person.get("id");
            personInfo.setEocId((String)person.get("id"));
            personInfo.setName((String)person.get("name"));
            personInfo.setEmail((String)person.get("email"));
            personInfo.setPhone((String)person.get("telephone"));
            Map user = (Map)person.get("user");
            if (user != null) {
                personInfo.setUserId((String)user.get("id"));
                personInfo.setEmail((String)user.get("email"));
            }
            StringBuilder position = new StringBuilder();
            List duties = (List)person.get("duties");
            if (duties != null && !duties.isEmpty()) {
                duties.stream().forEach(duty -> position.append(duty.get("name") + "/"));
            }
            if (position.length() > 0) {
                personInfo.setPosition(position.substring(0, position.length() - 1));
            }
        }
        if (StringUtils.hasLength((String)eocId) && (imResponseMap = (Map)(imResponseEntity = this.httpService.doGet(imUrl = AppContext.getApiUrlSetting().getImUrl() + "/user/getUserInfo/" + eocId, new AthenaBasicHttpRequestHead(iamUserToken), new HashMap(), Map.class)).getBody()).get("response") != null) {
            Map imInfo = (Map)imResponseMap.get("response");
            personInfo.setAccId((String)imInfo.get("accid"));
        }
        return personInfo;
    }

    public EocPersonInfo getEocPersonInfo(String id, String iamUserToken) {
        EocPersonInfo personInfo = new EocPersonInfo();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("empId", id);
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp/info";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(body), Map.class);
        Map responseMap = (Map)responseEntity.getBody();
        if (responseMap.get("code").equals(200)) {
            Map person = (Map)responseMap.get("data");
            personInfo.setEocId((String)person.get("id"));
            personInfo.setName((String)person.get("name"));
            personInfo.setEmail((String)person.get("email"));
            personInfo.setPhone((String)person.get("telephone"));
            Map user = (Map)person.get("user");
            if (user != null) {
                personInfo.setUserId((String)user.get("id"));
            }
            StringBuilder position = new StringBuilder();
            List duties = (List)person.get("duties");
            if (duties != null && !duties.isEmpty()) {
                duties.stream().forEach(duty -> position.append(duty.get("name") + "/"));
            }
            if (position.length() > 0) {
                personInfo.setPosition(position.substring(0, position.length() - 1));
            }
        }
        return personInfo;
    }

    public String getName(String id, String iamUserToken) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("empId", id);
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp/info";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(body), Map.class);
        Map responseMap = (Map)responseEntity.getBody();
        Map person = (Map)responseMap.get("data");
        return (String)person.get("name");
    }

    public String getEocId(String iamUserToken, String userId) {
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp/id";
        HashMap<String, String> body = new HashMap<String, String>(1);
        body.put("userId", userId);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(body), Map.class);
        Map responseMap = (Map)responseEntity.getBody();
        return (String)responseMap.get("data");
    }

    public List<Map<String, Object>> getCompany(String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/corp/company";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), new HashMap(), Map.class);
        List<Map<String, Object>> resultMap = (List<Map<String, Object>>)((Map)responseEntity.getBody()).get("data");
        return resultMap != null ? resultMap : Collections.emptyList();
    }

    public List<Map<String, Object>> getFactory(String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/corp/factory";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), new HashMap(), Map.class);
        List<Map<String, Object>> resultMap = (List<Map<String, Object>>)((Map)responseEntity.getBody()).get("data");
        return resultMap != null ? resultMap : Collections.emptyList();
    }

    public List<Map<String, Object>> getArea(String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/area?pageSize={pageSize}";
        HashMap<String, Integer> uriVariables = new HashMap<String, Integer>();
        uriVariables.put("pageSize", 9999);
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), uriVariables, Map.class);
        Map resultMap = (Map)((Map)responseEntity.getBody()).get("data");
        if (resultMap == null) {
            return Collections.emptyList();
        }
        List<Map<String, Object>> resultList = (List<Map<String, Object>>)resultMap.get("list");
        return resultList != null ? resultList : Collections.emptyList();
    }

    public Boolean isDeptDirector(String userId, String iamUserToken) {
        List eocUserDTOList = this.getAllUserByDirectorId(userId, Integer.valueOf(1), iamUserToken);
        if (!CollectionUtils.isEmpty((Collection)eocUserDTOList)) {
            return Boolean.TRUE;
        }
        DigiwinEocEmployee eocEmployeeDTO = this.getEmployeeByUserId(userId, iamUserToken);
        if (eocEmployeeDTO != null && !CollectionUtils.isEmpty((Collection)eocEmployeeDTO.getDepts())) {
            for (DigiwinEocEmployee.DigiwinEocEmployeeDepart dept : eocEmployeeDTO.getDepts()) {
                if (!Objects.equals(dept.getDeptDirectorId(), eocEmployeeDTO.getId())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public List<DigiwinEocTenantAllUser.DigiwinEocUser> getAllUserByDirectorId(String directorId, Integer size, String iamUserToken) {
        DigiwinEocEmployee eocEmployeeDTO = this.getEmployeeByUserId(directorId, iamUserToken);
        if (eocEmployeeDTO == null) {
            return Collections.emptyList();
        }
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp/simple?pageNum=1&pageSize={pageSize}&params={params}";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("directorId", eocEmployeeDTO.getId());
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("pageSize", size.toString());
        param.put("params", JsonUtil.javaObjectToJsonString(params));
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), param, DigiwinEocTenantAllUser.class);
        DigiwinEocTenantAllUser result = (DigiwinEocTenantAllUser)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return result.getData().getList();
        }
        return null;
    }

    public DigiwinEocEmployee getEmployeeByUserId(String userId, String iamUserToken) {
        return this.getEmployee(userId, null, iamUserToken);
    }

    private DigiwinEocEmployee getEmployee(String userId, String empId, String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp/info";
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("userId", userId);
        param.put("empId", empId);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(param), Map.class);
        Map resultMap = (Map)((Map)responseEntity.getBody()).get("data");
        return resultMap != null ? (DigiwinEocEmployee)JsonUtil.objectToJavaObject((Object)resultMap, DigiwinEocEmployee.class) : null;
    }

    public List<EocProxyUserResult.EocProxyUser> getProxyTargetUsers(String userId, String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp/agent/target";
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("userId", userId);
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(param), EocProxyUserResult.class);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return null;
            }
            EocProxyUserResult baseResult = (EocProxyUserResult)responseEntity.getBody();
            if (baseResult != null && baseResult.getCode() == 200 && baseResult.getData() != null) {
                return baseResult.getData();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean addOrUpdateEocEmp(String locale, String userId, String iamUserToken, DigiwinEocAddUpdateEmp empInfo) {
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp";
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString((Object)empInfo), Map.class);
            return responseEntity.getStatusCode().is2xxSuccessful();
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    private HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    private void addLang(HttpHeaders headers, String iamUserToken) {
        headers.add("locale", AppRequestContext.getContextEntity().getLocale());
        headers.add("digi-middleware-auth-user", iamUserToken);
        headers.add("digi-middleware-auth-app", this.sysEnvConfig.getAppToken());
        headers.add("token", iamUserToken);
    }

    public EocOrg getEocOrgTree(String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/org/tree";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), new HashMap(), DigiwinEocResult.class);
        DigiwinEocResult result = (DigiwinEocResult)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return (EocOrg)JsonUtil.objectToJavaObject((Object)result.getData(), EocOrg.class);
        }
        return null;
    }
}

