/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.esp.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.mobile.mobileuibot.api.ApiRequestPosition;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import com.digiwin.mobile.mobileuibot.common.logrecord.OuterRequestRecordManage;
import com.digiwin.mobile.mobileuibot.common.logrecord.RequestSourceEnum;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.OuterRequestRecord;
import com.digiwin.mobile.mobileuibot.printer.model.AbiReportAsyncExport;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.AppointmentDeliveryDate;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.CanAppointmentDeliveryTimeSlot;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinCustomerInfoRequest;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspEnumerateResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspErrorResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspExecution;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspStdData;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinInventoryData;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinItemCategory;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinOrderPriceData;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinReceivableRequest;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.PersonnelDutyResp;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.TransportList;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.UseAppointmentDeliveryPlatform;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbArea;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbCargoUnloading;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbDeliveryLoadingCount;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbTransportReceiptStatusCount;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbUserAddress;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import com.fasterxml.jackson.core.type.TypeReference;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class DigiwinEspProxyServiceImpl
implements DigiwinEspProxyService {
    private Logger logger = LoggerFactory.getLogger(DigiwinEspProxyServiceImpl.class);
    private static final String FEATURE_WEEK = "0";
    private static final String FEATURE_MONTH = "1";
    @Autowired
    private OuterRequestRecordManage outerRequestRecordManage;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinIamProxyService iamProxyService;

    public ResponseModel invokeRestSync(@NotNull String tenantId, @NotNull String locale, @NotNull String serviceProd, @NotNull String serviceName, @NotNull Map<String, String> headers, @NotNull String bodyJsonString) {
        RequestModel requestModel = new RequestModel();
        requestModel.setHostAcct("athena");
        requestModel.setHostProd("Athena-mobile");
        requestModel.setHostVer(AppContext.getApiUrlSetting().getApplicationVersion());
        requestModel.setHostId("Athena-mobile");
        requestModel.setLanguage(locale);
        requestModel.setTenantId(tenantId);
        requestModel.setHeaderMap(headers);
        JSONObject body = new JSONObject();
        JSONObject stdData = new JSONObject();
        body.put("std_data", (Object)stdData);
        stdData.put("parameter", JsonUtil.jsonStringToObject((String)bodyJsonString, JSONObject.class));
        requestModel.setBodyJsonString(JsonUtil.javaObjectToJsonString((Object)body));
        requestModel.setServiceProd(serviceProd);
        requestModel.setServiceName(serviceName);
        long startTime = System.currentTimeMillis();
        try {
            ResponseModel responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
            long endTime = System.currentTimeMillis();
            LocalDateTime logStartTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(startTime), ZoneId.systemDefault());
            LocalDateTime logEndTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(endTime), ZoneId.systemDefault());
            this.logger.info("========================\u4f7f\u7528esp-sdk\u8bf7\u6c42\u63a5\u53e3\u62e6\u622a==========================\nserviceProd\uff1a{}\nserviceName\uff1a{}\nrequestTime: {}\nresponseTime\uff1a{}\nrunningTime\uff1a{}ms\nrequest body json string\uff1a{}\nresponse body json string\uff1a{}", new Object[]{serviceProd, serviceName, logStartTime, logEndTime, endTime - startTime, requestModel.getBodyJsonString(), responseModel.getBodyJsonString()});
            this.buildOuterRequestRecord(true, requestModel, responseModel, startTime, endTime, "");
            DigiwinEspErrorResponse espErrorResponse = (DigiwinEspErrorResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspErrorResponse.class);
            if (!(ObjectUtils.isEmpty((Object)espErrorResponse) || ObjectUtils.isEmpty((Object)espErrorResponse.getErrorCode()) || ObjectUtils.isEmpty((Object)espErrorResponse.getErrorMessage()))) {
                throw new ServiceException("ESP errorCode: " + espErrorResponse.getErrorCode() + ", errorMessage: " + espErrorResponse.getErrorMessage() + ", errorInstructors: " + espErrorResponse.getErrorInstructors());
            }
            return responseModel;
        }
        catch (Exception e) {
            this.logger.error("\u4f7f\u7528esp-sdk\u8bf7\u6c42\u63a5\u53e3\u5f02\u5e38\uff0cAPI\u540d\u79f0\uff1a{}\uff0c\u8bf7\u6c42body\uff1a{}", (Object)serviceName, (Object)bodyJsonString);
            long endTime = System.currentTimeMillis();
            this.buildOuterRequestRecord(false, requestModel, null, startTime, endTime, ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
            return null;
        }
    }

    public ResponseModel invokeRestFasync(String tenantId, String locale, String serviceProd, String serviceName, Map<String, String> headers, String bodyJsonString) {
        RequestModel requestModel = new RequestModel();
        requestModel.setHostAcct("athena");
        requestModel.setHostProd("Athena-mobile");
        requestModel.setHostVer(AppContext.getApiUrlSetting().getApplicationVersion());
        requestModel.setHostId("Athena-mobile");
        requestModel.setLanguage(locale);
        requestModel.setTenantId(tenantId);
        requestModel.setHeaderMap(headers);
        JSONObject body = new JSONObject();
        JSONObject stdData = new JSONObject();
        body.put("std_data", (Object)stdData);
        stdData.put("parameter", JsonUtil.jsonStringToObject((String)bodyJsonString, JSONObject.class));
        requestModel.setBodyJsonString(JsonUtil.javaObjectToJsonString((Object)body));
        requestModel.setServiceProd(serviceProd);
        requestModel.setServiceName(serviceName);
        long startTime = System.currentTimeMillis();
        try {
            ResponseModel responseModel = Invoker.invokeRestFasync((RequestModel)requestModel);
            long endTime = System.currentTimeMillis();
            this.buildOuterRequestRecord(true, requestModel, responseModel, startTime, endTime, "");
            DigiwinEspErrorResponse espErrorResponse = (DigiwinEspErrorResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspErrorResponse.class);
            if (!(ObjectUtils.isEmpty((Object)espErrorResponse) || ObjectUtils.isEmpty((Object)espErrorResponse.getErrorCode()) || ObjectUtils.isEmpty((Object)espErrorResponse.getErrorMessage()))) {
                throw new ServiceException("ESP errorCode: " + espErrorResponse.getErrorCode() + ", errorMessage: " + espErrorResponse.getErrorMessage() + ", errorInstructors: " + espErrorResponse.getErrorInstructors());
            }
            return responseModel;
        }
        catch (Exception e) {
            long endTime = System.currentTimeMillis();
            this.buildOuterRequestRecord(false, requestModel, null, startTime, endTime, ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
            return null;
        }
    }

    private void buildOuterRequestRecord(boolean success, RequestModel requestModel, ResponseModel responseModel, long startTime, long endTime, String errorMsg) {
        try {
            OuterRequestRecord requestRecord = new OuterRequestRecord().setRequestId(UUIDUtil.getUuid()).setTraceId(TraceIdUtil.get()).setMethod("ESP").setSource(RequestSourceEnum.OUTER.getSource()).setUrl(requestModel.getServiceName()).setRequestObj(this.buildRequest(requestModel)).setResponseObj(this.buildResponse(success, responseModel, errorMsg)).setRequestTime(new Timestamp(startTime)).setResponseTime(new Timestamp(endTime)).setCode(this.buildCode(success, responseModel)).setMillis(Long.valueOf(endTime - startTime));
            this.outerRequestRecordManage.add(requestRecord);
        }
        catch (Exception e) {
            this.logger.error("esp-sdk server trace log error:", (Throwable)e);
        }
    }

    private Integer buildCode(boolean success, ResponseModel responseModel) {
        try {
            if (!success || null == responseModel || !StringUtils.hasLength((String)responseModel.getBodyJsonString())) {
                return 500;
            }
            DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
            if (null == response) {
                return 500;
            }
            return response.isRespOk() != false ? 200 : 500;
        }
        catch (Exception ignored) {
            return 500;
        }
    }

    private OuterRequestRecord.Request buildRequest(RequestModel requestModel) {
        OuterRequestRecord.Request reqRecord = new OuterRequestRecord.Request();
        reqRecord.setHeader(requestModel.getHeaderMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).setQueryString("").setBody(JsonUtil.jsonStringToObject((String)requestModel.getBodyJsonString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        return reqRecord;
    }

    private OuterRequestRecord.Response buildResponse(boolean success, ResponseModel responseModel, String errorMsg) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("errorMsg", errorMsg);
        OuterRequestRecord.Response respRecord = new OuterRequestRecord.Response();
        respRecord.setHeader(success ? responseModel.getHeaders() : new HashMap()).setBody(success ? JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */) : body);
        return respRecord;
    }

    public boolean checkProjectBackward(String iamUserToken, String tenantId, String locale) {
        JSONObject parameter = new JSONObject();
        JSONArray projectInfoArr = new JSONArray();
        parameter.put("project_info", (Object)projectInfoArr);
        parameter.put("site_no", (Object)"");
        parameter.put("enterprise_no", (Object)"");
        JSONObject projectInfo = new JSONObject();
        projectInfo.put("project_status", (Object)"");
        projectInfo.put("project_set_no", (Object)"");
        projectInfo.put("project_leader_code", (Object)"");
        projectInfo.put("project_type_no", (Object)"");
        projectInfoArr.add((Object)projectInfo);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-token", iamUserToken);
        String serviceName = "project.schedule.analysis.info.get";
        String serviceProd = "PCC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"project_schedule_info"});
        Map parameterMap = response.getStdData().getParameter();
        List projectScheduleInfoList = (List)parameterMap.get("project_schedule_info");
        if (projectScheduleInfoList == null || projectScheduleInfoList.isEmpty()) {
            return false;
        }
        AtomicBoolean haveProjectBackward = new AtomicBoolean(false);
        projectScheduleInfoList.stream().forEach(projectScheduleInfo -> {
            List projectScheduleDetailList = (List)projectScheduleInfo.get("project_schedule_detail");
            if (projectScheduleDetailList != null && !projectScheduleDetailList.isEmpty()) {
                projectScheduleDetailList.stream().forEach(projectScheduleDetail -> {
                    double actualCompleteRate;
                    double planCompleteRate = (Double)projectScheduleDetail.get("plan_complete_rate");
                    if (planCompleteRate - (actualCompleteRate = ((Double)projectScheduleDetail.get("actual_complete_rate")).doubleValue()) > 0.0) {
                        haveProjectBackward.set(true);
                    }
                });
            }
        });
        return haveProjectBackward.get();
    }

    public boolean checkProjectAmountOverdue(String iamUserToken, String tenantId, String locale) {
        JSONObject parameter = new JSONObject();
        JSONArray projectReceiveInfo = new JSONArray();
        parameter.put("project_receive_info", (Object)projectReceiveInfo);
        parameter.put("site_no", (Object)"");
        parameter.put("enterprise_no", (Object)"");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-token", iamUserToken);
        String serviceName = "project.receive.analysis.info.process";
        String serviceProd = "PCC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"project_receive_info"});
        Map parameterMap = response.getStdData().getParameter();
        List projectReceiveInfoList = (List)parameterMap.get("project_receive_info");
        if (projectReceiveInfoList == null || projectReceiveInfoList.isEmpty()) {
            return false;
        }
        AtomicBoolean haveProjectAmountOverdue = new AtomicBoolean(false);
        projectReceiveInfoList.stream().forEach(projectReceiveInfoItem -> {
            List projectReceiveDetailList = (List)projectReceiveInfoItem.get("project_receive_detail");
            if (projectReceiveDetailList != null && !projectReceiveDetailList.isEmpty()) {
                projectReceiveDetailList.stream().forEach(projectReceiveDetail -> {
                    double overdueDays = (Double)projectReceiveDetail.get("overdue_days");
                    double notReceivedTransCurrAmount = (Double)projectReceiveDetail.get("not_received_trans_curr_amount");
                    if (overdueDays > 0.0 && notReceivedTransCurrAmount > 0.0) {
                        haveProjectAmountOverdue.set(true);
                    }
                });
            }
        });
        return false;
    }

    public List<Map<String, Object>> getCardInfo(List<Map<String, Object>> cardInfoRequestList, String userToken, String tenantId, String locale) {
        HashMap<String, String> headers = new HashMap<String, String>(1);
        JSONObject parameter = new JSONObject();
        parameter.put("item_info", cardInfoRequestList);
        headers.put("digi-token", userToken);
        String serviceName = "cad.attribute.info.get";
        String serviceProd = "KSC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"cad_info"});
        return (List)response.getStdData().getParameter().get("cad_info");
    }

    public List<Map<String, Object>> getEmployeeInfoByProjectNo(List<Map<String, Object>> projectMemberInfoRequestList, String userToken, String tenantId, String locale) {
        HashMap<String, String> headers = new HashMap<String, String>(1);
        JSONObject parameter = new JSONObject();
        parameter.put("project_member_info", projectMemberInfoRequestList);
        headers.put("digi-token", userToken);
        String serviceName = "employee.info.process";
        String serviceProd = "PCC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"project_member_info"});
        return (List)response.getStdData().getParameter().get("project_member_info");
    }

    public List<Map<String, Object>> getHumanResourceLoad(List<Map<String, Object>> humanResourceLoadRequestList, String userToken, String tenantId, String locale) {
        HashMap<String, String> headers = new HashMap<String, String>(1);
        JSONObject parameter = new JSONObject();
        parameter.put("query_condition", humanResourceLoadRequestList);
        headers.put("digi-token", userToken);
        String serviceName = "human.resource.load.info.get";
        String serviceProd = "PCC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"department_data"});
        return (List)response.getStdData().getParameter().get("department_data");
    }

    public List<String> getProjectCriticalPath(String iamUserToken, String projectNo, String tenantId, String locale) {
        List<String> taskNoList = new ArrayList<String>();
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        JSONArray projectInfoArr = new JSONArray();
        parameter.put("project_info", (Object)projectInfoArr);
        JSONObject projectInfo = new JSONObject();
        projectInfo.put("project_no", (Object)projectNo);
        projectInfoArr.add((Object)projectInfo);
        String serviceName = "project.critical.path.info.get";
        String serviceProd = "PCC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"task_info"});
        List taskInfoList = (List)response.getStdData().getParameter().get("task_info");
        if (taskInfoList == null || taskInfoList.isEmpty()) {
            return taskNoList;
        }
        taskNoList = taskInfoList.stream().map(taskInfo -> (String)taskInfo.get("task_no")).collect(Collectors.toList());
        return taskNoList;
    }

    public List<String> getNewProjectCriticalPath(String iamUserToken, String projectNo, String tenantId, String locale) {
        List<String> taskNoList = new ArrayList<String>();
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        JSONArray projectInfoArr = new JSONArray();
        parameter.put("project_info", (Object)projectInfoArr);
        JSONObject projectInfo = new JSONObject();
        projectInfo.put("project_no", (Object)projectNo);
        parameter.put("algorithm_type", (Object)2);
        parameter.put("calculation_method", (Object)1);
        projectInfoArr.add((Object)projectInfo);
        String serviceName = "bm.pisc.project.critical.path.get";
        String serviceProd = "BM-PISC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"task_info"});
        List taskInfoList = (List)response.getStdData().getParameter().get("task_info");
        if (taskInfoList == null || taskInfoList.isEmpty()) {
            return taskNoList;
        }
        taskNoList = taskInfoList.stream().map(taskInfo -> (String)taskInfo.get("task_no")).collect(Collectors.toList());
        return taskNoList;
    }

    public List<String> getTaskPiscInfo(String iamUserToken, String projectNo, String taskNo, String tenantId, String locale) {
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("project_no", projectNo);
        parameter.put("task_info", Collections.singletonList(map));
        parameter.put("query_condition", (Object)"D1M1");
        String serviceName = "bm.pisc.task.get";
        String serviceProd = "BM-PISC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"task_info"});
        List taskInfoAllList = (List)response.getStdData().getParameter().get("task_info");
        List taskInfoList = taskInfoAllList.stream().filter(a -> a.get("task_no").toString().equalsIgnoreCase(taskNo)).collect(Collectors.toList());
        List beforeTaskNoList = taskInfoList.stream().map(stringObjectMap -> (List)stringObjectMap.get("task_dependency_info")).filter(CollUtil::isNotEmpty).flatMap(Collection::stream).map(objectMap -> objectMap.get("before_task_no").toString()).collect(Collectors.toList());
        ArrayList<String> taskStatusList = new ArrayList<String>(beforeTaskNoList.size());
        taskInfoAllList.forEach(stringObjectMap -> beforeTaskNoList.stream().filter(beforeTaskNo -> beforeTaskNo.equalsIgnoreCase(stringObjectMap.get("task_no").toString())).map(beforeTaskNo -> stringObjectMap.get("task_status").toString()).forEach(taskStatusList::add));
        return taskStatusList;
    }

    public List<PccProjectTaskInfo> getTaskInfo(String iamUserToken, String projectNo, String taskNo, String tenantId, String locale) {
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("project_no", projectNo);
        map.put("task_no", taskNo);
        parameter.put("task_info", Collections.singletonList(map));
        parameter.put("query_condition", (Object)"M1D2");
        String serviceName = "bm.pisc.task.get";
        String serviceProd = "BM-PISC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"task_info"});
        return ModuleUtils.listMapToListT((List)((List)response.getStdData().getParameter().get("task_info")), PccProjectTaskInfo.class);
    }

    public List<Map<String, Object>> getHumanResourceLoadByDateId(List<String> itemInfo, String dateId, String tenantId, String locale, String iamUserToken) {
        ArrayList personnelInfo;
        HashMap<String, Object> items;
        ArrayList humanResourceLoadRequestList;
        ArrayList employeeInfoList = new ArrayList();
        ArrayList<Map<String, Object>> humanResourceLoadList = new ArrayList<Map<String, Object>>();
        for (String item : itemInfo) {
            ArrayList projectMemberInfoRequestList = new ArrayList();
            HashMap<String, String> items2 = new HashMap<String, String>(1);
            items2.put("project_no", item);
            projectMemberInfoRequestList.add(items2);
            employeeInfoList.addAll(this.getEmployeeInfoByProjectNo(projectMemberInfoRequestList, iamUserToken, tenantId, locale));
        }
        if (employeeInfoList != null && employeeInfoList.size() > 0) {
            humanResourceLoadRequestList = new ArrayList();
            items = new HashMap<String, Object>(1);
            items.put("datetime_s", DateTimeUtil.getTodayTimeUseDefaultPattern());
            if (FEATURE_WEEK.equals(dateId)) {
                items.put("datetime_e", DateTimeUtil.getSevthDate(null));
            } else if (FEATURE_MONTH.equals(dateId)) {
                items.put("datetime_e", DateTimeUtil.getOneMonthDate(null));
            } else {
                items.put("datetime_e", DateTimeUtil.getSevthDate(null));
            }
            personnelInfo = new ArrayList(employeeInfoList.size());
            for (Map employeeInfo : employeeInfoList) {
                HashMap<String, String> personnelNo = new HashMap<String, String>();
                personnelNo.put("personnel_no", (String)employeeInfo.get("employee_no"));
                personnelInfo.add(personnelNo);
            }
        } else {
            return Collections.emptyList();
        }
        items.put("personnel_info", personnelInfo);
        humanResourceLoadRequestList.add(items);
        humanResourceLoadList.addAll(this.getHumanResourceLoad(humanResourceLoadRequestList, iamUserToken, tenantId, locale));
        return humanResourceLoadList;
    }

    public List<Map<String, Object>> getProjectWoProductionInfoProcess(String eocSiteId, String eocCompanyId, List<PccProjectTaskInfo> taskInfoList, String iamUserToken, String tenantId, String locale, String processStatus) {
        String mKey = "doc_info";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        JSONArray queryConditionArr = new JSONArray();
        for (PccProjectTaskInfo taskInfo : taskInfoList) {
            Map taskInfoMap = (Map)JsonUtil.objectToJavaObject((Object)taskInfo, JSONObject.class);
            taskInfoMap.put("project_no", taskInfo.getProjectNo());
            taskInfoMap.put("task_no", taskInfo.getTaskNo());
            taskInfoMap.put("display_project_no", taskInfo.getDisplayProjectNo());
            taskInfoMap.put("process_status", processStatus);
            queryConditionArr.add((Object)taskInfo);
        }
        parameter.put(mKey, (Object)queryConditionArr);
        parameter.put("enterprise_no", (Object)eocCompanyId);
        parameter.put("site_no", (Object)eocSiteId);
        String serviceProd = "PCC";
        String serviceName = "project.wo.production.info.process";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{mKey});
        return (List)response.getStdData().getParameter().get(mKey);
    }

    public List<Map<String, Object>> getProjectDocInfoProcess(String eocSiteId, String eocCompanyId, List<PccProjectTaskInfo> taskInfoList, String iamUserToken, String tenantId, String locale, String processStatus) {
        String mKey = "doc_info";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        JSONArray queryConditionArr = new JSONArray();
        for (PccProjectTaskInfo taskInfo : taskInfoList) {
            Map taskInfoMap = (Map)JsonUtil.objectToJavaObject((Object)taskInfo, JSONObject.class);
            taskInfoMap.put("process_status", processStatus);
            queryConditionArr.add((Object)taskInfoMap);
        }
        parameter.put(mKey, (Object)queryConditionArr);
        parameter.put("enterprise_no", (Object)eocCompanyId);
        parameter.put("site_no", (Object)eocSiteId);
        String serviceProd = "PCC";
        String serviceName = "project.doc.info.process";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{mKey});
        return (List)response.getStdData().getParameter().get(mKey);
    }

    public List<Map<String, Object>> getTaskInfo(String eocSiteId, String eocCompanyId, List<PccProjectTaskInfo> pccProjectTaskInfoList, String iamUserToken, String tenantId, String locale, String processStatus) {
        String mKey = "project_info";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        JSONArray queryConditionArr = new JSONArray();
        for (PccProjectTaskInfo taskInfo : pccProjectTaskInfoList) {
            Map taskInfoMap = (Map)JsonUtil.objectToJavaObject((Object)taskInfo, JSONObject.class);
            taskInfoMap.put("control_mode", FEATURE_MONTH);
            taskInfoMap.put("process_status", processStatus);
            queryConditionArr.add((Object)taskInfoMap);
        }
        parameter.put(mKey, (Object)queryConditionArr);
        parameter.put("enterprise_no", (Object)eocCompanyId);
        parameter.put("site_no", (Object)eocSiteId);
        String serviceProd = "PCC";
        String serviceName = "task.info.get";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{mKey});
        return (List)response.getStdData().getParameter().get(mKey);
    }

    public List<Map<String, Object>> getBmPiscAttachmentJoinRelation(String eocSiteId, String eocCompanyId, String iamUserToken, String tenantId, String locale, String processStatus, String projectNo, String taskNo) {
        String mKey = "task_info";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        JSONArray queryConditionArr = new JSONArray();
        JSONObject taskInfo = new JSONObject();
        taskInfo.put("project_no", (Object)projectNo);
        taskInfo.put("task_no", (Object)taskNo);
        taskInfo.put("process_status", (Object)processStatus);
        queryConditionArr.add((Object)taskInfo);
        parameter.put(mKey, (Object)queryConditionArr);
        parameter.put("query_condition", (Object)"ALL");
        parameter.put("enterprise_no", (Object)eocCompanyId);
        parameter.put("site_no", (Object)eocSiteId);
        String serviceProd = "BM-PISC";
        String serviceName = "bm.pisc.attachment.join.relation.get";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{mKey});
        return (List)response.getStdData().getParameter().get(mKey);
    }

    public List<Map<String, Object>> getWorkItemData(String eocSiteId, String eocCompanyId, List<PccProjectTaskInfo> taskInfoList, String iamUserToken, String tenantId, String locale, String processStatus) {
        String serviceProd = "PLM";
        String serviceName = "work.item.data.get";
        String mKey = "doc_info";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        JSONArray docInfoArray = new JSONArray();
        for (PccProjectTaskInfo taskInfo : taskInfoList) {
            HashMap<String, String> docInfo = new HashMap<String, String>(4);
            docInfo.put("project_no", taskInfo.getProjectNo());
            docInfo.put("task_no", taskInfo.getTaskNo());
            docInfo.put("process_status", processStatus);
            docInfo.put("display_project_no", taskInfo.getDisplayProjectNo());
            docInfoArray.add(docInfo);
        }
        parameter.put(mKey, (Object)docInfoArray);
        parameter.put("enterprise_no", (Object)eocCompanyId);
        parameter.put("site_no", (Object)eocSiteId);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{mKey});
        return (List)response.getStdData().getParameter().get(mKey);
    }

    public List<Map<String, Object>> getProjectTaskCompleteRateData(String eocSiteId, String eocCompanyId, List<PccProjectTaskInfo> taskInfoList, String iamUserToken, String tenantId, String locale) {
        String serviceProd = "PLM";
        String serviceName = "project.task.complete.rate.data.get";
        String mKey = "doc_info";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        JSONArray docInfoArray = new JSONArray();
        for (PccProjectTaskInfo taskInfo : taskInfoList) {
            HashMap<String, String> docInfo = new HashMap<String, String>(4);
            docInfo.put("project_no", taskInfo.getProjectNo());
            docInfo.put("task_no", taskInfo.getTaskNo());
            docInfoArray.add(docInfo);
        }
        parameter.put(mKey, (Object)docInfoArray);
        parameter.put("enterprise_no", (Object)eocCompanyId);
        parameter.put("site_no", (Object)eocSiteId);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{mKey});
        return (List)response.getStdData().getParameter().get(mKey);
    }

    public String getEocSiteIdByPurchaseNo(String purchaseNo, String companyId, String iamUserToken, String tenantId, String locale) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", companyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        JSONArray purchaseDataArr = new JSONArray();
        JSONObject purchaseData = new JSONObject();
        purchaseData.put("purchase_no", (Object)purchaseNo);
        purchaseData.put("eoc_company_id", (Object)companyId);
        purchaseDataArr.add((Object)purchaseData);
        parameter.put("purchase_data", (Object)purchaseDataArr);
        String serviceName = "bm.posc.purchase.order.get";
        String serviceProd = "BM-POSC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"purchase_data"});
        Map parameterMap = response.getStdData().getParameter();
        List purchaseDataList = (List)parameterMap.get("purchase_data");
        if (purchaseDataList == null || purchaseDataList.isEmpty()) {
            return "";
        }
        return (String)((Map)purchaseDataList.get(0)).get("eoc_site_id");
    }

    public List<DigiwinItemCategory> getCategoryByItemNo(String itemNo, String companyId, String iamUserToken, String tenantId, String locale) {
        ArrayList<DigiwinItemCategory> list = new ArrayList<DigiwinItemCategory>();
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", companyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        JSONArray itemDataArr = new JSONArray();
        JSONObject itemData = new JSONObject();
        itemData.put("item_no", (Object)itemNo);
        itemDataArr.add((Object)itemData);
        parameter.put("item_data", (Object)itemDataArr);
        String serviceName = "bm.iisc.item.exclusive.class.get";
        String serviceProd = "BM-IISC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"item_data"});
        List itemDataList = (List)response.getStdData().getParameter().get("item_data");
        if (itemDataList == null || itemDataList.isEmpty()) {
            return list;
        }
        List itemCategoryList = (List)((Map)itemDataList.get(0)).get("item_category");
        if (itemCategoryList == null || itemCategoryList.isEmpty()) {
            return list;
        }
        return itemCategoryList.stream().map(itemCategory -> (DigiwinItemCategory)JsonUtil.objectToJavaObject((Object)itemCategory, DigiwinItemCategory.class)).collect(Collectors.toList());
    }

    public List<DigiwinInventoryData> getInventoryByCategory(String eocSiteId, List<DigiwinItemCategory> itemCategoryList, String companyId, String iamUserToken, String tenantId, String locale) {
        ArrayList<DigiwinInventoryData> inventoryDataList = new ArrayList<DigiwinInventoryData>();
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", companyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        JSONArray queryConditionArr = new JSONArray();
        for (DigiwinItemCategory itemCategory : itemCategoryList) {
            JSONObject queryCondition = new JSONObject();
            queryCondition.put("classification_method_no", (Object)itemCategory.getClassificationMethodNo());
            queryCondition.put("category_no", (Object)itemCategory.getCategoryNo());
            queryCondition.put("eoc_site_id", (Object)eocSiteId);
            queryConditionArr.add((Object)queryCondition);
        }
        parameter.put("query_condition", (Object)queryConditionArr);
        parameter.put("query_type", (Object)FEATURE_MONTH);
        String serviceName = "bm.iisc.item.category.inventory.get";
        String serviceProd = "BM-IISC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"inventory_data"});
        List inventoryDataObjList = (List)response.getStdData().getParameter().get("inventory_data");
        if (inventoryDataObjList == null || inventoryDataObjList.isEmpty()) {
            return inventoryDataList;
        }
        return inventoryDataObjList.stream().map(o -> (DigiwinInventoryData)JsonUtil.objectToJavaObject((Object)o, DigiwinInventoryData.class)).collect(Collectors.toList());
    }

    public List<DigiwinOrderPriceData> getLatelyPriceListByItemCode(List<String> itemCodeList, String iamUserToken, String tenantId, String locale) {
        ArrayList<DigiwinOrderPriceData> orderPriceDataList = new ArrayList<DigiwinOrderPriceData>();
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        ArrayList itemData = new ArrayList();
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return orderPriceDataList;
        }
        for (String itemCode : itemCodeList) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("item_code", itemCode);
            item.put("item_feature_code", "");
            itemData.add(item);
        }
        parameter.put("item_data", itemData);
        parameter.put("enterprise_no", "");
        parameter.put("site_no", "");
        parameter.put("supplier_center_code", "");
        String serviceName = "ddsm.zicd.po.order.lately.price.get";
        String serviceProd = "E10";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"order_price_data"});
        List orderPriceDataObjList = (List)response.getStdData().getParameter().get("order_price_data");
        if (orderPriceDataObjList == null || orderPriceDataObjList.isEmpty()) {
            return orderPriceDataList;
        }
        return orderPriceDataObjList.stream().map(o -> (DigiwinOrderPriceData)JsonUtil.objectToJavaObject((Object)o, DigiwinOrderPriceData.class)).collect(Collectors.toList());
    }

    public List<Map<String, Object>> getCustomerInfoByNo(List<String> customerNos, String iamUserToken, String tenantId, String locale) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        ArrayList<DigiwinCustomerInfoRequest> digiwinCustomerInfoRequests = new ArrayList<DigiwinCustomerInfoRequest>(customerNos.size());
        for (String customerNo : customerNos) {
            DigiwinCustomerInfoRequest customerInfoRequest = new DigiwinCustomerInfoRequest();
            customerInfoRequest.setCustomerNo(customerNo);
            digiwinCustomerInfoRequests.add(customerInfoRequest);
        }
        JSONObject parameter = new JSONObject();
        parameter.put("customer_info", digiwinCustomerInfoRequests);
        String serviceName = "customer.application.info.get";
        String serviceProd = "POM";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"customer_info"});
        return (List)response.getStdData().getParameter().get("customer_info");
    }

    public List<Map<String, Object>> getReceivableByNo(List<String> customerNos, String iamUserToken, String tenantId, String locale, String eocCompanyId) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> eocmap = new HashMap<String, String>(1);
        eocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(eocmap));
        ArrayList<DigiwinReceivableRequest> digiwinReceivableRequests = new ArrayList<DigiwinReceivableRequest>(customerNos.size());
        for (String customerNo : customerNos) {
            DigiwinReceivableRequest digiwinReceivableRequest = new DigiwinReceivableRequest();
            digiwinReceivableRequest.setCustomerNo(customerNo);
            digiwinReceivableRequest.setEocCompanyId(eocCompanyId);
            digiwinReceivableRequests.add(digiwinReceivableRequest);
        }
        JSONObject parameter = new JSONObject();
        parameter.put("ar_data", digiwinReceivableRequests);
        String serviceName = "bm.arsc.account.receivable.customer.detail.get";
        String serviceProd = "BM-ARSC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"ar_data"});
        return (List)response.getStdData().getParameter().get("ar_data");
    }

    public Map<String, Object> exceptReportVerifyInfoProcess(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String serviceProd = "APC";
        String serviceName = "except.report.verify.info.process";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        if (!CollectionUtils.isEmpty(params)) {
            HashMap<String, String> digiEocmap = new HashMap<String, String>();
            digiEocmap.put("eoc_company_id", StringUtil.valueOf((Object)params.get("eoc_company_id")));
            digiEocmap.put("eoc_site_id", StringUtil.valueOf((Object)params.get("eoc_site_id")));
            headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        }
        JSONObject parameter = new JSONObject();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(1);
        data.add(params);
        parameter.put("except_report_data", data);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (response == null) {
            throw new ServiceException("Service " + serviceName + " call returned NONE Response!");
        }
        if (StringUtils.hasLength((String)response.getStdDataExecutionDescription())) {
            return (Map)JsonUtil.objectToJavaObject((Object)response.getStdData().getExecution(), Map.class);
        }
        if (!response.isRespOk("wo_op_report_data").booleanValue()) {
            throw new ServiceException(response.getResponseFullDescriptionMsgWhenNotOK(serviceProd, serviceName, parameterBodyJson));
        }
        return response.getStdData().getParameter();
    }

    public Boolean exceptReportInfoProcess(String iamUserToken, String tenantId, String locale, Map<String, Object> params, List<Map<String, Object>> woOpReportData) {
        String serviceProd = "APC";
        String serviceName = "except.report.info.process";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        if (!CollectionUtils.isEmpty(params)) {
            HashMap<String, String> digiEocmap = new HashMap<String, String>();
            digiEocmap.put("eoc_company_id", StringUtil.valueOf((Object)params.get("eoc_company_id")));
            digiEocmap.put("eoc_site_id", StringUtil.valueOf((Object)params.get("eoc_site_id")));
            headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        }
        JSONObject parameter = new JSONObject();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(1);
        data.add(params);
        parameter.put("except_report_data", data);
        parameter.put("wo_op_report_data", woOpReportData);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return true;
    }

    public Map<String, Object> getAsnHeader(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "delivery.head.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"delivery_head"});
        return (Map)response.getStdData().getParameter().get("delivery_head");
    }

    public List<Map<String, Object>> getDriverVehicle(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        String serviceName = "driver.vehicle.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"vehicle_list"});
        return (List)response.getStdData().getParameter().get("vehicle_list");
    }

    public Boolean getElectronicFenceShowFlag(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        String serviceName = "electronic.fence.show.flag.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"electronic_fence_show_flag"});
        return (Boolean)response.getStdData().getParameter().get("electronic_fence_show_flag");
    }

    public List<Map<String, Object>> getElectronicFenceFactoryList(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        String serviceName = "electronic.fence.list.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"electronic_fence_factory_list"});
        return (List)response.getStdData().getParameter().get("electronic_fence_factory_list");
    }

    public List<Map<String, Object>> getDriverVehicleDetail(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String parameterBodyJson;
        String serviceName;
        String serviceProd;
        ResponseModel responseModel;
        DigiwinEspResponse response;
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        if (!(response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)(responseModel = this.invokeRestSync(tenantId, locale, serviceProd = "srm-loading", serviceName = "driver.vehicle.detail.get", headers, parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter))).getBodyJsonString(), DigiwinEspResponse.class)).isRespOk().booleanValue()) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("vehicle_list");
    }

    public Boolean addDriverVehicle(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String parameterBodyJson;
        String serviceName;
        String serviceProd;
        ResponseModel responseModel;
        DigiwinEspResponse response;
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        if (!(response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)(responseModel = this.invokeRestSync(tenantId, locale, serviceProd = "srm-loading", serviceName = "driver.vehicle.create", headers, parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter))).getBodyJsonString(), DigiwinEspResponse.class)).isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    public Boolean updateDriverVehicle(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String parameterBodyJson;
        String serviceName;
        String serviceProd;
        ResponseModel responseModel;
        DigiwinEspResponse response;
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        if (!(response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)(responseModel = this.invokeRestSync(tenantId, locale, serviceProd = "srm-loading", serviceName = "driver.vehicle.update", headers, parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter))).getBodyJsonString(), DigiwinEspResponse.class)).isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    public Boolean saveElectronicFence(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String parameterBodyJson;
        String serviceName;
        String serviceProd;
        ResponseModel responseModel;
        DigiwinEspResponse response;
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        if (!(response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)(responseModel = this.invokeRestSync(tenantId, locale, serviceProd = "srm-loading", serviceName = "electronic.fence.process", headers, parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter))).getBodyJsonString(), DigiwinEspResponse.class)).isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    public Boolean deleteDriverVehicle(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String parameterBodyJson;
        String serviceName;
        String serviceProd;
        ResponseModel responseModel;
        DigiwinEspResponse response;
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        if (!(response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)(responseModel = this.invokeRestSync(tenantId, locale, serviceProd = "srm-loading", serviceName = "driver.vehicle.delete", headers, parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter))).getBodyJsonString(), DigiwinEspResponse.class)).isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    public Map<String, Object> getAsnBody(String iamUserToken, String tenantId, String locale, Integer page_no, Integer page_size, Boolean use_has_next, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("page_no", (Object)page_no);
        parameter.put("page_size", (Object)page_size);
        parameter.put("use_has_next", (Object)use_has_next);
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        String serviceName = "delivery.detail.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"delivery_detail"});
        HashMap<String, Object> deliveryDetailInfo = new HashMap<String, Object>();
        deliveryDetailInfo.put("total_results", response.getStdData().getParameter().get("total_results"));
        deliveryDetailInfo.put("has_next", response.getStdData().getParameter().get("has_next"));
        deliveryDetailInfo.put("delivery_detail", response.getStdData().getParameter().get("delivery_detail"));
        return deliveryDetailInfo;
    }

    public List<Map<String, Object>> getVehicleInfo(String iamUserToken, String tenantId, String locale, String taskNo, Boolean isLoadCar, String keyword) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("task_no", taskNo);
        if (StringUtils.hasLength((String)keyword)) {
            params.put("vehicle_keyword", keyword);
        }
        params.put("is_filter_load_car", isLoadCar);
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        String serviceName = "delivery.vehicle.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"vehicle_info"});
        return (List)response.getStdData().getParameter().get("vehicle_info");
    }

    public DigiwinEspStdData driverCurrentVehicleUpdate(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        String serviceName = "driver.current.vehicle.update";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return response.getStdData();
    }

    public DigiwinEspStdData ztbSubmit(String iamUserToken, String tenantId, String locale, String taskNo, String status) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        JSONObject param = new JSONObject();
        param.put("task_no", (Object)taskNo);
        param.put("status", (Object)status);
        parameter.put("parameter", (Object)param);
        String serviceName = "delivery.task.status.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return response.getStdData();
    }

    public DigiwinEspStdData ztbLoadingSubmit(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> cargoInformation, Map<String, Object> vehicleInfo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("cargo_information", cargoInformation);
        parameter.put("vehicle_info", vehicleInfo);
        String serviceName = "cargo.loading.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return response.getStdData();
    }

    public DigiwinEspStdData ztbJsonTenant(String iamUserToken, String locale, String taskNo, String userId) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        JSONObject param = new JSONObject();
        param.put("task_no", (Object)taskNo);
        param.put("user_id", (Object)userId);
        parameter.put("parameter", (Object)param);
        String serviceName = "driver.join.tenant.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync("", locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return response.getStdData();
    }

    public List<Map<String, Object>> getProjectsByIDs(String iamUserToken, String tenantId, String locale, List<String> projectIds) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (String projectId : projectIds) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("project_no", (Object)projectId);
            jsonArray.add((Object)jsonObject);
        }
        parameter.put("project_info", (Object)jsonArray);
        String serviceName = "bm.pisc.project.get";
        String serviceProd = "BM-PISC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"project_info"});
        return (List)response.getStdData().getParameter().get("project_info");
    }

    public List<Map<String, Object>> getAbnormalReviewInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> docInfos) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("doc_info", docInfos);
        String serviceName = "project.abnormal.review.info.get";
        String serviceProd = "PCC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"doc_info"});
        return (List)response.getStdData().getParameter().get("doc_info");
    }

    public List<DigiwinEspEnumerateResponse> getEnumerateInfo(String iamUserToken, String tenantId, String locale, String schema) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        JSONObject param = new JSONObject();
        param.put("enumerate_type", (Object)schema);
        parameter.put("parameter", (Object)param);
        String serviceName = "enumerate.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"enumerate_list"});
        return ModuleUtils.listMapToListObject((List)((List)response.getStdData().getParameter().get("enumerate_list")), DigiwinEspEnumerateResponse.class);
    }

    public DigiwinEspStdData cargoDepart(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "cargo.depart.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return response.getStdData();
    }

    public Map<String, Object> getTransportVehicleInfo(String iamUserToken, String tenantId, String locale, String transportNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transport_no", transportNo);
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        String serviceName = "transport.vehicle.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"vehicle_info"});
        return (Map)response.getStdData().getParameter().get("vehicle_info");
    }

    public Map<String, Object> getTransportEntryArrangement(String iamUserToken, String tenantId, String locale, String transportNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transport_no", transportNo);
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        String serviceName = "transport.entry.arrangement.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"entry_arrangement_info"});
        return (Map)response.getStdData().getParameter().get("entry_arrangement_info");
    }

    public DigiwinTransportResponse getTransportMainInfo(String iamUserToken, String tenantId, String locale, String transportNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);
        String serviceName = "transport.main.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"transport_main_info"});
        return (DigiwinTransportResponse)JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("transport_main_info"), DigiwinTransportResponse.class);
    }

    public Map<String, Object> getTransportMainInfoResponseMap(String iamUserToken, String tenantId, String locale, String transportNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);
        String serviceName = "transport.main.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"transport_main_info"});
        return (Map)response.getStdData().getParameter().get("transport_main_info");
    }

    public DigiwinEspStdData scheduleInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "schedule.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return response.getStdData();
    }

    public DigiwinEspStdData completeReceiptPreparationInfo(String iamUserToken, String tenantId, String locale, String transportNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);
        String serviceName = "complete.receipt.preparation.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return response.getStdData();
    }

    public DigiwinEspStdData receiptPreparationInfo(String iamUserToken, String tenantId, String locale, String transportNo, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);
        String serviceName = "receipt.preparation.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return response.getStdData();
    }

    public DigiwinEspStdData transportComingSoonProcess(String iamUserToken, String tenantId, String locale, String transportNo, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);
        String serviceName = "transport.coming.soon.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return response.getStdData();
    }

    public List<ZtbUserInfo> getUserInfo(String iamUserToken, String tenantId, String locale, String param, Integer pageNo, Integer pageSize, Map<String, String> para) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.putAll(para);
        params.put("query_rule", param);
        parameter.put("parameter", params);
        parameter.put("page_no", (Object)pageNo);
        parameter.put("page_size", (Object)pageSize);
        String serviceName = "unloader.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"user_list"});
        return ModuleUtils.listMapToListObject((List)((List)response.getStdData().getParameter().get("user_list")), ZtbUserInfo.class);
    }

    public Map<String, Object> getTransportCargoInfo(String iamUserToken, String tenantId, String locale, String transportNo, Integer pageNo, Integer pageSize, Boolean useHasNext) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("page_no", (Object)pageNo);
        parameter.put("page_size", (Object)pageSize);
        parameter.put("use_has_next", (Object)useHasNext);
        JSONObject transportNoObject = new JSONObject();
        transportNoObject.put("transport_no", (Object)transportNo);
        parameter.put("parameter", (Object)transportNoObject);
        String serviceName = "transport.cargo.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"cargo_information"});
        HashMap<String, Object> cargoInformation = new HashMap<String, Object>(3);
        cargoInformation.put("total_results", response.getStdData().getParameter().get("total_results"));
        cargoInformation.put("has_next", response.getStdData().getParameter().get("has_next"));
        cargoInformation.put("cargo_information", response.getStdData().getParameter().get("cargo_information"));
        return cargoInformation;
    }

    public DigiwinEspStdData confirmCargoReceiptInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "cargo.receipt.confirm.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return response.getStdData();
    }

    public List<AppointmentDeliveryDate> getAppointmentDeliveryDate(String iamUserToken, String tenantId, String locale, String deliveryNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("delivery_no", deliveryNo);
        parameter.put("parameter", params);
        String serviceName = "appointment.delivery.date.data.get";
        String serviceProd = "ILC-SRM";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"can_appointment_delivery_date"});
        return ModuleUtils.listMapToListObject((List)((List)response.getStdData().getParameter().get("can_appointment_delivery_date")), AppointmentDeliveryDate.class);
    }

    public List<UseAppointmentDeliveryPlatform> getAppointmentPlatformInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "appointment.platform.data.get";
        String serviceProd = "ILC-SRM";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"can_appointment_delivery_platform"});
        return ModuleUtils.listMapToListObject((List)((List)response.getStdData().getParameter().get("can_appointment_delivery_platform")), UseAppointmentDeliveryPlatform.class);
    }

    public List<CanAppointmentDeliveryTimeSlot> getAppointmentDeliveryTimeSlot(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "appointment.delivery.time.slot.data.get";
        String serviceProd = "ILC-SRM";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"can_appointment_delivery_time_slot"});
        return ModuleUtils.listMapToListObject((List)((List)response.getStdData().getParameter().get("can_appointment_delivery_time_slot")), CanAppointmentDeliveryTimeSlot.class);
    }

    public List<Map<String, Object>> getShippingSchedule(String iamUserToken, String tenantId, String locale, String transportNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);
        String serviceName = "delivery.schedule.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"vehicle_appointment_delivery_list"});
        return (List)JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("vehicle_appointment_delivery_list"), List.class);
    }

    public DigiwinEspStdData abnormalAlertCheck(String iamUserToken, String tenantId, String locale, String transportNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);
        String serviceName = "abnormal.alert.check";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return response.getStdData();
    }

    public DigiwinEspStdData validArrival(String iamUserToken, String tenantId, String locale, String taskNo, String transportNo, ApiRequestPosition position) {
        String parameterBodyJson;
        String serviceName;
        String serviceProd;
        ResponseModel responseModel;
        DigiwinEspResponse response;
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("transport_no", transportNo);
        params.put("task_no", taskNo);
        parameter.put("parameter", params);
        if (position != null) {
            params.put("longitude", position.getLongitude());
            params.put("latitude", position.getLatitude());
            params.put("province", position.getProvince());
            params.put("city", position.getCity());
            params.put("area", position.getArea());
            params.put("complete_address", position.getCompleteAddress());
            params.put("detail_address", position.getDetailAddress());
        }
        if (!(response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)(responseModel = this.invokeRestSync(tenantId, locale, serviceProd = "srm-loading", serviceName = "transport.arrival.valid.process", headers, parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter))).getBodyJsonString(), DigiwinEspResponse.class)).isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData();
    }

    public DigiwinEspStdData cargoArrival(String arrivalType, String iamUserToken, String tenantId, String locale, String transportNo, String receiverName, String receiverMobile, ApiRequestPosition position) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("transport_no", transportNo);
        params.put("arrival_type", arrivalType);
        params.put("receiver_name", receiverName);
        params.put("receiver_mobile", receiverMobile);
        if (position != null) {
            params.put("longitude", position.getLongitude());
            params.put("latitude", position.getLatitude());
            params.put("province", position.getProvince());
            params.put("city", position.getCity());
            params.put("area", position.getArea());
            params.put("complete_address", position.getCompleteAddress());
            params.put("detail_address", position.getDetailAddress());
        }
        parameter.put("parameter", params);
        String serviceName = "cargo.arrival.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData();
    }

    public List<Map<String, Object>> getTransportDriver(String iamUserToken, String tenantId, String locale, String transportNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);
        String serviceName = "old.driver.transport.transshipment.vehicle.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"vehicle_info"});
        return (List)JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("vehicle_info"), List.class);
    }

    public DigiwinEspStdData oldDriverProcess(String iamUserToken, String tenantId, String locale, String transportNo, String vehicleInfoId, ApiRequestPosition position) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("transport_no", transportNo);
        params.put("vehicle_info_id", vehicleInfoId);
        if (position != null) {
            params.put("longitude", position.getLongitude());
            params.put("latitude", position.getLatitude());
            params.put("province", position.getProvince());
            params.put("city", position.getCity());
            params.put("area", position.getArea());
            params.put("complete_address", position.getCompleteAddress());
            params.put("detail_address", position.getDetailAddress());
        }
        parameter.put("parameter", params);
        String serviceName = "old.driver.transport.transshipment.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return response.getStdData();
    }

    public DigiwinEspStdData commitDriverMsg(String iamUserToken, String tenantId, String locale, Map<String, Object> params, ApiRequestPosition position) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (position != null) {
            params.put("longitude", position.getLongitude());
            params.put("latitude", position.getLatitude());
            params.put("province", position.getProvince());
            params.put("city", position.getCity());
            params.put("area", position.getArea());
            params.put("complete_address", position.getCompleteAddress());
            params.put("detail_address", position.getDetailAddress());
        }
        parameter.put("parameter", params);
        String serviceName = "transport.driver.msg.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return response.getStdData();
    }

    public DigiwinEspStdData newDriverProcess(String iamUserToken, String tenantId, String locale, String transportNo, Object vehicleInfoId) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("transport_no", transportNo);
        params.put("vehicle_info_id", vehicleInfoId);
        parameter.put("parameter", params);
        String serviceName = "new.driver.transport.transshipment.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
        return response.getStdData();
    }

    public List<TransportList> getTaskTransportPositionInfo(String iamUserToken, String tenantId, String locale, String taskNo, Boolean isArrival) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("task_no", taskNo);
        params.put("is_arrival", isArrival);
        parameter.put("parameter", params);
        parameter.put("use_has_next", (Object)false);
        String serviceName = "task.transport.position.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"transport_list"});
        return ModuleUtils.listMapToListObject((List)((List)response.getStdData().getParameter().get("transport_list")), TransportList.class);
    }

    public List<Map<String, Object>> woOpReportCheckInInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        String serviceProd = "APC";
        String serviceName = "wo.op.report.check.in.info.process";
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("wo_op_report_data", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"wo_op_report_data"});
        return (List)response.getStdData().getParameter().get("wo_op_report_data");
    }

    public Boolean isDeptDirector(String iamUserToken, String tenantId, String locale, String eocCompanyId, String eocSiteId) {
        List list = this.personnelDutyGet(iamUserToken, tenantId, locale, eocCompanyId, eocSiteId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Boolean.FALSE;
        }
        if ("director".equals(((PersonnelDutyResp)list.get(0)).getDutyNo())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean isDeptDirector(List<PersonnelDutyResp> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Boolean.FALSE;
        }
        if ("director".equals(list.get(0).getDutyNo())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public List<PersonnelDutyResp> personnelDutyGet(String iamUserToken, String tenantId, String locale, String eocCompanyId, String eocSiteId) {
        String serviceProd = "APC";
        String serviceName = "personnel.duty.get";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        digiEocmap.put("eoc_site_id", eocSiteId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, "APC", "personnel.duty.get", headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, "APC", "personnel.duty.get", parameterBodyJson, new String[]{"personnel_info"});
        return ModuleUtils.listMapToListObject((List)((List)response.getStdData().getParameter().get("personnel_info")), PersonnelDutyResp.class);
    }

    public List<Map<String, Object>> currentTeamPersonnelInfoGet(String iamUserToken, String tenantId, String locale, String eocCompanyId, String eocSiteId) {
        String serviceProd = "APC";
        String serviceName = "current.team.personnel.info.get";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        digiEocmap.put("eoc_site_id", eocSiteId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, "APC", "current.team.personnel.info.get", headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, "APC", "current.team.personnel.info.get", parameterBodyJson, new String[]{"team_personnel_list"});
        return (List)response.getStdData().getParameter().get("team_personnel_list");
    }

    public List<Map<String, Object>> teamPersonnelInfoGet(String iamUserToken, String tenantId, String locale, Map<String, Object> params, Map<String, Object> headerParams) {
        String serviceProd = "APC";
        String serviceName = "current.team.personnel.info.get";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(headerParams));
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, "APC", "current.team.personnel.info.get", headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, "APC", "current.team.personnel.info.get", parameterBodyJson, new String[]{"team_personnel_list"});
        return (List)response.getStdData().getParameter().get("team_personnel_list");
    }

    public List<ZtbArea> getAreaList(String iamUserToken, String tenantId, String locale, String parentId) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        JSONObject parent = new JSONObject();
        parent.put("parent_id", (Object)parentId);
        parameter.put("parameter", (Object)parent);
        String serviceName = "area.list.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"areaList"});
        return ModuleUtils.listMapToListObject((List)((List)JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("areaList"), List.class)), ZtbArea.class);
    }

    public List<ZtbUserAddress> getuserAddressList(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "user.address.list.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"user_address_list"});
        return ModuleUtils.listMapToListObject((List)((List)JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("user_address_list"), List.class)), ZtbUserAddress.class);
    }

    public Boolean createUserAddress(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "user.address.create";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    public Boolean deleteUserAddress(String iamUserToken, String tenantId, String locale, String addressId) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("address_id", addressId);
        parameter.put("parameter", params);
        String serviceName = "user.address.delete";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    public Boolean updateUserAddress(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "user.address.update";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    public Map<String, Object> getUserAddress(String iamUserToken, String tenantId, String locale, String addressId) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("address_id", addressId);
        parameter.put("parameter", params);
        String serviceName = "user.address.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (response == null || response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("user_address") == null) {
            throw new ServiceException(this.localeService.getLanguageValue(locale, "\u6682\u672a\u627e\u5230\u5730\u5740\u4fe1\u606f"));
        }
        return (Map)JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("user_address"), Map.class);
    }

    public ZtbDeliveryLoadingCount getDeliveryLoadingCount(String iamUserToken, String tenantId, String locale, String taskNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("task_no", taskNo);
        parameter.put("parameter", params);
        String serviceName = "delivery.loading.count.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        return (ZtbDeliveryLoadingCount)JsonUtil.objectToJavaObject((Object)response.getStdData().getParameter(), ZtbDeliveryLoadingCount.class);
    }

    public List<ZtbCargoUnloading> getDeliveryUnloadingList(String iamUserToken, String tenantId, String locale, String taskNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("task_no", taskNo);
        parameter.put("parameter", params);
        String serviceName = "delivery.unloading.list.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"cargo_unloading_list"});
        return ModuleUtils.listMapToListObject((List)((List)JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("cargo_unloading_list"), List.class)), ZtbCargoUnloading.class);
    }

    public List<ZTBDriverVehicle> getDeliveryLoadedCarList(String iamUserToken, String tenantId, String locale, String taskNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("task_no", taskNo);
        parameter.put("parameter", params);
        String serviceName = "delivery.loaded.car.list.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (response.getStdData().getParameter().get("transport_list") == null) {
            return Collections.emptyList();
        }
        return ModuleUtils.listMapToListObject((List)((List)JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("transport_list"), List.class)), ZTBDriverVehicle.class);
    }

    public List<ZtbCargoUnloading> getDeliveryLoadedItemList(String iamUserToken, String tenantId, String locale, String transportNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);
        String serviceName = "delivery.loaded.item.list.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"transport_detail"});
        return ModuleUtils.listMapToListObject((List)((List)JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("transport_detail"), List.class)), ZtbCargoUnloading.class);
    }

    public Boolean driverRoleValid(String iamUserToken, String tenantId, String locale, String userId) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("user_id", userId);
        parameter.put("parameter", params);
        String serviceName = "driver.role.valid";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"is_driver"});
        return (Boolean)JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("is_driver"), Boolean.class);
    }

    public List<WoOpReportInfo> woOpReportPersonnelCheckedInInfoGet(String iamUserToken, String tenantId, String locale, String eocCompanyId, String eocSiteId) {
        String serviceProd = "APC";
        String serviceName = "wo.op.report.personnel.checked.in.info.get";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        digiEocmap.put("eoc_site_id", eocSiteId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, "APC", "wo.op.report.personnel.checked.in.info.get", headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, "APC", "wo.op.report.personnel.checked.in.info.get", parameterBodyJson, new String[]{"wo_op_report_info"});
        List woOpReportInfoList = ModuleUtils.listMapToListObject((List)((List)response.getStdData().getParameter().get("wo_op_report_info")), WoOpReportInfo.class);
        woOpReportInfoList.forEach(e -> e.setSupervisor(MapUtils.getBoolean((Map)response.getStdData().getParameter(), (Object)"is_supervisor").booleanValue()));
        return woOpReportInfoList;
    }

    public List<WoOpReportInfo> woOpReportPersonnelNotCheckInInfoGet(String iamUserToken, String tenantId, String locale, String eocCompanyId, String eocSiteId) {
        String serviceProd = "APC";
        String serviceName = "wo.op.report.personnel.not.check.in.info.get";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        digiEocmap.put("eoc_site_id", eocSiteId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, "APC", "wo.op.report.personnel.not.check.in.info.get", headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, "APC", "wo.op.report.personnel.not.check.in.info.get", parameterBodyJson, new String[]{"wo_op_report_info"});
        return ModuleUtils.listMapToListObject((List)((List)response.getStdData().getParameter().get("wo_op_report_info")), WoOpReportInfo.class);
    }

    public List<WoOpReportInfo> woOpReportPersonnelExceptInfoGet(String iamUserToken, String tenantId, String locale, String eocCompanyId, String eocSiteId) {
        String serviceProd = "APC";
        String serviceName = "wo.op.report.personnel.except.info.get";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        digiEocmap.put("eoc_site_id", eocSiteId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, "APC", "wo.op.report.personnel.except.info.get", headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, "APC", "wo.op.report.personnel.except.info.get", parameterBodyJson, new String[]{"wo_op_report_info"});
        return ModuleUtils.listMapToListObject((List)((List)response.getStdData().getParameter().get("wo_op_report_info")), WoOpReportInfo.class);
    }

    public List<WoOpReportInfo> requestSupportInfoGet(String iamUserToken, String tenantId, String locale, String eocCompanyId, String eocSiteId) {
        String serviceProd = "APC";
        String serviceName = "request.support.info.get";
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        digiEocmap.put("eoc_site_id", eocSiteId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, "APC", "request.support.info.get", headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        Optional<List> parameterOpt = Optional.ofNullable(response.getStdData()).map(DigiwinEspStdData::getParameter).map(e -> (List)e.get("request_support"));
        if (!parameterOpt.isPresent()) {
            return Collections.emptyList();
        }
        return ModuleUtils.listMapToListObject((List)parameterOpt.get(), WoOpReportInfo.class);
    }

    public Map<String, Object> taskTransportVehicleCodeScan(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "task.transport.vehicle.code.scan";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"transport_info"});
        return (Map)JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("transport_info"), Map.class);
    }

    public Map<String, Object> taskTransportOcrScan(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "task.transport.ocr.scan";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        return (Map)JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("transport_info"), Map.class);
    }

    public List<ZtbCargoUnloading> taskTransportBarcodeScan(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "task.transport.barcode.scan";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[]{"item_list"});
        return ModuleUtils.listMapToListObject((List)((List)JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("item_list"), List.class)), ZtbCargoUnloading.class);
    }

    public Map<String, Object> changeTaskTransportVehicle(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "task.transport.vehicle.change";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    public Map<String, Object> submitTaskTransportLoading(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "task.transport.loading.submit";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    public List<ZtbTransportReceiptStatusCount> getTransportReceiptStatusCount(String iamUserToken, String tenantId, String locale, String transportNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);
        String serviceName = "transport.receipt.status.count.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return ModuleUtils.listMapToListObject((List)((List)response.getStdData().getParameter().get("receipt_status_list")), ZtbTransportReceiptStatusCount.class);
    }

    public List<ZtbCargoUnloading> getTransportReceiptItemInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "transport.receipt.item.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return ModuleUtils.listMapToListObject((List)((List)response.getStdData().getParameter().get("cargo_information")), ZtbCargoUnloading.class);
    }

    public Boolean transportAbnormalAlarmProcess(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "transport.abnormal.alarm.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    public Boolean deliveryStartManualSubmit(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "delivery.start.manual.submit";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    public Boolean deliveryHeadInfoSubmit(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "delivery.head.info.submit";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    public Boolean transportPaperReceiptSubmit(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "transport.paper.receipt.submit";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    public String getSrmLoadingWebUrl(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "srm.loading.web.url.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        if (responseModel == null) {
            return null;
        }
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return (String)response.getStdData().getParameter().get("web_url");
    }

    public Map<String, Object> getDeliverySourceDetail(String iamUserToken, String tenantId, String locale, String sourceNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("source_no", sourceNo);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "delivery.source.detail.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    public Map<String, Object> validTransportArrival(String iamUserToken, String tenantId, String locale, String transport_no) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transport_no", transport_no);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "transport.arrival.valid";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    public List<Map<String, Object>> getTransportReceive(String iamUserToken, String tenantId, String locale, String transport_no) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transport_no", transport_no);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "transport.receive.record.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return (List)response.getStdData().getParameter().get("transport_receive_list");
    }

    public Map<String, Object> scanTransportToReceive(String userId, String iamUserToken, String tenantId, String locale, String transport_no) {
        DigiwinIamUserInfo userInfo = this.iamProxyService.userInfoById(userId, iamUserToken, locale);
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transport_no", transport_no);
        if (ObjectUtil.isNotEmpty((Object)userInfo)) {
            params.put("receiver_name", userInfo.getName());
            params.put("receiver_mobile", userInfo.getTelephone());
        }
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);
        String serviceName = "receive.transport.scan";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return (Map)response.getStdData().getParameter().get("scan_result");
    }

    public List<Map<String, Object>> getWoOpReportWaitProcessAbnormalInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.report.wait.process.abnormal.info.get";
        String serviceProd = "APC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("wo_op_report_data") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("wo_op_report_data");
    }

    public List<Map<String, Object>> getCurrentTeamInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(params));
        String serviceName = "current.team.info.get";
        String serviceProd = "APC";
        String parameterBodyJson = "{}";
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("team_data") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("team_data");
    }

    public List<Map<String, Object>> getWoOpSupportDemandWindowsInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.support.demand.windows.info.get";
        String serviceProd = "APC";
        HashMap body = new HashMap(1);
        ArrayList<Map<String, Object>> info = new ArrayList<Map<String, Object>>(1);
        info.add(params);
        body.put("wo_op_support_demand_windows_info", info);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("supporter_info") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("supporter_info");
    }

    public List<Map<String, Object>> getWoOpRequestSupportApproveInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.request.support.approve.info.get";
        String serviceProd = "APC";
        HashMap body = new HashMap(1);
        ArrayList<Map<String, Object>> info = new ArrayList<Map<String, Object>>(1);
        info.add(params);
        body.put("wo_op_request_support_approve_info", info);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("approve_info") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("approve_info");
    }

    public List<Map<String, Object>> getInfoSupplierQuestion(String iamUserToken, String tenantId, String locale, String supplierSource) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "question.supplier.info.get";
        String serviceProd = "FRC";
        HashMap<String, String> body = new HashMap<String, String>(1);
        body.put("supplier_source", supplierSource);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("supplier_info") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("supplier_info");
    }

    public List<Map<String, Object>> getProjectInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "project.third.party.info.get";
        String serviceProd = "FRC";
        HashMap body = new HashMap(1);
        HashMap<String, Object> info = new HashMap<String, Object>(1);
        info.put("project_source", params.get("project_source"));
        info.put("project_status", "all");
        info.put("inquiry_data", params.get("inquiry_data"));
        String projectPersonnelRequired = params.get("projectPersonnelRequired").toString();
        if ("Y".equals(projectPersonnelRequired)) {
            info.put("liable_person_id", params.get("userId"));
            info.put("liable_person_name", params.get("userId"));
        }
        body.put("project_info", info);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("project_info") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("project_info");
    }

    public List<Map<String, Object>> getLayoutAreaWoOpInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "layout.area.wo.op.info.get";
        String serviceProd = "APC";
        HashMap<String, List<Map<String, Object>>> body = new HashMap<String, List<Map<String, Object>>>(1);
        if (!CollectionUtils.isEmpty(params)) {
            HashMap<String, String> digiEocmap = new HashMap<String, String>();
            digiEocmap.put("eoc_company_id", (String)params.get(0).get("eoc_company_id"));
            digiEocmap.put("eoc_site_id", (String)params.get(0).get("eoc_site_id"));
            headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        }
        body.put("report_area_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("machine_position_map_data") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("machine_position_map_data");
    }

    public Map<String, Object> getWoOpDispatchAreaSpaceDetailInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.dispatch.area.space.detail.info.get";
        String serviceProd = "APC";
        HashMap body = new HashMap(1);
        if (!CollectionUtils.isEmpty(params)) {
            HashMap<String, String> digiEocmap = new HashMap<String, String>();
            digiEocmap.put("eoc_company_id", (String)params.get("eoc_company_id"));
            digiEocmap.put("eoc_site_id", (String)params.get("eoc_site_id"));
            headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(1);
        params.remove("isAPC");
        params.remove("type");
        params.remove("onSiteResourcePlanningMechanism");
        mapList.add(params);
        body.put("query_condition", mapList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("wo_op_data") == null) {
            return returnMap;
        }
        Map woOpData = (Map)JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("wo_op_data"), Map.class);
        returnMap.put("eff_wo_op_data", woOpData.get("eff_wo_op_data"));
        returnMap.put("area_space_percentage", woOpData.get("area_space_percentage"));
        return returnMap;
    }

    public List<Map<String, Object>> getDispatchAreaSpaceColorInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.dispatch.area.space.color.info.get";
        String serviceProd = "APC";
        HashMap body = new HashMap(1);
        if (!CollectionUtils.isEmpty(params)) {
            HashMap<String, String> digiEocmap = new HashMap<String, String>();
            digiEocmap.put("eoc_company_id", (String)params.get("eoc_company_id"));
            digiEocmap.put("eoc_site_id", (String)params.get("eoc_site_id"));
            headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(1);
        mapList.add(params);
        body.put("query_condition", mapList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            return Collections.emptyList();
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("wo_op_data") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("wo_op_data");
    }

    public List<Map<String, Object>> getDispatchOpWoDscBmInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "bm.dsc.wo.op.dispatch.get";
        String serviceProd = "BM-DSC";
        HashMap body = new HashMap(1);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(1);
        mapList.add(params);
        body.put("wo_op_dispatch_data", mapList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            return Collections.emptyList();
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("wo_op_dispatch_data") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("wo_op_dispatch_data");
    }

    public List<Map<String, Object>> getWorkstationProgressFeedbackInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "workstation.progress.feedback.info.get";
        String serviceProd = "APC";
        HashMap<String, List<Map<String, Object>>> body = new HashMap<String, List<Map<String, Object>>>(1);
        body.put("workstation_progress_feedback_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("workstation_progress_feedback_info") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("workstation_progress_feedback_info");
    }

    public List<Map<String, Object>> getWoOpOnlineReporterInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.online.reporter.info.get";
        String serviceProd = "APC";
        HashMap<String, List<Map<String, Object>>> body = new HashMap<String, List<Map<String, Object>>>(1);
        body.put("wo_op_report_data", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("wo_op_report_data") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("wo_op_report_data");
    }

    public List<Map<String, Object>> returnWoOpReportAbnormalInfoClosecase(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        if (!CollectionUtils.isEmpty(params)) {
            HashMap<String, String> digiEocmap = new HashMap<String, String>();
            digiEocmap.put("eoc_company_id", (String)params.get(0).get("eoc_company_id"));
            digiEocmap.put("eoc_site_id", (String)params.get(0).get("eoc_site_id"));
            headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        }
        String serviceName = "wo.op.report.abnormal.info.closecase.return";
        String serviceProd = "APC";
        HashMap<String, List<Map<String, Object>>> body = new HashMap<String, List<Map<String, Object>>>(1);
        body.put("wo_op_report_abnormal", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        List reportAbnormals = (List)response.getStdData().getParameter().get("wo_op_report_abnormal");
        return reportAbnormals;
    }

    public Boolean processWoOpReportAbnormalInfoClosecase(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        if (!CollectionUtils.isEmpty(params)) {
            HashMap<String, String> digiEocmap = new HashMap<String, String>();
            digiEocmap.put("eoc_company_id", (String)params.get(0).get("eoc_company_id"));
            digiEocmap.put("eoc_site_id", (String)params.get(0).get("eoc_site_id"));
            headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        }
        String serviceName = "wo.op.report.abnormal.info.closecase.process";
        String serviceProd = "APC";
        HashMap<String, List<Map<String, Object>>> body = new HashMap<String, List<Map<String, Object>>>(1);
        body.put("wo_op_report_abnormal", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    public List<Map<String, Object>> getEquipmentInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "equipment.info.get";
        String serviceProd = "FRC";
        HashMap<String, Map<String, Object>> body = new HashMap<String, Map<String, Object>>(1);
        body.put("equipment_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("equipment_info") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("equipment_info");
    }

    public List<Map<String, Object>> getProjectStageThirdPartyInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "project.stage.third.party.info.get";
        String serviceProd = "FRC";
        HashMap<String, Map<String, Object>> body = new HashMap<String, Map<String, Object>>(1);
        body.put("project_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("project_info") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("project_info");
    }

    public List<Map<String, Object>> getTransferQuantityInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.report.transfer.info.get";
        String serviceProd = "APC";
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>(1);
        map.put("wo_op_report_data", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(map);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("wo_op_report_data") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("wo_op_report_data");
    }

    public List<Map<String, Object>> getOpNextInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.next.op.get";
        String serviceProd = "APC";
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>(1);
        map.put("wo_op_data", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(map);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("wo_op_data") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("wo_op_data");
    }

    public List<Map<String, Object>> getWoOpReportQtyInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.report.qty.info.get";
        String serviceProd = "APC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("wo_op_report_data") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("wo_op_report_data");
    }

    public boolean updateIssueNoticeInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "ca.cim.issue.notice.info.update";
        String serviceProd = "ca-cim-ap";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional<String> codeOptional = Optional.ofNullable(response.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getCode);
        return codeOptional.isPresent() && FEATURE_WEEK.equals(codeOptional.get());
    }

    public boolean updateOutSourceReportInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "ca.cim.outsourcing.report.info.update";
        String serviceProd = "ca-cim-ap";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional<String> codeOptional = Optional.ofNullable(response.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getCode);
        return codeOptional.isPresent() && FEATURE_WEEK.equals(codeOptional.get());
    }

    public Boolean woOpDispatchDataProcess(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.dispatch.data.process";
        String serviceProd = "APC";
        HashMap<String, List<Map<String, Object>>> bodys = new HashMap<String, List<Map<String, Object>>>(1);
        bodys.put("wo_op_dispatch_data", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional<String> codeOptional = Optional.ofNullable(response.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && FEATURE_WEEK.equals(codeOptional.get())) {
            return true;
        }
        return false;
    }

    public Map<String, Object> updateProcessInfoTransferReport(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        HashMap<String, Object> retrunMap = new HashMap<String, Object>(2);
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.report.transfer.info.process";
        String serviceProd = "APC";
        Map<String, Object> paramsMap = params.get(0);
        if (!ObjectUtils.isEmpty((Object)paramsMap.get("eoc_company_id")) && !ObjectUtils.isEmpty((Object)paramsMap.get("eoc_site_id"))) {
            HashMap<String, Object> eocMap = new HashMap<String, Object>();
            eocMap.put("eoc_company_id", paramsMap.get("eoc_company_id"));
            eocMap.put("eoc_site_id", paramsMap.get("eoc_site_id"));
            headers.put("digi-eocmap", JSONObject.toJSONString(eocMap));
        }
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>(1);
        map.put("wo_op_report_data", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(map);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional<String> codeOptional = Optional.ofNullable(response.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && FEATURE_WEEK.equals(codeOptional.get()) && !ObjectUtil.isEmpty((Object)response.getStdData().getParameter())) {
            if (ObjectUtils.isEmpty(response.getStdData().getParameter().get("error_msg"))) {
                retrunMap.put("submit", true);
                retrunMap.put("errorMsg", null);
                retrunMap.put("data", response.getStdData().getParameter());
                return retrunMap;
            }
            retrunMap.put("submit", false);
            retrunMap.put("errorMsg", response.getStdData().getParameter().get("error_msg"));
            return retrunMap;
        }
        return retrunMap;
    }

    public List<Map<String, Object>> getWoOpWorkstationRecommandTeamInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params, Map<String, Object> headerParams) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(headerParams));
        String serviceName = "wo.op.workstation.recommand.team.info.get";
        String serviceProd = "APC";
        HashMap<String, List<Map<String, Object>>> bodys = new HashMap<String, List<Map<String, Object>>>(1);
        bodys.put("wo_op_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("work_team_personnel_info") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("work_team_personnel_info");
    }

    public List<Map<String, Object>> createTbdsTrialProductionReport(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "bm.opsc.trial.production.report.create";
        String serviceProd = "BM-OPSC";
        HashMap<String, List<Map<String, Object>>> bodys = new HashMap<String, List<Map<String, Object>>>(1);
        this.handleDocumentInfo(params);
        bodys.put("op_data", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        if (ObjectUtils.isEmpty((Object)responseModel)) {
            LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleService.class);
            throw new ServiceException(localeService.getLanguageValue(locale, "\u4fdd\u5b58\u5931\u8d25"));
        }
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional<String> codeOptional = Optional.ofNullable(response.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && FEATURE_WEEK.equals(codeOptional.get()) && response.getStdData() != null && !CollectionUtils.isEmpty((Map)response.getStdData().getParameter())) {
            return (List)response.getStdData().getParameter().get("op_data");
        }
        return Collections.emptyList();
    }

    public Integer getTbdsTrialProductionComplete(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params, String opSeq) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "bm.opsc.trial.production.complete.get";
        String serviceProd = "BM-OPSC";
        HashMap<String, List<Map<String, Object>>> bodys = new HashMap<String, List<Map<String, Object>>>(1);
        bodys.put("query_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional<String> codeOptional = Optional.ofNullable(response.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && FEATURE_WEEK.equals(codeOptional.get()) && response.getStdData() != null && !CollectionUtils.isEmpty((Map)response.getStdData().getParameter())) {
            List datas = (List)response.getStdData().getParameter().get("op_data");
            for (Map data : datas) {
                if (!opSeq.equals(data.get("op_seq"))) continue;
                return Integer.valueOf((String)data.get("is_associate_project"));
            }
        }
        return 0;
    }

    public List<Map<String, Object>> getTbdsTrialProductionCompleteList(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "bm.opsc.trial.production.complete.get";
        String serviceProd = "BM-OPSC";
        HashMap<String, List<Map<String, Object>>> bodys = new HashMap<String, List<Map<String, Object>>>(1);
        bodys.put("query_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional<String> codeOptional = Optional.ofNullable(response.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && FEATURE_WEEK.equals(codeOptional.get()) && response.getStdData() != null && !CollectionUtils.isEmpty((Map)response.getStdData().getParameter())) {
            return (List)response.getStdData().getParameter().get("op_data");
        }
        return Collections.emptyList();
    }

    public List<Map<String, Object>> getBmQmscTestPlanReportInfo(String iamUserToken, String tenantId, String locale, String joinInspectionNo) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "bm.qmsc.test.plan.report.info.get";
        String serviceProd = "BM-QMSC";
        HashMap bodys = new HashMap(1);
        ArrayList body = new ArrayList(1);
        HashMap<String, String> testReportInfo = new HashMap<String, String>(1);
        testReportInfo.put("inspection_no", joinInspectionNo);
        body.add(testReportInfo);
        bodys.put("test_report_info", body);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional<String> codeOptional = Optional.ofNullable(response.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && FEATURE_WEEK.equals(codeOptional.get()) && response.getStdData() != null && !CollectionUtils.isEmpty((Map)response.getStdData().getParameter())) {
            return (List)response.getStdData().getParameter().get("test_report_info");
        }
        return Collections.emptyList();
    }

    public List<Map<String, Object>> getBmOpscEarliestStartDateTrialWoProcess(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> trialWoProcessList) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "bm.opsc.earliest.start.date.trial.wo.process.get";
        String serviceProd = "BM-OPSC";
        HashMap<String, List<Map<String, Object>>> bodys = new HashMap<String, List<Map<String, Object>>>(1);
        bodys.put("trial_wo_process", trialWoProcessList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional<String> codeOptional = Optional.ofNullable(response.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && FEATURE_WEEK.equals(codeOptional.get()) && response.getStdData() != null && !CollectionUtils.isEmpty((Map)response.getStdData().getParameter())) {
            return (List)response.getStdData().getParameter().get("trial_wo_process");
        }
        return Collections.emptyList();
    }

    public List<Map<String, Object>> getBmOpscTrialWoProcess(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> trialWoProcessList) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "bm.opsc.trial.wo.process.get";
        String serviceProd = "BM-OPSC";
        HashMap<String, List<Map<String, Object>>> bodys = new HashMap<String, List<Map<String, Object>>>(1);
        bodys.put("trial_wo_process", trialWoProcessList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional<String> codeOptional = Optional.ofNullable(response.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && FEATURE_WEEK.equals(codeOptional.get()) && response.getStdData() != null && !CollectionUtils.isEmpty((Map)response.getStdData().getParameter())) {
            return (List)response.getStdData().getParameter().get("trial_wo_process");
        }
        return Collections.emptyList();
    }

    public List<Map<String, Object>> getBmMoscTrialWo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> trialWoList) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "bm.mosc.trial.wo.get";
        String serviceProd = "BM-MOSC";
        HashMap<String, List<Map<String, Object>>> bodys = new HashMap<String, List<Map<String, Object>>>(1);
        bodys.put("trial_wo", trialWoList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional<String> codeOptional = Optional.ofNullable(response.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && FEATURE_WEEK.equals(codeOptional.get()) && response.getStdData() != null && !CollectionUtils.isEmpty((Map)response.getStdData().getParameter())) {
            return (List)response.getStdData().getParameter().get("trial_wo");
        }
        return Collections.emptyList();
    }

    public List<Map<String, Object>> getBmUscMeasureUnitList(String iamUserToken, String tenantId, String locale) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "bm.usc.measure.unit.list.get";
        String serviceProd = "BM-USC";
        HashMap bodys = new HashMap(1);
        ArrayList body = new ArrayList(1);
        HashMap<String, String> manageStatus = new HashMap<String, String>(1);
        manageStatus.put("manage_status", "Y");
        body.add(manageStatus);
        bodys.put("query_condition", body);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional<String> codeOptional = Optional.ofNullable(response.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && FEATURE_WEEK.equals(codeOptional.get()) && response.getStdData() != null && !CollectionUtils.isEmpty((Map)response.getStdData().getParameter())) {
            return (List)response.getStdData().getParameter().get("measure_unit_info");
        }
        return Collections.emptyList();
    }

    public void saveDriverPosition(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        params.put("detail_address", params.get("detailAddress"));
        params.put("complete_address", params.get("completeAddress"));
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        String serviceName = "transport.driver.position.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, new String[0]);
    }

    public List<Map<String, Object>> getTransportDriverMsg(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String parameterBodyJson;
        String serviceName;
        String serviceProd;
        ResponseModel responseModel;
        DigiwinEspResponse response;
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }
        if (!(response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)(responseModel = this.invokeRestSync(tenantId, locale, serviceProd = "srm-loading", serviceName = "transport.driver.msg.get", headers, parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)parameter))).getBodyJsonString(), DigiwinEspResponse.class)).isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return (List)response.getStdData().getParameter().get("msg_list");
    }

    private void isRespOk(DigiwinEspResponse response, String serviceProd, String serviceName, String parameterBodyJson, String ... serviceFields) {
        String field;
        if (response == null) {
            throw new ServiceException("Service " + serviceName + " call returned NONE Response!");
        }
        if (response.isRespOk("error_msg").booleanValue()) {
            String message = (String)response.getStdData().getParameter().get("error_msg");
            if (StringUtils.hasLength((String)message)) {
                throw new ServiceException(message);
            }
            throw new ServiceException("error_msg is empty, please check log of Service " + serviceName);
        }
        if (serviceFields.length == 0) {
            if (!response.isRespOk().booleanValue()) {
                throw new ServiceException(response.getResponseFullDescriptionMsgWhenNotOK(serviceProd, serviceName, parameterBodyJson));
            }
            return;
        }
        boolean isRespOk = true;
        String[] stringArray = serviceFields;
        int n = stringArray.length;
        for (int i = 0; i < n && (isRespOk = response.isRespOk(field = stringArray[i]).booleanValue()); ++i) {
        }
        if (!isRespOk) {
            throw new ServiceException(response.getResponseFullDescriptionMsgWhenNotOK(serviceProd, serviceName, parameterBodyJson));
        }
    }

    public List<Map<String, Object>> getAacrArdateInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("digi-token", iamUserToken);
        String serviceName = "aacr.ardata.get";
        String serviceProd = "A20230410171317-bq3200";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("ar_data") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("ar_data");
    }

    public List<Map<String, Object>> createAacrAppArProgress(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("digi-token", iamUserToken);
        String serviceName = "aacr.app.arprogress.create";
        String serviceProd = "A20230410171317-bq3200";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("ar_progress") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("ar_progress");
    }

    private void handleDocumentInfo(List<Map<String, Object>> params) {
        if (!CollectionUtils.isEmpty(params)) {
            params.forEach(item -> {
                List documentInfoList = (List)MapUtil.getOrDefault((Map)item, (String)"document_info", Collections.emptyList());
                if (CollectionUtils.isEmpty((Collection)documentInfoList)) {
                    HashMap documentInfoMap = new HashMap();
                    documentInfoMap.put("project_no", item.get("project_no"));
                    documentInfoMap.put("eoc_company_id", item.get("eoc_company_id"));
                    documentInfoMap.put("eoc_site_id", item.get("eoc_site_id"));
                    documentInfoMap.put("trial_wo_no", item.get("trial_wo_no"));
                    documentInfoMap.put("op_seq", item.get("op_seq"));
                    documentInfoMap.put("op_no", item.get("op_no"));
                    HashMap<String, Object> attachmentMap = new HashMap<String, Object>();
                    attachmentMap.put("data", Collections.emptyList());
                    attachmentMap.put("rowData", "");
                    documentInfoMap.put("attachment", attachmentMap);
                    documentInfoMap.put("document_type", "2");
                    item.put("document_info", Collections.singletonList(documentInfoMap));
                }
            });
        }
    }

    public List<Map<String, Object>> bmDpscWorkingDayPlan(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "bm.dpsc.working.day.plan.get";
        String serviceProd = "BM-DPSC";
        HashMap body = new HashMap(1);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(1);
        mapList.add(params);
        body.put("day_plan_data", mapList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            return Collections.emptyList();
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("day_plan_data") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("day_plan_data");
    }

    public List<Map<String, Object>> getApcWorkingDayPlanDispatchInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "apc.working.day.plan.dispatch.info.get";
        String serviceProd = "APC";
        HashMap body = new HashMap(1);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(1);
        mapList.add(params);
        body.put("apc_day_plan_data", mapList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            return Collections.emptyList();
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("apc_day_plan_data") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("apc_day_plan_data");
    }

    public void updateTaskWarnInvImsc(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "bmd.imsc.inv.warn.task.update";
        String serviceProd = "BMD-IMSC-001";
        HashMap<String, List<Map<String, Object>>> body = new HashMap<String, List<Map<String, Object>>>(1);
        body.put("safety_inventory_warn_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException("");
        }
    }

    public Map<String, Object> getWoOpMergeReportWorkHoursInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.merge.report.work.hours.info.get";
        String serviceProd = "APC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    public Map<String, Object> getWoOpReportWorkHoursInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.report.work.hours.info.get";
        String serviceProd = "APC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    public Map<String, Object> getBmWrscWoOpReportWorkHours(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "bm.wrsc.wo.op.report.work.hours.get";
        String serviceProd = "BM-WRSC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    public Map<String, Object> getQuestionEocDeptUserInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "question.eoc.dept.user.info.get";
        String serviceProd = "FRC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    public List<Map<String, Object>> getTaskReportRecordInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("digi-token", iamUserToken);
        String serviceName = "task.report.record.info.get";
        String serviceProd = "PCC";
        HashMap<String, List<Map<String, Object>>> body = new HashMap<String, List<Map<String, Object>>>(1);
        body.put("query_condition", Collections.singletonList(params));
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("report_info") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("report_info");
    }

    public Map<String, Object> getWoOpReportWorkHoursHistoryInfoGet(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.report.work.hours.history.info.get";
        String serviceProd = "APC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    public List<Map<String, Object>> getDispatchReportInfo(String iamUserToken, String tenantId, String locale, String eocCompanyId, List<Map<String, Object>> params) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "dispatch.report.info.get";
        String serviceProd = "APC";
        HashMap<String, List<Map<String, Object>>> body = new HashMap<String, List<Map<String, Object>>>(1);
        HashMap<String, String> digiEocmap = new HashMap<String, String>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        body.put("query_condition", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = this.invokeRestSync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null || response.getStdData().getParameter().get("query_data") == null) {
            return Collections.emptyList();
        }
        return (List)response.getStdData().getParameter().get("query_data");
    }

    public Map<String, Object> getExportAbiUrlFasync(String iamUserToken, String tenantId, String locale, AbiReportAsyncExport export) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "abi.rpt.export";
        String serviceProd = "ABI";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString((Object)export);
        ResponseModel responseModel = this.invokeRestFasync(tenantId, locale, serviceProd, serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = (DigiwinEspResponse)JsonUtil.jsonStringToObject((String)responseModel.getBodyJsonString(), DigiwinEspResponse.class);
        if (!response.isRespOk().booleanValue()) {
            return responseModel.getHeaders();
        }
        return response.getStdData().getParameter();
    }
}

