/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.analyzer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.analyzer.LabelFieldAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.group.UiBotGroupPrototype;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.analyzer.LayoutAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="uibotDArrayAnalyzer")
public class UiBotDArrayAnalyzer
implements LayoutAnalyzer<String> {
    private static final Logger logger = LoggerFactory.getLogger(UiBotDArrayAnalyzer.class);
    public static final String LAYOUT_TYPE = "D_ARRAY";
    public static final String LAYOUT_TYPE_TWO = "LINE_TABLE";
    private static final String FIELD_RESULT_TEMPLATE = "%s: %s";
    private static final String LAYOUT_TYPE_CHECK_ERROR_MSG = String.format("Only %s type field can be anaylyzed", "D_ARRAY");
    @Autowired
    private LabelFieldAnalyzer labelFieldAnalyzer;

    public String analyze(UiBotLayout layout, UiBotPageData pageData, Class<String> clazz) {
        List columnDefs;
        Assert.notNull((Object)layout, (String)"layout must not be null");
        Assert.isTrue((LAYOUT_TYPE.equalsIgnoreCase(layout.getType()) || LAYOUT_TYPE_TWO.equalsIgnoreCase(layout.getType()) ? 1 : 0) != 0, (String)LAYOUT_TYPE_CHECK_ERROR_MSG);
        String pageDataKey = layout.getSchema();
        Object pageDataValue = pageData.get((Object)pageDataKey);
        boolean pageDataValueIsList = pageDataValue instanceof List;
        if (LAYOUT_TYPE.equalsIgnoreCase(layout.getType())) {
            StringBuffer sbResult = new StringBuffer(512);
            for (UiBotGroupPrototype groupPrototype : layout.getGroupPrototype()) {
                String type = groupPrototype.getType();
                Assert.isTrue((boolean)"GROUP".equalsIgnoreCase(type), (String)"must group type!");
                for (UiBotLayout fieldLayout : groupPrototype.getGroup()) {
                    if ("LABEL".equalsIgnoreCase(fieldLayout.getType())) {
                        if (pageDataValueIsList) {
                            JSONArray pageDataValueArray = (JSONArray)JSONArray.toJSON((Object)pageDataValue);
                            pageDataValueArray.forEach(valObj -> sbResult.append(this.labelFieldAnalyzer.analyze(fieldLayout, (JSONObject)JSONObject.toJSON((Object)valObj), pageData, Boolean.valueOf(false))));
                        } else {
                            sbResult.append(this.labelFieldAnalyzer.analyze(fieldLayout, (JSONObject)JSONObject.toJSON((Object)pageDataValue), pageData, Boolean.valueOf(false)));
                        }
                    }
                    if (sbResult.length() <= 0) continue;
                    sbResult.append(" ");
                }
            }
            return sbResult.subSequence(0, sbResult.length() - 1).toString();
        }
        if (LAYOUT_TYPE_TWO.equalsIgnoreCase(layout.getType()) && (columnDefs = layout.getColumnDefs()) != null && columnDefs.size() > 0) {
            JSONArray pageDataValueArray;
            String columnSchema = ((UiBotTableColumnDefinition)columnDefs.get(0)).getSchema();
            if (pageDataValueIsList && (pageDataValueArray = (JSONArray)JSONArray.toJSON((Object)pageDataValue)) != null && pageDataValueArray.size() > 0) {
                JSONObject pageDataObj = pageDataValueArray.getJSONObject(0);
                return (String)pageDataObj.get((Object)columnSchema);
            }
        }
        return "";
    }
}

