/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern.PatternTaskInfo;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcActivityData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmPage;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.AbstractPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.NewTaskSubmitService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.ProjectDataSourceAnalysisService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmOtherInfoService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotAttachmentUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotConvertTmActivityUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ProjectPageDefineAnalyzer
extends AbstractPageDefineAnalyzer<PcUiBotTaskPageDefine> {
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private ProjectDataSourceAnalysisService tmProjectDataSourceService;
    @Autowired
    private TmPageOperationService tmPageOperationService;
    @Autowired
    private TmOtherInfoService tmOtherInfoService;
    @Autowired
    private NewTaskSubmitService newTaskSubmitService;

    public List<PcUiBotTaskPageDefine> analysis(PcUiBotExecuteContext executeContext, String projectId, ApiRequest apiRequest) {
        DigiwinAtmcActivityData activityData = this.digiwinAtmcProxyService.getProjectData(projectId, executeContext);
        if (activityData != null && CollectionUtils.isNotEmpty((Collection)activityData.getTasks()) && StringUtils.hasText((String)((DigiwinAtmcTaskWithBacklogData)activityData.getTasks().get(0)).getProxyToken())) {
            executeContext.setProxyToken(((DigiwinAtmcTaskWithBacklogData)activityData.getTasks().get(0)).getProxyToken());
            AppRequestContext.getContextEntity().setProxyToken(executeContext.getProxyToken());
        }
        if (activityData == null || CollectionUtils.isEmpty((Collection)activityData.getTasks())) {
            return new ArrayList<PcUiBotTaskPageDefine>();
        }
        executeContext.appendTaskData(activityData);
        PcUiBotTmActivity tmActivity = this.getActivityAction(apiRequest, executeContext);
        if (tmActivity.getDataSources() == null) {
            String message = MessageFormat.format("\u4efb\u52a1\u5b9a\u4e49\u4e0d\u5b8c\u6574\uff0c\u6ca1\u6709\u76f8\u5173\u7684\u6570\u636e\u6e90\u5b9a\u4e49,tmActivity\uff1a{0}", tmActivity.getActivityId());
            throw new ServiceException(message);
        }
        executeContext.appendTmActivityInfo(tmActivity);
        ArrayList pageDefineList = super.createPageDefines(executeContext, tmActivity);
        if (null == pageDefineList) {
            pageDefineList = new ArrayList();
        }
        this.appendInternalPageDefine(executeContext, tmActivity, pageDefineList);
        return this.filterNoResultQuery(pageDefineList);
    }

    public PcUiBotTmActivity getActivityAction(ApiRequest apiRequest, PcUiBotExecuteContext executeContext) {
        KnowledgeMapsActivityDefinition rawActivityDefinition = Optional.ofNullable(apiRequest).map(ApiRequest::getPatternTaskInfo).map(PatternTaskInfo::getUiBotDesignerConfig).map(UiBotDesignerConfig::getRawTaskActivityDefinition).orElse(null);
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("taskId", executeContext.getTmProjectId());
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", executeContext.getPageCode());
        DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getTenantId())).uriVariables(uriVariables).build();
        rawActivityDefinition = rawActivityDefinition != null ? rawActivityDefinition : this.digiwinKnowledgeMapsProxyService.getActivityDefinition(athenaApiRequest);
        PcUiBotTmActivity tmActivity = (PcUiBotTmActivity)JsonUtil.objectToJavaObject((Object)rawActivityDefinition, PcUiBotTmActivity.class);
        this.handleDataState(tmActivity);
        this.buildDataStateSubmitAction(tmActivity);
        PcUiBotConvertTmActivityUtils.convert((String)executeContext.getPageCode(), (String)executeContext.getLocale(), (PcUiBotTmActivity)tmActivity);
        return tmActivity;
    }

    private List<PcUiBotTaskPageDefine> filterNoResultQuery(List<PcUiBotTaskPageDefine> actionVOList) {
        if (actionVOList == null) {
            return actionVOList;
        }
        ArrayList<PcUiBotTaskPageDefine> filter = new ArrayList<PcUiBotTaskPageDefine>();
        for (PcUiBotTaskPageDefine pageDefine : actionVOList) {
            if (pageDefine.getDataSourceSet() != null) {
                pageDefine.setType("async");
            }
            filter.add(pageDefine);
        }
        return filter;
    }

    protected PcUiBotTaskPageDefine createNewPageDefine() {
        return new PcUiBotTaskPageDefine();
    }

    protected PcUiBotExecuteContext createNewContext(PcUiBotExecuteContext oldExecuteContext) {
        return oldExecuteContext.clone();
    }

    protected void addDefaultConfigInfo(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {
        PcUiBotAttachmentUtil.addDefaultAttachmentDataSourceProcess((PcUiBotExecuteContext)executeContext, (PcUiBotTmActivity)tmActivity);
        PcUiBotAttachmentUtil.appendEffectAfterSubmitAction((PcUiBotExecuteContext)executeContext, (PcUiBotTmActivity)tmActivity);
    }

    protected void analysisBaseInfo(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage) {
        if (executeContext.getTaskWithBacklogDataList() == null || executeContext.getTaskWithBacklogDataList().size() == 0) {
            return;
        }
        pageDefine.setPrePerformer(tmPage.getPrePerformer());
        pageDefine.setSubjectMatter(tmPage.getSubjectMatter());
        pageDefine.setSubjectMatterTargets(tmPage.getSubjectMatterTargets());
        pageDefine.setSubjectMatterProperties(tmPage.getSubjectMatterProperties());
        pageDefine.setRoleAttention(tmPage.getRoleAttention());
        pageDefine.setStartApproveActivityName(tmActivity.getStartApproveActivityName());
        pageDefine.setStartApproveActivity(tmActivity.getStartApproveActivity());
        pageDefine.setVersion(tmActivity.isFlowEngine() != false ? "1.0" : "2.0");
        pageDefine.setDomain(tmPage.getDomain());
        this.initFinishedInfo(executeContext, pageDefine, tmPage);
        pageDefine.setDataKeyProperties(tmPage.getDataKeyProperties());
        pageDefine.setSubjectExpect(tmPage.getSubjectExpect());
        pageDefine.setSubjectShortfall(tmPage.getSubjectShortfall());
        pageDefine.setDataStateCount(tmPage.getDataStates() == null ? 0 : tmPage.getDataStates().size());
        this.tmOtherInfoService.analysis((PcUiBotPageDefine)pageDefine, tmPage, ((DigiwinAtmcTaskWithBacklogData)executeContext.getTaskWithBacklogDataList().get(0)).getBpmData());
        pageDefine.setBindForm(tmActivity.getBindForm());
        pageDefine.setFieldConfig(tmActivity.getFieldConfig());
    }

    private void initFinishedInfo(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmPage tmPage) {
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)executeContext.getTaskWithBacklogDataList()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)((DigiwinAtmcTaskWithBacklogData)executeContext.getTaskWithBacklogDataList().get(0)).getBacklog())) {
            String finishedActionId = ((DigiwinAtmcBacklogData)((DigiwinAtmcTaskWithBacklogData)executeContext.getTaskWithBacklogDataList().get(0)).getBacklog().get(0)).getFinishedActionId();
            if (!StringUtils.isEmpty((Object)finishedActionId)) {
                for (DigiwinAtmcTaskWithBacklogData withBacklogData : executeContext.getTaskWithBacklogDataList()) {
                    if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((DigiwinAtmcBacklogData)withBacklogData.getBacklog().get(0)).getFinishedActionId())) continue;
                    finishedActionId = null;
                    break;
                }
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)finishedActionId)) {
                pageDefine.setFinished(Boolean.valueOf(true));
                pageDefine.setFinishedActionId(finishedActionId);
                List submitActions = null;
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tmPage.getDataStates())) {
                    for (PcUiBotTmDataState dataState : tmPage.getDataStates()) {
                        if (org.springframework.util.CollectionUtils.isEmpty((Collection)dataState.getSubmitActions())) continue;
                        submitActions = dataState.getSubmitActions();
                        break;
                    }
                }
                if (submitActions != null) {
                    for (PcUiBotTmAction submitAction : submitActions) {
                        if (!Objects.equals(submitAction.getId(), finishedActionId) && !Objects.equals(submitAction.getActionId(), finishedActionId)) continue;
                        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)submitAction.getReturnText())) {
                            pageDefine.setFinishedTitle(submitAction.getTitle());
                        } else {
                            pageDefine.setFinishedTitle(ProjectPageDefineAnalyzer.getMessageWithLanguage((String)submitAction.getReturnText(), (String)executeContext.getLocale()));
                        }
                        break;
                    }
                }
            } else {
                boolean isFinished = executeContext.getTaskWithBacklogDataList().stream().filter(x -> Objects.equals(((DigiwinAtmcBacklogData)x.getBacklog().get(0)).isClosed(), false)).count() <= 0L;
                pageDefine.setFinished(Boolean.valueOf(isFinished));
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pageDefine.getFinishedTitle())) {
                if (Objects.equals(finishedActionId, "athena_bpm_reassign")) {
                    pageDefine.setFinishedTitle("\u8f6c\u6d3e");
                } else if (Objects.equals(finishedActionId, "athena_bpm_cancel")) {
                    pageDefine.setFinishedTitle("\u64a4\u9500");
                } else if (Objects.equals(finishedActionId, "uibot_retrive")) {
                    pageDefine.setFinishedTitle("\u5df2\u64a4\u56de");
                } else if (Objects.equals(finishedActionId, "uibot_action_id_finished")) {
                    pageDefine.setFinishedTitle("\u5df2\u7ed3\u675f");
                } else if (Objects.equals(finishedActionId, "athena_overdue_task_terminate")) {
                    pageDefine.setFinishedTitle("\u903e\u671f\u7ec8\u6b62");
                }
            }
        }
    }

    public static String getMessageWithLanguage(String message, String language) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)message)) {
            return message;
        }
        try {
            Map map = (Map)JsonUtil.jsonStringToObject((String)message, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return (String)map.get(language);
        }
        catch (Exception ex) {
            return message;
        }
    }

    protected void analysisOperators(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {
        this.tmPageOperationService.createOperations(executeContext, (PcUiBotPageDefine)pageDefine, tmActivity, operations);
    }

    protected void analysisDataSource(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSet = this.tmProjectDataSourceService.analysis(executeContext, tmActivity, dataSources, tmDataFilter);
        pageDefine.setDataSourceSet(dataSourceSet);
        if (tmDataFilter != null) {
            pageDefine.setQueryTitle(tmDataFilter.getTitle());
            pageDefine.setRowSizeType(tmDataFilter.getRowSizeType());
        }
    }

    protected void analysisAllDataSource(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSet = this.tmProjectDataSourceService.analysis(executeContext, tmActivity, tmActivity.getDataSources(), tmDataFilter);
        pageDefine.setAllDataSourceSet(dataSourceSet);
    }

    protected void analysisSubmitActions(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
        String executeType = tmActivity.getExecuteType();
        DigiwinAtmcProjectData projectData = executeContext.getProjectData();
        if (projectData == null || Objects.equals(projectData.getProjectCardState(), 3)) {
            return;
        }
        if ("auto".equals(executeType)) {
            if (executeContext.getTaskWithBacklogData() == null || CollectionUtils.isEmpty((Collection)executeContext.getTaskWithBacklogData().getBacklog())) {
                return;
            }
            for (PcUiBotTmAction tmAction : submitActions) {
                if (PcUiBotSubmitActionUtil.isReturnOrTaskWithdrawAction((PcUiBotTmAction)tmAction)) continue;
                return;
            }
        }
        this.newTaskSubmitService.createTaskSubmit(executeContext, tmActivity, dataState, (PcUiBotPageDefine)pageDefine);
        this.setSubmitTypeBatch(pageDefine.getSubmitActions());
    }

    private void setSubmitTypeBatch(List<PcUiBotSubmitAction> actionList) {
        if (CollectionUtils.isNotEmpty(actionList)) {
            for (PcUiBotSubmitAction submitAction : actionList) {
                PcUiBotSubmitType submitType = submitAction.getSubmitType();
                if (submitType != null) {
                    submitType.setIsBatch(Boolean.valueOf(true));
                }
                this.setSubmitTypeBatch(submitAction.getAttachActions());
            }
        }
    }
}

