/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser;

import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.ActionDataSourceAnalysisService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.NewTaskSubmitActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.SubmitActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TaskSubmitActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmApprovalService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;

public abstract class AbstractCombineSubmitActionParser {
    @Lazy
    @Autowired
    protected SubmitActionCreateService submitActionCreateService;
    @Lazy
    @Autowired
    protected TaskSubmitActionCreateService taskSubmitActionCreateService;
    @Lazy
    @Autowired
    protected NewTaskSubmitActionCreateService newTaskSubmitActionCreateService;
    @Lazy
    @Autowired
    protected TmApprovalService tmApprovalService;
    @Lazy
    @Autowired
    protected ActionDataSourceAnalysisService tmDataSourceService;
    protected PcUiBotTmDataState tmDataState;
    protected PcUiBotPageDefine pageDefine;

    protected void init(PcUiBotTmDataState tmDataState) {
        this.tmDataState = tmDataState;
    }

    protected void init(PcUiBotTmDataState tmDataState, PcUiBotPageDefine pageDefine) {
        this.tmDataState = tmDataState;
        this.pageDefine = pageDefine;
    }

    public List<PcUiBotSubmitAction> parse(List<PcUiBotTmAction> tmActionList) {
        tmActionList = Optional.ofNullable(tmActionList).orElse(Lists.newArrayList());
        ArrayList submitActionList = Lists.newArrayList();
        for (PcUiBotTmAction tmAction : tmActionList) {
            PcUiBotSubmitAction submitAction;
            if ("COMBINE".equals(tmAction.getType()) || !CollectionUtils.isEmpty((Collection)tmAction.getCombineActions())) {
                List combineActions = tmAction.getCombineActions();
                if (CollectionUtils.isEmpty((Collection)combineActions)) {
                    throw new ServiceException("\u7ec4\u5408\u6309\u94ae\u7f3a\u5c11\u5fc5\u8981\u914d\u7f6e");
                }
                List combineSubmitActionList = this.parse(combineActions);
                submitAction = this.buildCombineSubmitAction(tmAction, combineSubmitActionList);
                tmAction.setType("COMBINE");
            } else {
                submitAction = this.buildSubmitAction(tmAction);
            }
            if (submitAction != null) {
                submitAction.setType(tmAction.getType());
            }
            submitActionList.add(submitAction);
        }
        submitActionList.removeAll(Collections.singletonList(null));
        return submitActionList;
    }

    protected abstract PcUiBotSubmitAction buildSubmitAction(PcUiBotTmAction var1);

    protected PcUiBotSubmitAction buildCombineSubmitAction(PcUiBotTmAction tmAction, List<PcUiBotSubmitAction> combineSubmitActionList) {
        if (CollectionUtils.isEmpty(combineSubmitActionList)) {
            return null;
        }
        PcUiBotSubmitAction submitAction = new PcUiBotSubmitAction();
        submitAction.setCombineActions(combineSubmitActionList);
        submitAction.setActionType(tmAction.getActionType());
        submitAction.setDefaultAction(tmAction.isDefaultAction());
        submitAction.setUuid(tmAction.getUuid());
        submitAction.setBtnId(tmAction.getBtnId());
        submitAction.setBtnType(tmAction.getBtnType());
        submitAction.setJumpAction(tmAction.getJumpAction());
        submitAction.setTitle(tmAction.getTitle());
        submitAction.setId(tmAction.getId());
        submitAction.setSubmitType(tmAction.getSubmitType());
        submitAction.setCategory(tmAction.getType());
        if (tmAction.getIgnoreRule() != null) {
            submitAction.setIgnoreRule(tmAction.getIgnoreRule());
        }
        return submitAction;
    }

    protected void setSubmitType(PcUiBotSubmitAction submitAction, String mainDataSourceName) {
        if (submitAction == null) {
            return;
        }
        if (submitAction.getSubmitType() == null) {
            if (this.tmDataState.getSubmitType() != null) {
                submitAction.setSubmitType(this.tmDataState.getSubmitType());
            } else {
                PcUiBotSubmitType submitType = new PcUiBotSubmitType();
                submitType.setIsBatch(Boolean.FALSE);
                submitType.setSchema(mainDataSourceName);
                submitAction.setSubmitType(submitType);
                this.tmDataState.setSubmitType(submitType);
            }
        }
    }
}

