/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.DataSourceAnalysisServiceBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.DataSourceDTOFactory;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.QueryActionCreateService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActionDataSourceAnalysisService
extends DataSourceAnalysisServiceBase {
    @Autowired
    private QueryActionCreateService queryActionService;

    public PcUiBotDataSourceDTO analysisHasParas(PcUiBotExecuteContext executeContext, String dataSourceName, PcUiBotTmQueryAction tmAction, Map paras) {
        if (StringUtils.isEmpty((CharSequence)dataSourceName)) {
            dataSourceName = tmAction.getName();
        }
        PcUiBotQueryAction queryAction = null;
        switch (tmAction.getType()) {
            case "ESP": 
            case "TM": 
            case "RAWDATA": 
            case "SD": 
            case "LCDP": {
                queryAction = this.queryActionService.createQueryHasParasAction(executeContext.getTenantId(), executeContext.getBusinessUnit(), tmAction, paras, executeContext);
                queryAction.setCategory(tmAction.getType());
            }
        }
        if (queryAction != null) {
            return DataSourceDTOFactory.create((PcUiBotTmQueryAction)tmAction, queryAction, (String)dataSourceName, null, (boolean)true);
        }
        return null;
    }

    public PcUiBotDataSourceDTO analysis(PcUiBotExecuteContext executeContext, String dataSourceName, PcUiBotTmQueryAction tmAction, Map bpmData) {
        if (StringUtils.isEmpty((CharSequence)dataSourceName)) {
            dataSourceName = tmAction.getName();
        }
        PcUiBotQueryAction queryAction = null;
        switch (tmAction.getType()) {
            case "ATMC": 
            case "ESP": 
            case "TM": 
            case "RAWDATA": 
            case "SD": 
            case "LCDP": {
                queryAction = this.queryActionService.createQueryAction(executeContext.getTenantId(), executeContext.getBusinessUnit(), null, tmAction, bpmData, executeContext);
                queryAction.setCategory(tmAction.getType());
                break;
            }
            case "PTM_DATA": {
                Map map;
                List workitemList;
                List backlogData;
                queryAction = this.queryActionService.createQueryAction(executeContext.getTenantId(), executeContext.getBusinessUnit(), null, tmAction, bpmData, executeContext);
                DigiwinAtmcTaskWithBacklogData taskWithBacklogData = executeContext.getTaskWithBacklogData();
                if (taskWithBacklogData == null || taskWithBacklogData.getBacklog() == null || CollectionUtils.isEmpty((Collection)(backlogData = taskWithBacklogData.getBacklog())) || CollectionUtils.isEmpty((Collection)(workitemList = ((DigiwinAtmcBacklogData)backlogData.get(0)).getWorkitemList())) || (map = (Map)workitemList.get(0)) == null) break;
                String workitemId = MapUtils.getString((Map)map, (Object)"id");
                HashMap<String, String> paras = queryAction.getParas();
                if (paras == null) {
                    paras = new HashMap<String, String>();
                    queryAction.setParas(paras);
                }
                paras.put("workItemId", workitemId);
                break;
            }
            case "MIX_MERGE": {
                if (tmAction.getLeft() == null) {
                    throw new IllegalArgumentException("\u5408\u5e76\u6570\u636e\u96c6\u7684\u5de6\u8fb9\u662fnull");
                }
                if (CollectionUtils.isEmpty((Collection)tmAction.getRightList())) {
                    throw new IllegalArgumentException("\u5408\u5e76\u6570\u636e\u96c6\u7684\u53f3\u8fb9\u662fnull");
                }
                PcUiBotDataSourceDTO left = this.analysis(executeContext, "left", tmAction.getLeft(), bpmData);
                ArrayList<PcUiBotDataSourceDTO> rightList = new ArrayList<PcUiBotDataSourceDTO>();
                int index = 0;
                for (PcUiBotTmQueryAction tmQueryAction : tmAction.getRightList()) {
                    PcUiBotDataSourceDTO dataSourceBase = this.analysis(executeContext, "rigth-" + index, tmQueryAction, bpmData);
                    rightList.add(dataSourceBase);
                    ++index;
                }
                PcUiBotDataSourceDTO mergeDataSource = new PcUiBotDataSourceDTO();
                mergeDataSource.setType("MIX_MERGE");
                mergeDataSource.setLeft(left);
                mergeDataSource.setRightList(rightList);
                mergeDataSource.setName(dataSourceName);
                mergeDataSource.setActionId(tmAction.getLeft().getActionId());
                mergeDataSource.setDataKeys(tmAction.getLeft().getDataKeys());
                mergeDataSource.setMetadataFields(tmAction.getMetadataFields());
                return mergeDataSource;
            }
            case "MIX_LEFT_JOIN": {
                if (tmAction.getLeft() == null) {
                    throw new IllegalArgumentException("\u5408\u5e76\u6570\u636e\u96c6\u7684\u5de6\u8fb9\u662fnull");
                }
                if (CollectionUtils.isEmpty((Collection)tmAction.getRightList())) {
                    throw new IllegalArgumentException("\u5408\u5e76\u6570\u636e\u96c6\u7684\u53f3\u8fb9\u662fnull");
                }
                PcUiBotDataSourceDTO left = this.analysis(executeContext, "left", tmAction.getLeft(), bpmData);
                ArrayList<PcUiBotDataSourceDTO> rightList = new ArrayList<PcUiBotDataSourceDTO>();
                int index = 0;
                for (PcUiBotTmQueryAction tmQueryAction : tmAction.getRightList()) {
                    PcUiBotDataSourceDTO dataSourceBase = this.analysis(executeContext, "rigth-" + index, tmQueryAction, bpmData);
                    rightList.add(dataSourceBase);
                    ++index;
                }
                PcUiBotDataSourceDTO leftJoinDataSource = new PcUiBotDataSourceDTO();
                leftJoinDataSource.setType("MIX_LEFT_JOIN");
                leftJoinDataSource.setLeft(left);
                leftJoinDataSource.setRightList(rightList);
                leftJoinDataSource.setName(dataSourceName);
                leftJoinDataSource.setActionId(tmAction.getLeft().getActionId());
                leftJoinDataSource.setDataKeys(tmAction.getLeft().getDataKeys());
                leftJoinDataSource.setMetadataFields(tmAction.getMetadataFields());
                leftJoinDataSource.setOverride(tmAction.getOverride());
                return leftJoinDataSource;
            }
        }
        if (queryAction != null) {
            return DataSourceDTOFactory.create((PcUiBotTmQueryAction)tmAction, queryAction, (String)dataSourceName, null, (boolean)true);
        }
        return null;
    }
}

