/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataElement;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataResponse;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataPrecision;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MetadataService {
    private static String patternStr = "^\\((?<length>\\d*?),(?<place>\\d*?)\\)$|^(?<size>\\d*?)$";
    private static Pattern pattern = Pattern.compile(patternStr);

    public PcUiBotApiMetadata createApiMetadata(KnowledgeMapsActionMetadataQueryResult metadataDataDTO) {
        PcUiBotApiMetadata apiMetadata = new PcUiBotApiMetadata();
        String actionId = metadataDataDTO.getActionId();
        String serviceName = metadataDataDTO.getServiceName();
        apiMetadata.setActionId(actionId);
        apiMetadata.setServiceName(serviceName);
        if (metadataDataDTO.getRequest() != null && metadataDataDTO.getRequest().getParameters() != null) {
            apiMetadata.setRequestFields(MetadataService.createMetadataField(new ArrayList(), (List)metadataDataDTO.getRequest().getParameters()));
        }
        if (metadataDataDTO.getResponse() != null && metadataDataDTO.getResponse().getData() != null) {
            apiMetadata.setResponseFields(MetadataService.createMetadataField(new ArrayList(), (KnowledgeMapsActionMetadataElement)metadataDataDTO.getResponse().getData()));
        }
        return apiMetadata;
    }

    public PcUiBotApiMetadata createApiMetadata(String actionId, String serviceName, Object apiMetadataObj) {
        KnowledgeMapsActionMetadataQueryResult metadataDataDTO = new KnowledgeMapsActionMetadataQueryResult();
        metadataDataDTO.setActionId(actionId);
        metadataDataDTO.setServiceName(serviceName);
        KnowledgeMapsActionMetadataElement data = (KnowledgeMapsActionMetadataElement)JsonUtil.objectToJavaObject((Object)apiMetadataObj, KnowledgeMapsActionMetadataElement.class);
        KnowledgeMapsActionMetadataResponse responseDTO = new KnowledgeMapsActionMetadataResponse();
        responseDTO.setData(data);
        metadataDataDTO.setResponse(responseDTO);
        PcUiBotApiMetadata apiMetadata = new PcUiBotApiMetadata();
        apiMetadata.setActionId(actionId);
        apiMetadata.setServiceName(serviceName);
        if (metadataDataDTO.getRequest() != null && metadataDataDTO.getRequest().getParameters() != null) {
            apiMetadata.setRequestFields(MetadataService.createMetadataField(new ArrayList(), (List)metadataDataDTO.getRequest().getParameters()));
        }
        if (metadataDataDTO.getResponse() != null && metadataDataDTO.getResponse().getData() != null) {
            apiMetadata.setResponseFields(MetadataService.createMetadataField(new ArrayList(), (KnowledgeMapsActionMetadataElement)metadataDataDTO.getResponse().getData()));
        }
        return apiMetadata;
    }

    private static List<PcUiBotMetadataField> createMetadataField(List<PcUiBotMetadataField> requestFields, List<KnowledgeMapsActionMetadataElement> metadataFieldDTOs) {
        for (KnowledgeMapsActionMetadataElement metadataFieldDTO : metadataFieldDTOs) {
            Matcher m;
            PcUiBotMetadataField metadataField = new PcUiBotMetadataField();
            metadataField.setName(metadataFieldDTO.getDataName());
            if (metadataFieldDTO.getRequired() == null) {
                metadataField.setRequired(false);
            } else {
                metadataField.setRequired("true".equalsIgnoreCase(metadataFieldDTO.getRequired().toString()));
            }
            metadataField.setDescription(metadataFieldDTO.getDescription());
            metadataField.setRemark(metadataFieldDTO.getRemark());
            metadataField.setBusinessKey("true".equalsIgnoreCase(StringUtil.valueOf((Object)metadataFieldDTO.getIsBusinesskey())));
            metadataField.setDataKey(metadataFieldDTO.getIsDatakey());
            metadataField.setDataType(metadataFieldDTO.getDataType());
            metadataField.setEnumKey(StringUtil.valueOf((Object)metadataFieldDTO.getEnumKey()));
            if (metadataFieldDTO.getPrecision() != null && (m = pattern.matcher(StringUtil.valueOf((Object)metadataFieldDTO.getPrecision()))).matches()) {
                PcUiBotMetadataPrecision precision = new PcUiBotMetadataPrecision();
                if (m.group("size") != null) {
                    precision.setLength(Integer.valueOf(Integer.parseInt(m.group("size"))));
                    metadataField.setPrecision(precision);
                } else if (m.group("length") != null && m.group("place") != null) {
                    precision.setLength(Integer.valueOf(Integer.parseInt(m.group("length"))));
                    precision.setPlace(Integer.valueOf(Integer.parseInt(m.group("place"))));
                    metadataField.setPrecision(precision);
                }
            }
            metadataField.setArray(metadataFieldDTO.getIsArray().booleanValue());
            if (!CollectionUtils.isEmpty((Collection)metadataFieldDTO.getField())) {
                ArrayList subRequestFields = new ArrayList();
                metadataField.setSubFields(MetadataService.createMetadataField(subRequestFields, (List)metadataFieldDTO.getField()));
            }
            requestFields.add(metadataField);
        }
        return requestFields;
    }

    private static List<PcUiBotMetadataField> createMetadataField(List<PcUiBotMetadataField> requestFields, KnowledgeMapsActionMetadataElement metadataFieldDTO) {
        PcUiBotMetadataField metadataField = new PcUiBotMetadataField();
        metadataField.setName(metadataFieldDTO.getDataName());
        if (metadataFieldDTO.getRequired() == null) {
            metadataField.setRequired(false);
        } else {
            metadataField.setRequired("true".equalsIgnoreCase(metadataFieldDTO.getRequired().toString()));
        }
        metadataField.setDescription(metadataFieldDTO.getDescription());
        metadataField.setRemark(metadataFieldDTO.getRemark());
        metadataField.setDataKey(metadataFieldDTO.getIsDatakey());
        metadataField.setBusinessKey("true".equalsIgnoreCase(StringUtil.valueOf((Object)metadataFieldDTO.getIsBusinesskey())));
        metadataField.setDataType(metadataFieldDTO.getDataType());
        metadataField.setArray(metadataFieldDTO.getIsArray().booleanValue());
        metadataField.setEnumKey(StringUtil.valueOf((Object)metadataFieldDTO.getEnumKey()));
        if (!CollectionUtils.isEmpty((Collection)metadataFieldDTO.getField())) {
            ArrayList subRequestFields = new ArrayList();
            metadataField.setSubFields(MetadataService.createMetadataField(subRequestFields, (List)metadataFieldDTO.getField()));
        }
        requestFields.add(metadataField);
        return requestFields;
    }
}

