/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import cn.hutool.core.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.rule.DesignerTrigger;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfigRepository;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsRuleQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.PcRuleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.ShowFieldService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PcRuleService {
    private static final String PAGE_SUFFIX = "page1";
    @Autowired
    private ShowFieldService showFieldService;
    @Autowired
    protected DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private MobileDesignerConfigRepository mobileDesignerConfigRepository;

    public void rulePostProcessor(ProcessType processType, UiBotModel dynamicForm, QueryResultSet queryResultSet) {
        this.showFieldService.removeWordHiddenRule(dynamicForm.getRules());
        this.dealHooksRule(dynamicForm);
        this.addProjectDetailRule(dynamicForm.getExecuteContext(), queryResultSet, dynamicForm.getActions(), dynamicForm.getRules());
    }

    public void removeEditRule(UiBotModel dynamicForm) {
        String pageCode = Optional.of(dynamicForm).map(UiBotModel::getExecuteContext).map(ex -> ex.getString("pageCode")).orElse(null);
        if ("browse-page-mobile".equals(pageCode)) {
            List rules = dynamicForm.getRules();
            this.removeEditRule(rules);
        }
    }

    public void removeEditRule(List<UiBotRule> rules) {
        rules.removeIf(rule -> Objects.equals("EDIT", rule.getScope()));
    }

    private void dealHooksRule(UiBotModel dynamicForm) {
    }

    private void addProjectDetailRule(UiBotExecuteContext executeContext, QueryResultSet queryResultSet, List<UiBotAction> actions, List<UiBotRule> rules) {
        List actionList;
        if (executeContext == null) {
            return;
        }
        String pageCode = executeContext.getString("pageCode");
        List submitActions = (List)JsonUtil.objectToJavaObject(actions, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if ("project-detail-mobile".equals(pageCode) && PcUiBotSubmitActionUtil.hasSubmitTypeBatch((List)submitActions) && !CollectionUtils.isEmpty((Collection)(actionList = PcUiBotSubmitActionUtil.onlyKeepWithdrawAction((List)submitActions)))) {
            UiBotRule rule = new UiBotRule();
            rule.setSchema("uibot_checked");
            rule.setPath(queryResultSet.getDataSourceNameFromApiResp());
            rule.setKey("disabled");
            DesignerTrigger trigger = new DesignerTrigger();
            trigger.setCondition("data.activity__backLog__data.projectState == 3");
            rule.setTrigger(trigger);
            rules.add(rule);
        }
    }

    public static boolean exist(List<Map<String, Object>> rules, String schema, String key) {
        for (Map<String, Object> rule : rules) {
            String keyFromRule = MapUtil.getStr(rule, (Object)"key", (String)"");
            String schemaFromRule = MapUtil.getStr(rule, (Object)"schema", (String)"");
            if (!keyFromRule.equals(key) || !schemaFromRule.equals(schema)) continue;
            return true;
        }
        return false;
    }

    public List<UiBotRule> buildRuleOfKm(String tmActivityId, String locale, String iamUserToken, String tenantId) {
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        map.put("include", Lists.newArrayList((Object[])new String[]{"contentMobile"}));
        DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId)).bodyPayloadMap("activityId", (Object)tmActivityId).bodyPayloadMap("count", (Object)-1).bodyPayloadMap("features", map).build();
        return this.filterRules(this.buildRule(this.digiwinKnowledgeMapsProxyService.getRuleQueryResult(athenaApiRequest)));
    }

    public List<UiBotRule> buildRule(KnowledgeMapsRuleQueryResult ruleQueryResult) {
        if (null == ruleQueryResult || CollectionUtils.isEmpty((Collection)ruleQueryResult.getRules())) {
            return new ArrayList<UiBotRule>();
        }
        return ruleQueryResult.getRules().stream().filter(rule -> !CollectionUtils.isEmpty((Map)rule.getContentMobile())).map(rule -> {
            UiBotRule uiBotRule = (UiBotRule)JsonUtil.objectToJavaObject((Object)rule.getContentMobile(), UiBotRule.class);
            uiBotRule.setName(rule.getName());
            Optional<String> apiPrefixType = Optional.ofNullable(uiBotRule.getTrigger()).map(DesignerTrigger::getApiPrefixType);
            if (apiPrefixType.isPresent() && StringUtils.isNotEmpty((CharSequence)apiPrefixType.get().trim())) {
                String prefixUrl = AppContext.getUrl((String)apiPrefixType.get());
                Optional<String> apiUrl = Optional.ofNullable(uiBotRule.getTrigger()).map(DesignerTrigger::getApiUrl);
                if (apiUrl.isPresent() && StringUtils.isNotEmpty((CharSequence)apiUrl.get().trim())) {
                    uiBotRule.getTrigger().setApiUrl(prefixUrl + apiUrl.get());
                }
            }
            return uiBotRule;
        }).collect(Collectors.toList());
    }

    public List<UiBotRule> buildRuleOfLocal(String tmActivityId, String type) {
        return this.filterRules(this.buildRule((KnowledgeMapsRuleQueryResult)JsonUtil.objectToJavaObject((Object)this.mobileDesignerConfigRepository.selectAllRule(tmActivityId, type), KnowledgeMapsRuleQueryResult.class)));
    }

    private List<UiBotRule> filterRules(List<UiBotRule> uiBotRules) {
        ArrayList<UiBotRule> rules = new ArrayList<UiBotRule>();
        if (CollectionUtils.isEmpty(uiBotRules)) {
            return rules;
        }
        String currentPageId = AppRequestContext.getContextEntity().getPageId();
        PageSettingIdPresetEnum enumPageId = PageSettingIdPresetEnum.getEnumByName((String)currentPageId);
        uiBotRules.forEach(rule -> {
            String pageId = rule.getPageId();
            if (StringUtils.isEmpty((CharSequence)pageId)) {
                rules.add((UiBotRule)rule);
                return;
            }
            if (enumPageId != null) {
                if (pageId.endsWith(PAGE_SUFFIX)) {
                    rules.add((UiBotRule)rule);
                }
            } else {
                if (StringUtils.isEmpty((CharSequence)currentPageId) && pageId.endsWith(PAGE_SUFFIX)) {
                    rules.add((UiBotRule)rule);
                    return;
                }
                if (StringUtils.isNotEmpty((CharSequence)currentPageId) && currentPageId.equalsIgnoreCase(pageId)) {
                    rules.add((UiBotRule)rule);
                }
            }
        });
        return rules;
    }
}

