/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataProcess;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.DataSourceAnalysisServiceBase;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TmDataSourceService
extends DataSourceAnalysisServiceBase {
    public PcUiBotDataSourceSetDTO analysis(PcUiBotExecuteContext executeContext, Map<String, PcUiBotTmQueryAction> dataSources) {
        PcUiBotDataSourceSetDTO dataSourceSet = new PcUiBotDataSourceSetDTO();
        if (CollectionUtils.isEmpty(dataSources)) {
            return dataSourceSet;
        }
        dataSourceSet.setDataSourceList((List)Lists.newArrayList());
        List dataSourceList = dataSourceSet.getDataSourceList();
        for (Map.Entry<String, PcUiBotTmQueryAction> tmQueryActionEntry : dataSources.entrySet()) {
            PcUiBotTmQueryAction queryAction = tmQueryActionEntry.getValue();
            PcUiBotDataSourceDTO dataSourceBase = this.createDataSourceWithoutTask(executeContext, tmQueryActionEntry.getKey(), queryAction);
            if (dataSourceBase == null) continue;
            dataSourceBase.setLimit(queryAction.getLimit());
            dataSourceBase.setNotArray(queryAction.getNotArray());
            dataSourceBase.setMetadataFields(queryAction.getMetadataFields());
            dataSourceList.add(dataSourceBase);
        }
        for (PcUiBotTmQueryAction queryAction : dataSources.values()) {
            if (CollectionUtils.isEmpty((Collection)queryAction.getDataProcessors())) continue;
            for (PcUiBotTmDataProcess dataProcessor : queryAction.getDataProcessors()) {
                if (!"executeCompleted".equals(dataProcessor.getActivePoint())) continue;
                if (null == dataSourceSet.getDataProcess()) {
                    dataSourceSet.setDataProcess(new ArrayList());
                }
                dataSourceSet.getDataProcess().add(dataProcessor);
            }
        }
        return dataSourceSet;
    }
}

