/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.apposition.Apposition;
import com.digiwin.mobile.mobileuibot.core.component.apposition.AppositionData;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbUserAddress;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildZTBAddressBookStrategy")
public class UiBotModelBuildZTBAddressBookStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildZTBAddressBookStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildAddressBook");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        List ztbUserAddressList;
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        Object rawData = apiRequest.getRawData();
        UiBotPageData pageData = uiBotModel.getPageData();
        if (CollectionUtils.isEmpty((Map)rawData)) {
            rawData = new HashMap(2);
            rawData.put("pageNo", "1");
            rawData.put("pageSize", "9999");
        }
        if (CollectionUtils.isEmpty((Collection)(ztbUserAddressList = this.digiwinEspProxyService.getuserAddressList(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), (Map)rawData)))) {
            return UiBotModel.emptyUibotModel((String)apiRequest.getLocale());
        }
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case "APPOSITION": {
                    Apposition apposition = (Apposition)JsonUtil.objectToJavaObject((Object)pageData.get((Object)uiBotLayout.getSchema()), Apposition.class);
                    pageData.put((Object)uiBotLayout.getSchema(), (Object)this.buildAddressBookApposition(apposition, ztbUserAddressList, apiRequest));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)uiBotLayout.getSchema()), BottomButtonList.class);
                    bottomButtonList.forEach(button -> {
                        Action action = button.getAction();
                        if (action == null) {
                            action = new Action();
                            action.setType(ActionTypeEnum.CALL_API.getValue());
                        }
                        HashMap<String, String> actionRawData = new HashMap<String, String>(2);
                        actionRawData.put("page_id", apiRequest.getPageId());
                        actionRawData.put("biz_id", "ZTB");
                        action.setRawData(actionRawData);
                    });
                    pageData.put((Object)uiBotLayout.getSchema(), (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private Apposition buildAddressBookApposition(Apposition apposition, List<ZtbUserAddress> districts, ApiRequest apiRequest) {
        List datas = apposition.getDatas();
        for (ZtbUserAddress userAddress : districts) {
            datas.add(AppositionData.create((ZtbUserAddress)userAddress, (LocaleService)this.localeService, (ApiRequest)apiRequest));
        }
        return apposition;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = null;
        String data = FileUtil.readText((String)"static/addressBook.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

