/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleLabelPositionEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbDeliveryLoadingCount;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.AsnHeaderResponse;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class UiBotModelBuildZTBShippingTaskStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private ZhilinkService zhilinkService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        AsnHeaderResponse asnHeaderResponse;
        String tmActivityId;
        String tmTaskId;
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        Boolean isSubmit = false;
        String planArrivalDate = "";
        if (apiRawData.get((Object)"isSubmit") != null && ((Boolean)apiRawData.get((Object)"isSubmit")).booleanValue()) {
            isSubmit = true;
            planArrivalDate = apiRawData.getString("plan_arrival_date");
        }
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        if (null != apiRequest.getExtraParameter()) {
            tmTaskId = apiRequest.getExtraParameter().getTmTaskId();
            tmActivityId = apiRequest.getExtraParameter().getTmActivityId();
        } else {
            tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
            tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        }
        apiRawData.put("digi-proxy-token", (Object)digiwinAtmcBacklogDetail.getProxyToken());
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue()) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)apiRequest.getLocale());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List buttons = uiBotModel.getAppbarButtonList();
            HashMap<String, String> buttonActionRawData = new HashMap<String, String>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", (String)digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign((String)(digiwinAtmcBacklogDetail.getId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"TASK", (Integer)59096));
        }
        String taskNo = "";
        Map deliveryHead = (Map)pcUiBotModel.getPageData().get((Object)"delivery_head");
        if (!CollectionUtils.isEmpty((Map)deliveryHead)) {
            taskNo = (String)deliveryHead.get("task_no");
        }
        if (StringUtils.hasLength((String)(asnHeaderResponse = this.zhilinkService.getAsnHeaderByTaskNo(taskNo, apiRequest.getTenantId(), locale, apiRequest.getIamUserToken())).getPlanArrivalDate())) {
            planArrivalDate = asnHeaderResponse.getPlanArrivalDate();
        }
        Boolean noUnloading = false;
        ZtbDeliveryLoadingCount counts = this.digiwinEspProxyService.getDeliveryLoadingCount(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, taskNo);
        List ztbCargoUnloadings = this.digiwinEspProxyService.getDeliveryUnloadingList(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, taskNo);
        List ztbDriverVehicles = this.digiwinEspProxyService.getDeliveryLoadedCarList(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, taskNo);
        if (!CollectionUtils.isEmpty((Collection)ztbDriverVehicles)) {
            isSubmit = true;
        }
        if (CollectionUtils.isEmpty((Collection)ztbCargoUnloadings)) {
            noUnloading = true;
        }
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            String layoutType = layout.getType();
            String schema = layout.getSchema();
            switch (layoutType) {
                case "TITLE_BODY": {
                    TitleBody titleBody = TitleBody.create((String)locale, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail);
                    titleBody.setLabelPosition(TitleLabelPositionEnum.DOWN_TO_TITLE.getPosition());
                    pageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "BLANK_AREA": {
                    BlankArea area = (BlankArea)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), BlankArea.class);
                    pageData.put((Object)schema, (Object)area);
                    break;
                }
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = new CustomGroup();
                    if ("CUSTOM_GROUP_LOGISTICS".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildLogisticsGroup(locale, asnHeaderResponse, (UiBotModel)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), UiBotModel.class), Boolean.valueOf(isSubmit == false));
                    } else if ("plan_arrival_date".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildAppointmentDeliveryDate(locale, layout, this.localeService.getLanguageValue(locale, layout.getLabel()), isSubmit, planArrivalDate);
                    }
                    pageData.put((Object)schema, (Object)customGroup);
                    break;
                }
                case "CUSTOM_TABS": {
                    CustomTabs customTabs = (CustomTabs)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), CustomTabs.class);
                    customTabs.detailMessage(customTabs, counts, ztbCargoUnloadings, ztbDriverVehicles, this.localeService, locale, isSubmit, this.digiwinDmcProxyService);
                    pageData.put((Object)schema, (Object)customTabs);
                    break;
                }
                case "MULTI_FUNCTION_LIST": {
                    MultiFunctionList multiFunctionList = (MultiFunctionList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), MultiFunctionList.class);
                    multiFunctionList.setChoice(MultiFunctionListChoiceEnum.NO_CHOICE.toString());
                    multiFunctionList.setPageable(Boolean.valueOf(true));
                    multiFunctionList.setTitle(this.localeService.getLanguageValue(locale, multiFunctionList.getTitle()));
                    multiFunctionList.setSearch(Boolean.valueOf(false));
                    multiFunctionList.setDataUrl("/mobile/v1/ztb/cargo/information");
                    multiFunctionList.setStyleType(MultiFunctionListStyleTypeEnum.CARD.toString());
                    ApiRawData rawData = new ApiRawData();
                    rawData.put("task_no", (Object)taskNo);
                    rawData.put("isLoadCar", (Object)false);
                    multiFunctionList.setRawData(rawData);
                    pageData.put((Object)schema, (Object)multiFunctionList);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    if (noUnloading.booleanValue()) break;
                    ArrayList<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<BottomButtonDigiwinAthena>();
                    BottomButtonDigiwinAthena bottomButton = new BottomButtonDigiwinAthena();
                    bottomButton.setName(this.localeService.getLanguageValue(locale, "[-] \u626b\u63cf\u8f66\u8f86"));
                    bottomButton.setType(BottomButtonStyleEnum.STRESS.getValue());
                    Action action = new Action();
                    action.setType(ActionTypeEnum.OPEN_NATIVE_SCAN_COTAIN_OCR.getValue());
                    HashMap<String, Object> buttonRawData = new HashMap<String, Object>(4);
                    buttonRawData.put("task_no", taskNo);
                    buttonRawData.put("cargo_infomation", ztbCargoUnloadings == null ? Collections.emptyList() : ztbCargoUnloadings);
                    buttonRawData.put("ztbCargoUnloadingSize", CollectionUtils.isEmpty((Collection)ztbCargoUnloadings) ? 0 : ztbCargoUnloadings.size());
                    buttonRawData.put("biz_id", "ZTB");
                    buttonRawData.put("scanRequestId", ComponentSettingRequestIdEnum.OCR_ZTB_CAR_NUMBER);
                    buttonRawData.put("taskId", dataId);
                    buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                    buttonRawData.put("page_id", PageSettingIdPresetEnum.MOBILE_ZTB_SHIPPING_TASK.toString());
                    UiBotAction uiBotAction = this.getSubmitAction(pcUiBotModel, "submit-data");
                    if (uiBotAction != null) {
                        buttonRawData.put("action", uiBotAction);
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                        data.put(actionDataScheme, pcUiBotModel.getPageData().get((Object)actionDataScheme));
                        buttonRawData.put("data", data);
                    }
                    action.setRawData(buttonRawData);
                    bottomButton.setAction(action);
                    bottomButtonList.add(bottomButton);
                    pageData.put((Object)schema, bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotAction getSubmitAction(UiBotModel pcUiBotModel, String actionId) {
        List layoutList = pcUiBotModel.getLayout();
        if (CollectionUtils.isEmpty((Collection)layoutList)) {
            return null;
        }
        AtomicReference<UiBotAction> uiBotAction = new AtomicReference<UiBotAction>();
        block0: for (UiBotLayout layout : layoutList) {
            List actions = layout.getActions();
            if (CollectionUtils.isEmpty((Collection)actions)) continue;
            for (UiBotAction action : actions) {
                if (!actionId.equalsIgnoreCase(action.getActionId())) continue;
                uiBotAction.set(action);
                break block0;
            }
        }
        return (UiBotAction)uiBotAction.get();
    }
}

