/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildZTBTransportForwardingAgentStrategy")
public class UiBotModelBuildZTBTransportForwardingAgentStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildZTBTransportForwardingAgentStrategy.class);
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build ReceiptConfirmation");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        ApiRawData apiRawData;
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData2 = apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        if (StringUtils.hasLength((String)digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", (Object)digiwinAtmcBacklogDetail.getProxyToken());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List buttons = uiBotModel.getAppbarButtonList();
            HashMap<String, String> buttonActionRawData = new HashMap<String, String>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", (String)digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign((String)(digiwinAtmcBacklogDetail.getId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"TASK", (Integer)59096));
        }
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue()) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)apiRequest.getLocale());
        }
        String transportNo = "";
        String taskNo = "";
        List deliveryDetailList = (List)pcUiBotModel.getPageData().get((Object)"cargo_information");
        if (!CollectionUtils.isEmpty((Collection)deliveryDetailList)) {
            taskNo = String.valueOf(((Map)deliveryDetailList.get(0)).get("task_no"));
            transportNo = String.valueOf(((Map)deliveryDetailList.get(0)).get("transport_no"));
        }
        DigiwinTransportResponse transportMainInfo = this.digiwinEspProxyService.getTransportMainInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, transportNo);
        Map transportVehicleInfo = this.digiwinEspProxyService.getTransportVehicleInfo(iamUserToken, tenantId, locale, transportNo);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    TitleBody titleBody = TitleBody.create((String)locale, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail);
                    pageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "GRAPHIC_DISPLAY": {
                    pageData.put((Object)layout.getSchema(), (Object)GraphicDisplay.createNoSubTitle((ZTBDriverVehicle)((ZTBDriverVehicle)JsonUtil.objectToJavaObject((Object)transportVehicleInfo, ZTBDriverVehicle.class)), (Integer)1, (DigiwinDmcProxyService)this.digiwinDmcProxyService));
                    break;
                }
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = new CustomGroup();
                    if ("CUSTOM_GROUP_ONE".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildLogisticsGroup(locale, transportMainInfo, (UiBotModel)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), UiBotModel.class), Boolean.valueOf(false));
                    } else if ("CUSTOM_GROUP_FOUR".equalsIgnoreCase(schema)) {
                        customGroup = this.buildPlatFormMessageGroup(locale, transportMainInfo, (UiBotModel)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), UiBotModel.class), (String)((Map)uiBotModel.getPageData().get((Object)schema)).get("name"));
                    }
                    pageData.put((Object)schema, (Object)customGroup);
                    break;
                }
                case "PAGE_BUTTON": {
                    PageButton pageButton = (PageButton)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), PageButton.class);
                    pageButton.setName(this.localeService.getLanguageValue(locale, pageButton.getName()));
                    Action pageButtonAction = pageButton.getAction();
                    pageButtonAction.setDataId(transportNo);
                    pageButton.setAction(pageButtonAction);
                    pageData.put((Object)schema, (Object)pageButton);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    String finalTaskNo = taskNo;
                    String finalTransportNo = transportNo;
                    BottomButtonList newBottomButtonList = new BottomButtonList();
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        Action action;
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength((String)buttonName)) {
                            bottomButtonDigiwinAthena.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        if ((action = bottomButtonDigiwinAthena.getAction()) != null) {
                            if (action.getConfirmPop() != null && StringUtils.hasLength((String)action.getConfirmPop().getContent())) {
                                action.getConfirmPop().setContent(this.localeService.getLanguageValue(locale, action.getConfirmPop().getContent()));
                            } else if (StringUtils.hasLength((String)action.getJumpPageTitle())) {
                                action.setJumpPageTitle(this.localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                            }
                        }
                        Map<String, String> buttonRawData = new HashMap<String, String>();
                        if (action.getRawData() != null) {
                            buttonRawData = (Map)action.getRawData();
                        }
                        buttonRawData.put("task_no", finalTaskNo);
                        buttonRawData.put("transport_no", finalTransportNo);
                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                        UiBotAction uiBotAction = this.getSubmitAction(pcUiBotModel, "submit-data");
                        if (null != uiBotAction) {
                            buttonRawData.put("action", (String)uiBotAction);
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            data.put(actionDataScheme, pcUiBotModel.getPageData().get((Object)actionDataScheme));
                            buttonRawData.put("data", (String)((Object)data));
                        }
                        action.setRawData(buttonRawData);
                        newBottomButtonList.add(bottomButtonDigiwinAthena);
                    });
                    pageData.put((Object)schema, (Object)newBottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private CustomGroup buildPlatFormMessageGroup(String locale, DigiwinTransportResponse transportMainInfo, UiBotModel uiBotModel, String name) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(this.localeService.getLanguageValue(locale, name));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        Map dataMap = (Map)JsonUtil.jsonStringToObject((String)JsonUtil.javaObjectToJsonString((Object)transportMainInfo), Map.class);
        block6: for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "FIELD": {
                    if ("appoint_time".equalsIgnoreCase(schema)) {
                        String date = StringUtils.hasLength((String)transportMainInfo.getAppointmentDeliveryDate()) ? transportMainInfo.getAppointmentDeliveryDate() : "-";
                        String[] values = date.split(" ");
                        String value = "";
                        value = values.length > 1 ? values[0] : date;
                        pageData.put((Object)schema, (Object)Field.createLabelValueLeftFieldNoNewLine((String)((String)layout.getmLabelText().get(locale)), (String)value));
                        break;
                    }
                    if ("time_slot".equalsIgnoreCase(schema)) {
                        List timeSlots = transportMainInfo.getTimeSlot();
                        if (timeSlots == null || timeSlots.size() <= 0) continue block6;
                        String value = transportMainInfo.getTimeSlots(timeSlots);
                        pageData.put((Object)schema, (Object)Field.createLabelValueLeftFieldNoNewLine((String)((String)layout.getmLabelText().get(locale)), (String)value));
                        break;
                    }
                    pageData.put((Object)schema, (Object)Field.createLabelValueLeftFieldNoNewLine((String)((String)layout.getmLabelText().get(locale)), (String)((String)dataMap.get(schema))));
                    break;
                }
            }
        }
        CustomGroupContent content = new CustomGroupContent();
        content.setPageData(pageData);
        content.setLayout(uiBotLayouts);
        customGroup.setContent(content);
        customGroup.setHiddenConfig(new HiddenConfig());
        customGroup.setUseExpand(Boolean.valueOf(false));
        customGroup.setHasDetail(Boolean.valueOf(false));
        return customGroup;
    }

    private UiBotAction getSubmitAction(UiBotModel pcUiBotModel, String actionId) {
        List layoutList = pcUiBotModel.getLayout();
        if (CollectionUtils.isEmpty((Collection)layoutList)) {
            return null;
        }
        AtomicReference<UiBotAction> uiBotAction = new AtomicReference<UiBotAction>();
        block0: for (UiBotLayout layout : layoutList) {
            List actions = layout.getActions();
            if (CollectionUtils.isEmpty((Collection)actions)) continue;
            for (UiBotAction action : actions) {
                if (!actionId.equalsIgnoreCase(action.getActionId())) continue;
                uiBotAction.set(action);
                break block0;
            }
        }
        return (UiBotAction)uiBotAction.get();
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

