/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UiBotModelBuildZTBTransportStopAbnormalAlarmStrategy
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelBuildZTBTransportStopAbnormalAlarmStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        ApiRawData rawData = apiRequest.getRawData();
        log.debug("apiRequest:" + JSONUtil.toJsonStr((Object)apiRequest));
        log.debug("rawData:" + JSONUtil.toJsonStr((Object)rawData));
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List layoutList = uiBotModel.getLayout();
        for (UiBotLayout layout : layoutList) {
            String type = layout.getType();
            String schema = layout.getSchema();
            switch (type) {
                case "INPUT_MULTI": {
                    pageData.put((Object)schema, (Object)InputMultiText.create((String)schema, (String)((String)layout.getmLabelText().get(locale)), (String)"", (Boolean)true, (Boolean)false, (Boolean)false, (String)locale));
                    break;
                }
                case "BUTTON_SINGLE_SELECT": {
                    DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
                    pageData.put((Object)schema, (Object)ButtonSingleSelect.createByZtbStopAbnormalAlarm((UiBotLayout)layout, (String)locale, (Boolean)false, (Map)rawData, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String nameKey = bottomButtonDigiwinAthena.getName();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)nameKey));
                        if (ActionTypeEnum.CALL_API.getValue().equals(bottomButtonDigiwinAthena.getAction().getType())) {
                            Action action = bottomButtonDigiwinAthena.getAction();
                            Map<String, Object> buttonRawData = ObjectUtil.isEmpty((Object)action.getRawData()) ? new HashMap() : (Map)action.getRawData();
                            Object buttonActionId = buttonRawData.get("action_id");
                            if (StrUtil.equals((CharSequence)StrUtil.toString(buttonRawData.get("action_id")), (CharSequence)"cancel")) {
                                bottomButtonDigiwinAthena.setIsCheckButton(Boolean.valueOf(false));
                            }
                            buttonRawData.put("transport_no", rawData.get((Object)"transport_no"));
                            buttonRawData.put("task_no", rawData.get((Object)"task_no"));
                            buttonRawData.put("biz_id", "ZTB");
                            buttonRawData.put("page_id", pageSetting.getPageId());
                            buttonRawData.put("action", rawData.get((Object)"action"));
                            buttonRawData.put("data", rawData.get((Object)"data"));
                            buttonRawData.put("notValidInput", true);
                            buttonRawData.put("action_id", "stop");
                            buttonRawData.put("button_action_id", buttonActionId);
                            action.setRawData(buttonRawData);
                            bottomButtonDigiwinAthena.setAction(action);
                        }
                    });
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }
}

