/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.mapaddress.MapAddress;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCode;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleLabelPositionEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class UiBotModelBuildZTBTransportStrategy
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelBuildZTBTransportStrategy.class);
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String transportNo;
        String taskNo;
        List deliveryDetailList;
        String iamUserToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = "";
        String tmActivityId = "";
        if (null != apiRequest.getExtraParameter()) {
            tmTaskId = apiRequest.getExtraParameter().getTmTaskId();
            tmActivityId = apiRequest.getExtraParameter().getTmActivityId();
        } else {
            tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
            tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        }
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        apiRawData.put("digi-proxy-token", (Object)digiwinAtmcBacklogDetail.getProxyToken());
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue()) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)apiRequest.getLocale());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List buttons = uiBotModel.getAppbarButtonList();
            HashMap<String, String> buttonActionRawData = new HashMap<String, String>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", (String)digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign((String)(digiwinAtmcBacklogDetail.getId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"TASK", (Integer)59096));
        }
        if (!CollectionUtils.isEmpty((Collection)(deliveryDetailList = (List)pcUiBotModel.getPageData().get((Object)"cargo_information")))) {
            taskNo = String.valueOf(((Map)deliveryDetailList.get(0)).get("task_no"));
            transportNo = String.valueOf(((Map)deliveryDetailList.get(0)).get("transport_no"));
        } else {
            taskNo = "";
            transportNo = "";
        }
        DigiwinTransportResponse transportMainInfo = this.digiwinEspProxyService.getTransportMainInfo(iamUserToken, apiRequest.getTenantId(), locale, transportNo);
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    TitleBody titleBody = TitleBody.create((String)locale, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail);
                    titleBody.setLabelPosition(TitleLabelPositionEnum.DOWN_TO_TITLE.getPosition());
                    pageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "MAP_ADDRESS": {
                    pageData.put((Object)schema, (Object)MapAddress.create((String)schema, (DigiwinTransportResponse)transportMainInfo, (LocaleService)this.localeService, (String)locale));
                    break;
                }
                case "CARD": {
                    Card card = (Card)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), Card.class);
                    this.buildCard(card, locale, transportNo, transportMainInfo);
                    pageData.put((Object)schema, (Object)card);
                    break;
                }
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = new CustomGroup();
                    if ("CUSTOM_GROUP_LOGISTICS".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildLogisticsGroup(locale, transportMainInfo, (UiBotModel)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), UiBotModel.class), Boolean.valueOf(false));
                    } else if ("cargoInformation".equalsIgnoreCase(schema)) {
                        UiBotModel customUiboModel = (UiBotModel)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), UiBotModel.class);
                        List uiBotLayoutList = customUiboModel.getLayout();
                        UiBotPageData customPageData = customUiboModel.getPageData();
                        for (UiBotLayout uiBotLayout : uiBotLayoutList) {
                            switch (uiBotLayout.getType()) {
                                case "PAGE_BUTTON": {
                                    PageButton pageButton = new PageButton();
                                    pageButton.setName(this.localeService.getLanguageValue(locale, customUiboModel.getName()));
                                    Action pageButtonAction = (Action)JsonUtil.objectToJavaObject((Object)customPageData.get((Object)"action"), Action.class);
                                    pageButtonAction.setJumpPageTitle(this.localeService.getLanguageValue(locale, pageButtonAction.getJumpPageTitle()));
                                    pageButtonAction.setDataId(transportNo);
                                    pageButton.setAction(pageButtonAction);
                                    customPageData.put((Object)uiBotLayout.getSchema(), (Object)pageButton);
                                    break;
                                }
                            }
                        }
                        CustomGroupContent content = new CustomGroupContent();
                        content.setLayout(uiBotLayoutList);
                        content.setPageData(customPageData);
                        customGroup.setContent(content);
                        customGroup.setHiddenConfig(new HiddenConfig());
                        customGroup.setUseExpand(Boolean.valueOf(false));
                        customGroup.setHasDetail(Boolean.valueOf(false));
                    }
                    pageData.put((Object)schema, (Object)customGroup);
                    break;
                }
                case "PAGE_BUTTON": {
                    PageButton pageButton = (PageButton)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), PageButton.class);
                    pageButton.setName(this.localeService.getLanguageValue(locale, pageButton.getName()));
                    Action pageButtonAction = pageButton.getAction();
                    if ("cargoInformation".equalsIgnoreCase(schema)) {
                        pageButtonAction.setJumpPageTitle(this.localeService.getLanguageValue(locale, pageButtonAction.getJumpPageTitle()));
                        pageButtonAction.setDataId(transportNo);
                    } else if ("shippingSchedule".equalsIgnoreCase(schema)) {
                        pageButtonAction.setJumpPageTitle(this.localeService.getLanguageValue(locale, pageButtonAction.getJumpPageTitle()));
                        HashMap<String, String> params = new HashMap<String, String>(1);
                        params.put("module_type", "2");
                        String url = this.digiwinEspProxyService.getSrmLoadingWebUrl(iamUserToken, tenantId, locale, params) + "&userId=" + apiRequest.getUserId();
                        pageButtonAction.setRequestUrl(url);
                    }
                    pageButton.setAction(pageButtonAction);
                    pageData.put((Object)schema, (Object)pageButton);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    String finalTaskNo = taskNo;
                    String finalTransportNo = transportNo;
                    String arrivalStatus = StrUtil.isBlank((CharSequence)transportMainInfo.getArrivalStatus()) ? "0" : transportMainInfo.getArrivalStatus();
                    BottomButtonList newBottomButtonList = new BottomButtonList();
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        Action action;
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength((String)buttonName)) {
                            bottomButtonDigiwinAthena.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        if ((action = bottomButtonDigiwinAthena.getAction()) != null) {
                            if (action.getConfirmPop() != null && StringUtils.hasLength((String)action.getConfirmPop().getContent())) {
                                action.getConfirmPop().setContent(this.localeService.getLanguageValue(locale, action.getConfirmPop().getContent()));
                            } else if (StringUtils.hasLength((String)action.getJumpPageTitle())) {
                                action.setJumpPageTitle(this.localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                            }
                        }
                        Map<String, String> buttonRawData = new HashMap<String, String>();
                        if (action.getRawData() != null) {
                            buttonRawData = (Map)action.getRawData();
                        }
                        buttonRawData.put("task_no", finalTaskNo);
                        buttonRawData.put("transport_no", finalTransportNo);
                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                        UiBotAction uiBotAction = this.getSubmitAction(pcUiBotModel, "submit-data");
                        if (null != uiBotAction) {
                            buttonRawData.put("action", (String)uiBotAction);
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            data.put(actionDataScheme, pcUiBotModel.getPageData().get((Object)actionDataScheme));
                            buttonRawData.put("data", (String)((Object)data));
                        }
                        action.setRawData(buttonRawData);
                        List children = bottomButtonDigiwinAthena.getChildren();
                        if (!CollectionUtils.isEmpty((Collection)children)) {
                            for (BottomButtonDigiwinAthena button : children) {
                                Action action1;
                                if (StringUtils.hasLength((String)button.getName())) {
                                    button.setName(this.localeService.getLanguageValue(locale, button.getName()));
                                }
                                if (StringUtils.hasLength((String)button.getSubName())) {
                                    button.setSubName(this.localeService.getLanguageValue(locale, button.getSubName()));
                                }
                                if ((action1 = button.getAction()) != null) {
                                    if (StringUtils.hasLength((String)action1.getJumpPageTitle())) {
                                        action1.setJumpPageTitle(this.localeService.getLanguageValue(locale, action1.getJumpPageTitle()));
                                    }
                                    if (StringUtils.hasLength((String)action1.getToastMsg())) {
                                        action1.setToastMsg(this.localeService.getLanguageValue(locale, action1.getToastMsg()));
                                    }
                                    Map<String, String> childButtonRawData = new HashMap<String, String>();
                                    if (action1.getRawData() != null) {
                                        childButtonRawData = (Map)action1.getRawData();
                                    }
                                    childButtonRawData.put("transport_no", transportNo);
                                    childButtonRawData.put("task_no", taskNo);
                                    childButtonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                                    if (StrUtil.equals((CharSequence)StrUtil.toString(childButtonRawData.get("action_id")), (CharSequence)"receive_scan")) {
                                        QrCodeContentMsg qrCodeContentMsg = new QrCodeContentMsg("TRANSPORT_RECEIVE");
                                        qrCodeContentMsg.put("transport_no", transportNo);
                                        QrCode qrCode = QrCode.create((QrCodeContentMsg)qrCodeContentMsg, (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u626b\u63cf\u8fd0\u5355\u4e8c\u7ef4\u7801"));
                                        childButtonRawData.put("qrCode", (String)qrCode);
                                    }
                                    if (null != uiBotAction) {
                                        childButtonRawData.put("action", (String)uiBotAction);
                                        HashMap<String, Object> data = new HashMap<String, Object>();
                                        String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                                        data.put(actionDataScheme, pcUiBotModel.getPageData().get((Object)actionDataScheme));
                                        childButtonRawData.put("data", (String)((Object)data));
                                    }
                                    action1.setRawData(childButtonRawData);
                                }
                                this.setRequestUrl(button);
                            }
                        }
                        if (ObjectUtil.isNotEmpty(buttonRawData.get("action_id"))) {
                            if (StrUtil.equals((CharSequence)StrUtil.toString(buttonRawData.get("action_id")), (CharSequence)"transport_arrival")) {
                                if (StrUtil.equals((CharSequence)arrivalStatus, (CharSequence)"0")) {
                                    newBottomButtonList.add(bottomButtonDigiwinAthena);
                                }
                            } else if (StrUtil.equals((CharSequence)StrUtil.toString(buttonRawData.get("action_id")), (CharSequence)"transport_receive")) {
                                if (StrUtil.equals((CharSequence)arrivalStatus, (CharSequence)"1")) {
                                    newBottomButtonList.add(bottomButtonDigiwinAthena);
                                }
                            } else {
                                newBottomButtonList.add(bottomButtonDigiwinAthena);
                            }
                        } else {
                            newBottomButtonList.add(bottomButtonDigiwinAthena);
                        }
                    });
                    pageData.put((Object)schema, (Object)newBottomButtonList);
                    break;
                }
            }
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("transport_no", transportNo);
        List msgList = this.digiwinEspProxyService.getTransportDriverMsg(iamUserToken, tenantId, locale, params);
        if (ObjectUtil.isNotEmpty((Object)msgList) && msgList.size() > 0) {
            Optional<Map> msgOptional1 = msgList.stream().filter(o -> StrUtil.equals((CharSequence)"1", (CharSequence)StrUtil.toString(o.get("msg_type")))).findFirst();
            if (msgOptional1.isPresent()) {
                uiBotModel.setShowStartPosition(Boolean.valueOf(true));
            } else {
                uiBotModel.setShowStartPosition(Boolean.valueOf(false));
            }
            List list = msgList.stream().filter(o -> !StrUtil.equals((CharSequence)"1", (CharSequence)StrUtil.toString(o.get("msg_type")))).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(list) && list.size() > 0) {
                String actionDataScheme;
                HashMap<String, Object> data;
                HashMap<String, Object> rawData;
                Map map = (Map)list.get(0);
                Action action = new Action();
                UiBotAction uiBotAction = this.getSubmitAction(pcUiBotModel, "submit-data");
                if (StrUtil.equals((CharSequence)"3", (CharSequence)StrUtil.toString(map.get("msg_type")))) {
                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT_STOP_ABNORMAL_ALARM.name());
                    action.setJumpPageTitle(this.localeService.getLanguageValue(locale, "\u957f\u65f6\u95f4\u505c\u7559\u9884\u8b66"));
                    rawData = new HashMap<String, Object>();
                    rawData.put("action_id", "stop");
                    rawData.put("transport_no", transportNo);
                    rawData.put("task_no", taskNo);
                    if (null != uiBotAction) {
                        rawData.put("action", uiBotAction);
                        data = new HashMap<String, Object>();
                        actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                        data.put(actionDataScheme, pcUiBotModel.getPageData().get((Object)actionDataScheme));
                        rawData.put("data", data);
                    }
                    action.setRawData(rawData);
                }
                if (StrUtil.equals((CharSequence)"2", (CharSequence)StrUtil.toString(map.get("msg_type")))) {
                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT_SHIFTING_ABNORMAL_ALARM.name());
                    action.setJumpPageTitle(this.localeService.getLanguageValue(locale, "\u504f\u79fb\u9884\u8b66"));
                    rawData = new HashMap();
                    rawData.put("action_id", "shifting");
                    rawData.put("transport_no", transportNo);
                    rawData.put("task_no", taskNo);
                    if (null != uiBotAction) {
                        rawData.put("action", uiBotAction);
                        data = new HashMap();
                        actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                        data.put(actionDataScheme, pcUiBotModel.getPageData().get((Object)actionDataScheme));
                        rawData.put("data", data);
                    }
                    action.setRawData(rawData);
                }
                log.debug("beforeAction:" + JSONUtil.toJsonStr((Object)action));
                uiBotModel.setBeforeAction(action);
            }
        }
        log.debug("uiBotModel:" + JSONUtil.toJsonStr((Object)uiBotModel));
        return uiBotModel;
    }

    private void setRequestUrl(BottomButtonDigiwinAthena button) {
        Action action = button.getAction();
        if (action == null || !StringUtils.hasLength((String)action.getRequestUrl())) {
            return;
        }
        action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
    }

    private void buildCard(Card card, String locale, String transportNo, DigiwinTransportResponse transportMainInfo) {
        List contentList;
        if (StringUtils.hasLength((String)card.getTitle())) {
            card.setTitle(this.localeService.getLanguageValue(locale, card.getTitle()));
        }
        if (!CollectionUtils.isEmpty((Collection)(contentList = card.getContent()))) {
            Map transportMainInfoMap = (Map)JsonUtil.objectToJavaObject((Object)transportMainInfo, Map.class);
            contentList.forEach(cardContent -> {
                String schema;
                if (StringUtils.hasLength((String)cardContent.getLabel())) {
                    cardContent.setLabel(this.localeService.getLanguageValue(locale, cardContent.getLabel()));
                }
                if ("transport_no".equalsIgnoreCase(schema = cardContent.getSchema())) {
                    cardContent.setValue(transportNo);
                } else if ("appoint_time".equalsIgnoreCase(schema)) {
                    String date = StringUtils.hasLength((String)transportMainInfo.getAppointmentDeliveryDate()) ? transportMainInfo.getAppointmentDeliveryDate() : "-";
                    String[] values = date.split(" ");
                    String value = "";
                    value = values.length > 1 ? values[0] : date;
                    cardContent.setValue(value);
                } else if ("time_slot".equalsIgnoreCase(schema)) {
                    List timeSlots = transportMainInfo.getTimeSlot();
                    if (timeSlots != null && timeSlots.size() > 0) {
                        cardContent.setValue(transportMainInfo.getTimeSlots(timeSlots));
                    }
                } else {
                    cardContent.setValue((String)transportMainInfoMap.get(schema));
                }
            });
        }
    }

    private UiBotAction getSubmitAction(UiBotModel pcUiBotModel, String actionId) {
        List layoutList = pcUiBotModel.getLayout();
        if (CollectionUtils.isEmpty((Collection)layoutList)) {
            return null;
        }
        AtomicReference<UiBotAction> uiBotAction = new AtomicReference<UiBotAction>();
        block0: for (UiBotLayout layout : layoutList) {
            List actions = layout.getActions();
            if (CollectionUtils.isEmpty((Collection)actions)) continue;
            for (UiBotAction action : actions) {
                if (!actionId.equalsIgnoreCase(action.getActionId())) continue;
                uiBotAction.set(action);
                break block0;
            }
        }
        return (UiBotAction)uiBotAction.get();
    }
}

