/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.recommend.appentrancerecord.service.impl;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.mapper.AppEntranceRecordMapper;
import com.digiwin.mobile.mobileuibot.model.AppEntranceRecord;
import com.digiwin.mobile.mobileuibot.recommend.appentrancerecord.service.AppEntranceRecordService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AppEntranceRecordServiceImpl
implements AppEntranceRecordService {
    @Autowired
    private AppEntranceRecordMapper appEntranceRecordMapper;
    private final Object lockObj = new Object();
    private static final int COMMON_APP_DAYS = 7;
    private static final int COMMON_APP_COUNT = 7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppEntrance(AppEntranceRecord appEntranceRecord) {
        if (!(StringUtils.hasLength((String)appEntranceRecord.getAppId()) && StringUtils.hasLength((String)appEntranceRecord.getUserId()) && StringUtils.hasLength((String)appEntranceRecord.getTenantId()))) {
            return;
        }
        Object object = this.lockObj;
        synchronized (object) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(AppEntranceRecord::getUserId, (Object)appEntranceRecord.getUserId());
            wrapper.eq(AppEntranceRecord::getTenantId, (Object)appEntranceRecord.getTenantId());
            wrapper.eq(AppEntranceRecord::getDate, (Object)((DateTime)appEntranceRecord.getDate()).toDateStr());
            wrapper.eq(AppEntranceRecord::getAppId, (Object)appEntranceRecord.getAppId());
            List appEntranceRecords = this.appEntranceRecordMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)appEntranceRecords)) {
                appEntranceRecords.stream().filter(Objects::nonNull).forEachOrdered(existAppEntranceRecord -> {
                    existAppEntranceRecord.setCount(Integer.valueOf(existAppEntranceRecord.getCount() + 1));
                    this.appEntranceRecordMapper.updateById(existAppEntranceRecord);
                });
            } else {
                appEntranceRecord.setRecordId(UUIDUtil.getUuid());
                appEntranceRecord.setCount(Integer.valueOf(1));
                this.appEntranceRecordMapper.insert((Object)appEntranceRecord);
            }
        }
    }

    public List<String> getAppIdListByUserId(String userId, String tenantId) {
        ArrayList<String> appIdList = new ArrayList<String>();
        String date = DateTime.of((long)(System.currentTimeMillis() - 604800000L)).toDateStr();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppEntranceRecord::getUserId, (Object)userId);
        wrapper.eq(AppEntranceRecord::getTenantId, (Object)tenantId);
        wrapper.ge(AppEntranceRecord::getDate, (Object)date);
        wrapper.orderByDesc(AppEntranceRecord::getCount);
        List appEntranceRecordList = this.appEntranceRecordMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)appEntranceRecordList)) {
            return appIdList;
        }
        HashMap appIdCountMap = new HashMap();
        appEntranceRecordList.forEach(appEntranceRecord -> {
            if (!"Athena_SCHEDULE".equalsIgnoreCase(appEntranceRecord.getAppId())) {
                if (appIdCountMap.containsKey(appEntranceRecord.getAppId())) {
                    Integer count = (Integer)appIdCountMap.get(appEntranceRecord.getAppId());
                    appIdCountMap.put(appEntranceRecord.getAppId(), count + appEntranceRecord.getCount());
                } else {
                    appIdCountMap.put(appEntranceRecord.getAppId(), appEntranceRecord.getCount());
                }
            }
        });
        Set entries = appIdCountMap.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            int i = (Integer)entry.getValue();
            if (i >= 7) continue;
            iterator.remove();
        }
        Map map = MapUtil.sortMapDescOrderByValue(appIdCountMap);
        map.keySet().forEach(id -> appIdList.add((String)id));
        return appIdList;
    }

    public List<String> getReportAppIdListByUserId(String userId, String tenantId) {
        ArrayList<String> appIdList = new ArrayList<String>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppEntranceRecord::getUserId, (Object)userId);
        wrapper.eq(AppEntranceRecord::getTenantId, (Object)tenantId);
        wrapper.ge(AppEntranceRecord::getAppId, (Object)"REPORT_%");
        wrapper.orderByDesc(AppEntranceRecord::getCount);
        List appEntranceRecordList = this.appEntranceRecordMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)appEntranceRecordList)) {
            return appIdList;
        }
        HashMap appIdCountMap = new HashMap(appEntranceRecordList.size());
        appEntranceRecordList.forEach(appEntranceRecord -> {
            Integer count = (Integer)appIdCountMap.get(appEntranceRecord.getAppId());
            if (count != null && count != 0) {
                appIdCountMap.put(appEntranceRecord.getAppId(), appEntranceRecord.getCount() + count);
            } else {
                appIdCountMap.put(appEntranceRecord.getAppId(), appEntranceRecord.getCount());
            }
        });
        Map map = MapUtil.sortMapDescOrderByValue(appIdCountMap);
        map.keySet().forEach(id -> appIdList.add((String)id));
        return appIdList;
    }
}

