/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.recommend.rule;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceAccessRecord;
import java.io.Serializable;

public class RecommendMobileConfig
implements Serializable {
    private static final long serialVersionUID = 6183506967071080912L;
    private String name;
    private Integer iconData;
    private String iconColor;
    private Action action;
    private String image;
    private String imageUrl;
    private String imageFileId;
    private AppEntranceAccessRecord accessRecord;

    public void initSetting(String locale) {
        if (null != this.name) {
            this.name = LocaleUtil.getMobileTextByKey((String)locale, (String)this.name);
        }
        if (null != this.action && null != this.action.getJumpPageTitle()) {
            String oldJumpTitle = this.action.getJumpPageTitle();
            this.action.setJumpPageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)oldJumpTitle));
        }
        if (StringUtil.isNotEmpty((CharSequence)this.imageFileId)) {
            this.imageUrl = AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/Athena/preview/" + this.imageFileId;
        }
    }

    public void convert(RecommendMobileConfig mobileConfig) {
        if (null == mobileConfig) {
            return;
        }
        if (null != mobileConfig.getName()) {
            this.name = mobileConfig.getName();
        }
        if (null != mobileConfig.getIconData()) {
            this.iconData = mobileConfig.getIconData();
        }
        if (null != mobileConfig.getIconColor()) {
            this.iconColor = mobileConfig.getIconColor();
        }
        if (null != mobileConfig.getAction()) {
            if (null == this.action) {
                this.action = new Action();
            }
            this.action.convert(mobileConfig.getAction());
        }
        if (null != mobileConfig.getImage()) {
            this.image = mobileConfig.getImage();
        }
        if (null != mobileConfig.getImageFileId()) {
            this.imageFileId = mobileConfig.getImageFileId();
        }
        if (null != mobileConfig.getAccessRecord()) {
            if (null == this.accessRecord) {
                this.accessRecord = new AppEntranceAccessRecord();
            }
            this.accessRecord.convert(mobileConfig.getAccessRecord());
        }
    }

    public String getName() {
        return this.name;
    }

    public Integer getIconData() {
        return this.iconData;
    }

    public String getIconColor() {
        return this.iconColor;
    }

    public Action getAction() {
        return this.action;
    }

    public String getImage() {
        return this.image;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getImageFileId() {
        return this.imageFileId;
    }

    public AppEntranceAccessRecord getAccessRecord() {
        return this.accessRecord;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIconData(Integer iconData) {
        this.iconData = iconData;
    }

    public void setIconColor(String iconColor) {
        this.iconColor = iconColor;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setImageFileId(String imageFileId) {
        this.imageFileId = imageFileId;
    }

    public void setAccessRecord(AppEntranceAccessRecord accessRecord) {
        this.accessRecord = accessRecord;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecommendMobileConfig)) {
            return false;
        }
        RecommendMobileConfig other = (RecommendMobileConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$iconData = this.getIconData();
        Integer other$iconData = other.getIconData();
        if (this$iconData == null ? other$iconData != null : !((Object)this$iconData).equals(other$iconData)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$iconColor = this.getIconColor();
        String other$iconColor = other.getIconColor();
        if (this$iconColor == null ? other$iconColor != null : !this$iconColor.equals(other$iconColor)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        String this$imageFileId = this.getImageFileId();
        String other$imageFileId = other.getImageFileId();
        if (this$imageFileId == null ? other$imageFileId != null : !this$imageFileId.equals(other$imageFileId)) {
            return false;
        }
        AppEntranceAccessRecord this$accessRecord = this.getAccessRecord();
        AppEntranceAccessRecord other$accessRecord = other.getAccessRecord();
        return !(this$accessRecord == null ? other$accessRecord != null : !this$accessRecord.equals(other$accessRecord));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecommendMobileConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $iconData = this.getIconData();
        result = result * 59 + ($iconData == null ? 43 : ((Object)$iconData).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $iconColor = this.getIconColor();
        result = result * 59 + ($iconColor == null ? 43 : $iconColor.hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        String $imageFileId = this.getImageFileId();
        result = result * 59 + ($imageFileId == null ? 43 : $imageFileId.hashCode());
        AppEntranceAccessRecord $accessRecord = this.getAccessRecord();
        result = result * 59 + ($accessRecord == null ? 43 : $accessRecord.hashCode());
        return result;
    }

    public String toString() {
        return "RecommendMobileConfig(name=" + this.getName() + ", iconData=" + this.getIconData() + ", iconColor=" + this.getIconColor() + ", action=" + this.getAction() + ", image=" + this.getImage() + ", imageUrl=" + this.getImageUrl() + ", imageFileId=" + this.getImageFileId() + ", accessRecord=" + this.getAccessRecord() + ")";
    }

    public RecommendMobileConfig() {
    }

    public RecommendMobileConfig(String name, Integer iconData, String iconColor, Action action, String image, String imageUrl, String imageFileId, AppEntranceAccessRecord accessRecord) {
        this.name = name;
        this.iconData = iconData;
        this.iconColor = iconColor;
        this.action = action;
        this.image = image;
        this.imageUrl = imageUrl;
        this.imageFileId = imageFileId;
        this.accessRecord = accessRecord;
    }
}

