/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.search;

import com.digiwin.mobile.mobileuibot.abireport.ReportCategoryEnum;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.basic.LabelTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartFuzzySearch;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearch;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchField;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelOnlineManage;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.StateTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcSearchTaskResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.kbs.model.Pagination;
import com.digiwin.mobile.mobileuibot.proxy.kbs.serivce.DigiwinKbsService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.search.SearchCategoryEnum;
import com.digiwin.mobile.mobileuibot.search.SearchController;
import com.digiwin.mobile.mobileuibot.search.model.GlobalSearchContent;
import com.digiwin.mobile.mobileuibot.search.model.GlobalSearchContentData;
import com.digiwin.mobile.mobileuibot.search.model.GlobalSearchData;
import com.digiwin.mobile.mobileuibot.search.service.MobileSearchService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/search"})
public class SearchController {
    private static final int SEARCH_TYPE_FUZZY = 0;
    private static final int SEARCH_TYPE_PRECISE = 1;
    private static final int SEARCH_TYPE_DIRECT_PRECISE = 2;
    private static final String GLOBAL_SEARCH_TYPE_PROJECT = "0";
    private static final String GLOBAL_SEARCH_TYPE_TASK = "1";
    private static final int SHOW_MORE_SIZE = 3;
    @Autowired
    private MobileSearchService mobileSearchService;
    @Autowired
    private DigiwinKbsService digiwinKbsService;
    @Autowired
    private ColumnTagService columnTagService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinAudcProxyService audcProxyService;
    @Autowired
    private PersonnelOnlineManage personnelOnlineManage;
    @Autowired
    private PageTaskRelationService pageTaskRelationService;
    @Autowired
    private CustomTaskConfigService customTaskConfigService;
    @Autowired
    private ProjectFilterService projectFilterService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private ActivityFilterService activityFilterService;

    @RequestMapping(value={"/allSearch"}, method={RequestMethod.POST})
    public ApiResponse allSearch(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        Integer searchType = (Integer)params.get("searchType");
        String tenantId = (String)params.get("tenantId");
        String question = (String)params.get("question");
        String iamUserToken = (String)params.get("iamUserToken");
        String locale = (String)params.get("locale");
        Map ext = (Map)params.get("ext");
        Boolean useCountNum = (Boolean)params.get("useCountNum");
        String countText = (String)params.get("countText");
        String countTextTemplate = (String)params.get("countTextTemplate");
        String sid = (String)params.get("sid");
        String tmActivityId = (String)params.get("tmActivityId");
        String inquiryNo = (String)params.get("inquiry_no");
        List smartPreciseSearches = new ArrayList();
        Map apiRequest = (Map)params.get("apiRequest");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (useMockData.booleanValue() || modelTypeShow.booleanValue()) {
            Map mockData = this.doMockData(searchType.intValue());
            return ApiResponse.buildOK().setData((Object)mockData);
        }
        if (0 == searchType) {
            List smartFuzzySearches = this.mobileSearchService.findFuzzySearch(tenantId, question, ext, iamUserToken);
            if (smartFuzzySearches == null) {
                HashMap bigData = new HashMap(1);
                ArrayList emptyList = new ArrayList(0);
                bigData.put("contentList", emptyList);
                return ApiResponse.buildOK().setData(bigData);
            }
            HashMap bigData = new HashMap(1);
            ArrayList contentListData = new ArrayList();
            for (SmartFuzzySearch smartFuzzySearch : smartFuzzySearches) {
                HashMap<String, String> data = new HashMap<String, String>(smartFuzzySearches.size());
                data.put("componentType", "SMART_FUZZY_SEARCH_ITEM");
                data.put("data", (String)smartFuzzySearch);
                contentListData.add(data);
            }
            bigData.put("contentList", contentListData);
            return ApiResponse.buildOK().setData(bigData);
        }
        if (1 == searchType) {
            smartPreciseSearches = this.mobileSearchService.findPreciseSearches(tenantId, question, sid, ext, iamUserToken, locale, apiRequest);
        } else if (2 == searchType) {
            smartPreciseSearches = this.mobileSearchService.findDirectPreciseSearches(tmActivityId, inquiryNo, iamUserToken, tenantId, locale, apiRequest);
        }
        if (smartPreciseSearches == null || smartPreciseSearches.size() < 1) {
            HashMap data = new HashMap();
            data.put("contentList", new ArrayList(0));
            return ApiResponse.buildOK().setData(data);
        }
        return ApiResponse.buildOK().setData((Object)this.buildModel(smartPreciseSearches, question, countText, countTextTemplate, useCountNum, tmActivityId));
    }

    public Map<String, Object> buildModel(List<SmartPreciseSearch> smartPreciseSearches, String question, String countText, String countTextTemplate, Boolean useCountNum, String tmActivityId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (useCountNum.booleanValue() && !StringUtils.isEmpty((Object)countTextTemplate)) {
            data.put("countNumText", countText.replace(countTextTemplate, String.valueOf(smartPreciseSearches.size())));
        } else {
            data.put("countNumText", "");
        }
        ArrayList contentList = new ArrayList(smartPreciseSearches.size());
        for (SmartPreciseSearch smartPreciseSearch : smartPreciseSearches) {
            HashMap<String, Object> rawData = new HashMap<String, Object>(1);
            rawData.put("searchQ", question);
            HashMap<String, Object> content = new HashMap<String, Object>(2);
            String componentType = "SMART_PRECISE_SEARCH_ITEM";
            HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
            dataMap.put("fields", smartPreciseSearch.getFields());
            dataMap.put("pic", smartPreciseSearch.getPics());
            dataMap.put("styleType", smartPreciseSearch.getStyleType());
            HashMap<String, Object> action = new HashMap<String, Object>(4);
            action.put("dataId", "");
            if (Objects.equals(SmartPreciseSearchStyleTypeEnum.LEFT_IMAGE_RIGHT_TEXT.getValue(), smartPreciseSearch.getStyleType())) {
                action.put("jumpPageId", PageSettingIdPresetEnum.MOBILE_SEARCH_ITEM_DETAIL);
                dataMap.put("searchType", 1);
                data.put("entryJump", true);
            } else if (Objects.equals(SmartPreciseSearchStyleTypeEnum.TEXT_ONLY.getValue(), smartPreciseSearch.getStyleType())) {
                action.put("jumpPageId", PageSettingIdPresetEnum.MOBILE_SEARCH_ITEM_LIST);
                data.put("entryJump", false);
                dataMap.put("searchType", 2);
            }
            action.put("type", ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            if (smartPreciseSearch.getAction() != null) {
                Map row = (Map)smartPreciseSearch.getAction().getRawData();
                Map map = (Map)row.get("params");
                if (map.keySet().contains("params")) {
                    rawData.putAll(map);
                } else {
                    rawData.put("params", map);
                }
                if (StringUtils.hasLength((CharSequence)((CharSequence)row.get("dataKey")))) {
                    rawData.put("dataKey", row.get("dataKey"));
                } else {
                    rawData.put("dataKey", ((SmartPreciseSearchField)smartPreciseSearch.getFields().get(0)).getFieldValue());
                }
                String tmActivityId1 = (String)row.get("tmActivityId");
                if (StringUtils.hasLength((String)tmActivityId1)) {
                    tmActivityId = tmActivityId1;
                }
                rawData.put("tmActivityId", tmActivityId);
                if (tmActivityId.contains("ddc_inquiry")) {
                    data.put("showSearchBox", false);
                } else {
                    data.put("showSearchBox", true);
                }
            } else {
                rawData.put("dataKey", ((SmartPreciseSearchField)smartPreciseSearch.getFields().get(0)).getFieldValue());
            }
            action.put("rawData", rawData);
            dataMap.put("action", action);
            content.put("componentType", componentType);
            content.put("data", dataMap);
            contentList.add(content);
        }
        data.put("contentList", contentList);
        return data;
    }

    private Map<String, Object> doMockData(int searchType) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Map mockSearchData = null;
        String data = 0 == searchType ? FileUtil.readText((String)"static/smartsearch-fuzzysearch-result.json") : (1 == searchType ? FileUtil.readText((String)"static/smartsearch-precisesearch-result.json") : (2 == searchType ? FileUtil.readText((String)"static/smartsearch-precisesearch-result.json") : ""));
        if (null != data && !data.isEmpty()) {
            mockSearchData = (Map)JsonUtil.jsonStringToObject((String)data, Map.class);
        }
        return mockSearchData;
    }

    @RequestMapping(value={"/globalSearch"}, method={RequestMethod.POST})
    public ApiResponse<Map<String, Object>> globalSearch(HttpServletRequest request) throws IOException {
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String locale = (String)params.get("locale");
        String tenantId = (String)params.get("tenantId");
        String searchContent = (String)params.get("searchContent");
        String iamUserToken = (String)params.get("iamUserToken");
        String userId = (String)params.get("userId");
        String searchCategoryId = (String)params.get("searchCategoryId");
        Map rawData = (Map)params.get("rawData");
        if (!CollectionUtils.isEmpty((Map)rawData)) {
            searchCategoryId = (String)rawData.get("searchCategoryId");
        }
        if (searchCategoryId == null) {
            searchCategoryId = SearchCategoryEnum.ALL.getValue();
        }
        Integer page = (Integer)params.get("page");
        Integer pageSize = (Integer)params.get("pageSize");
        HashMap<String, Object> knowledgeInfos = new HashMap<String, Object>(9);
        HashMap<String, Integer> pagination = new HashMap<String, Integer>(2);
        pagination.put("page", page);
        pagination.put("page_size", pageSize);
        knowledgeInfos.put("pagination", pagination);
        knowledgeInfos.put("knowledge_classification_no", "");
        knowledgeInfos.put("search_content", searchContent);
        knowledgeInfos.put("knowledge_classification_name", "");
        knowledgeInfos.put("tag_classification_no", "");
        knowledgeInfos.put("tag_classification_name", "");
        knowledgeInfos.put("start_time", "");
        knowledgeInfos.put("end_time", "");
        HashMap data = new HashMap();
        ArrayList<GlobalSearchData> searchData = new ArrayList<GlobalSearchData>(4);
        if (modelTypeShow.booleanValue()) {
            return ApiResponse.buildOK().setData((Object)this.doMockData(locale));
        }
        switch (2.$SwitchMap$com$digiwin$mobile$mobileuibot$search$SearchCategoryEnum[SearchCategoryEnum.getEnumByValue((String)searchCategoryId).ordinal()]) {
            case 1: {
                searchData.addAll(this.buildGlobalSearchModel(knowledgeInfos, iamUserToken, locale, tenantId, searchCategoryId, searchContent));
                break;
            }
            case 2: {
                searchData.addAll(this.buildAthenaGlobalSearchModel(this.digiwinAtmcProxyService.getSearchResult(iamUserToken, locale, searchContent, tenantId), locale, searchCategoryId, searchContent, tenantId, iamUserToken));
                break;
            }
            case 3: {
                searchData.add(this.buildAthenaProjectOrTaskGlobalSearchModel(this.digiwinAtmcProxyService.getSearchResult(iamUserToken, locale, searchContent, tenantId), locale, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u4efb\u52a1"), searchContent, GLOBAL_SEARCH_TYPE_TASK, searchCategoryId, tenantId, iamUserToken));
                break;
            }
            case 4: {
                searchData.add(this.buildAthenaProjectOrTaskGlobalSearchModel(this.digiwinAtmcProxyService.getSearchResult(iamUserToken, locale, searchContent, tenantId), locale, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9879\u76ee"), searchContent, GLOBAL_SEARCH_TYPE_PROJECT, searchCategoryId, tenantId, iamUserToken));
                break;
            }
            case 5: {
                searchCategoryId = searchCategoryId.split("kbs_")[1];
                knowledgeInfos.put("search_range", searchCategoryId);
                searchData.add(this.buildKbsGlobalSearchModel(this.digiwinKbsService.getInfoBaseHome(knowledgeInfos, iamUserToken, locale), locale, searchCategoryId, SearchCategoryEnum.KBS_QUESTION.getValue(), searchContent));
                break;
            }
            case 6: {
                searchData.add(this.buildReportName(this.audcProxyService.getTmDataList("", iamUserToken, tenantId, locale), locale, this.localeService.getLanguageValue(locale, "\u62a5\u8868"), searchContent, searchCategoryId));
                break;
            }
            case 7: {
                List defaultSelects;
                String eocCompanyId = "";
                String eocSiteId = "";
                if (!CollectionUtils.isEmpty((Map)rawData) && null != rawData.get("eoc_company_id") && !CollectionUtils.isEmpty((Collection)(defaultSelects = (List)JsonUtil.objectToJavaObject(rawData.get("eoc_company_id"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */)))) {
                    eocCompanyId = ((InputCascade.DefaultSelect)defaultSelects.get(0)).getId();
                    eocSiteId = ((InputCascade.DefaultSelect)defaultSelects.get(1)).getId();
                }
                searchData.add(this.buildPersonnelOnlineSearch(this.personnelOnlineManage.woOpReportPersonnelGet(iamUserToken, tenantId, locale, eocCompanyId, eocSiteId), SearchCategoryEnum.PERSONNEL_ONLINE_SEARCH.getValue(), searchContent, locale, iamUserToken, tenantId));
                break;
            }
        }
        data.put("data", searchData);
        return ApiResponse.buildOK().setData(data);
    }

    private GlobalSearchData buildPersonnelOnlineSearch(List<WoOpReportInfo> allReportList, String searchCategoryId, String searchContent, String locale, String iamUserToken, String tenantId) {
        GlobalSearchData globalSearchData = new GlobalSearchData();
        globalSearchData.setSearchCategoryId(searchCategoryId);
        globalSearchData.setName(this.localeService.getLanguageValue(locale, "\u4eba\u5458\u4e0a\u7ebf\u60c5\u51b5"));
        globalSearchData.setUsePaging(Boolean.valueOf(true));
        globalSearchData.setEntryJump(Boolean.valueOf(true));
        globalSearchData.setShowSearchBox(Boolean.valueOf(true));
        globalSearchData.setUseExpand(Boolean.valueOf(false));
        List contentList = allReportList.stream().filter(reportInfo -> {
            if (!StringUtils.hasText((String)searchContent)) {
                return false;
            }
            boolean reporterName = Optional.ofNullable(reportInfo.getReporterName()).orElse("").contains(searchContent);
            boolean supporterName = Optional.ofNullable(reportInfo.getSupporterName()).orElse("").contains(searchContent);
            boolean opName = Optional.ofNullable(reportInfo.getOpName()).orElse("").contains(searchContent);
            boolean woNo = Optional.ofNullable(reportInfo.getWoNo()).orElse("").contains(searchContent);
            boolean plotNo = Optional.ofNullable(reportInfo.getPlotNo()).orElse("").contains(searchContent);
            boolean planLotNo = Optional.ofNullable(reportInfo.getPlanLotNo()).orElse("").contains(searchContent);
            boolean projectName = Optional.ofNullable(reportInfo.getProjectName()).orElse("").contains(searchContent);
            boolean areaName = Optional.ofNullable(reportInfo.getAreaName()).orElse("").contains(searchContent);
            return reporterName || supporterName || opName || woNo || plotNo || planLotNo || projectName || areaName;
        }).collect(Collectors.toList());
        int size = contentList.size();
        List onLineContentList = contentList.stream().filter(e -> PersonnelStateEnum.ONLINE.equals((Object)e.getStateEnum()) && StringUtils.hasLength((String)e.getMergeNo())).collect(Collectors.toList());
        Map<String, List<WoOpReportInfo>> onLineWoOpReportInfoMapByMergeNo = onLineContentList.stream().collect(Collectors.groupingBy(WoOpReportInfo::getMergeNo));
        ArrayList<Object> globalSearchContentList = new ArrayList<Object>();
        for (Map.Entry<String, List<WoOpReportInfo>> woOpReportInfoMapByMergeNoItem : onLineWoOpReportInfoMapByMergeNo.entrySet()) {
            List<WoOpReportInfo> woOpReportInfoListByMergeNo = woOpReportInfoMapByMergeNoItem.getValue();
            Map<String, List<WoOpReportInfo>> woOpReportInfoMapByReportName = woOpReportInfoListByMergeNo.stream().collect(Collectors.groupingBy(WoOpReportInfo::getReporterName));
            for (List<WoOpReportInfo> woOpReportInfoListByReportName : woOpReportInfoMapByReportName.values()) {
                globalSearchContentList.add(this.buildGlobalSearchContent(woOpReportInfoListByReportName, searchCategoryId, locale, true));
            }
        }
        contentList.removeAll(onLineContentList);
        Map variableListSimpleMap = this.digiwinKnowledgeMapsProxyService.getVariableListSimple(iamUserToken, tenantId, locale, Collections.singletonList("taskNameField"));
        String taskNameField = Optional.ofNullable(variableListSimpleMap).map(e -> MapUtils.getString((Map)e, (Object)"taskNameField")).orElse("");
        List supportContentList = contentList.stream().filter(e -> PersonnelStateEnum.SUPPORT.equals((Object)e.getStateEnum())).collect(Collectors.toList());
        Map woOpReportInfoListByWoNoAndOpNo = supportContentList.stream().collect(Collectors.groupingBy(e -> {
            if ("2".equals(taskNameField)) {
                return e.getProjectNo();
            }
            if ("3".equals(taskNameField)) {
                return e.getPlanLotNo();
            }
            return e.getWoNo();
        }, LinkedHashMap::new, Collectors.groupingBy(WoOpReportInfo::getOpNo, LinkedHashMap::new, Collectors.toList())));
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setLocale(locale);
        List retractableList = Retractable.buildRetractable((ApiRequest)apiRequest, (LocaleService)this.localeService, (Map)woOpReportInfoListByWoNoAndOpNo, (String)taskNameField, (String)"#F8F8FC");
        List supportGlobalSearchContentList = retractableList.stream().map(retractable -> {
            GlobalSearchContent globalSearchContent = new GlobalSearchContent();
            globalSearchContent.setComponentType("RETRACYABLE");
            globalSearchContent.setContent((BaseMobileComponent)retractable);
            return globalSearchContent;
        }).collect(Collectors.toList());
        globalSearchContentList.addAll(supportGlobalSearchContentList);
        contentList.removeAll(supportContentList);
        List globalSearchContentListNotByMergeNo = contentList.stream().map(reportInfo -> this.buildGlobalSearchContent(Collections.singletonList(reportInfo), searchCategoryId, locale, false)).collect(Collectors.toList());
        globalSearchContentList.addAll(globalSearchContentListNotByMergeNo);
        globalSearchData.setCountNumText(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u603b\u8ba1"), size));
        globalSearchData.setContentList(globalSearchContentList);
        return globalSearchData;
    }

    private GlobalSearchContent buildGlobalSearchContent(List<WoOpReportInfo> woOpReportInfoList, String searchCategoryId, String locale, boolean isMerge) {
        WoOpReportInfo reportInfo = woOpReportInfoList.get(0);
        GlobalSearchContent globalSearchContent = new GlobalSearchContent();
        globalSearchContent.setComponentType("GLOBAL_SEARCH_ITEM_LIST");
        GlobalSearchContentData contentData = new GlobalSearchContentData();
        contentData.setSearchType(searchCategoryId);
        contentData.setStyleType(SmartPreciseSearchStyleTypeEnum.LEFT_IMAGE_RIGHT_TEXT.getValue());
        ArrayList<SmartPreciseSearchField> fields = new ArrayList<SmartPreciseSearchField>();
        fields.add(SmartPreciseSearchField.create((String)reportInfo.getReporterNo(), (String)reportInfo.getReporterName(), (Boolean)false, (Integer)1));
        SmartPreciseSearchField stateField = SmartPreciseSearchField.create(null, (String)this.localeService.getLanguageValue(locale, reportInfo.getStateEnum().getDesc()), (Boolean)false, (Integer)2);
        fields.add(stateField);
        switch (2.$SwitchMap$com$digiwin$mobile$mobileuibot$core$strategy$modelbuild$custom$apc$personnel$PersonnelStateEnum[reportInfo.getStateEnum().ordinal()]) {
            case 1: {
                String opNameLabel;
                stateField.setFieldType(Integer.valueOf(StateTypeEnum.NORMAL.getValue()));
                String string = opNameLabel = "zh_TW".equalsIgnoreCase(locale) ? "\u6240\u5728\u88fd\u7a0b" : "\u6240\u5728\u5de5\u827a";
                if (isMerge) {
                    fields.add(SmartPreciseSearchField.create(null, (String)(opNameLabel + " " + (StringUtils.hasLength((String)reportInfo.getOpName()) ? reportInfo.getOpName() : "-")), (Boolean)false, (Integer)1));
                    fields.add(SmartPreciseSearchField.create(null, (String)(this.localeService.getLanguageValue(locale, "\u5408\u5e76\u5355\u53f7") + " " + (StringUtils.hasLength((String)reportInfo.getMergeNo()) ? reportInfo.getMergeNo() : "-")), (Boolean)false, (Integer)1));
                    Action queryAction = new Action();
                    queryAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_PERSONEL_STATE_MERGE_DETAIL.toString());
                    queryAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    queryAction.setDataId(UUIDUtil.getUuid());
                } else {
                    String projectNoLabel = "zh_TW".equalsIgnoreCase(locale) ? "\u5c08\u6848\u4ee3\u865f" : "\u9879\u76ee\u4ee3\u53f7";
                    String projectNameLabel = "zh_TW".equalsIgnoreCase(locale) ? "\u5c08\u6848\u540d\u7a31" : "\u9879\u76ee\u540d\u79f0";
                    String woNoLabel = "zh_TW".equalsIgnoreCase(locale) ? "\u88fd\u4ee4\u55ae\u865f" : "\u5de5\u5355\u5355\u53f7";
                    fields.add(SmartPreciseSearchField.create(null, (String)(opNameLabel + " " + (StringUtils.hasLength((String)reportInfo.getOpName()) ? reportInfo.getOpName() : "-")), (Boolean)false, (Integer)1));
                    fields.add(SmartPreciseSearchField.create(null, (String)(woNoLabel + " " + (StringUtils.hasLength((String)reportInfo.getWoNo()) ? reportInfo.getWoNo() : "-")), (Boolean)false, (Integer)1));
                    fields.add(SmartPreciseSearchField.create(null, (String)(this.localeService.getLanguageValue(locale, "\u54c1\u540d") + " " + (StringUtils.hasLength((String)reportInfo.getItemName()) ? reportInfo.getItemName() : "-")), (Boolean)false, (Integer)1));
                    fields.add(SmartPreciseSearchField.create(null, (String)(this.localeService.getLanguageValue(locale, "\u89c4\u683c") + " " + (StringUtils.hasLength((String)reportInfo.getItemSpec()) ? reportInfo.getItemSpec() : "-")), (Boolean)false, (Integer)1));
                    fields.add(SmartPreciseSearchField.create(null, (String)(projectNoLabel + " " + (StringUtils.hasLength((String)reportInfo.getProjectNo()) ? reportInfo.getProjectNo() : "-")), (Boolean)false, (Integer)1));
                    fields.add(SmartPreciseSearchField.create(null, (String)(projectNameLabel + " " + (StringUtils.hasLength((String)reportInfo.getProjectName()) ? reportInfo.getProjectName() : "-")), (Boolean)false, (Integer)1));
                    fields.add(SmartPreciseSearchField.create(null, (String)(this.localeService.getLanguageValue(locale, "\u533a\u57df") + " " + (StringUtils.hasLength((String)reportInfo.getAreaName()) ? reportInfo.getAreaName() : "-")), (Boolean)false, (Integer)1));
                }
                List buttonList = Button.buildButtonList(woOpReportInfoList, (String)locale, (LocaleService)this.localeService, (boolean)isMerge);
                contentData.setButtonList(buttonList);
                break;
            }
            case 2: {
                stateField.setFieldType(Integer.valueOf(StateTypeEnum.ABNORMAL.getValue()));
                break;
            }
            case 3: {
                stateField.setFieldType(Integer.valueOf(StateTypeEnum.GENERAL.getValue()));
                fields.add(SmartPreciseSearchField.create(null, (String)(this.localeService.getLanguageValue(locale, "\u9664\u5916\u539f\u56e0") + " " + (StringUtils.hasLength((String)reportInfo.getExceptName()) ? reportInfo.getExceptName() : "-")), (Boolean)false, (Integer)1));
                fields.add(SmartPreciseSearchField.create(null, (String)(this.localeService.getLanguageValue(locale, "\u65f6\u95f4") + " " + this.exceptTime(reportInfo.getStartTime(), reportInfo.getEndTime())), (Boolean)false, (Integer)1));
                break;
            }
        }
        fields.add(SmartPreciseSearchField.create(null, (String)(this.localeService.getLanguageValue(locale, "\u7ec4\u522b") + " " + (StringUtils.hasLength((String)reportInfo.getTeamName()) ? reportInfo.getTeamName() : "-")), (Boolean)false, (Integer)1));
        contentData.setFields(fields);
        globalSearchContent.setData(contentData);
        return globalSearchContent;
    }

    private String exceptTime(Date startTime, Date endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(startTime).split(" ")[1].substring(0, 5) + "-" + sdf.format(endTime).split(" ")[1].substring(0, 5);
    }

    private GlobalSearchData buildReportName(List<DigiwinAtmcTmData> tmDataList, String locale, String name, String searchContent, String searchCategoryId) {
        GlobalSearchData globalSearchData = new GlobalSearchData();
        globalSearchData.setSearchCategoryId(searchCategoryId);
        globalSearchData.setName(name);
        globalSearchData.setUsePaging(Boolean.valueOf(true));
        globalSearchData.setEntryJump(Boolean.valueOf(true));
        globalSearchData.setShowSearchBox(Boolean.valueOf(true));
        globalSearchData.setUseExpand(Boolean.valueOf(false));
        ArrayList<GlobalSearchContent> contentList = new ArrayList<GlobalSearchContent>();
        for (DigiwinAtmcTmData tmData : tmDataList) {
            List baseItemDtoList = tmData.getBaseItemDtoList();
            for (DigiwinAtmcTmDataReport dataReport : baseItemDtoList) {
                if (!dataReport.getName().contains(searchContent) || !dataReport.isAllow().booleanValue()) continue;
                GlobalSearchContent globalSearchContent = new GlobalSearchContent();
                globalSearchContent.setComponentType("GLOBAL_SEARCH_ITEM_LIST");
                GlobalSearchContentData contentData = new GlobalSearchContentData();
                contentData.setIconData(Integer.valueOf(59124));
                contentData.setSearchType(searchCategoryId);
                contentData.setStyleType(SmartPreciseSearchStyleTypeEnum.TEXT_ONLY.getValue());
                Action action = new Action();
                action.setDataId(dataReport.getCode());
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                action.setJumpPageTitle(dataReport.getName());
                if (!ReportCategoryEnum.ABI_STATEMENT.getValue().equals(dataReport.getCategory())) continue;
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ABI_REPORT_DETAIL.toString());
                HashMap<String, DigiwinAtmcTmDataReport> rawData = new HashMap<String, DigiwinAtmcTmDataReport>(1);
                rawData.put("data", dataReport);
                action.setRawData(rawData);
                contentData.setAction(action);
                ArrayList<SmartPreciseSearchField> fields = new ArrayList<SmartPreciseSearchField>(2);
                SmartPreciseSearchField searchTaskNameField = new SmartPreciseSearchField();
                searchTaskNameField.setFieldId(String.valueOf(dataReport.getItemId()));
                searchTaskNameField.setFieldValue(dataReport.getName());
                searchTaskNameField.setSkip(Boolean.valueOf(false));
                searchTaskNameField.setFieldLayoutType(Integer.valueOf(1));
                fields.add(searchTaskNameField);
                SmartPreciseSearchField searchField = new SmartPreciseSearchField();
                searchField.setFieldId(String.valueOf(dataReport.getAppCode()));
                searchField.setFieldValue(this.localeService.getLanguageValue(locale, "\u6240\u5c5e\u5e94\u7528\uff1a") + tmData.getAppName());
                searchField.setSkip(Boolean.valueOf(false));
                searchField.setFieldLayoutType(Integer.valueOf(1));
                fields.add(searchField);
                contentData.setFields(fields);
                globalSearchContent.setData(contentData);
                contentList.add(globalSearchContent);
            }
        }
        int size = contentList.size();
        globalSearchData.setCountNumText(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u603b\u8ba1"), size));
        globalSearchData.setContentList(contentList);
        return globalSearchData;
    }

    private GlobalSearchData buildAthenaTaskGlobalSearchModel(List<DigiwinAtmcSearchTaskResult> searchTaskResult, String locale, String name, String searchContent, String globalSearchType, String searchCategoryId) {
        GlobalSearchData globalSearchData = new GlobalSearchData();
        globalSearchData.setSearchCategoryId(searchCategoryId);
        globalSearchData.setName(name);
        globalSearchData.setUsePaging(Boolean.valueOf(true));
        globalSearchData.setEntryJump(Boolean.valueOf(true));
        globalSearchData.setShowSearchBox(Boolean.valueOf(true));
        globalSearchData.setUseExpand(Boolean.valueOf(false));
        int size = searchTaskResult.size();
        globalSearchData.setCountNumText(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u603b\u8ba1"), size));
        globalSearchData.setContentList(this.buildAthenaTaskGlobalSearchData(searchTaskResult, searchCategoryId.split("athena_")[1], locale));
        return globalSearchData;
    }

    private GlobalSearchData buildAthenaProjectOrTaskGlobalSearchModel(List<DigiwinAtmcSearchResult> searchResult, String locale, String name, String searchContent, String globalSearchType, String searchCategoryId, String tenantId, String iamUserToken) {
        GlobalSearchData globalSearchData = new GlobalSearchData();
        globalSearchData.setSearchCategoryId(searchCategoryId);
        globalSearchData.setName(name);
        globalSearchData.setUsePaging(Boolean.valueOf(true));
        globalSearchData.setEntryJump(Boolean.valueOf(true));
        globalSearchData.setShowSearchBox(Boolean.valueOf(true));
        globalSearchData.setUseExpand(Boolean.valueOf(false));
        searchResult = searchResult.stream().filter(result -> globalSearchType.equals(result.getType())).collect(Collectors.toList());
        int size = searchResult.size();
        globalSearchData.setCountNumText(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u603b\u8ba1"), size));
        globalSearchData.setContentList(this.buildAthenaProjectOrTaskGlobalSearchData(searchResult, searchCategoryId.split("athena_")[1], searchContent, locale, globalSearchType, tenantId, iamUserToken));
        return globalSearchData;
    }

    private List<GlobalSearchContent> buildAthenaTaskGlobalSearchData(List<DigiwinAtmcSearchTaskResult> searchResult, String searchCategoryId, String locale) {
        ArrayList<GlobalSearchContent> contentList = new ArrayList<GlobalSearchContent>(searchResult.size());
        for (DigiwinAtmcSearchTaskResult result : searchResult) {
            GlobalSearchContent globalSearchContent = new GlobalSearchContent();
            globalSearchContent.setComponentType("GLOBAL_SEARCH_ITEM_LIST");
            GlobalSearchContentData contentData = new GlobalSearchContentData();
            contentData.setIconData(Integer.valueOf(58937));
            contentData.setSearchType(searchCategoryId);
            contentData.setStyleType(SmartPreciseSearchStyleTypeEnum.TEXT_ONLY.getValue());
            Action action = new Action();
            action.setDataId(String.valueOf(result.getTaskId()));
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            action.setRequestUrl("/mobile/v1/pattern/jump/info?type=search");
            DigiwinAtmcSearchResult atmcSearchResult = new DigiwinAtmcSearchResult();
            atmcSearchResult.setEndTime(result.getProjectEndTime());
            atmcSearchResult.setId(result.getTaskId());
            atmcSearchResult.setName(result.getTaskName());
            atmcSearchResult.setStartTime(result.getProjectStartTime());
            atmcSearchResult.setType("PROJECT");
            atmcSearchResult.setCode(String.valueOf(result.getTaskId()));
            atmcSearchResult.setEngineType("TaskEngine");
            action.setRawData((Object)atmcSearchResult);
            contentData.setAction(action);
            ArrayList<SmartPreciseSearchField> fields = new ArrayList<SmartPreciseSearchField>(1);
            SmartPreciseSearchField searchTaskNameField = new SmartPreciseSearchField();
            searchTaskNameField.setFieldId(String.valueOf(result.getTaskId()));
            searchTaskNameField.setFieldValue(DateTimeUtil.getMonthDateOfTime((String)result.getPlanEndTime()) + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9700\u5b8c\u6210") + " " + result.getTaskName());
            searchTaskNameField.setSkip(Boolean.valueOf(false));
            searchTaskNameField.setFieldLayoutType(Integer.valueOf(1));
            fields.add(searchTaskNameField);
            SmartPreciseSearchField searchField = new SmartPreciseSearchField();
            searchField.setFieldId(String.valueOf(result.getTaskId()));
            searchField.setFieldValue(this.localeService.getLanguageValue(locale, "\u9879\u76ee\uff1a") + DateTimeUtil.getMonthDateOfTime((String)result.getProjectStartTime()) + "~" + DateTimeUtil.getMonthDateOfTime((String)result.getProjectEndTime()) + " " + result.getProjectName());
            searchField.setSkip(Boolean.valueOf(false));
            searchField.setFieldLayoutType(Integer.valueOf(1));
            fields.add(searchField);
            contentData.setFields(fields);
            globalSearchContent.setData(contentData);
            contentList.add(globalSearchContent);
        }
        return contentList;
    }

    private List<GlobalSearchContent> buildAthenaProjectOrTaskGlobalSearchData(List<DigiwinAtmcSearchResult> searchResult, String searchCategoryId, String searchContent, String locale, String globalSearchType, String tenantId, String iamUserToken) {
        ArrayList<GlobalSearchContent> contentList = new ArrayList<GlobalSearchContent>(searchResult.size());
        ArrayList<GlobalSearchContent> unReadAbleList = new ArrayList<GlobalSearchContent>(searchResult.size());
        String tenantVersion = this.activityFilterService.tenantVersion(iamUserToken, tenantId, locale);
        for (DigiwinAtmcSearchResult result : searchResult) {
            GlobalSearchContent globalSearchContent = new GlobalSearchContent();
            globalSearchContent.setComponentType("GLOBAL_SEARCH_ITEM_LIST");
            GlobalSearchContentData contentData = new GlobalSearchContentData();
            Action action = new Action();
            if (GLOBAL_SEARCH_TYPE_TASK.equalsIgnoreCase(globalSearchType)) {
                contentData.setIconData(Integer.valueOf(58937));
                action = Action.getTaskAction((PageTaskRelationService)this.pageTaskRelationService, (DigiwinAtmcProxyService)this.digiwinAtmcProxyService, (LocaleService)this.localeService, (CustomTaskConfigService)this.customTaskConfigService, (DigiwinAtmcSearchResult)result, (String)locale, (String)tenantId, (String)iamUserToken, (ActivityFilterService)this.activityFilterService, (String)tenantVersion);
            } else if (GLOBAL_SEARCH_TYPE_PROJECT.equalsIgnoreCase(globalSearchType)) {
                contentData.setIconData(Integer.valueOf(58938));
                action = Action.getProjectAction((ProjectFilterService)this.projectFilterService, (DigiwinAtmcProxyService)this.digiwinAtmcProxyService, (LocaleService)this.localeService, (DigiwinAtmcSearchResult)result, (String)locale, (String)tenantId, (String)iamUserToken);
            }
            contentData.setSearchType(searchCategoryId);
            contentData.setStyleType(SmartPreciseSearchStyleTypeEnum.TEXT_ONLY.getValue());
            if (action.getNoSupport().booleanValue()) {
                List labelList = contentData.getLabelList();
                labelList.add(Label.create((String)this.localeService.getLanguageValue(locale, "\u4e0d\u53ef\u67e5\u9605"), (String)LabelTypeEnum.UNREADABLE.getType()));
                contentData.setReadable(Boolean.valueOf(false));
            }
            contentData.setAction(action);
            ArrayList<SmartPreciseSearchField> fields = new ArrayList<SmartPreciseSearchField>(1);
            SmartPreciseSearchField searchField = new SmartPreciseSearchField();
            searchField.setFieldId(String.valueOf(result.getId()));
            if (GLOBAL_SEARCH_TYPE_TASK.equals(result.getType())) {
                searchField.setFieldValue(DateTimeUtil.getMonthDateOfTime((String)result.getEndTime()) + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9700\u5b8c\u6210") + " " + result.getName());
            } else {
                searchField.setFieldValue(DateTimeUtil.getMonthDateOfTime((String)result.getStartTime()) + "~" + DateTimeUtil.getMonthDateOfTime((String)result.getEndTime()) + " " + result.getName());
            }
            searchField.setSkip(Boolean.valueOf(false));
            searchField.setFieldLayoutType(Integer.valueOf(1));
            fields.add(searchField);
            contentData.setFields(fields);
            globalSearchContent.setData(contentData);
            if (action.getNoSupport().booleanValue()) {
                unReadAbleList.add(globalSearchContent);
                continue;
            }
            contentList.add(globalSearchContent);
        }
        contentList.addAll(unReadAbleList);
        return contentList;
    }

    private List<GlobalSearchData> buildGlobalSearchModel(Map<String, Object> knowledgeInfos, String iamUserToken, String locale, String tenantId, String searchCategoryId, String searchContent) {
        ArrayList<GlobalSearchData> globalSearchData = new ArrayList<GlobalSearchData>(4);
        List searchResult = this.digiwinAtmcProxyService.getSearchResult(iamUserToken, locale, searchContent, tenantId);
        GlobalSearchData searchAllData = new GlobalSearchData();
        searchAllData.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5168\u90e8"));
        searchAllData.setSearchCategoryId(searchCategoryId);
        searchAllData.setUseExpand(Boolean.valueOf(false));
        searchAllData.setCountNumText("");
        searchAllData.setShowSearchBox(Boolean.valueOf(true));
        searchAllData.setEntryJump(Boolean.valueOf(true));
        searchAllData.setUsePaging(Boolean.valueOf(false));
        searchAllData.setContentList(Collections.emptyList());
        ArrayList allContent = new ArrayList();
        GlobalSearchData searchTaskData = this.buildAthenaProjectOrTaskGlobalSearchModel(searchResult, locale, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u4efb\u52a1"), searchContent, GLOBAL_SEARCH_TYPE_TASK, SearchCategoryEnum.ATHENA_TASK.getValue(), tenantId, iamUserToken);
        this.dealWithGlobalSearchData(searchTaskData, allContent, false);
        GlobalSearchData searchProjectData = this.buildAthenaProjectOrTaskGlobalSearchModel(searchResult, locale, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9879\u76ee"), searchContent, GLOBAL_SEARCH_TYPE_PROJECT, SearchCategoryEnum.ATHENA_PROJECT.getValue(), tenantId, iamUserToken);
        this.dealWithGlobalSearchData(searchProjectData, allContent, false);
        knowledgeInfos.put("search_range", SearchCategoryEnum.QUESTION.getValue());
        Map kbsSearchResultMap = this.digiwinKbsService.getInfoBaseHome(knowledgeInfos, iamUserToken, locale);
        GlobalSearchData searchKbsData = this.buildKbsGlobalSearchModel(kbsSearchResultMap, locale, SearchCategoryEnum.QUESTION.getValue(), SearchCategoryEnum.KBS_QUESTION.getValue(), searchContent);
        this.dealWithGlobalSearchData(searchKbsData, allContent, true);
        searchAllData.setAllContent(allContent);
        globalSearchData.add(searchAllData);
        globalSearchData.add(searchTaskData);
        globalSearchData.add(searchProjectData);
        globalSearchData.add(searchKbsData);
        return globalSearchData;
    }

    private void dealWithGlobalSearchData(GlobalSearchData searchData, List<GlobalSearchData> allContent, boolean usePaging) {
        GlobalSearchData searchAllData = new GlobalSearchData();
        searchData.setUsePaging(Boolean.valueOf(usePaging));
        BeanUtils.copyProperties((Object)searchData, (Object)searchAllData);
        if (searchData.getContentList().size() > 3) {
            searchData.setUseExpand(Boolean.valueOf(true));
            searchAllData.setUseExpand(Boolean.valueOf(true));
            allContent.add(this.buildGlobalSearchData(searchData, searchAllData));
        } else {
            searchAllData.setCountNumText("");
            searchAllData.setUsePaging(Boolean.valueOf(false));
            searchAllData.setUseExpand(Boolean.valueOf(false));
            searchData.setUseExpand(Boolean.valueOf(false));
            if (searchData.getContentList().size() != 0) {
                allContent.add(searchAllData);
            }
        }
    }

    private GlobalSearchData buildGlobalSearchData(GlobalSearchData searchData, GlobalSearchData searchAllTaskData) {
        searchAllTaskData.setCountNumText("");
        ArrayList<GlobalSearchContent> newContent = new ArrayList<GlobalSearchContent>(3);
        List oldContent = searchData.getContentList();
        int i = 0;
        for (GlobalSearchContent content : oldContent) {
            if (i == 3) break;
            ++i;
            newContent.add(content);
        }
        searchAllTaskData.setContentList(newContent);
        return searchAllTaskData;
    }

    private List<GlobalSearchData> buildAthenaGlobalSearchModel(List<DigiwinAtmcSearchResult> searchResult, String locale, String searchCategoryId, String searchContent, String tenantId, String iamUserToken) {
        ArrayList<GlobalSearchData> dataList = new ArrayList<GlobalSearchData>();
        GlobalSearchData searchAllData = new GlobalSearchData();
        searchAllData.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5168\u90e8"));
        searchAllData.setSearchCategoryId(searchCategoryId);
        searchAllData.setUseExpand(Boolean.valueOf(false));
        searchAllData.setCountNumText("");
        searchAllData.setShowSearchBox(Boolean.valueOf(true));
        searchAllData.setEntryJump(Boolean.valueOf(true));
        searchAllData.setUsePaging(Boolean.valueOf(false));
        searchAllData.setContentList(Collections.emptyList());
        ArrayList allContent = new ArrayList();
        GlobalSearchData searchTaskData = this.buildAthenaProjectOrTaskGlobalSearchModel(searchResult, locale, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u4efb\u52a1"), searchContent, GLOBAL_SEARCH_TYPE_TASK, searchCategoryId, tenantId, iamUserToken);
        this.dealWithGlobalSearchData(searchTaskData, allContent, false);
        GlobalSearchData searchProjectData = this.buildAthenaProjectOrTaskGlobalSearchModel(searchResult, locale, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9879\u76ee"), searchContent, GLOBAL_SEARCH_TYPE_PROJECT, searchCategoryId, tenantId, iamUserToken);
        this.dealWithGlobalSearchData(searchProjectData, allContent, false);
        searchAllData.setAllContent(allContent);
        dataList.add(searchAllData);
        dataList.add(searchProjectData);
        dataList.add(searchTaskData);
        return dataList;
    }

    private Map<String, Object> doMockData(String locale) {
        String data = FileUtil.readText((String)"static/appstore-use/global-search-question.json");
        return (Map)JsonUtil.jsonStringToObject((String)data, Map.class);
    }

    private GlobalSearchData buildKbsGlobalSearchModel(Map<String, Object> kbsSearchResultMap, String locale, String searchCategoryId, String returnSearchCategoryId, String searchContent) {
        if (CollectionUtils.isEmpty(kbsSearchResultMap)) {
            GlobalSearchData globalSearchData = new GlobalSearchData();
            globalSearchData.setSearchCategoryId(returnSearchCategoryId);
            globalSearchData.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u95ee\u9898"));
            globalSearchData.setShowSearchBox(Boolean.valueOf(true));
            globalSearchData.setContentList(Collections.emptyList());
            globalSearchData.setCountNumText(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u603b\u8ba1"), 0));
            return globalSearchData;
        }
        List knowledgeInfos = (List)kbsSearchResultMap.get("knowledge_info");
        Pagination pagination = (Pagination)JsonUtil.jsonStringToObject((String)JsonUtil.javaObjectToJsonString((Object)kbsSearchResultMap.get("pagination")), Pagination.class);
        GlobalSearchData globalSearchData = new GlobalSearchData();
        globalSearchData.setSearchCategoryId(returnSearchCategoryId);
        globalSearchData.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u95ee\u9898"));
        globalSearchData.setShowSearchBox(Boolean.valueOf(true));
        globalSearchData.setEntryJump(Boolean.valueOf(true));
        globalSearchData.setPagination(pagination);
        if (knowledgeInfos == null || knowledgeInfos.size() < 1) {
            globalSearchData.setContentList(Collections.emptyList());
            globalSearchData.setCountNumText(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u603b\u8ba1"), 0));
            return globalSearchData;
        }
        globalSearchData.setCountNumText(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u603b\u8ba1"), knowledgeInfos.size()));
        List columnTagList = this.columnTagService.listColumnTagsByPathAndPageId(searchCategoryId, PageSettingIdPresetEnum.MOBILE_ATHENA_SEARCH_ITEM_LIST.toString());
        globalSearchData.setContentList(this.buildKbsQuestGlobalSearchContentList(knowledgeInfos, "question", columnTagList, locale, searchContent));
        return globalSearchData;
    }

    private List<GlobalSearchContent> buildKbsQuestGlobalSearchContentList(List<Map<String, Object>> knowledgeInfos, String searchCategoryId, List<ColumnTag> columnTagList, String locale, String searchContent) {
        ArrayList<GlobalSearchContent> contentList = new ArrayList<GlobalSearchContent>(knowledgeInfos.size());
        for (Map<String, Object> knowledgeInfo : knowledgeInfos) {
            GlobalSearchContent globalSearchContent = new GlobalSearchContent();
            globalSearchContent.setComponentType("GLOBAL_SEARCH_ITEM_LIST");
            GlobalSearchContentData contentData = new GlobalSearchContentData();
            contentData.setStyleType(SmartPreciseSearchStyleTypeEnum.TEXT_ONLY.getValue());
            contentData.setSearchType(searchCategoryId);
            Action action = new Action((String)knowledgeInfo.get("knowledge_id"), PageSettingIdPresetEnum.MOBILE_ATHENA_SEARCH_ITEM_DETAIL.toString(), ActionTypeEnum.OPEN_NEW_PAGE.getValue(), knowledgeInfo);
            contentData.setAction(action);
            ArrayList<SmartPreciseSearchField> fields = new ArrayList<SmartPreciseSearchField>(columnTagList.size());
            for (ColumnTag columnTag : columnTagList) {
                SmartPreciseSearchField field = new SmartPreciseSearchField();
                field.setFieldId(columnTag.getSchema());
                if (StringUtils.hasLength((String)((String)columnTag.getmLabelText().get(locale)))) {
                    field.setFieldValue(knowledgeInfo.get(columnTag.getSchema()) + (String)columnTag.getmLabelText().get(locale));
                } else {
                    String knowledgeInfoContent = "";
                    if ("knowledge_content".equals(columnTag.getSchema())) {
                        int first;
                        knowledgeInfoContent = (String)knowledgeInfo.get(columnTag.getSchema());
                        if (knowledgeInfoContent != null && knowledgeInfoContent.contains(searchContent) && (first = knowledgeInfoContent.indexOf(searchContent)) > 15) {
                            knowledgeInfoContent = knowledgeInfoContent.substring(first - 15);
                        }
                    } else {
                        knowledgeInfoContent = (String)knowledgeInfo.get(columnTag.getSchema());
                    }
                    field.setFieldValue(knowledgeInfoContent);
                }
                field.setFieldLayoutType(Integer.valueOf(columnTag.getParallel() == null ? 1 : (columnTag.getParallel() != false ? 2 : 1)));
                field.setSkip(Boolean.valueOf(columnTag.getSkip() == null ? false : columnTag.getSkip()));
                fields.add(field);
            }
            contentData.setFields(fields);
            globalSearchContent.setData(contentData);
            contentList.add(globalSearchContent);
        }
        return contentList;
    }
}

