/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.search.model;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentListBuilder;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.search.Pic;
import com.digiwin.mobile.mobileuibot.core.component.search.SkipConfig;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearch;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchField;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchFieldLayoutType;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.PcUiBotPageDataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotBizFieldBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="smartPreciseSearchListBuilder")
public class SmartPreciseSearchListBuilder
implements MobileComponentListBuilder<SmartPreciseSearch> {
    private static final Logger logger = LoggerFactory.getLogger(SmartPreciseSearchListBuilder.class);
    @Autowired
    private ColumnTagService columnTagService;

    public String getMobileComponentType() {
        return "SMART_PRECISE_SEARCH";
    }

    public List<SmartPreciseSearch> build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<SmartPreciseSearch> clazz, Object ... args) {
        Assert.notNull((Object)args[0], (String)"params from search must be NOT null!");
        Assert.notNull((Object)args[1], (String)"tmActivityId must be NOT null!");
        Object searchParams = args[0];
        String tmActivityId = (String)args[1];
        List uiBotLayouts = pcUiBotModel.getLayout();
        if (uiBotLayouts == null || uiBotLayouts.isEmpty()) {
            return Collections.emptyList();
        }
        UiBotLayout pcDataLayout = pcUiBotModel.searchPcTargetLayout().getTargetUiBotLayout();
        List tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return Collections.emptyList();
        }
        List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
        if (args.length == 4) {
            String path = (String)args[2];
            Map dataKeyMatchedBizData = (Map)args[3];
            List bizDataList = this.getDeepestBizDataByDataKeyMatchedBizDataAndPath(path, dataKeyMatchedBizData);
            List columnTagList = this.columnTagService.listColumnTagsByPathAndPageId(path, apiRequest.getPageId());
            return this.getItemListByBizDataAndColumnTag(apiRequest, path, tableColumns, bizDataList, columnTagList, pcUiBotModel, searchParams, tmActivityId);
        }
        String schema = pcUiBotModel.searchBizDataSchema();
        List bizDataList = (List)pcUiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizDataList, (String)("pagedata." + schema + " cannot be null"));
        if (bizDataList.isEmpty()) {
            return Collections.emptyList();
        }
        List columnTagList = this.columnTagService.listColumnTagsByPathAndPageId(schema, apiRequest.getPageId());
        return this.getItemListByBizDataAndColumnTag(apiRequest, schema, tableColumns, bizDataList, columnTagList, pcUiBotModel, searchParams, tmActivityId);
    }

    private List<Map<String, Object>> getDeepestBizDataByDataKeyMatchedBizDataAndPath(String path, Map<String, Object> datakeyMatchedBizData) {
        List<Map<String, Object>> bizDataList = new ArrayList<Map<String, Object>>();
        int firstDotIdx = path.indexOf(".");
        ArrayList<String> pathSeperated = new ArrayList<String>();
        if (firstDotIdx == -1) {
            pathSeperated.add(path);
        } else {
            pathSeperated.add(path.substring(0, firstDotIdx));
            pathSeperated.add(path.substring(firstDotIdx + 1));
        }
        for (int i = 0; i < pathSeperated.size(); ++i) {
            String partOfPath = (String)pathSeperated.get(i);
            if (!datakeyMatchedBizData.containsKey(partOfPath)) continue;
            Object tempData = datakeyMatchedBizData.get(partOfPath);
            if (tempData instanceof Map) {
                if (i == pathSeperated.size() - 1) {
                    bizDataList.add((Map)tempData);
                    break;
                }
                bizDataList = this.getDeepestBizDataByDataKeyMatchedBizDataAndPath((String)pathSeperated.get(i + 1), (Map)tempData);
                continue;
            }
            if (!(tempData instanceof List)) continue;
            if (i == pathSeperated.size() - 1) {
                bizDataList = (List)tempData;
                break;
            }
            bizDataList = this.getDeepestBizDataByDataKeyMatchedBizDataAndPath((String)pathSeperated.get(i + 1), (Map)((List)tempData).get(0));
        }
        return bizDataList;
    }

    private List<SmartPreciseSearch> getItemListByBizDataAndColumnTag(ApiRequest apiRequest, String path, List<UiBotTableColumn> tableColumns, List<Map<String, Object>> bizDataList, List<ColumnTag> columnTagList, UiBotModel pcUiBotModel, Object searchParams, String tmActivityId) {
        Map<String, UiBotTableColumn> tableColumnMap = tableColumns.stream().collect(Collectors.toMap(UiBotBizFieldBase::getSchema, c -> c, (c1, c2) -> c1));
        List profileTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode())).sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        List picTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_PIC.getCode())).sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        List groupTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_GROUP.getCode())).sorted(Comparator.comparingInt(ColumnTag::getGroupNo)).collect(Collectors.toList());
        ArrayList<SmartPreciseSearch> smartPreciseSearches = new ArrayList<SmartPreciseSearch>(bizDataList.size());
        ArrayList<SmartPreciseSearchField> smartPreciseSearchFields = new ArrayList<SmartPreciseSearchField>(profileTagList.size());
        for (ColumnTag columnTag : profileTagList) {
            SmartPreciseSearchField smartPreciseSearchField = new SmartPreciseSearchField();
            for (UiBotTableColumn column : tableColumns) {
                if (!columnTag.getSchema().equals(column.getSchema())) continue;
                smartPreciseSearchField.setFieldId(columnTag.getSchema());
                smartPreciseSearchField.setFieldLayoutType(columnTag.getParallel() == true ? SmartPreciseSearchFieldLayoutType.PARALLEL_TRUE.getValue() : SmartPreciseSearchFieldLayoutType.PARALLEL_FALSE.getValue());
                if (columnTag.getShowTitle() == null || columnTag.getShowTitle().booleanValue()) {
                    smartPreciseSearchField.setFieldTitle(column.getHeaderName());
                } else {
                    smartPreciseSearchField.setFieldTitle("");
                }
                Boolean canSkip = false;
                if (columnTag.getSkip() != null) {
                    canSkip = columnTag.getSkip();
                }
                smartPreciseSearchField.setSkip(canSkip);
                if (!canSkip.booleanValue()) break;
                Object skipConfig = columnTag.getSkipConfig();
                if (skipConfig == null) {
                    skipConfig = new SkipConfig();
                }
                skipConfig.setTaskCode((String)column.getExtendParas().get("taskCode"));
                skipConfig.setQueryName((String)column.getExtendParas().get("queryName"));
                smartPreciseSearchField.setSkipConfig((SkipConfig)skipConfig);
                break;
            }
            smartPreciseSearchFields.add(smartPreciseSearchField);
        }
        for (ColumnTag columnTag : groupTagList) {
            SmartPreciseSearchField smartPreciseSearchField = new SmartPreciseSearchField();
            for (UiBotTableColumn column : tableColumns) {
                if (!columnTag.getSchema().equals(column.getSchema())) continue;
                smartPreciseSearchField.setFieldId(columnTag.getSchema());
                Boolean isParallel = false;
                if (columnTag.getParallel() != null) {
                    isParallel = columnTag.getParallel();
                }
                smartPreciseSearchField.setFieldLayoutType(isParallel == true ? SmartPreciseSearchFieldLayoutType.PARALLEL_TRUE.getValue() : SmartPreciseSearchFieldLayoutType.PARALLEL_FALSE.getValue());
                smartPreciseSearchField.setFieldTitle(column.getHeaderName());
                break;
            }
            smartPreciseSearchFields.add(smartPreciseSearchField);
        }
        ArrayList<SmartPreciseSearchField> picSmartPreciseSearchField = new ArrayList<SmartPreciseSearchField>(picTagList.size());
        for (ColumnTag columnTag : picTagList) {
            int i = 0;
            String schema = columnTag.getSchema();
            String[] schemas = schema.split("\\.");
            if (schemas.length <= 0) continue;
            for (String s : schemas) {
                SmartPreciseSearchField smartPreciseSearchField2 = new SmartPreciseSearchField();
                smartPreciseSearchField2.setFieldId(s);
                smartPreciseSearchField2.setLevel(Integer.valueOf(i));
                picSmartPreciseSearchField.add(smartPreciseSearchField2);
                ++i;
            }
        }
        for (Map map : bizDataList) {
            SmartPreciseSearch smartPreciseSearch = new SmartPreciseSearch();
            String dataKey = PcUiBotPageDataUtil.getBizDataKey((UiBotModel)pcUiBotModel, (String)path, (Map)map);
            smartPreciseSearch.setDataKey(dataKey);
            ArrayList<SmartPreciseSearchField> newSmartPreciseSearchFields = new ArrayList<SmartPreciseSearchField>(smartPreciseSearchFields.size());
            for (SmartPreciseSearchField smartPreciseSearchField : smartPreciseSearchFields) {
                SmartPreciseSearchField searchField = new SmartPreciseSearchField();
                if (map.get(smartPreciseSearchField.getFieldId()) == null) {
                    smartPreciseSearchField.setFieldValue("");
                } else {
                    smartPreciseSearchField.setFieldValue(String.valueOf(map.get(smartPreciseSearchField.getFieldId())));
                }
                BeanUtils.copyProperties((Object)smartPreciseSearchField, (Object)searchField);
                newSmartPreciseSearchFields.add(searchField);
            }
            List list = new ArrayList();
            for (SmartPreciseSearchField smartPreciseSearchField4 : picSmartPreciseSearchField) {
                if (smartPreciseSearchField4.getLevel() == 0) {
                    list = (List)map.get(smartPreciseSearchField4.getFieldId());
                    continue;
                }
                ArrayList<Pic> picList = new ArrayList<Pic>();
                if (list == null || list.size() == 0) continue;
                Map params = (Map)list.get(0);
                Pic pic = new Pic();
                pic.setPicUrl((String)params.get(smartPreciseSearchField4.getFieldId()));
                picList.add(pic);
                smartPreciseSearch.setPics(picList);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put("dataKey", dataKey);
            hashMap.put("params", searchParams);
            hashMap.put("searchQ", "");
            hashMap.put("tmActivityId", tmActivityId);
            Action action = new Action(apiRequest.getDataId(), PageSettingIdPresetEnum.MOBILE_SEARCH_ITEM_DETAIL.toString(), "", ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue(), hashMap);
            smartPreciseSearch.setAction(action);
            smartPreciseSearch.setStyleType(SmartPreciseSearchStyleTypeEnum.LEFT_IMAGE_RIGHT_TEXT.getValue());
            smartPreciseSearch.setFields(newSmartPreciseSearchFields);
            smartPreciseSearches.add(smartPreciseSearch);
        }
        return smartPreciseSearches;
    }
}

