/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.search.service.impl;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.search.SkipConfig;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartFuzzySearch;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearch;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchField;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartSearchTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.search.model.QaExt;
import com.digiwin.mobile.mobileuibot.proxy.search.model.QaRequest;
import com.digiwin.mobile.mobileuibot.proxy.search.model.QaResponse;
import com.digiwin.mobile.mobileuibot.proxy.search.model.QuestionCompletionResponse;
import com.digiwin.mobile.mobileuibot.proxy.search.service.SearchService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.search.model.SmartPreciseSearchListBuilder;
import com.digiwin.mobile.mobileuibot.search.service.MobileSearchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mobileSearchService")
public class MobileSearchServiceImpl
implements MobileSearchService {
    public static final String DDC_INQUIRY_LIST = "ddc_inquiry_list";
    public static final String DDC_ITEMATTRIBUTE_LIST = "ddc_itemAttribute_list";
    @Autowired
    private SearchService searchService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private SmartPreciseSearchListBuilder smartPreciseSearchListBuilder;

    public List<SmartFuzzySearch> findFuzzySearch(String tenantId, String question, Map<String, String> ext, String iamUserToken) {
        List qcr = this.searchService.questionCompletion(tenantId, question, ext, iamUserToken);
        if (qcr != null && qcr.size() > 0) {
            ArrayList<SmartFuzzySearch> smartFuzzySearches = new ArrayList<SmartFuzzySearch>(qcr.size());
            for (QuestionCompletionResponse questionCompletionResponse : qcr) {
                SmartFuzzySearch search = new SmartFuzzySearch();
                search.setSearchType(SmartSearchTypeEnum.PRECISE_SEARCH.getValue());
                search.setText(questionCompletionResponse.getRecommend());
                search.setEnterIconData(Integer.valueOf(59125));
                search.setSearchIconData(Integer.valueOf(59124));
                smartFuzzySearches.add(search);
            }
            return smartFuzzySearches;
        }
        return null;
    }

    public List<SmartPreciseSearch> findPreciseSearches(String tenantId, String question, String sid, Map<String, String> ext, String iamUserToken, String locale, Map<String, String> apiRequest) {
        List answers = this.getQaAnswers(tenantId, question, sid, ext, iamUserToken);
        if (answers == null) {
            return null;
        }
        Object params = ((Map)answers.get(0)).get("params");
        HashMap map = new HashMap(1);
        map.put("params", params);
        String tmActivityId = (String)((Map)answers.get(0)).get("intent_code");
        List smartPreciseSearches = this.simpleShow(tmActivityId, map, iamUserToken, tenantId, locale, params, apiRequest);
        for (SmartPreciseSearch smartPreciseSearch : smartPreciseSearches) {
            HashMap<String, String> parm = new HashMap<String, String>();
            parm.put("iamUserToken", iamUserToken);
            parm.put("locale", locale);
            parm.put("question", question);
            parm.put("sid", sid);
            parm.put("tenantId", tenantId);
            smartPreciseSearch.setQueryInfo(params);
            if (DDC_ITEMATTRIBUTE_LIST.equals(tmActivityId)) {
                smartPreciseSearch.setStyleType(Integer.valueOf(1));
            } else if (DDC_INQUIRY_LIST.equals(tmActivityId)) {
                smartPreciseSearch.setStyleType(Integer.valueOf(6));
            } else {
                smartPreciseSearch.setStyleType(Integer.valueOf(1));
            }
            smartPreciseSearch.setTmActivityId(tmActivityId);
            for (SmartPreciseSearchField searchField : smartPreciseSearch.getFields()) {
                if (searchField.getSkip() == null || !searchField.getSkip().booleanValue()) continue;
                if ("inquiry_no".equals(searchField.getFieldId())) {
                    parm.put("inquiry_no", searchField.getFieldValue());
                }
                SkipConfig skipConfig = searchField.getSkipConfig();
                Map para = skipConfig.getParams();
                for (String key : para.keySet()) {
                    Object o = para.get(key);
                    if (o instanceof String) {
                        if (!StringUtils.isEmpty(o)) continue;
                        para.put(key, parm.get(key));
                        continue;
                    }
                    para.put(key, parm.get(key));
                }
            }
            smartPreciseSearch.setTmActivityId(tmActivityId);
        }
        return smartPreciseSearches;
    }

    public List<SmartPreciseSearch> simpleShow(String tmActivityId, Map<String, Object> map, String iamUserToken, String tenantId, String locale, Object params, Map<String, String> apiRequest) {
        UiBotModel uiBotModel = this.digiwinPcUiBotProxyService.simpleShow(tmActivityId, map, iamUserToken, tenantId, locale);
        ApiRequest apiRequest1 = new ApiRequest();
        apiRequest1.setPageId(apiRequest.get("pageId"));
        return this.smartPreciseSearchListBuilder.build(apiRequest1, null, uiBotModel, SmartPreciseSearch.class, new Object[]{params, tmActivityId});
    }

    public List<SmartPreciseSearch> findDirectPreciseSearches(String tmActivityId, String inquiryNo, String iamUserToken, String tenantId, String locale, Map<String, String> apiRequest) {
        ArrayList inquiryNos = new ArrayList(1);
        HashMap<String, String> inquiryNoMap = new HashMap<String, String>(1);
        inquiryNoMap.put("inquiry_no", inquiryNo);
        inquiryNos.add(inquiryNoMap);
        HashMap inquiryDetail = new HashMap(1);
        inquiryDetail.put("inquiry_detail", inquiryNos);
        HashMap params = new HashMap(1);
        params.put("params", inquiryDetail);
        tmActivityId = tmActivityId + "_detail";
        return this.simpleShow(tmActivityId, params, iamUserToken, tenantId, locale, params, apiRequest);
    }

    private List<Map<String, Object>> getQaAnswers(String tenantId, String question, String sid, Map<String, String> ext, String iamUserToken) {
        QaRequest qaRequest = new QaRequest();
        qaRequest.setQuestion(question);
        qaRequest.setTenant_id(tenantId);
        qaRequest.setUid(sid);
        QaExt qaExt = new QaExt();
        qaExt.setLocale(ext.get("locale"));
        qaExt.setTenantId(tenantId);
        qaExt.setToken(iamUserToken);
        qaExt.setUserId(ext.get("userId"));
        qaRequest.setExt(qaExt);
        QaResponse qaResponse = this.searchService.qa(qaRequest, iamUserToken);
        List answers = qaResponse.getAnswer();
        if (answers == null || answers.size() < 1) {
            return null;
        }
        return answers;
    }
}

