/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.model;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.TextMulti;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.FileMaxSize;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.ocr.InputOcr;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.sign.InputSign;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleInitConfig;
import com.digiwin.mobile.mobileuibot.core.rule.RuleScopeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableAttachmentColumnAttribute;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public abstract class AbstractTaskDetail
extends LinkedHashMap<String, MobileComponent>
implements TaskDetail {
    private static final long serialVersionUID = -8428314755038635277L;
    private LocaleService localeService;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private List<UiBotLayout> actualLayoutList = new ArrayList();

    public AbstractTaskDetail() {
    }

    public AbstractTaskDetail(LocaleService localeService) {
        this.localeService = localeService;
    }

    public List<UiBotLayout> getActualLayoutList() {
        return this.actualLayoutList;
    }

    public void setActualLayoutList(List<UiBotLayout> actualLayoutList) {
        this.actualLayoutList = actualLayoutList;
    }

    public void addActualLayout(UiBotLayout actualLayout) {
        this.getActualLayoutList().add(actualLayout);
    }

    public void addActualLayout(int index, UiBotLayout actualLayout) {
        this.getActualLayoutList().add(index, actualLayout);
    }

    public void addActualLayout(int index, List<UiBotLayout> actualLayoutList) {
        this.getActualLayoutList().addAll(index, actualLayoutList);
    }

    protected abstract Boolean skipCurrentColumn(ColumnTag var1);

    public void addMobileComponent(MobileComponent mobileComponent) {
        int tailIndex = this.getActualLayoutList().size();
        this.addMobileComponent(tailIndex, mobileComponent.returnComponentType() + "_" + UUIDUtil.getUuid(), mobileComponent);
    }

    public void addMobileComponent(String componentSchema, MobileComponent mobileComponent) {
        int tailIndex = this.getActualLayoutList().size();
        this.addMobileComponent(tailIndex, componentSchema, mobileComponent);
    }

    public void addMobileComponent(int index, MobileComponent mobileComponent) {
        this.addMobileComponent(index, mobileComponent.returnComponentType() + "_" + UUIDUtil.getUuid(), mobileComponent);
    }

    public void addMobileComponent(int index, String componentSchema, MobileComponent mobileComponent) {
        UiBotLayout layout = new UiBotLayout();
        layout.setType(mobileComponent.returnComponentType());
        layout.setSchema(componentSchema);
        this.addActualLayout(index, layout);
        this.put((Object)componentSchema, (Object)mobileComponent);
    }

    public void addMobileComponentsByColumnAndBizData(String locale, List<UiBotTableColumn> columnList, UiBotModel pcUibotModel, Map<String, Object> bizData, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, List<Rule> mobileRuleList, List<ColumnTag> columnTagList, ApiRequest apiRequest) {
        boolean taskInReadOnlyMode = apiRequest.getRawData().getBooleanValue("isTeamTask");
        List uiBotRuleList = pcUibotModel.getRules();
        if (taskInReadOnlyMode) {
            uiBotRuleList = Collections.emptyList();
            mobileRuleList = Collections.emptyList();
        }
        Map<String, List<Rule>> mobileRuleGroupedMap = mobileRuleList.stream().collect(Collectors.groupingBy(Rule::getSchema));
        UiBotTableColumn prevColumn = null;
        for (UiBotTableColumn column : columnList) {
            ColumnTag columnTag = columnTagList.stream().filter(ct -> ct.getSchema().equalsIgnoreCase(column.getSchema())).findFirst().orElse(null);
            if (this.skipCurrentColumn(columnTag).booleanValue()) continue;
            if (mobileRuleGroupedMap.containsKey(column.getSchema())) {
                List initRule = mobileRuleGroupedMap.get(column.getSchema()).stream().filter(r -> RuleScopeEnum.INIT.getScope().equalsIgnoreCase(r.getScope()) && null != r.getInitConfig()).collect(Collectors.toList());
                if (Rule.hasCustomMadeRule((ApiRequest)apiRequest, initRule)) {
                    initRule = Rule.compareRule((ApiRequest)apiRequest, initRule, (String)RuleScopeEnum.INIT.getScope());
                }
                initRule.forEach((? super T rule) -> {
                    if (rule.validWithBizData(bizData)) {
                        String componentType = Optional.ofNullable(rule.getInitConfig()).map(RuleInitConfig::getComponentType).orElse("FIELD");
                        Boolean initScopeEnable = Optional.ofNullable(rule.getInitConfig()).map(RuleInitConfig::getEnable).orElse(null);
                        Boolean initScopeRequired = Optional.ofNullable(rule.getInitConfig()).map(RuleInitConfig::getRequired).orElse(null);
                        if (!(null == initScopeEnable || taskInReadOnlyMode || initScopeEnable.booleanValue() && column.canEdit())) {
                            if (initScopeEnable.booleanValue() && !column.canEdit()) {
                                column.doSetCanEdit();
                            } else if (!initScopeEnable.booleanValue() && column.canEdit()) {
                                column.doSetCanNotEdit();
                            }
                        }
                        if (null != initScopeRequired && !taskInReadOnlyMode) {
                            column.setMRequired(initScopeRequired);
                        }
                    }
                });
            }
            List ruleForCurrentColumnSelfOnly = uiBotRuleList.stream().filter(uiBotRule -> null != uiBotRule.getSchema() && uiBotRule.getSchema().equalsIgnoreCase(column.getSchema()) && null == uiBotRule.getTargetSchema() && "pattern".equalsIgnoreCase(uiBotRule.getKey()) || null != uiBotRule.getTargetSchema() && uiBotRule.getTargetSchema().equalsIgnoreCase(column.getSchema()) || null != uiBotRule.getSchema() && uiBotRule.getSchema().equalsIgnoreCase(column.getSchema()) && "required".equalsIgnoreCase(uiBotRule.getKey()) || null != uiBotRule.getSchema() && uiBotRule.getSchema().equalsIgnoreCase(column.getSchema()) && "maxLength".equalsIgnoreCase(uiBotRule.getKey())).collect(Collectors.toList());
            this.calculateComponent(locale, column, ruleForCurrentColumnSelfOnly, bizData, digiwinAtmcBacklogDetail, mobileRuleList, mobileRuleGroupedMap, columnTag, apiRequest, pcUibotModel.getVariableMaps());
            prevColumn = column;
        }
    }

    protected void calculateComponent(String locale, UiBotTableColumn column, List<UiBotRule> columnRuleList, Map<String, Object> bizData, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, List<Rule> mobileRuleList, Map<String, List<Rule>> mobileRuleGroupedMap, ColumnTag columnTag, ApiRequest apiRequest, Map<String, Object> variableMaps) {
        String value;
        String errorMessage;
        String bizDataSchema = column.getSchema();
        Assert.notNull((Object)bizDataSchema, (String)"bizDataSchema must not null in building process!");
        String dataType = Optional.ofNullable(column.getDataType()).orElse("");
        String type = Optional.ofNullable(column.getType()).orElse("");
        Object mobileComponent = null;
        if ("string".equalsIgnoreCase(dataType) && !type.toUpperCase().contains("UPLOAD")) {
            if (column.canEdit()) {
                if (null != columnTag && columnTag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_LONGTEXT.getCode())) {
                    errorMessage = this.localeService.getLanguageValue(locale, "\u4efb\u52a1\u5df2\u903e\u671f\uff0c\u62a5\u5de5\u8bf4\u660e\u5fc5\u586b\uff01");
                    mobileComponent = InputMultiText.create((String)locale, (UiBotTableColumn)column, columnRuleList, bizData, mobileRuleList, (boolean)false, (Integer)Optional.ofNullable(column).map(UiBotTableColumn::getMaxLength).orElse(-1), variableMaps, (String)errorMessage);
                } else {
                    mobileComponent = InputSingleText.create((String)locale, (UiBotTableColumn)column, columnRuleList, bizData, mobileRuleList);
                }
                this.put((Object)bizDataSchema, mobileComponent);
            } else {
                value = column.getValueForDisplay(bizData);
                if (!value.trim().isEmpty()) {
                    if (null != columnTag && columnTag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_LONGTEXT.getCode())) {
                        mobileComponent = TextMulti.create((UiBotTableColumn)column, (String)value, (String)locale);
                    } else {
                        Field field = Field.create((UiBotTableColumn)column, (String)value);
                        field.setLabelStyleType(Integer.valueOf(2));
                        mobileComponent = field;
                    }
                    this.put((Object)bizDataSchema, mobileComponent);
                }
            }
        } else if ("date".equalsIgnoreCase(dataType) && "DATEPICKER".equalsIgnoreCase(type)) {
            mobileComponent = InputCalendar.create((String)locale, (UiBotTableColumn)column, columnRuleList, bizData, mobileRuleList, (boolean)true, (boolean)Optional.ofNullable(column).map(UiBotTableColumn::getMRequired).orElse(false), (ApiRequest)apiRequest);
            if (column.canEdit()) {
                ((InputCalendar)mobileComponent).setEnable(Boolean.valueOf(true));
            } else {
                ((InputCalendar)mobileComponent).setEnable(Boolean.valueOf(false));
            }
            this.put((Object)bizDataSchema, mobileComponent);
        } else if ("numeric".equalsIgnoreCase(dataType)) {
            mobileComponent = InputNumeric.create((String)locale, (UiBotTableColumn)column, columnRuleList, bizData, mobileRuleList, (ApiRequest)apiRequest, variableMaps, (LocaleService)this.localeService);
            if (column.canEdit()) {
                ((InputNumeric)mobileComponent).setEnable(Boolean.valueOf(true));
            } else {
                ((InputNumeric)mobileComponent).setEnable(Boolean.valueOf(false));
            }
            this.put((Object)bizDataSchema, mobileComponent);
        } else if (type.equalsIgnoreCase("TEXTAREA_TEXT") || PcModuleEnum.TEXTAREA.getValue().equalsIgnoreCase(type)) {
            if (column.canEdit()) {
                errorMessage = this.localeService.getLanguageValue(locale, "\u4efb\u52a1\u5df2\u903e\u671f\uff0c\u62a5\u5de5\u8bf4\u660e\u5fc5\u586b\uff01");
                mobileComponent = InputMultiText.create((String)locale, (UiBotTableColumn)column, columnRuleList, bizData, mobileRuleList, (boolean)false, (Integer)Optional.ofNullable(column).map(UiBotTableColumn::getMaxLength).orElse(-1), Collections.emptyMap(), (String)errorMessage);
                this.put((Object)bizDataSchema, mobileComponent);
            } else {
                value = column.getValueForDisplay(bizData);
                if (!value.trim().isEmpty()) {
                    mobileComponent = TextMulti.create((UiBotTableColumn)column, (String)value, (String)locale);
                    this.put((Object)bizDataSchema, mobileComponent);
                }
            }
        } else if ("sch_manualAssignment".equalsIgnoreCase(digiwinAtmcBacklogDetail.getTmActivityId()) && ("sch-manual-task-delivery".equalsIgnoreCase(type) || "sch-manual-task-delivery-history".equalsIgnoreCase(type))) {
            mobileComponent = Attachment.createManualReportingAttachment((String)locale, (UiBotTableColumn)column, bizData, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail);
            this.put((Object)bizDataSchema, mobileComponent);
        } else if (type.toUpperCase().contains("UPLOAD") || type.toUpperCase().contains("FILE_UPLOAD")) {
            List supportFileExtensions;
            if ("sch_manualAssignment".equalsIgnoreCase(digiwinAtmcBacklogDetail.getTmActivityId()) && "delivery_attachment".equalsIgnoreCase(column.getSchema())) {
                Object data = bizData.get(column.getSchema());
                Attachment.translateDoubleTimeToString((Object)data, (String)"create_date");
            }
            boolean isOnlyForPicture = (supportFileExtensions = Optional.ofNullable(column.getAttribute()).map(UiBotTableAttachmentColumnAttribute::getFileExtensions).orElse(Collections.emptyList())) != null && !supportFileExtensions.isEmpty() && (((String)supportFileExtensions.get(0)).toLowerCase().contains("png") || ((String)supportFileExtensions.get(0)).toLowerCase().contains("jpg"));
            boolean disableAam = Optional.ofNullable(column.getAttribute()).map(UiBotTableAttachmentColumnAttribute::getDisableAam).orElse(false);
            mobileComponent = isOnlyForPicture ? Picture.create((String)locale, (UiBotTableColumn)column, columnRuleList, bizData, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, mobileRuleList, (Boolean)disableAam) : Attachment.create(Attachment.class, (String)locale, (UiBotTableColumn)column, columnRuleList, bizData, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, mobileRuleList, (Boolean)disableAam);
            Attachment attachment = (Attachment)mobileComponent;
            attachment.setSchema(bizDataSchema);
            if (TaskStringUtil.isPccTask((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
                attachment.setLimit(Integer.valueOf(3));
                if ("attachment1".equals(bizDataSchema)) {
                    attachment.setFileMaxSize(new FileMaxSize(Long.valueOf(0x6400000L)));
                } else if ("attachment2".equals(bizDataSchema)) {
                    attachment.setFileMaxSize(new FileMaxSize(Long.valueOf(0x3200000L)));
                }
            }
            if (!Objects.equals(attachment.getType(), AttachmentTypeEnum.READ_ONLY.getValue()) || attachment.getFileList() != null && attachment.getFileList().size() != 0) {
                this.put((Object)bizDataSchema, mobileComponent);
            }
        } else if (ColumnTagDefinitionCodeEnum.INPUT_SIGN.getCode().equalsIgnoreCase(column.getType()) || null != columnTag && columnTag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.INPUT_SIGN.getCode())) {
            mobileComponent = InputSign.create((String)locale, (UiBotTableColumn)column, columnRuleList, bizData, mobileRuleList);
            if (column.canEdit()) {
                ((BaseInputMobileComponent)mobileComponent).setEnable(Boolean.valueOf(true));
            } else {
                ((BaseInputMobileComponent)mobileComponent).setEnable(Boolean.valueOf(false));
            }
            this.put((Object)bizDataSchema, mobileComponent);
        } else if (null != columnTag && columnTag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.INPUT_DATETIME_PICKER.getCode())) {
            if (column.canEdit()) {
                mobileComponent = InputDateTimePicker.create((String)locale, (UiBotTableColumn)column, columnRuleList, bizData, mobileRuleList);
                this.put((Object)bizDataSchema, mobileComponent);
            } else {
                value = column.getValueForDisplay(bizData);
                if (!value.trim().isEmpty()) {
                    mobileComponent = Field.create((UiBotTableColumn)column, (String)value);
                    this.put((Object)column.getSchema(), mobileComponent);
                }
            }
        } else if ("FORM_LIST".equalsIgnoreCase(type) && "INPUT_OCR".equals(column.getMContentType())) {
            mobileComponent = InputOcr.create((String)locale, (UiBotTableColumn)column, columnRuleList, bizData, mobileRuleList, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail);
            this.put((Object)column.getSchema(), mobileComponent);
        } else if ("boolean".equalsIgnoreCase(dataType) && "CHECKBOX".equalsIgnoreCase(type)) {
            if (column.canEdit()) {
                mobileComponent = InputSwitch.create((String)locale, (UiBotTableColumn)column, columnRuleList, bizData, mobileRuleList);
                this.put((Object)bizDataSchema, mobileComponent);
            } else {
                value = column.getValueForDisplay(bizData);
                String string = "true".equalsIgnoreCase(value) ? "\u662f" : (value = "false".equalsIgnoreCase(value) ? "\u5426" : value);
                if (!value.trim().isEmpty()) {
                    mobileComponent = Field.create((UiBotTableColumn)column, (String)value);
                    this.put((Object)column.getSchema(), mobileComponent);
                }
            }
        } else if (column.canEdit()) {
            mobileComponent = InputSingleText.create((String)locale, (UiBotTableColumn)column, columnRuleList, bizData, mobileRuleList);
            this.put((Object)bizDataSchema, mobileComponent);
        } else {
            value = column.getValueForDisplay(bizData);
            if (!value.trim().isEmpty()) {
                Field field = Field.create((UiBotTableColumn)column, (String)value);
                field.setLabelStyleType(Integer.valueOf(2));
                mobileComponent = field;
                this.put((Object)column.getSchema(), mobileComponent);
            }
        }
        if (null != mobileComponent) {
            UiBotLayout actualColumnLayout = new UiBotLayout();
            actualColumnLayout.setSchema(bizDataSchema);
            actualColumnLayout.setType(mobileComponent.returnComponentType());
            this.addActualLayout(actualColumnLayout);
        }
    }

    public void addEmptyComponent(ApiRequest apiRequest) {
        Empty mobileComponent = Empty.create((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u6682\u65e0\u6570\u636e"));
        String schema = "EMPTY_" + UUID.randomUUID();
        this.put((Object)schema, (Object)mobileComponent);
        UiBotLayout actualLayout = new UiBotLayout();
        actualLayout.setSchema(schema);
        actualLayout.setType(mobileComponent.returnComponentType());
        this.addActualLayout(actualLayout);
    }

    public void addCustomContentComponent(ApiRequest apiRequest) {
        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleService.class);
        Empty mobileComponent = Empty.create((String)localeService.getLanguageValue(apiRequest.getLocale(), "\u8be5\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u8bf7\u5230web\u7aef\u67e5\u770b"));
        String schema = "EMPTY_" + UUID.randomUUID();
        this.put((Object)schema, (Object)mobileComponent);
        UiBotLayout actualLayout = new UiBotLayout();
        actualLayout.setSchema(schema);
        actualLayout.setType(mobileComponent.returnComponentType());
        this.addActualLayout(actualLayout);
    }
}

