/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildApcAbnormalReportListStrategy")
public class UiBotModelBuildApcAbnormalReportListStrategy
implements TaskDetailBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildApcAbnormalReportListStrategy.class);
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    public String getTaskDetailType() {
        return "apc_abnormalReport_workshop_plan_syn_userproject";
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        StopWatch stopWatch = new StopWatch("Build Apc abnormal report list");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        boolean isTeamTask = BooleanUtils.isTrue((Boolean)apiRawData.getBoolean("isTeamTask"));
        if (StringUtils.hasLength((String)digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", (Object)digiwinAtmcBacklogDetail.getProxyToken());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List buttons = uiBotModel.getAppbarButtonList();
            HashMap<String, String> buttonActionRawData = new HashMap<String, String>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", (String)digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign((String)(digiwinAtmcBacklogDetail.getId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"TASK", (Integer)59096));
        }
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue()) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)locale);
        }
        String path = "wo_op_report_data";
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    TitleBody titleBody = TitleBody.createApc((DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, (UiBotModel)pcUiBotModel, (String)locale);
                    pageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "CARD": {
                    Card card = (Card)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), Card.class);
                    Card.handle((ApiRequest)apiRequest, (UiBotModel)pcUiBotModel, (Card)card);
                    pageData.put((Object)layout.getSchema(), (Object)card);
                    break;
                }
                case "BLANK_AREA": {
                    BlankArea area = (BlankArea)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), BlankArea.class);
                    pageData.put((Object)schema, (Object)area);
                    break;
                }
                case "CUSTOM_TABS": {
                    CustomTabs customTabs = (CustomTabs)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), CustomTabs.class);
                    pageData.put((Object)layout.getSchema(), (Object)customTabs.detailMessage(customTabs, pcUiBotModel, null, path, locale, this.localeService, isTeamTask));
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        return null;
    }
}

