/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.abireport;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="uiBotModelBuildAbiReportInfoStrategy")
public class UiBotModelBuildAbiReportInfoStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildAbiReportInfoStrategy.class);
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        ApiRawData rawData = apiRequest.getRawData();
        Map data = new HashMap(1);
        Boolean useCommon = (Boolean)rawData.get("useCommon");
        String conditionName = "";
        if (useCommon != null && useCommon.booleanValue()) {
            data = (Map)rawData.get("data");
            conditionName = (String)rawData.get("conditionName");
        }
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        UiBotModel pcUibotModel = this.digiwinPcUiBotProxyService.conditionShow(locale, iamUserToken, tenantId, dataId);
        if (pcUibotModel != null && pcUibotModel.getLayout() != null) {
            String textSchema = "conditionName";
            String inputSwitchSchema = "inputSwitch";
            for (UiBotLayout uiBotLayout : uiBotLayouts) {
                switch (uiBotLayout.getType()) {
                    case "CUSTOM_GROUP": {
                        CustomGroup customGroup = this.buildCustomGroup(pcUibotModel, locale, uiBotLayout.getLabel(), data, iamUserToken);
                        pageData.put((Object)uiBotLayout.getSchema(), (Object)customGroup);
                        if (customGroup == null) break;
                        CustomGroupContent content = customGroup.getContent();
                        content.getLayout().add(new UiBotLayout(inputSwitchSchema, "INPUT_SWITCH"));
                        content.getLayout().add(new UiBotLayout(textSchema, "INPUT_SINGLE"));
                        if (StringUtil.isNotEmpty((CharSequence)conditionName)) {
                            content.getPageData().put((Object)inputSwitchSchema, (Object)InputSwitch.createByAbiCondition((Boolean)true, (String)this.localeService.getLanguageValue(locale, "\u4fdd\u5b58\u4e3a\u5e38\u7528\u6761\u4ef6"), (String)textSchema));
                            content.getPageData().put((Object)textSchema, (Object)InputSingleText.create((String)textSchema, (String)this.localeService.getLanguageValue(locale, "\u5e38\u7528\u6761\u4ef6\u540d\u79f0"), (Boolean)true, (Boolean)true, (String)locale, (String)conditionName, (Boolean)false));
                        } else {
                            content.getPageData().put((Object)inputSwitchSchema, (Object)InputSwitch.createByAbiCondition((Boolean)false, (String)this.localeService.getLanguageValue(locale, "\u4fdd\u5b58\u4e3a\u5e38\u7528\u6761\u4ef6"), (String)textSchema));
                            content.getPageData().put((Object)textSchema, (Object)InputSingleText.create((String)textSchema, (String)this.localeService.getLanguageValue(locale, "\u5e38\u7528\u6761\u4ef6\u540d\u79f0"), (Boolean)false, (Boolean)false, (String)locale, (String)"", (Boolean)true));
                        }
                        customGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_ONLY_NO_PADDING.getValue());
                        break;
                    }
                    case "BOTTOM_BUTTON": {
                        List buttons = ModuleUtils.listMapToListObject((List)((List)pageData.get((Object)uiBotLayout.getSchema())), BottomButtonDigiwinAthena.class);
                        for (BottomButtonDigiwinAthena bottomButton : buttons) {
                            bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)bottomButton.getName()));
                            Action action = bottomButton.getAction();
                            Map actionRawData = (Map)action.getRawData();
                            if (actionRawData == null) continue;
                            actionRawData.put("data", pcUibotModel.getPageData());
                            actionRawData.put("layout", pcUibotModel.getLayout());
                            actionRawData.put("action", pcUibotModel.getActions().get(0));
                            actionRawData.put("dataId", dataId);
                            actionRawData.put("isAbi", true);
                            action.setRawData((Object)actionRawData);
                            ConfirmPop confirmPop = new ConfirmPop();
                            confirmPop.setContent(this.localeService.getLanguageValue(locale, "\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6") + "?");
                            confirmPop.setNeedConfirm(Boolean.valueOf(true));
                            confirmPop.setCompareContent(conditionName);
                            confirmPop.setCompareSchema(textSchema);
                            confirmPop.setCheckedSchema(inputSwitchSchema);
                            action.setConfirmPop(confirmPop);
                        }
                        pageData.put((Object)uiBotLayout.getSchema(), (Object)buttons);
                        break;
                    }
                }
            }
        }
        return uiBotModel;
    }

    private CustomGroup buildCustomGroup(UiBotModel pcUibotModel, String locale, String label, Map<String, Object> data, String iamUserToken) {
        CustomGroup customGroup = new CustomGroup();
        List pcUiBotLayouts = pcUibotModel.getLayout();
        UiBotPageData pcPageData = pcUibotModel.getPageData();
        if (!CollectionUtils.isEmpty((Collection)pcUiBotLayouts)) {
            UiBotLayout uiBotLayout = (UiBotLayout)pcUiBotLayouts.get(0);
            if (!CollectionUtils.isEmpty((Collection)((Collection)pcPageData.get((Object)uiBotLayout.getSchema())))) {
                if (CollectionUtils.isEmpty(data)) {
                    data = (Map)((List)pcPageData.get((Object)uiBotLayout.getSchema())).get(0);
                }
                List companys = this.digiwinEocProxyService.getCompany(iamUserToken);
                List factorys = this.digiwinEocProxyService.getFactory(iamUserToken);
                if (!(CollectionUtils.isEmpty((Map)data) || CollectionUtils.isEmpty((Collection)companys) || CollectionUtils.isEmpty((Collection)factorys))) {
                    data.put("companys", companys);
                    data.put("factorys", factorys);
                }
                customGroup = (CustomGroup)ModuleUtils.buildFormList((UiBotLayout)uiBotLayout, (Map)data, (UiBotExecuteContext)pcUibotModel.getExecuteContext(), (String)locale, (String)this.localeService.getLanguageValue(locale, label), (List)pcUibotModel.getRules(), (Boolean)true, (Boolean)true, (boolean)false, (String)iamUserToken);
            }
        } else {
            customGroup = CustomGroup.createEmptyGroup((String)locale, (String)this.localeService.getLanguageValue(locale, label));
        }
        return customGroup;
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}

