/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.http.impl;

import com.digiwin.mobile.mobileuibot.cache.JvmCache;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.DigiwhaleBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.proxy.enums.AthenaCheckApiEnum;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service(value="httpService")
public class HttpServiceImpl
implements HttpService {
    private static final Logger logger = LoggerFactory.getLogger(HttpServiceImpl.class);
    @Autowired
    private SysEnvConfig sysEnvConfig;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private JvmCache jvmCache;

    private HttpHeaders processHeaders(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead) {
        String proxyToken;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("digi-middleware-auth-app", this.sysEnvConfig.getAppToken());
        httpHeaders.set("digi-middleware-auth-user", athenaBasicHttpRequestHead.getUserToken());
        httpHeaders.set("token", athenaBasicHttpRequestHead.getUserToken());
        httpHeaders.set("client-agent", athenaBasicHttpRequestHead.getClientAgent());
        httpHeaders.set("locale", athenaBasicHttpRequestHead.getLocale());
        httpHeaders.set("m-device-type", athenaBasicHttpRequestHead.getDeviceType());
        httpHeaders.set("m-device-id", athenaBasicHttpRequestHead.getDeviceId());
        httpHeaders.set("m-source", athenaBasicHttpRequestHead.getSourceFrom());
        httpHeaders.set("digi-middleware-device-id", athenaBasicHttpRequestHead.getIamDeviceId());
        String tenantId = this.getTenantId(url, athenaBasicHttpRequestHead);
        if (StringUtils.hasLength((String)tenantId)) {
            httpHeaders.set("routerKey", tenantId);
        }
        if (StringUtils.hasLength((String)(proxyToken = this.getProxyToken(athenaBasicHttpRequestHead)))) {
            httpHeaders.set("digi-proxy-token", proxyToken);
        }
        if (StringUtils.hasLength((String)athenaBasicHttpRequestHead.getAcceptLanguage())) {
            httpHeaders.set("accept-language", athenaBasicHttpRequestHead.getAcceptLanguage());
        } else if (StringUtils.hasLength((String)athenaBasicHttpRequestHead.getLocale())) {
            httpHeaders.set("accept-language", athenaBasicHttpRequestHead.getLocale().replace("_", "-"));
        }
        try {
            String traceId = TraceIdUtil.get();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)traceId)) {
                httpHeaders.set("traceId", traceId);
            }
        }
        catch (Exception e) {
            logger.error("getTraceIdEx", (Throwable)e);
        }
        return httpHeaders;
    }

    private HttpEntity<MultiValueMap<String, Object>> processFileHeaders(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, MultipartFile file, Map<String, ?> requestParam) {
        String proxyToken;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.MULTIPART_FORM_DATA);
        httpHeaders.set("digi-middleware-auth-app", this.sysEnvConfig.getAppToken());
        httpHeaders.set("digi-middleware-auth-user", athenaBasicHttpRequestHead.getUserToken());
        httpHeaders.set("token", athenaBasicHttpRequestHead.getUserToken());
        httpHeaders.set("client-agent", athenaBasicHttpRequestHead.getClientAgent());
        httpHeaders.set("locale", athenaBasicHttpRequestHead.getLocale());
        String tenantId = this.getTenantId(url, athenaBasicHttpRequestHead);
        if (StringUtils.hasLength((String)tenantId)) {
            httpHeaders.set("routerKey", tenantId);
        }
        if (StringUtils.hasLength((String)(proxyToken = this.getProxyToken(athenaBasicHttpRequestHead)))) {
            httpHeaders.set("digi-proxy-token", proxyToken);
        }
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"file", (Object)file.getResource());
        if (requestParam != null) {
            for (Map.Entry<String, ?> entry : requestParam.entrySet()) {
                body.add((Object)entry.getKey(), entry.getValue());
            }
        }
        return new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
    }

    private HttpEntity<MultiValueMap<String, Object>> processFileRequest(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, List<MultipartFile> files, Map<String, ?> requestParam) {
        String proxyToken;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.MULTIPART_FORM_DATA);
        httpHeaders.set("digi-middleware-auth-app", this.sysEnvConfig.getAppToken());
        httpHeaders.set("digi-middleware-auth-user", athenaBasicHttpRequestHead.getUserToken());
        httpHeaders.set("token", athenaBasicHttpRequestHead.getUserToken());
        httpHeaders.set("client-agent", athenaBasicHttpRequestHead.getClientAgent());
        httpHeaders.set("locale", athenaBasicHttpRequestHead.getLocale());
        String tenantId = this.getTenantId(url, athenaBasicHttpRequestHead);
        if (StringUtils.hasLength((String)tenantId)) {
            httpHeaders.set("routerKey", tenantId);
        }
        if (StringUtils.hasLength((String)(proxyToken = this.getProxyToken(athenaBasicHttpRequestHead)))) {
            httpHeaders.set("digi-proxy-token", proxyToken);
        }
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        if (files != null) {
            for (MultipartFile multipartFile : files) {
                body.add((Object)"files", (Object)multipartFile.getResource());
            }
        }
        if (requestParam != null) {
            for (Map.Entry entry : requestParam.entrySet()) {
                body.add(entry.getKey(), entry.getValue());
            }
        }
        return new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
    }

    public String getTenantId(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead) {
        String tenantId = athenaBasicHttpRequestHead.getTenantId();
        if (StringUtils.hasLength((String)tenantId)) {
            return tenantId;
        }
        tenantId = AppRequestContext.getContextEntity().getTenantId();
        if (StringUtils.hasLength((String)tenantId)) {
            return tenantId;
        }
        if (BooleanUtils.isFalse((Boolean)this.jvmCache.getAthenaApiSwitch())) {
            return null;
        }
        if (!AthenaCheckApiEnum.isExist((String)url)) {
            return null;
        }
        throw new ServiceException("API request header tenantId is empty! url\uff1a" + url);
    }

    public String getProxyToken(AthenaBasicHttpRequestHead athenaBasicHttpRequestHead) {
        String proxyToken = athenaBasicHttpRequestHead.getProxyToken();
        if (StringUtils.hasLength((String)proxyToken)) {
            return proxyToken;
        }
        proxyToken = AppRequestContext.getContextEntity().getProxyToken();
        if (StringUtils.hasLength((String)proxyToken)) {
            return proxyToken;
        }
        return null;
    }

    private HttpHeaders processHeaders(DigiwhaleBasicHttpRequestHead digiwhaleBasicHttpRequestHead) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("Authorization", digiwhaleBasicHttpRequestHead.getAuthorization());
        return httpHeaders;
    }

    public <T> ResponseEntity<T> doGet(String url, Class<T> clazz) {
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, HttpEntity.EMPTY, clazz, new Object[0]);
        this.checkResponse(url, responseEntity, "zh_CN");
        return responseEntity;
    }

    public <T> ResponseEntity<T> doGet(String url, ParameterizedTypeReference<T> responseType) {
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, HttpEntity.EMPTY, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, "zh_CN");
        return responseEntity;
    }

    public <T> ResponseEntity<T> doGet(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, Class<T> clazz) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, clazz, uriVariables);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doGet(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, ParameterizedTypeReference<T> responseType) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, responseType, uriVariables);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doGet(String url, DigiwhaleBasicHttpRequestHead digiwhaleBasicHttpRequestHead, Map<String, ?> uriVariables, Class<T> clazz) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(digiwhaleBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, clazz, uriVariables);
        this.checkResponse(url, responseEntity, (String)uriVariables.get("locale"));
        return responseEntity;
    }

    public <T> ResponseEntity<T> doGet(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, ParameterizedTypeReference<T> responseType) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, Class<T> clazz) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, clazz, uriVariables);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, String bodyPayload, Class<T> clazz) {
        HttpEntity requestEntity = new HttpEntity((Object)bodyPayload, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, clazz, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, String bodyPayload, ParameterizedTypeReference<T> responseType) {
        HttpEntity requestEntity = new HttpEntity((Object)bodyPayload, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, ParameterizedTypeReference<T> responseType) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, uriVariables);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, ParameterizedTypeReference<T> responseType) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Class<T> clazz) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, clazz, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public void checkResponse(String url, ResponseEntity responseEntity, String locale) {
        block11: {
            Map body2;
            if (url.contains("/oauth/oauth/token")) {
                return;
            }
            if (responseEntity.getStatusCode() != HttpStatus.UNAUTHORIZED) break block11;
            if (!StringUtils.hasLength((String)locale)) {
                locale = "zh_CN";
            }
            String message = "\u767b\u5f55\u8fc7\u671f";
            if (url.contains("/api/iam/v2/identity/login")) {
                try {
                    body2 = (Map)JsonUtil.objectToJavaObject((Object)responseEntity.getBody(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    message = body2.getOrDefault("errorMessage", "\u767b\u5f55\u8fc7\u671f");
                }
                catch (Exception body2) {
                    // empty catch block
                }
            }
            if (url.contains("/identity/token/analyze")) {
                try {
                    body2 = (Map)JsonUtil.objectToJavaObject((Object)responseEntity.getBody(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    String errorCode = body2.getOrDefault("errorCode", "");
                    if (Arrays.asList("21006", "21008").contains(errorCode)) {
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception(LocaleUtil.getMobileTextByKey((String)locale, (String)message));
        }
    }

    public <T> ResponseEntity<T> doPost(String url, ParameterizedTypeReference<T> responseType) {
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, HttpEntity.EMPTY, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, "zh_CN");
        return responseEntity;
    }

    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, MultipartFile file, Map<String, ?> uriVariables, Class<T> clazz) {
        HttpEntity requestEntity = this.processFileHeaders(url, athenaBasicHttpRequestHead, file, uriVariables);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, clazz, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, List<MultipartFile> files, Map<String, ?> requestParam, ParameterizedTypeReference<T> responseType) {
        HttpEntity requestEntity = this.processFileRequest(url, athenaBasicHttpRequestHead, files, requestParam);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }
}

