/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.config;

import com.digiwin.mobile.mobileuibot.common.converter.DateToTimestampConverter;
import com.digiwin.mobile.mobileuibot.common.converter.TimestampToDateConverter;
import java.util.ArrayList;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;

@Configuration
public class MultipleMongoConfig {
    @Bean
    @Primary
    @ConfigurationProperties(prefix="spring.data.mongodb.primary")
    public MongoProperties primaryMongoProperties() {
        return new MongoProperties();
    }

    @Bean(value={"secondMongoProperties"})
    @ConfigurationProperties(prefix="spring.data.mongodb.second")
    public MongoProperties secondMongoProperties() {
        return new MongoProperties();
    }

    @Bean
    @Primary
    public MongoTemplate mongoTemplate() {
        MongoTemplate mongoTemplate = new MongoTemplate(this.primaryMongoFactory(this.primaryMongoProperties()));
        MappingMongoConverter mongoMapping = (MappingMongoConverter)mongoTemplate.getConverter();
        mongoMapping.afterPropertiesSet();
        return mongoTemplate;
    }

    @Bean(name={"secondMongoTemplate"})
    public MongoTemplate secondMongoTemplate() {
        MongoProperties mongoProperties = this.secondMongoProperties();
        MongoDatabaseFactory mongoDatabaseFactory = this.secondMongoFactory(mongoProperties);
        MongoTemplate mongoTemplate = new MongoTemplate(mongoDatabaseFactory);
        MappingMongoConverter mongoMapping = (MappingMongoConverter)mongoTemplate.getConverter();
        mongoMapping.afterPropertiesSet();
        return mongoTemplate;
    }

    @Bean
    @Primary
    public MongoDatabaseFactory primaryMongoFactory(MongoProperties mongoProperties) {
        return new SimpleMongoClientDatabaseFactory(mongoProperties.getUri());
    }

    @Bean
    public MongoDatabaseFactory secondMongoFactory(MongoProperties mongoProperties) {
        return new SimpleMongoClientDatabaseFactory(mongoProperties.getUri());
    }

    @Bean
    public MongoCustomConversions customConversions() {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.add(new DateToTimestampConverter());
        converters.add(new TimestampToDateConverter());
        return new MongoCustomConversions(converters);
    }
}

