/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.config.request;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final Map<String, String[]> params = new HashMap();
    private byte[] body;
    private Map<String, String> mapCookies;

    public RequestWrapper(HttpServletRequest request) {
        super(request);
        String sessionStream = this.getBodyString((ServletRequest)request);
        this.body = sessionStream.getBytes(DEFAULT_CHARSET);
        this.params.putAll(request.getParameterMap());
        this.mapCookies = new HashMap();
    }

    public RequestWrapper(HttpServletRequest request, Map<String, Object> extendParams) {
        this(request);
        this.addAllParameters(extendParams);
    }

    public String getBodyString() {
        return new String(this.body, DEFAULT_CHARSET);
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBodyString(ServletRequest request) {
        StringBuilder sb = new StringBuilder();
        InputStream inputStream = null;
        BufferedReader reader = null;
        try {
            inputStream = this.cloneInputStream(request.getInputStream());
            reader = new BufferedReader(new InputStreamReader(inputStream, DEFAULT_CHARSET));
            String line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public InputStream cloneInputStream(ServletInputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = inputStream.read(buffer)) > -1) {
                byteArrayOutputStream.write(buffer, 0, len);
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Enumeration<String> getParameterNames() {
        return new Vector(this.params.keySet()).elements();
    }

    public String getParameter(String name) {
        String[] values = (String[])this.params.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        String[] values = (String[])this.params.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values;
    }

    public void addAllParameters(Map<String, Object> otherParams) {
        for (Map.Entry<String, Object> entry : otherParams.entrySet()) {
            this.addParameter(entry.getKey(), entry.getValue());
        }
    }

    public void addParameter(String name, Object value) {
        if (value != null) {
            if (value instanceof String[]) {
                this.params.put(name, (String[])value);
            } else if (value instanceof String) {
                this.params.put(name, new String[]{(String)value});
            } else {
                this.params.put(name, new String[]{String.valueOf(value)});
            }
        }
    }

    public void putCookie(String name, String value) {
        this.mapCookies.put(name, value);
    }

    public String getCookieForRequest(String key) {
        Cookie[] cookies = this.getCookieArrForRequest();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>(Arrays.asList(cookies));
        for (int i = 0; i < cookieList.size(); ++i) {
            if (!((Cookie)cookieList.get(i)).getName().equals(key)) continue;
            return ((Cookie)cookieList.get(i)).getValue();
        }
        return null;
    }

    public Cookie[] getCookieArrForRequest() {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        return request.getCookies();
    }

    public Cookie[] getCookies() {
        Cookie[] cookies = this.getCookieArrForRequest();
        if (this.mapCookies == null || this.mapCookies.isEmpty()) {
            return cookies;
        }
        if (cookies == null || cookies.length == 0) {
            LinkedList<Cookie> cookieList = new LinkedList<Cookie>();
            for (Map.Entry entry : this.mapCookies.entrySet()) {
                String key = (String)entry.getKey();
                if (key == null || "".equals(key)) continue;
                cookieList.add(new Cookie(key, (String)entry.getValue()));
            }
            if (cookieList.isEmpty()) {
                return cookies;
            }
            return cookieList.toArray(new Cookie[cookieList.size()]);
        }
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>(Arrays.asList(cookies));
        for (Map.Entry entry : this.mapCookies.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null || "".equals(key)) continue;
            for (int i = 0; i < cookieList.size(); ++i) {
                if (!((Cookie)cookieList.get(i)).getName().equals(key)) continue;
                cookieList.remove(i);
            }
            cookieList.add(new Cookie(key, (String)entry.getValue()));
        }
        return cookieList.toArray(new Cookie[cookieList.size()]);
    }
}

