/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotService;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContentRequest;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntrance;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceDirectionEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.pageable.PageableListData;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabContentArea;
import com.digiwin.mobile.mobileuibot.core.component.webview.WebviewPanel;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcLayoutEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.index.IndexBuildAgileDataPrivatizationStrategy;
import com.digiwin.mobile.mobileuibot.index.IndexBuildDriverNoVehicleZtbStrategy;
import com.digiwin.mobile.mobileuibot.index.IndexBuildNoTenantStrategy;
import com.digiwin.mobile.mobileuibot.index.IndexBuildNoWorkStrategy;
import com.digiwin.mobile.mobileuibot.index.IndexBuildNonSuperAdminNotSetAccountStrategy;
import com.digiwin.mobile.mobileuibot.index.IndexBuildTouristModeStrategy;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataViewPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.DataViewService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.ProjectPageService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.TaskPageService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import com.digiwin.mobile.mobileuibot.recommend.RecommendService;
import com.digiwin.mobile.mobileuibot.test.TestController;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/uibot"})
public class UiBotController {
    private static final Logger logger = LoggerFactory.getLogger(UiBotController.class);
    @Autowired
    private PageSettingService pageSettingService;
    @Autowired
    private UiBotService uiBotService;
    @Autowired
    private RecommendService recommendService;
    @Autowired
    private IndexBuildTouristModeStrategy indexBuildTouristModeStrategy;
    @Autowired
    private IndexBuildNoTenantStrategy indexBuildNoTenantStrategy;
    @Autowired
    private IndexBuildDriverNoVehicleZtbStrategy indexBuildDriverNoVehicleZtbStrategy;
    @Autowired
    private IndexBuildNonSuperAdminNotSetAccountStrategy indexBuildNonSuperAdminNotSetAccountStrategy;
    @Autowired
    private ZhilinkService zhilinkService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private TaskPageService taskPageService;
    @Autowired
    private ProjectPageService projectPageService;
    @Autowired
    private DataViewService dataViewService;
    @Autowired
    private IndexBuildAgileDataPrivatizationStrategy agileDataPrivatizationStrategy;
    @Autowired
    private IndexBuildNoWorkStrategy indexBuildNoWorkStrategy;

    @RequestMapping(value={"/model"}, method={RequestMethod.POST})
    public ApiResponse<UiBotModel> buildRenderPageModel(@RequestBody ApiRequest apiRequest) throws IOException {
        JSONObject executeContextJsonObj;
        PageSettingIdPresetEnum pageIdEnum = PageSettingIdPresetEnum.getEnumByName((String)apiRequest.getPageId());
        if (!PageSettingIdPresetEnum.MOBILE_ATHENA_ASSISTANT.equals((Object)pageIdEnum) && BooleanUtils.isTrue((Boolean)AppContext.getApiUrlSetting().getAgileDataPrivatization())) {
            return ApiResponse.buildOK().setData((Object)this.agileDataPrivatizationStrategy.build(apiRequest));
        }
        if (PageSettingIdPresetEnum.INDEX.equals((Object)pageIdEnum) && !StringUtils.hasLength((String)apiRequest.getIamUserToken())) {
            PageSetting pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.INDEX_TOURIST_MODE.toString());
            return ApiResponse.buildOK().setData((Object)this.indexBuildTouristModeStrategy.build(pageSetting, apiRequest));
        }
        if (PageSettingIdPresetEnum.INDEX.equals((Object)pageIdEnum) && !StringUtils.hasLength((String)apiRequest.getTenantId())) {
            PageSetting pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.INDEX_NO_TENANT.toString());
            return ApiResponse.buildOK().setData((Object)this.indexBuildNoTenantStrategy.build(pageSetting, apiRequest));
        }
        if (!TestController.specialHandleSwitch() && PageSettingIdPresetEnum.INDEX.equals((Object)pageIdEnum) && this.uiBotService.nonSuperAdminNotSetAccount(apiRequest)) {
            PageSetting pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.INDEX_NON_SUPER_ADMIN_NOT_SET_ACCOUNT.toString());
            return ApiResponse.buildOK().setData((Object)this.indexBuildNonSuperAdminNotSetAccountStrategy.build(pageSetting, apiRequest));
        }
        PageSetting pageSetting = this.pageSettingService.findById(apiRequest.getPageId());
        UiBotModel uiBotModel = null;
        if (null == apiRequest.getExtraParameter()) {
            Optional<Object> extraParameterOpt;
            ApiExtraParameter apiExtraParameter;
            JSONObject apiExtraParameterJsonObj = apiRequest.getRawData().getJSONObject("extraParameter");
            if (apiExtraParameterJsonObj != null && (apiExtraParameter = (ApiExtraParameter)JSONObject.toJavaObject((JSON)apiExtraParameterJsonObj, ApiExtraParameter.class)) != null) {
                apiRequest.setExtraParameter(apiExtraParameter);
                apiRequest.getRawData().remove((Object)"extraParameter");
            }
            if ((extraParameterOpt = Optional.ofNullable(apiRequest.getRawData()).map(e -> e.get((Object)"taskExtraParameter"))).isPresent()) {
                apiRequest.setExtraParameter((ApiExtraParameter)JsonUtil.objectToJavaObject((Object)extraParameterOpt.get(), ApiExtraParameter.class));
            }
        }
        if ((executeContextJsonObj = apiRequest.getRawData().getJSONObject("executeContext")) != null) {
            apiRequest.setSourceType(executeContextJsonObj.getString("sourceType"));
        }
        if (null != (uiBotModel = this.uiBotService.buildRenderPageModel(pageSetting, apiRequest))) {
            if (MobileRenderMetaData.RENDER_VERSION_2.equals(uiBotModel.getRenderVersion()) && (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData()) || CollectionUtils.isEmpty((Collection)uiBotModel.getRenderData().getBody()))) {
                uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
                uiBotModel.getRenderData().addEmptyComponentToBody();
            }
            if (CollectionUtils.isEmpty((Collection)uiBotModel.getAppbarButtonList()) && uiBotModel.getReassignButton() != null) {
                uiBotModel.setAppbarButtonList((List)Lists.newArrayList((Object[])new Button[]{uiBotModel.getReassignButton()}));
                uiBotModel.setReassignButton(null);
            }
            return ApiResponse.buildOK().setData((Object)uiBotModel);
        }
        return ApiResponse.buildError().setData(null);
    }

    private boolean checkZtbDriverNoVehicle(ApiRequest apiRequest) {
        try {
            if (!Optional.ofNullable(apiRequest.getIsZtbDriver()).orElse(false).booleanValue()) {
                return false;
            }
            return CollectionUtils.isEmpty((Collection)this.digiwinEspProxyService.getDriverVehicle(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), null));
        }
        catch (Exception e) {
            logger.error("UiBotController[checkZtbDriverNoVehicle] error: ", (Throwable)e);
            return false;
        }
    }

    @RequestMapping(value={"/model/add"}, method={RequestMethod.POST})
    public ApiResponse<String> addPageModel(PageSetting pageSetting) {
        return null;
    }

    @RequestMapping(value={"/component"}, method={RequestMethod.POST})
    public ApiResponse<MobileComponent> buildComponentData(@RequestParam(name="clientId", required=false) String clientId, @RequestParam(name="tenantId", required=false) String tenantId, @RequestBody ApiRequest apiRequest) throws IOException {
        ComponentSettingRequestIdEnum requestIdEnum;
        MobileComponent mobileComponent;
        String requestId = apiRequest.getRequestId();
        if (!StringUtils.hasLength((String)requestId)) {
            return ApiResponse.buildError((String)"Component build failed with invalid requestId, please check your request").setData(null);
        }
        if (StringUtils.hasLength((String)clientId)) {
            apiRequest.setClientId(clientId);
        }
        if (StringUtils.hasLength((String)tenantId)) {
            apiRequest.setTenantId(tenantId);
        }
        if (null != (mobileComponent = this.uiBotService.buildComponentDataModel(requestIdEnum = ComponentSettingRequestIdEnum.getEnumByName((String)requestId), apiRequest))) {
            return ApiResponse.buildOK().setData((Object)mobileComponent);
        }
        return ApiResponse.buildError().setData(null);
    }

    @RequestMapping(value={"/component/list"}, method={RequestMethod.POST})
    public ApiResponse<List<MobileComponent>> buildComponentDataList(@RequestParam(name="clientId", required=false) String clientId, @RequestParam(name="tenantId", required=false) String tenantId, @RequestBody ApiRequest apiRequest) throws IOException {
        ComponentSettingRequestIdEnum requestIdEnum;
        List mobileComponentList;
        String requestId = apiRequest.getRequestId();
        if (!StringUtils.hasLength((String)requestId)) {
            return ApiResponse.buildError((String)"Component build failed with invalid requestId, please check your request");
        }
        if (StringUtils.hasLength((String)clientId)) {
            apiRequest.setClientId(clientId);
        }
        if (StringUtils.hasLength((String)tenantId)) {
            apiRequest.setTenantId(tenantId);
        }
        if (null != (mobileComponentList = this.uiBotService.buildComponentDataModelList(requestIdEnum = ComponentSettingRequestIdEnum.getEnumByName((String)requestId), apiRequest))) {
            return ApiResponse.buildOK().setData((Object)mobileComponentList);
        }
        return ApiResponse.buildError();
    }

    @Deprecated
    @RequestMapping(value={"/component/pageablelist/data"}, method={RequestMethod.POST})
    public ApiResponse<MobileComponent> buildComponentPageableListData(@RequestBody ApiRequest apiRequest) throws IOException {
        Integer page_no = null == apiRequest.getPageNum() ? 1 : apiRequest.getPageNum();
        Integer page_size = null == apiRequest.getPageSize() ? 10 : apiRequest.getPageSize();
        Boolean use_has_next = null == apiRequest.getRawData().get((Object)"use_has_next") ? true : (Boolean)apiRequest.getRawData().get((Object)"use_has_next");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("task_no", apiRequest.getRawData().get((Object)"task_no"));
        PageableListData pageableListData = this.zhilinkService.getAsnBodyByTaskNo(page_no, page_size, use_has_next, parameter, apiRequest);
        if (null != pageableListData) {
            return ApiResponse.buildOK().setData((Object)pageableListData);
        }
        return ApiResponse.buildError().setData(null);
    }

    @RequestMapping(value={"/universalparse/component/customtabitem"}, method={RequestMethod.POST})
    public ApiResponse<CustomTabContentArea> getTabItem(@RequestBody ApiRequest apiRequest) throws IOException {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        ApiRawData rawData = apiRequest.getRawData();
        UiBotModel tabUibotModel = this.digiwinPcUiBotProxyService.actionShow(locale, iamUserToken, JsonUtil.javaObjectToJsonString(rawData.get("rawData")));
        UiBotAction action = ModuleUtils.getDefaultAction((UiBotModel)tabUibotModel);
        CustomTabContentArea contentArea = new CustomTabContentArea();
        List bodyArea = contentArea.getBodyArea();
        if (!ModuleUtils.uibotIsNotEmpty((UiBotModel)tabUibotModel).booleanValue()) {
            bodyArea.add(CustomTabContentContainer.emptyContainer((String)locale));
        } else {
            List tabLayouts = tabUibotModel.getLayout();
            UiBotPageData tabPageData = tabUibotModel.getPageData();
            ArrayList searchAllModule = new ArrayList();
            ModuleUtils.searchAllModule((List)tabLayouts, searchAllModule);
            for (UiBotLayout tabLayout : searchAllModule) {
                CustomTabContentContainer container = new CustomTabContentContainer();
                String type = tabLayout.getType();
                String schema = tabLayout.getSchema();
                container.setContentCmptType("CUSTOM_GROUP");
                if (type.equalsIgnoreCase(PcLayoutEnum.FORM_LIST.getValue())) {
                    Map bizData = (Map)tabPageData.get((Object)schema);
                    container.setData((Object)ModuleUtils.buildFormList((UiBotLayout)tabLayout, (Map)bizData, (UiBotExecuteContext)tabUibotModel.getExecuteContext(), (String)locale, (String)"", (List)tabUibotModel.getRules(), (Boolean)false, (Boolean)true, (boolean)true, (String)iamUserToken));
                    bodyArea.add(container);
                    continue;
                }
                if (!type.equalsIgnoreCase(PcLayoutEnum.ATHENA_TABLE.getValue())) continue;
                List table = ModuleUtils.buildAthenaTable((UiBotModel)tabUibotModel, (UiBotLayout)tabLayout, (String)locale, (UiBotAction)action);
                contentArea.setSize(Integer.valueOf(table != null ? table.size() : 0));
                bodyArea.addAll(table);
            }
        }
        BottomButtonList buttonList = (BottomButtonList)ModuleUtils.buildBottomButtonList((UiBotModel)tabUibotModel, (int)ActionTypeEnum.CALL_API_BACK_INDEX.getValue());
        if (buttonList != null && buttonList.size() > 0) {
            List bottomArea = contentArea.getBottomArea();
            CustomTabContentContainer buttonContainer = new CustomTabContentContainer();
            buttonContainer.setContentCmptType("BOTTOM_BUTTON");
            buttonContainer.setPosition(Integer.valueOf(2));
            buttonContainer.setData((Object)buttonList);
            bottomArea.add(buttonContainer);
        }
        return ApiResponse.buildOK().setData((Object)contentArea);
    }

    @RequestMapping(value={"/customcontent/outer"}, method={RequestMethod.POST})
    public ApiResponse<UiBotModel> customContentOuter(@RequestParam(name="locale") String locale, @RequestParam(name="useDap") String useDap, @RequestParam(name="getReportInOldWay") String getReportInOldWay, @RequestParam(name="serviceUrl") String serviceUrl, @RequestBody CustomContentRequest customContentRequest) throws IOException {
        boolean recommend = false;
        if (customContentRequest.getSysParam().get("recommend") != null) {
            recommend = (Boolean)customContentRequest.getSysParam().get("recommend");
        }
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (useMockData.booleanValue() || modelTypeShow.booleanValue()) {
            String data = recommend ? FileUtil.readText((String)"static/appstore-use/index-recommend-see.json") : FileUtil.readText((String)"static/dashboard-custom-content.json");
            if (null != data && !data.isEmpty()) {
                UiBotModel uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
                return ApiResponse.buildOK().setData((Object)uiBotModel);
            }
            return ApiResponse.buildError();
        }
        HashMap<String, String> queryParam = new HashMap<String, String>();
        queryParam.put("locale", locale);
        queryParam.put("useDap", useDap);
        queryParam.put("serviceUrl", serviceUrl);
        boolean bGetReportInOldWay = Boolean.parseBoolean(getReportInOldWay);
        if (bGetReportInOldWay) {
            return ApiResponse.buildOK().setData((Object)this.uiBotService.buildCustomContentReportUseTbbApi(queryParam, customContentRequest));
        }
        return ApiResponse.buildOK().setData((Object)this.uiBotService.buildCustomContentReportUseAthenaApi(queryParam, customContentRequest));
    }

    @RequestMapping(value={"/customcontent/recommend/menu"}, method={RequestMethod.POST})
    public ApiResponse<UiBotModel> getRecommendMenu(@RequestParam(name="userId") String userId, @RequestBody CustomContentRequest customContentRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (useMockData.booleanValue() || modelTypeShow.booleanValue()) {
            String data = FileUtil.readText((String)"static/appstore-use/index-recommend-do.json");
            if (null != data && !data.isEmpty()) {
                UiBotModel uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
                return ApiResponse.buildOK().setData((Object)uiBotModel);
            }
            return ApiResponse.buildError();
        }
        Map sysParam = customContentRequest.getSysParam();
        String locale = (String)sysParam.get("locale");
        String iamUserToken = (String)sysParam.get("iamUserToken");
        AppEntrance appEntrance = new AppEntrance();
        appEntrance.setDirection(AppEntranceDirectionEnum.HORIZONTAL.getValue());
        appEntrance.setAppLayoutType(AppEntranceLayoutTypeEnum.EQUAL_RATION.getValue());
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setLocale(locale);
        apiRequest.setIamUserToken(iamUserToken);
        apiRequest.setUserId(userId);
        appEntrance.getAppList().addAll(this.recommendService.getRecommendAppList(apiRequest));
        String schema = UUIDUtil.getUuid();
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        ArrayList<UiBotLayout> layoutList = new ArrayList<UiBotLayout>();
        UiBotLayout layout = new UiBotLayout();
        layout.setSchema(schema);
        layout.setType("APP_ENTRANCE");
        layoutList.add(layout);
        uiBotModel.setLayout(layoutList);
        UiBotPageData pageData = new UiBotPageData();
        pageData.put((Object)schema, (Object)appEntrance);
        uiBotModel.setPageData(pageData);
        return ApiResponse.buildOK().setData((Object)uiBotModel);
    }

    @RequestMapping(value={"/customcontent/empty"}, method={RequestMethod.POST})
    public ApiResponse<UiBotModel> getCustomContent(@RequestBody CustomContentRequest request) {
        Boolean useMockData = AppContext.getUseMockData();
        UiBotModel uiBotModel = null;
        if (!useMockData.booleanValue()) {
            String schema = "panel";
            UiBotLayout layout = new UiBotLayout();
            layout.setSchema(schema);
            layout.setType("WEBVIEW_PANEL");
            ArrayList<UiBotLayout> layoutList = new ArrayList<UiBotLayout>();
            layoutList.add(layout);
            WebviewPanel webviewPanel = new WebviewPanel();
            webviewPanel.setTitle(LocaleUtil.getMobileTextByKey((String)((String)request.getSysParam().get("locale")), (String)"\u656c\u8bf7\u671f\u5f85") + "!");
            webviewPanel.setData(new ArrayList());
            uiBotModel = new UiBotModel(layoutList);
            uiBotModel.addPageData(schema, (Object)webviewPanel);
        } else {
            String data = FileUtil.readText((String)"static/dashboard-custom-content.json");
            if (null != data && !data.isEmpty()) {
                uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
            }
        }
        return ApiResponse.buildOK().setData(uiBotModel);
    }

    @RequestMapping(value={"/action/show"}, method={RequestMethod.POST})
    public ApiResponse<UiBotModel> actionShow(@RequestBody ApiRequest apiRequest) {
        ApiRawData rawData = apiRequest.getRawData();
        PcUiBotExecuteContext executeContext = (PcUiBotExecuteContext)JsonUtil.objectToJavaObject((Object)rawData.get((Object)"executeContext"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        executeContext.setAuthoredUser(new PcUiBotAuthoredUser().setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId()).setToken(apiRequest.getIamUserToken()));
        PcUiBotTaskPageDefine pageDefine = (PcUiBotTaskPageDefine)JsonUtil.objectToJavaObject((Object)rawData, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        pageDefine.getExecuteContext().setAuthoredUser(executeContext.getAuthoredUser());
        UiBotModel uiBotModel = "project-detail-mobile".equals(executeContext.getPageCode()) ? this.projectPageService.createPage(executeContext, pageDefine, apiRequest) : this.taskPageService.createPage(executeContext, pageDefine, apiRequest);
        if (!CollectionUtils.isEmpty((Collection)uiBotModel.getRules())) {
            this.filterEditRules(uiBotModel.getRules());
        }
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        if (MobileRenderMetaData.RENDER_VERSION_2.equals(uiBotModel.getRenderVersion()) && (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData()) || CollectionUtils.isEmpty((Collection)uiBotModel.getRenderData().getBody()))) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
            uiBotModel.getRenderData().addEmptyComponentToBody();
        }
        return ApiResponse.buildOK().setData((Object)uiBotModel);
    }

    private void filterEditRules(List<UiBotRule> rules) {
        rules.removeIf(rule -> Objects.equals("EDIT", rule.getScope()));
    }

    @RequestMapping(value={"/dataView/show"}, method={RequestMethod.POST})
    public ApiResponse<UiBotModel> dataViewShow(@RequestBody ApiRequest apiRequest) {
        PcUiBotDataViewPageDefine dataViewPageDefine = (PcUiBotDataViewPageDefine)JsonUtil.objectToJavaObject((Object)apiRequest.getRawData(), PcUiBotDataViewPageDefine.class);
        dataViewPageDefine.getExecuteContext().setAuthoredUser(new PcUiBotAuthoredUser().setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId()).setToken(apiRequest.getIamUserToken()));
        UiBotModel uiBotModel = this.dataViewService.createDynamicForm(dataViewPageDefine, apiRequest);
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        if (MobileRenderMetaData.RENDER_VERSION_2.equals(uiBotModel.getRenderVersion()) && (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData()) || CollectionUtils.isEmpty((Collection)uiBotModel.getRenderData().getBody()))) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
            uiBotModel.getRenderData().addEmptyComponentToBody();
        }
        return ApiResponse.buildOK().setData((Object)uiBotModel);
    }
}

