/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="uiBotModelBuildService")
public class UiBotModelBuildServiceImpl
implements UiBotModelBuildService {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildServiceImpl.class);
    @Autowired
    private PageSettingService pageSettingService;

    public UiBotModel buildModel(PageSetting pageSetting, Object data) {
        if (null != pageSetting) {
            UiBotModel pageModel = pageSetting.getPageModel();
            List layoutList = pageModel.getLayout();
            if (null != layoutList && layoutList.size() > 0) {
                pageModel.addPageData(((UiBotLayout)layoutList.get(0)).getSchema(), data);
            }
            return pageModel;
        }
        return UiBotModel.emptyUiBotModel();
    }

    public UiBotModel buildModel(PageSetting pageSetting, Object data, Boolean fullMount) {
        if (!fullMount.booleanValue()) {
            return this.buildModel(pageSetting, data);
        }
        if (null != pageSetting) {
            UiBotModel pageModel = pageSetting.getPageModel();
            List layoutList = pageModel.getLayout();
            if (!CollectionUtils.isEmpty((Collection)layoutList)) {
                UiBotPageData uiBotPageData = (UiBotPageData)JSON.parseObject((String)JSON.toJSONString((Object)data), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
                List<UiBotLayout> bottomButtonLayoutList = pageModel.getLayout().stream().filter(layout -> "BOTTOM_BUTTON".equalsIgnoreCase(layout.getType())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(bottomButtonLayoutList)) {
                    bottomButtonLayoutList.forEach(bottomButtonLayout -> {
                        JSONArray bottomButtonPageData = (JSONArray)uiBotPageData.get((Object)bottomButtonLayout.getSchema());
                        if (CollectionUtils.isEmpty((Collection)bottomButtonPageData)) {
                            pageModel.getLayout().remove(bottomButtonLayout);
                            uiBotPageData.remove((Object)bottomButtonLayout.getSchema());
                        }
                    });
                }
                pageModel.setPageData(uiBotPageData);
            }
            return pageModel;
        }
        return UiBotModel.emptyUiBotModel();
    }

    public UiBotModel buildModel(PageSetting pageSetting, UiBotPageData data) {
        if (null != pageSetting) {
            UiBotModel pageModel = pageSetting.getPageModel();
            List layoutList = pageModel.getLayout();
            if (null != layoutList && layoutList.size() > 0) {
                pageModel.setPageData(data);
            }
            return pageModel;
        }
        return UiBotModel.emptyUiBotModel();
    }
}

