/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.core.component.BaseLayoutMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapperJsonDeserializer;
import com.digiwin.mobile.mobileuibot.core.component.layout.ComponentLayoutTypeEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class BaseListMobileComponent<T extends BaseMobileComponent>
extends BaseLayoutMobileComponent {
    private static final long serialVersionUID = -3463956265364418603L;
    @JsonDeserialize(contentUsing=BaseMobileComponentWrapperJsonDeserializer.class)
    protected List<BaseMobileComponentWrapper<T>> contentList;

    public BaseListMobileComponent() {
        this.contentList = new ArrayList();
    }

    public BaseListMobileComponent(List<BaseMobileComponentWrapper<T>> contentList) {
        this.contentList = contentList;
    }

    public ComponentLayoutTypeEnum getComponentLayoutType() {
        return ComponentLayoutTypeEnum.VERTICAL;
    }

    public void add(BaseMobileComponentWrapper<T> wrappered) {
        if (null != this.getContentList()) {
            this.getContentList().add(wrappered);
        }
    }

    public void addAll(List<BaseMobileComponentWrapper<T>> wrapperedList) {
        if (null != this.getContentList()) {
            this.getContentList().addAll(wrapperedList);
        }
    }

    public void addComponentToList(T component) {
        if (null != this.getContentList()) {
            this.getContentList().add(new BaseMobileComponentWrapper(component));
        }
    }

    public void addComponentToList(T component, String customComponentType) {
        if (null != this.getContentList()) {
            this.getContentList().add(new BaseMobileComponentWrapper(component, customComponentType));
        }
    }

    public void addAllComponentsToList(List<T> componentList) {
        if (null != this.getContentList() && !CollectionUtils.isEmpty(componentList)) {
            componentList.forEach(c -> this.getContentList().add(new BaseMobileComponentWrapper(c)));
        }
    }

    public void addAllComponentsToList(List<T> componentList, String customComponentType) {
        if (null != this.getContentList() && !CollectionUtils.isEmpty(componentList)) {
            componentList.forEach(c -> this.getContentList().add(new BaseMobileComponentWrapper(c, customComponentType)));
        }
    }

    public void addAllComponentsToList(List<T> componentList, String componentTypePrefix, String componentTypeSuffix, String schema) {
        if (null != this.getContentList() && !CollectionUtils.isEmpty(componentList)) {
            String localPrefix = "";
            String localSuffix = "";
            if (StringUtils.hasLength((String)componentTypePrefix)) {
                localPrefix = componentTypePrefix;
            }
            if (StringUtils.hasLength((String)componentTypeSuffix)) {
                localSuffix = componentTypeSuffix;
            }
            for (BaseMobileComponent t : componentList) {
                this.getContentList().add(new BaseMobileComponentWrapper(t, localPrefix + t.returnComponentType() + localSuffix, schema));
            }
        }
    }

    public void deleteComponentInList(int index) {
        if (null != this.contentList && index > -1) {
            this.contentList.remove(index);
        }
    }

    public void clearComponentsList() {
        if (null != this.contentList) {
            this.contentList.clear();
        }
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    public boolean isEmpty() {
        if (null != this.contentList) {
            return this.contentList.isEmpty();
        }
        return true;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public List<BaseMobileComponentWrapper<T>> getContentList() {
        return this.contentList;
    }

    @JsonDeserialize(contentUsing=BaseMobileComponentWrapperJsonDeserializer.class)
    public void setContentList(List<BaseMobileComponentWrapper<T>> contentList) {
        this.contentList = contentList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseListMobileComponent)) {
            return false;
        }
        BaseListMobileComponent other = (BaseListMobileComponent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$contentList = this.getContentList();
        List other$contentList = other.getContentList();
        return !(this$contentList == null ? other$contentList != null : !((Object)this$contentList).equals(other$contentList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseListMobileComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $contentList = this.getContentList();
        result = result * 59 + ($contentList == null ? 43 : ((Object)$contentList).hashCode());
        return result;
    }

    public String toString() {
        return "BaseListMobileComponent(contentList=" + this.getContentList() + ")";
    }
}

