/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFillTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.TargetDatetime;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizReport;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AutoFillData
extends BaseMobileComponent {
    private static final long serialVersionUID = 4139155369185206418L;
    public static final String COMPONENT_TYPE = "AUTO_FILL_DATA";
    private String name;
    private String nameColor;
    private String nameSize;
    private Action action;
    private RelationRule relationRule;
    private String id;
    private Integer type;
    private String content;

    public static AutoFillData create(String name, UiBotLayout pcDataLayout, Map<String, Object> pcData, Map<String, Object> variableListSimpleMap) {
        CommonRule actualStartDateRule;
        AutoFillData autoFillData = new AutoFillData();
        autoFillData.setName(name);
        autoFillData.setNameColor("5037DB");
        autoFillData.setNameSize("28");
        RelationRule relationRule = new RelationRule();
        ArrayList<CommonRule> ruleList = new ArrayList<CommonRule>();
        String rawActualStartDate = String.valueOf(pcData.get("actual_start_date")).trim();
        String rawPlanStartDate = String.valueOf(pcData.get("plan_start_date")).trim();
        if (!StringUtils.hasLength((String)rawActualStartDate)) {
            boolean isAfterNowDate;
            actualStartDateRule = new CommonRule();
            actualStartDateRule.setCondition(CommonRuleCondition.CONDITION_EMPTY_RESET.getType());
            String rawTargetText = rawActualStartDate;
            if (!StringUtils.hasLength((String)rawActualStartDate)) {
                rawTargetText = rawPlanStartDate;
            }
            if (isAfterNowDate = DateTimeUtil.isAfterNowDate((String)rawTargetText).booleanValue()) {
                rawTargetText = DateTimeUtil.getTodayUseDefaultPattern();
            }
            actualStartDateRule.setTargetText(DateTimeUtil.getDateTextInMobileShowDefaultPattern((String)rawTargetText));
            actualStartDateRule.setTargetSchema("actual_start_date");
            ruleList.add(actualStartDateRule);
        }
        if ("task_info".equalsIgnoreCase(pcDataLayout.getSchema())) {
            actualStartDateRule = new CommonRule();
            actualStartDateRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
            actualStartDateRule.setTargetText(DateTimeUtil.getTodayDateTextInMobileShowDefaultPattern());
            actualStartDateRule.setTargetSchema("actual_start_date");
            if (((Boolean)pcData.get("is_attachment")).booleanValue()) {
                CommonRule rule = new CommonRule();
                rule.setCondition(Integer.valueOf(1));
                rule.setTargetRequired(Boolean.valueOf(true));
                rule.setTargetSchema("delivery");
                ruleList.add(rule);
            }
            ruleList.add(actualStartDateRule);
        }
        CommonRule commonRule1 = new CommonRule();
        commonRule1.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        commonRule1.setTargetSchema("actual_finish_date");
        commonRule1.setTargetText("");
        commonRule1.setTargetHidden(null);
        commonRule1.setTargetEnable(Boolean.valueOf(true));
        ArrayList<TargetDatetime> targetDatetimes = new ArrayList<TargetDatetime>();
        TargetDatetime targetDatetime1 = new TargetDatetime();
        targetDatetime1.setDatetimeType(Integer.valueOf(1));
        targetDatetime1.setLinkageSchema("actual_start_date");
        targetDatetimes.add(targetDatetime1);
        commonRule1.setTargetDatetime(targetDatetimes);
        ruleList.add(commonRule1);
        CommonRule actualFinshDateRule = new CommonRule();
        actualFinshDateRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        actualFinshDateRule.setTargetText(DateTimeUtil.getTodayDateTextInMobileShowDefaultPattern());
        actualFinshDateRule.setTargetSchema("actual_finish_date");
        ruleList.add(actualFinshDateRule);
        CommonRule completeRateRule = new CommonRule();
        completeRateRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        completeRateRule.setTargetText("100");
        completeRateRule.setTargetSchema("complete_rate");
        ruleList.add(completeRateRule);
        if (!CollectionUtils.isEmpty(variableListSimpleMap)) {
            Boolean isAllowReportAfter = MapUtils.getBoolean(variableListSimpleMap, (Object)"isAllowReportAfter");
            if (BooleanUtils.isTrue((Boolean)isAllowReportAfter)) {
                CommonRule reportDateCommonRule = new CommonRule();
                reportDateCommonRule.setTargetSchema("report_date");
                reportDateCommonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                TargetDatetime reportDateTargetDatetime = new TargetDatetime();
                reportDateTargetDatetime.setLinkageSchema("actual_start_date");
                reportDateTargetDatetime.setDatetimeType(Integer.valueOf(1));
                reportDateCommonRule.setTargetDatetime(Collections.singletonList(reportDateTargetDatetime));
                reportDateCommonRule.setTargetEnable(Boolean.valueOf(true));
                ruleList.add(reportDateCommonRule);
            } else {
                CommonRule actualFinishDateCommonRule = new CommonRule();
                actualFinishDateCommonRule.setTargetSchema("actual_finish_date");
                actualFinishDateCommonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                TargetDatetime actualFinishDatTargetDatetime = new TargetDatetime();
                actualFinishDatTargetDatetime.setLinkageSchema("actual_start_date");
                actualFinishDatTargetDatetime.setDatetimeType(Integer.valueOf(1));
                actualFinishDateCommonRule.setTargetDatetime(Collections.singletonList(actualFinishDatTargetDatetime));
                actualFinishDateCommonRule.setTargetEnable(Boolean.valueOf(true));
                ruleList.add(actualFinishDateCommonRule);
            }
        }
        relationRule.setRuleList(ruleList);
        autoFillData.setRelationRule(relationRule);
        return autoFillData;
    }

    public static AutoFillData create(ApiRequest apiRequest, TaskDetailBizReport taskDetailBizReport, LocaleService localeService, Boolean isworkHourZero) {
        String locale = apiRequest.getLocale();
        AutoFillData autoFillData = new AutoFillData();
        autoFillData.setName(localeService.getLanguageValue(locale, "\u4ee3\u4e3a\u62a5\u5de5"));
        autoFillData.setNameColor("5037DB");
        autoFillData.setNameSize("28");
        Action replaceReportAction = new Action();
        replaceReportAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_REPLACE_REPORT_TASK_EXECUTOR_DETAIL.toString());
        replaceReportAction.setJumpPageTitle(localeService.getLanguageValue(locale, "\u6279\u91cf\u9009\u62e9\u6267\u884c\u4eba"));
        replaceReportAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        HashMap<String, Boolean> workHoursRawData = new HashMap<String, Boolean>();
        workHoursRawData.put("isworkHourZero", isworkHourZero);
        workHoursRawData.putAll((Map<String, Boolean>)apiRequest.getRawData());
        MobileComponent workHoursMobileComponent = (MobileComponent)taskDetailBizReport.get((Object)"work_hours");
        if (!Objects.isNull(workHoursMobileComponent)) {
            MobileComponent totalwWorkHoursMobileComponent;
            InputNumeric workHours = (InputNumeric)JsonUtil.objectToJavaObject((Object)workHoursMobileComponent, InputNumeric.class);
            workHours.setType(InputNumericTypeEnum.DECIMAL_ALLOW_NEGATIVE.getValue());
            workHours.setMaxLength(Integer.valueOf(99999999));
            ArrayList<ValidateRule> validateRuleList = new ArrayList<ValidateRule>(2);
            ValidateRule validateWorkHoursPrecisionRule = new ValidateRule();
            validateWorkHoursPrecisionRule.setSchema("work_hours");
            validateWorkHoursPrecisionRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
            validateWorkHoursPrecisionRule.setType(ValidateRuleTypeEnum.PATTERN.getType());
            validateWorkHoursPrecisionRule.setParameter("^(-?)*(?=.*0|[1-9])\\d*(?:\\.\\d{1,2})?\\s*$");
            validateWorkHoursPrecisionRule.setErrorMessage(localeService.getLanguageValue(locale, "\u6700\u591a\u4e24\u4f4d\u5c0f\u6570"));
            validateRuleList.add(validateWorkHoursPrecisionRule);
            if (isworkHourZero.booleanValue()) {
                ValidateRule validateRule1 = new ValidateRule();
                validateRule1.setSchema("work_hours");
                validateRule1.setScope(ValidateRuleScopeEnum.EDIT.getScope());
                validateRule1.setType(ValidateRuleTypeEnum.APPOINT.getType());
                validateRule1.setOperatorType(Integer.valueOf(2));
                validateRule1.setParameter("0");
                validateRule1.setErrorMessage(localeService.getLanguageValue(locale, "\u5de5\u65f6\u4e0d\u80fd\u7b49\u4e8e0"));
                validateRule1.setOrder(Integer.valueOf(1));
                validateRule1.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                validateRuleList.add(validateRule1);
            }
            if (!Objects.isNull(totalwWorkHoursMobileComponent = (MobileComponent)taskDetailBizReport.get((Object)"total_work_hours"))) {
                InputNumeric totalwWorkHours = (InputNumeric)JsonUtil.objectToJavaObject((Object)totalwWorkHoursMobileComponent, InputNumeric.class);
                ValidateRule validateSumWorkHoursRule = new ValidateRule();
                validateSumWorkHoursRule.setSchema("work_hours");
                validateSumWorkHoursRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
                validateSumWorkHoursRule.setType(ValidateRuleTypeEnum.APPOINT.getType());
                validateSumWorkHoursRule.setParameter(new BigDecimal(totalwWorkHours.getText()).negate().toString());
                validateSumWorkHoursRule.setOperatorType(Integer.valueOf(6));
                validateSumWorkHoursRule.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                validateSumWorkHoursRule.setErrorMessage(localeService.getLanguageValue(locale, "\u8017\u7528\u603b\u5de5\u65f6\u4e0e\u5de5\u65f6\u7d2f\u8ba1\u4e0d\u53ef\u5c0f\u4e8e0\uff01"));
                validateRuleList.add(validateSumWorkHoursRule);
            }
            workHours.setValidateRuleList(validateRuleList);
            workHoursRawData.put("work_hours", (Boolean)workHours);
            taskDetailBizReport.put((Object)"work_hours", (Object)workHours);
        }
        replaceReportAction.setRawData(workHoursRawData);
        autoFillData.setAction(replaceReportAction);
        return autoFillData;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        Action action;
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.nameColor = "6A4CFF";
        this.nameSize = "28";
        if (AutoFillTypeEnum.OPEN_PAGE.getValue().equals(this.type)) {
            action = new Action();
            action.setJumpPageId(this.content);
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            this.action = action;
        } else if (AutoFillTypeEnum.OPEN_WINDOW.getValue().equals(this.type)) {
            action = new Action();
            action.setJumpPageId(this.content);
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            this.action = action;
        } else {
            this.action = AutoFillTypeEnum.EXECUTE_JS.getValue().equals(this.type) ? null : null;
        }
        if (this.action != null) {
            HashMap<String, Object> rawData = new HashMap<String, Object>();
            rawData.put("allRawMap", mobilePageRawData.getAllRawMap());
            rawData.put("rawMap", mobilePageRawData.getRawMap());
            rawData.put("rawDataType", mobilePageRawData.getRawDataType());
            rawData.put("baseEntryExtendedFields", mobilePageRawData.getExtendedFields());
            rawData.put("sourceCategory", mobilePageRawData.getSourceCategory());
            rawData.put("dataKeys", mobilePageRawData.getDataKeys());
            rawData.put("componentId", mobilePageRawData.getComponentId());
            rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());
            rawData.put("data", data);
            rawData.put("executeContext", executeContext);
            this.action.setRawData(rawData);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNameColor() {
        return this.nameColor;
    }

    public String getNameSize() {
        return this.nameSize;
    }

    public Action getAction() {
        return this.action;
    }

    public RelationRule getRelationRule() {
        return this.relationRule;
    }

    public String getId() {
        return this.id;
    }

    public Integer getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameColor(String nameColor) {
        this.nameColor = nameColor;
    }

    public void setNameSize(String nameSize) {
        this.nameSize = nameSize;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setRelationRule(RelationRule relationRule) {
        this.relationRule = relationRule;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoFillData)) {
            return false;
        }
        AutoFillData other = (AutoFillData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$nameColor = this.getNameColor();
        String other$nameColor = other.getNameColor();
        if (this$nameColor == null ? other$nameColor != null : !this$nameColor.equals(other$nameColor)) {
            return false;
        }
        String this$nameSize = this.getNameSize();
        String other$nameSize = other.getNameSize();
        if (this$nameSize == null ? other$nameSize != null : !this$nameSize.equals(other$nameSize)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        RelationRule this$relationRule = this.getRelationRule();
        RelationRule other$relationRule = other.getRelationRule();
        if (this$relationRule == null ? other$relationRule != null : !this$relationRule.equals(other$relationRule)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoFillData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $nameColor = this.getNameColor();
        result = result * 59 + ($nameColor == null ? 43 : $nameColor.hashCode());
        String $nameSize = this.getNameSize();
        result = result * 59 + ($nameSize == null ? 43 : $nameSize.hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        RelationRule $relationRule = this.getRelationRule();
        result = result * 59 + ($relationRule == null ? 43 : $relationRule.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "AutoFillData(name=" + this.getName() + ", nameColor=" + this.getNameColor() + ", nameSize=" + this.getNameSize() + ", action=" + this.getAction() + ", relationRule=" + this.getRelationRule() + ", id=" + this.getId() + ", type=" + this.getType() + ", content=" + this.getContent() + ")";
    }
}

