/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.button;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseGroupMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroupAlignEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.ComponentLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotJumpAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.model.BaseDataStatusConfig;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ButtonGroup
extends BaseGroupMobileComponent<BottomButtonDigiwinAthena> {
    private static final long serialVersionUID = -6168875577301983184L;
    public static final String COMPONENT_TYPE = "BUTTON_GROUP";
    private Integer alignmentType = ButtonGroupAlignEnum.CENTER.getValue();
    private Integer buttonLayoutType = ButtonLayoutTypeEnum.FOLD.getValue();

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public ComponentLayoutTypeEnum getComponentLayoutType() {
        return ComponentLayoutTypeEnum.GRID;
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        this.handleHiddenButton(cmptContext, executeContext, mobilePageRawData.getExtendedFields(), data);
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        List contentGroup = this.getContentGroup();
        if (!CollectionUtils.isEmpty((Collection)contentGroup)) {
            for (BaseMobileComponentWrapper wrapper : contentGroup) {
                Button button = (Button)wrapper.getData();
                button.handleComponentParam(cmptContext, wrapper.getMobilePath(), wrapper.getSchema(), data, executeContext, mobilePageRawData);
            }
        }
        if (cmptContext.getCanBottomButton().booleanValue()) {
            this.handleContentGroup(cmptContext);
        }
    }

    public void applyEditable(Boolean enable) {
        if (BooleanUtils.isFalse((Boolean)enable)) {
            this.handleHiddenButtonOfSubmit(submitAction -> BooleanUtils.isNotTrue((Boolean)submitAction.getApplyAlthoughFinished()));
            this.handleHiddenButtonOfJump(submitAction -> ActionTypeEnum.RESET.getValue().equals(Optional.ofNullable(submitAction.getJumpAction()).map(UiBotJumpAction::getType).orElse(null)));
        }
    }

    private void handleContentGroup(ComponentContext cmptContext) {
        boolean addFlag = BooleanUtils.isTrue((Boolean)cmptContext.getAddAllSelectButton());
        BaseMobileComponentWrapper allSelectWrapper = null;
        if (addFlag) {
            BottomButtonDigiwinAthena allSelectButton = new BottomButtonDigiwinAthena();
            allSelectButton.setName(LocaleUtil.getMobileTextByKey((String)cmptContext.getLocale(), (String)"\u5168\u9009"));
            allSelectButton.setType(BottomButtonStyleEnum.SELECT_ALL.getValue());
            allSelectWrapper = new BaseMobileComponentWrapper((BaseMobileComponent)allSelectButton, "DW_BUTTON");
        }
        List contentGroup = this.getContentGroup();
        if (addFlag) {
            if (CollectionUtils.isEmpty((Collection)contentGroup)) {
                contentGroup.add(allSelectWrapper);
            } else {
                contentGroup.add(0, allSelectWrapper);
            }
        }
    }

    private void handleHiddenButton(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, Map<String, Object> extendedFields, Map<String, Object> data) {
        if (!PcUiBotPatternUtil.isBaseData((String)executeContext.getPattern())) {
            return;
        }
        String EDIT_TYPE_ADD = "add";
        if ("add".equals(executeContext.getEditType())) {
            this.handleHiddenButtonOfSubmit(submitAction -> StringUtils.hasLength((String)submitAction.getActionType()) && !"basic-data-update".equals(submitAction.getActionType()) && !"basic-data-save".equals(submitAction.getActionType()));
            this.handleHiddenButtonOfJump(submitAction -> BusinessTypeEnum.LOCAL_DELETE.getValue().equals(Optional.ofNullable(submitAction.getJumpAction()).map(UiBotJumpAction::getBusinessType).orElse(null)));
            this.handleHiddenButtonOfSubmit(submitAction -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)submitAction.getActionType()) && "workflow-invoke".equals(submitAction.getActionServiceIdName()));
            this.handleHiddenButtonOfJump(submitAction -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)submitAction.getActionType()) && "workflow-abort".equals(submitAction.getActionServiceIdName()));
            return;
        }
        BaseDataStatusConfig statusConfig = (BaseDataStatusConfig)JsonUtil.objectToJavaObject(extendedFields, BaseDataStatusConfig.class);
        String manageStatus = this.getManageStatus(data);
        if (statusConfig == null || BooleanUtils.isNotTrue((Boolean)statusConfig.getNeedStatusColumn())) {
            this.hiddenBottomButton(manageStatus, new ArrayList());
            return;
        }
        List ids = this.getShowButtonActionType(statusConfig, manageStatus);
        this.hiddenBottomButton(manageStatus, ids);
    }

    private void hiddenBottomButton(String manageStatus, List<String> ids) {
        this.handleHiddenButtonOfSubmit(submitAction -> StringUtils.hasLength((String)submitAction.getActionType()) && !"basic-data-update".equals(submitAction.getActionType()) && !"basic-data-save".equals(submitAction.getActionType()) && !"basic-data-delete".equals(submitAction.getActionType()) && !ids.contains(submitAction.getActionType()));
        boolean isModelDrive = ((List)Optional.ofNullable(this.getContentGroup()).orElse(new ArrayList())).stream().anyMatch(content -> {
            Button button = (Button)content.getData();
            UiBotAction submitAction = button.getSubmitAction();
            if (submitAction == null) {
                return false;
            }
            return "workflow-invoke".equals(submitAction.getActionServiceIdName()) || "workflow-abort".equals(submitAction.getActionServiceIdName());
        });
        this.handleHiddenButtonOfSubmit(submitAction -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)submitAction.getActionType()) && "workflow-invoke".equals(submitAction.getActionServiceIdName()) && !"N".equals(manageStatus));
        this.handleHiddenButtonOfJump(submitAction -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)submitAction.getActionType()) && "workflow-abort".equals(submitAction.getActionServiceIdName()) && !"I".equals(manageStatus) && !"Y".equals(manageStatus));
        if (isModelDrive) {
            this.handleHiddenButtonOfSubmit(submitAction -> StringUtils.hasLength((String)submitAction.getActionType()) && "basic-data-update".equals(submitAction.getActionType()) && ("I".equals(manageStatus) || "Y".equals(manageStatus)));
        }
    }

    private List<String> getShowButtonActionType(BaseDataStatusConfig statusConfig, String manageStatus) {
        ArrayList<String> ids = new ArrayList<String>();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)manageStatus)) {
            return ids;
        }
        Map showIdMap = statusConfig.getShowIdMap();
        if (CollectionUtils.isEmpty((Map)showIdMap)) {
            return ids;
        }
        return Optional.ofNullable(showIdMap.get(manageStatus)).orElse(new ArrayList());
    }

    private String getManageStatus(Map<String, Object> data) {
        String manageStatus = "";
        if (data == null) {
            return manageStatus;
        }
        if (data.containsKey("manage_status")) {
            manageStatus = (String)data.get("manage_status");
            return manageStatus;
        }
        for (Object v : data.values()) {
            Object o;
            if (v == null) continue;
            if (v instanceof Map) {
                manageStatus = (String)((Map)v).get("manage_status");
                continue;
            }
            if (!(v instanceof List) || CollectionUtils.isEmpty((Collection)((Collection)v)) || !((o = ((List)v).get(0)) instanceof Map)) continue;
            manageStatus = (String)((Map)o).get("manage_status");
        }
        return manageStatus;
    }

    private void handleHiddenButtonOfSubmit(Predicate<UiBotAction> predicate) {
        this.handleHiddenButton(submitAction -> ButtonTypeEnum.isNotJump((String)submitAction.getBtnType()) && predicate.test((UiBotAction)submitAction));
    }

    private void handleHiddenButtonOfJump(Predicate<UiBotAction> predicate) {
        this.handleHiddenButton(submitAction -> ButtonTypeEnum.isJump((String)submitAction.getBtnType()) && predicate.test((UiBotAction)submitAction));
    }

    private void handleHiddenButton(Predicate<UiBotAction> predicate) {
        List contentGroup = this.getContentGroup();
        if (CollectionUtils.isEmpty((Collection)contentGroup)) {
            return;
        }
        contentGroup.removeIf(r -> {
            Button button = (Button)r.getData();
            UiBotAction submitAction = button.getSubmitAction();
            if (submitAction == null) {
                return false;
            }
            return predicate.test(submitAction);
        });
    }

    public Integer getAlignmentType() {
        return this.alignmentType;
    }

    public Integer getButtonLayoutType() {
        return this.buttonLayoutType;
    }

    public void setAlignmentType(Integer alignmentType) {
        this.alignmentType = alignmentType;
    }

    public void setButtonLayoutType(Integer buttonLayoutType) {
        this.buttonLayoutType = buttonLayoutType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ButtonGroup)) {
            return false;
        }
        ButtonGroup other = (ButtonGroup)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$alignmentType = this.getAlignmentType();
        Integer other$alignmentType = other.getAlignmentType();
        if (this$alignmentType == null ? other$alignmentType != null : !((Object)this$alignmentType).equals(other$alignmentType)) {
            return false;
        }
        Integer this$buttonLayoutType = this.getButtonLayoutType();
        Integer other$buttonLayoutType = other.getButtonLayoutType();
        return !(this$buttonLayoutType == null ? other$buttonLayoutType != null : !((Object)this$buttonLayoutType).equals(other$buttonLayoutType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ButtonGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $alignmentType = this.getAlignmentType();
        result = result * 59 + ($alignmentType == null ? 43 : ((Object)$alignmentType).hashCode());
        Integer $buttonLayoutType = this.getButtonLayoutType();
        result = result * 59 + ($buttonLayoutType == null ? 43 : ((Object)$buttonLayoutType).hashCode());
        return result;
    }

    public String toString() {
        return "ButtonGroup(alignmentType=" + this.getAlignmentType() + ", buttonLayoutType=" + this.getButtonLayoutType() + ")";
    }
}

